<?PHP
class Chatbox_Model extends CI_Model
{
	var $tableName='chatbox';
	var $siteServivcesDb = "";
    function __construct()
    {
        parent::__construct();
        $this->siteServivcesDb = $this->load->database("site_services",true,false);
    }

    function messageData($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->get($this->tableName);
		return $query->row();
	}

    public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			//$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServivcesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nMessages: ";
		if(isset($_POST['spam']) && is_numeric($_POST['spam']) && in_array($_POST['spam'],array(0,1)))
		{
			$query1->where("spam",$_POST['spam']);
			if($_POST['spam']==0)
			{
				$preData.="Not Spammed Messages";
			}
			else
			{
				$preData.="Spammed Messages";
			}
		}
		else
		{
			$preData.="All Messages";
		}

		/*if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('sent_on',$_POST['dir']);
				else
					$query1->order_by('sent_on',"desc");
			}
			$sql=$query1->get_compiled_select();
			$requestResp=$this->excel_exports_model->makeRequest($this->service,"model","chatbox_model",$sql,$this->currentUser,"default",$_POST,"All Chat Messages",$preData);
			return $requestResp;
		}*/
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('sent_on',$dir);
		}
		else
		{
			$query1->order_by('sent_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;

		$spamUserIds=array();
		foreach ($rtn['data'] as $row) 
		{
			if(!in_array($row['spammed_by'],$spamUserIds))
				$spamUserIds[]=$row['spammed_by'];
		}

		$spamUsers=array();
		if(count($spamUserIds))
		{
			$tempUsers=$this->users_model->getUsersByIds($spamUserIds);
			foreach ($tempUsers as $userRow)
			{
				$spamUsers[$userRow->id]=$userRow->username;
			}
		}

		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['sent_on']=date("d M Y h:i A",strtotime($row['sent_on']));
			$rtn['data'][$c]['spam_username']='';
			if($row['spam']==1)
			{
				if(isset($spamUsers[$row['spammed_by']]))
				{
					$rtn['data'][$c]['spam_username']='<a href="/usersadmin/view/'.$row['spammed_by'].'" target="_blank">'.$spamUsers[$row['spammed_by']]."</a>";
				}
				else
				{
					$rtn['data'][$c]['spam_username']='<span class="label label-danger">User Deleted</span>';
				}
			}
			else
			{
				$rtn['data'][$c]['spam_username']='-';
			}
			$sno++;
			$c++;
		}
		
		$rtn['spambyusers']=$spamUsers;
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function getChatsByUser()
	{
		$data['flag']=0;
		$data['messages']=array();

		$i=0;
		$query1=$this->siteServivcesDb;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$query1->where("spam",0);

		$filter='';
		$perpage=5;
		if(isset($_POST['search_text']) && $_POST['search_text']!='')
		{
			$query1->like("message",$_POST['search_text']);
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$data['total'] = $temp_result->c;
			$data['total_pages'] = ceil($temp_result->c/$perpage);
			goto step1;
		}
		
		if(isset($_POST['page']) && is_numeric($_POST['page']) && $_POST['page'])
		{
			if($_POST['page']<=$data['total_pages'])
			{
				$page=$_POST['page'];
			}
			else
			{
				$page=$data['total_pages'];
			}
			if($page-1>=0)
			$start=($page-1)*$perpage;
			else
				$start=0;
		}
		else
		{
			$page=1;
			$start=0;
		}
		$query1->order_by("sent_on","desc");
		
		$query1->limit($perpage,$start);

		$q=$query1->get();
		$i=0;
		foreach ($q->result() as $value) 
		{
			$data['messages'][$i]['mid']=$value->id;
			$data['messages'][$i]['user_id']=$value->user_id;
			$data['messages'][$i]['name']=$value->name;
			$data['messages'][$i]['message']=$value->message;
			$data['messages'][$i]['sent_on']=date("d M Y h:i A",strtotime($value->sent_on));
			$i++;
		}
		$data['count']=$i;
		return $data;
	}

	public function getTotalChatsToday($uid)
	{
		$this->siteServivcesDb->from($this->tableName);
		$this->siteServivcesDb->where("user_id",$uid);
		$this->siteServivcesDb->where("date(sent_on)",date("Y:m:d"));
		$q=$this->siteServivcesDb->get();
		return $q->num_rows();
	}

	public function postChat($uid)
	{
		$q=$this->siteServivcesDb->insert("chatbox",
			array(
				'message'=>str_replace('class=',"",trim($_POST['message'])),
				'user_id'=>$uid,
				'sent_on'=>date("Y:m:d H:i:s"),
				'username'=>$this->currentUser->username,
				'name'=>$this->currentUser->firstname
				));
	}

	public function saveMessage($id=0)
	{
		if($id)
		{
			$this->siteServivcesDb->where("id",$id);
			$q=$this->siteServivcesDb->update("chatbox",
				array(
					'message'=>trim($_POST['message']),
					'sent_on'=>date("Y:m:d H:i:s")
					));
			$idd=$id;
		}
		else
		{
			$q=$this->siteServivcesDb->insert("chatbox",
				array(
					'message'=>trim($_POST['message']),
					'user_id'=>$this->currentUser->id,
					'sent_on'=>date("Y:m:d H:i:s"),
					'username'=>$this->currentUser->username,
					'name'=>$this->currentUser->firstname." ".$this->currentUser->lastname
					));
			$idd=$this->siteServivcesDb->insert_id();
		}
		return $idd;
	}
	function  markSpam($mid=0,$uid)
	{
		$data['flag']=0;
		if($mid)
		{
			if(is_numeric($mid))
			{
				$this->siteServivcesDb->where("id",$mid);
				$this->siteServivcesDb->where("user_id !=",$uid);
				$q=$this->siteServivcesDb->get($this->tableName);
				//$q=$this->siteServivcesDb->query("select * from chatbox where id=".$mid." and user_id!=".$uid);
				if($q->num_rows())
				{
					$r=$q->row();
					if($r->spam==0)
					{
						$this->siteServivcesDb->where('id',$mid);
						$this->siteServivcesDb->update("chatbox",
									array(
										'spam'=>1,
										'spammed_on'=>date("Y:m:d H:i:s"),
										'spammed_by'=>$uid
										));
						$data['flag']=1;
					}
					else
					{
						$data['flag']=2;
					}
				}
			}
		}
		return $data;
	}

	public function  removeSpam($mid=0)
	{
		$this->siteServivcesDb->where('id',$mid);
		$this->siteServivcesDb->update("chatbox",
					array(
						'spam'=>0,
						'spammed_by'=>0
						));
		$data['flag']=1;
				
		return $data;
	}
	
	public function  delete($mid=0)
	{
		$this->siteServivcesDb->where("id",$mid);
		$this->siteServivcesDb->delete($this->tableName);
		return 1;
	}
	public function  deleteMessage($mid=0,$uid)
	{
		$data['flag']=0;
		if($mid)
		{
			if(is_numeric($mid))
			{
				$this->siteServivcesDb->where("id",$mid);
				$this->siteServivcesDb->where("user_id",$uid);
				$q=$this->siteServivcesDb->get($this->tableName);
				//$q=$this->siteServivcesDb->query("select * from chatbox where id=".$mid." and user_id=".$uid);
				if($q->num_rows())
				{
					$this->siteServivcesDb->where("id",$mid);
					$this->siteServivcesDb->delete($this->tableName);
					$data['flag']=1;
				}
			}
		}
		return $data;
	}
	
	function message_data($id)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->get($this->tableName);
		return $query->row();
	}
}
?>