<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_20210421000005 extends CI_Migration
{
    public function up()
    {
        if(!$this->db->field_exists('ashram_id', 'pooja_sevakarta_reports_crons'))
        {
            $sql1 ="ALTER TABLE `pooja_sevakarta_reports_crons` ADD `ashram_id` INT(11) NOT NULL DEFAULT '0' AFTER `id`;";
            $this->db->query($sql1);
        }

        $emailDb=$this->load->database("emails",true,false);
        $sql2 ="DROP TABLE IF EXISTS `mail_track_sevakarta_reports`;";
        $emailDb->query($sql2);

        $ashrams = $this->db->select("*")->from("ashrams")->get()->result_array();
        if(count($ashrams)>0)
        {
            $service = "sevakarta_reports";
            foreach($ashrams as $thisAshram)
            {
                $ashramId = $thisAshram['id'];
                $createOrNot = 'No';
                if( (isset($thisAshram['is_poojas_report_email']) && $thisAshram['is_poojas_report_email']==1) || 
                    (isset($thisAshram['is_donations_report_email']) && $thisAshram['is_donations_report_email']==1) || 
                    (isset($thisAshram['is_store_report_email']) && $thisAshram['is_store_report_email']==1) || 
                    (isset($thisAshram['is_subscriptions_report_email']) && $thisAshram['is_subscriptions_report_email']==1) 
                )
                {
                    $createOrNot = 'Yes';
                }
                if($ashramId>0 && trim($service)!='' && $createOrNot == 'Yes')
                {
                    $emailDb=$this->load->database("emails",true,false);
                    $emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_".$service."_".$ashramId."` (
                                      `id` int(11) NOT NULL AUTO_INCREMENT,
                                      `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
                                      `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
                                      `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                      `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                      `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                                      `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                                      `date` datetime NOT NULL,
                                      `sent_on` datetime DEFAULT NULL,
                                      `sent_by` int(11) DEFAULT '0',
                                      `mail_que_id` int(11) DEFAULT '0',
                                      `delivered` int(11) DEFAULT '0',
                                      `bounced` int(4) NOT NULL DEFAULT 0,
                                      `viewed` int(11) DEFAULT '0',
                                      `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
                                      `user_id` int(11) DEFAULT '0',
                                      `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                                      `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
                                      `resent` int(11) DEFAULT '0',
                                      `resent_id` int(11) NOT NULL DEFAULT '0',
                                      `type` int(11) DEFAULT '0',
                                      `mail_track_id` int(11) DEFAULT '0',
                                      `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
                                      `debug` mediumtext COLLATE utf8mb4_unicode_ci,
                                      `reads` int(11) NOT NULL DEFAULT '0',
                                      `clicked` int(11) DEFAULT '0',
                                      `priority` int(11) NOT NULL DEFAULT '0',
                                      PRIMARY KEY(`id`)
                                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

                    $serviceSlug = $service."_".$ashramId;
                    $email_setting_check = $this->db->select("id")->from("email_settings")->where("service_slug",$serviceSlug)->get();
                    if($email_setting_check->num_rows() == 0)
                    {
                         $this->db->insert('email_settings',
                          array(
                              'service_slug'=>$serviceSlug,
                              'smtp_host'=>base_domain,
                              'smtp_port'=>'587',
                              'email_template'=>'email_template',
                              'ashram_name'=>"",
                              "from_email"=>"noreply-".$serviceSlug,
                              "from_name"=>"SGS Ashrama - Sevakarta Reports",
                              "signature"=>"Kind Regards,<br>SGS Ashrama Tech Team<br>",
                              'ashram_id'=>0
                            )
                         );
                    }
                }
            }
        }
    }

    public function down()
    {

    }
}
?>