<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_20201202000002 extends CI_Migration {

    public function up()
    {
        $emailDb=$this->load->database("emails",true,false);
        $insert_sql = "CREATE TABLE IF NOT EXISTS `mail_track_mismatch_ashram_orders` (
                      `id` int(11) NOT NULL AUTO_INCREMENT,
                      `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
                      `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
                      `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                      `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                      `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                      `date` datetime NOT NULL,
                      `sent_on` datetime DEFAULT NULL,
                      `sent_by` int(11) DEFAULT '0',
                      `mail_que_id` int(11) DEFAULT '0',
                      `delivered` int(11) DEFAULT '0',
                      `viewed` int(11) DEFAULT '0',
                      `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
                      `user_id` int(11) DEFAULT '0',
                      `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                      `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
                      `resent` int(11) DEFAULT '0',
                      `resent_id` int(11) NOT NULL DEFAULT '0',
                      `type` int(11) DEFAULT '0',
                      `mail_track_id` int(11) DEFAULT '0',
                      `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
                      `debug` mediumtext COLLATE utf8mb4_unicode_ci,
                      `reads` int(11) NOT NULL DEFAULT '0',
                      `clicked` int(11) DEFAULT '0',
                      `priority` int(11) NOT NULL DEFAULT '0',
                      PRIMARY KEY(`id`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
        $emailDb->query($insert_sql);
        
        log_message("error","Table (mail_track_mismatch_ashram_orders) Created in Emails DB  for Migration_20201202000002");

        $email_setting_check = $this->db->select("id")->from("email_settings")->where("service_slug","mismatch_ashram_orders")->get();
        if($email_setting_check->num_rows() == 0)
        {
            $this->db->insert('email_settings',
              array(
                        'service_slug'=>"mismatch_ashram_orders",
                        'from_email'=>"noreply-payments",
                        'from_name'=>"SGS Ashrama - Payments",
                        "signature"=>"Kind Regards,<br>Office Accounts<br>SGS Ashrama<br>Mysore, India",
                        'smtp_host'=>base_domain,
                        'smtp_port'=>0,
                        'email_template'=>'email_template',
                    )
                );

            log_message("error","Email Settings Inserted in Main DB (Table email_settings) with service sulg mismatch_ashram_orders for Migration_20201202000002");
        }

        $insert_sql2 = "CREATE TABLE IF NOT EXISTS `mismatch_ashram_orders` (
                      `id` int(11) NOT NULL AUTO_INCREMENT,
                      `currency` varchar(15) DEFAULT NULL,
                      `order_amount` int(10) DEFAULT NULL,
                      `order_id` bigint(20) DEFAULT NULL,
                      `order_number` varchar(60) DEFAULT NULL,
                      `order_ashram_id` int(4) DEFAULT NULL,
                      `original_ashram_id` int(4) DEFAULT NULL,
                      `order_date` datetime DEFAULT NULL,
                      `payment_mode` varchar(100) DEFAULT NULL,
                      `order_type` int(2) DEFAULT NULL,
                      PRIMARY KEY(`id`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
        $this->db->query($insert_sql2);

        log_message("error","Table (mismatch_ashram_orders) Created in Main DB  for Migration_20201202000002");

        $insert_sql23 = "INSERT INTO `acl` (`id`, `title`, `description`, `controller`, `method`, `roles`, `is_ajax`, `active`, `excel_columns`, `need_admin_login`, `need_user_login`, `search_columns`, `sort_columns`) VALUES (NULL, NULL, NULL, 'Orders', 'mismatch_ashram_orders', '1,3,4', '0', '1', NULL, '0', '0', NULL, NULL);";

        $this->db->query($insert_sql23);

        log_message("error","ACL Created in Main DB  for Migration_20201202000002");

        $insert_sql24 = "INSERT INTO `acl` (`id`, `title`, `description`, `controller`, `method`, `roles`, `is_ajax`, `active`, `excel_columns`, `need_admin_login`, `need_user_login`, `search_columns`, `sort_columns`) VALUES (NULL, NULL, NULL, 'Orders', 'misc_ordersc', '1,3,4', '1', '1', 'order_id:Order ID', '0', '0', 'order_id', 'order_date,currency,order_amount');";

        $this->db->query($insert_sql24);

        log_message("error","ACL Created in Main DB  for Migration_20201202000002");
    }

    public function down()
    {
        $sql="";
        $sqls=explode(";",$sql);
        foreach ($sqls as $q)
        {
            if($q!='')
            $this->db->query($q);
        }
    }
}
?>