<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_20200815000001 extends CI_Migration
{
    public function up()
    {
        $create_sql1 = "CREATE TABLE IF NOT EXISTS `subscriptions_categories` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `name` varchar(255) NOT NULL,
                `order` int(11) NOT NULL DEFAULT 0,
                `description` text DEFAULT NULL,
                `allow_public_display` int(2) NOT NULL DEFAULT 1,
                `created_on` datetime NOT NULL,
                `modified_on` datetime NOT NULL,
                `category_ashram_id` int(11) NOT NULL DEFAULT 0 COMMENT 'id - ashrams table primary key',
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;";

        $this->db->query($create_sql1);

        $create_sql2 = "CREATE TABLE IF NOT EXISTS `subscriptions_bundle` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `bundle_id` int(11) NOT NULL,
                `subscription_id` int(11) NOT NULL,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;";

        $this->db->query($create_sql2);

        $create_sql3 = "CREATE TABLE IF NOT EXISTS `subscriptions` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `subscription_name` varchar(200) NOT NULL,
                `category` int(11) NOT NULL DEFAULT 9,
                `description` longtext DEFAULT NULL,
                `is_external_link` int(11) NOT NULL DEFAULT 0,
                `external_link` text DEFAULT NULL,
                `is_public_display` tinyint(2) NOT NULL DEFAULT 1,
                `have_personal_note` smallint(2) NOT NULL DEFAULT 0,
                `is_price_fixed` int(11) NOT NULL DEFAULT 0,
                `price_inr` int(100) DEFAULT 0,
                `price_usd` int(100) DEFAULT 0,
                `shipping` int(11) NOT NULL DEFAULT 0,
                `shipping_domestic_inr` int(11) NOT NULL DEFAULT 0,
                `shipping_domestic_usd` int(11) NOT NULL DEFAULT 0,
                `shipping_international_inr` int(11) NOT NULL DEFAULT 0,
                `shipping_international_usd` int(11) NOT NULL DEFAULT 0,
                `inr_display` int(11) NOT NULL DEFAULT 1,
                `usd_display` int(11) NOT NULL DEFAULT 1,
                `subscription` int(11) NOT NULL DEFAULT 0,
                `onetime_charge_inr` int(11) NOT NULL DEFAULT 0,
                `onetime_charge_usd` int(11) NOT NULL DEFAULT 0,
                `period` varchar(10) DEFAULT NULL,
                `frequency` int(11) NOT NULL DEFAULT 1,
                `expiration_method` int(11) NOT NULL DEFAULT 1,
                `expiry_date` date DEFAULT NULL,
                `num_of_payments` int(11) NOT NULL DEFAULT 0,
                `ashram_id` int(11) DEFAULT NULL,
                `status` int(11) DEFAULT 1,
                `partial_payments_allowed` int(11) NOT NULL DEFAULT 1,
                `image` mediumtext DEFAULT NULL,
                `s_flag` int(11) NOT NULL DEFAULT 0,
                `s_key` varchar(100) DEFAULT NULL,
                `order` int(11) NOT NULL DEFAULT 0,
                `is_bundle` int(11) NOT NULL DEFAULT 0,
                `is_used` int(11) NOT NULL DEFAULT 0,
                `assign_pet` int(11) NOT NULL DEFAULT 0,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;";

        $this->db->query($create_sql3);


        $sql4 = "INSERT INTO `acl` (`id`, `title`, `description`, `controller`, `method`, `roles`, `is_ajax`, `active`, `excel_columns`, `need_admin_login`, `need_user_login`, `search_columns`, `sort_columns`) VALUES
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'index', '1,3', 0, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'listc', '1,3', 1, 1, 'subscription_name:Subscription Name', 0, 0, 'subscription_name', 'subscription_name,status,price_inr,price_usd'),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'add_edit_subscription', '1,3', 0, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'delete', '1,3', 1, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'namecheck', '1,3', 1, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'changestatus', '1,3', 1, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'categories', '1,3', 0, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'listcats', '1,3', 1, 1, 'name:Category name', 0, 0, 'name', 'name,created_on,modified_on'),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'add_edit_category', '1,3', 0, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'delete_category', '1,3', 1, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'category_updateorder', '1,3', 1, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'categorycheckname', '1,3', 1, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'searchsubscription', '1,4', 1, 1, NULL, 0, 0, NULL, NULL),
                (NULL, NULL, NULL, 'Subscriptionitemsadmin', 'subscription_updateorder', '1,3', 1, 1, NULL, 0, 0, NULL, NULL);";
        $this->db->query($sql4);
    }

    public function down()
    {
        $sql1="DELETE TABLE `subscriptions_categories`";
        $this->db->query($sql1);

        $sql2="DELETE TABLE `subscriptions_bundle`";
        $this->db->query($sql2);

        $sql3="DELETE TABLE `subscriptions`";
        $this->db->query($sql3);
    }
}
?>