<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_20200806000002 extends CI_Migration 
{
    public function up()
    {
        $sql = "CREATE TABLE IF NOT EXISTS `transaction_temp` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `userid` int(11) DEFAULT 0,
                  `tx` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `sub_transaction` int(11) NOT NULL DEFAULT 0,
                  `sub_tx` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `is_sub_tx` int(11) NOT NULL DEFAULT 0,
                  `reference_id` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `ashram_id` int(11) NOT NULL DEFAULT 0,
                  `status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payu_currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `amount` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `paypal_currency` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payment_mode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payment_number` int(11) NOT NULL DEFAULT 0,
                  `subscription` int(11) NOT NULL DEFAULT 0,
                  `subscription_payment_id` int(11) NOT NULL DEFAULT 0,
                  `date` datetime DEFAULT NULL,
                  `order_id` int(11) DEFAULT NULL,
                  `order_item_id` int(11) NOT NULL DEFAULT 0,
                  `payu_mihpayid` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payu_mode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `authorizenet_mode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `authorizenet_authcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payu_unmapped_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `discount` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `created_on` datetime DEFAULT NULL,
                  `firstname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `lastname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `city` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `country_isd_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `zipcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `phone` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `hash` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `pg_type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `bank_ref_num` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `bankcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `cardnum` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `cardhash` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field1` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field2` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field3` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field4` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field5` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field6` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field7` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `field8` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf1` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf2` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf3` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf4` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf5` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf6` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf7` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf8` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf9` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `udf10` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `cheque_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `bank_name` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `branch` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `account_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `account_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `received_by` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `received_userid` int(11) DEFAULT 0,
                  `received_date` datetime DEFAULT NULL,
                  `note` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `t_status` int(11) DEFAULT 0,
                  `modified_on` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
                  `started_on` datetime DEFAULT NULL,
                  `redirect_url` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `flashvars` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `error` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `order_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `flag` int(11) NOT NULL DEFAULT 0,
                  `is_manual_payment` int(11) NOT NULL DEFAULT 0,
                  `manual_receipt_number` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `manual_receipt_date` datetime DEFAULT NULL,
                  `offline_number` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `offline_bank` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `offline_date` datetime DEFAULT NULL,
                  `is_foreign_payment` int(11) DEFAULT 0,
                  `foreign_currency` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `foreign_amount` int(11) DEFAULT 0,
                  `realized_amount` int(11) DEFAULT 0,
                  `refund_reference` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `refund_date` datetime DEFAULT NULL,
                  `refund_mode` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;";
        $this->db->query($sql);
        $sql1 = "CREATE TABLE IF NOT EXISTS `orders_temp` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `order_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `order_type` int(11) NOT NULL DEFAULT 1,
                  `date` datetime NOT NULL,
                  `user_id` int(10) NOT NULL DEFAULT 0,
                  `username` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `total_price` int(100) DEFAULT 0,
                  `paid` int(11) NOT NULL DEFAULT 0,
                  `total_paid` float NOT NULL DEFAULT 0,
                  `transaction_ids` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `price_in_words` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `status` int(11) DEFAULT 0,
                  `created_by` int(11) DEFAULT 0 COMMENT '0=Guest,1=Admin,2=User',
                  `ashram_id` int(11) DEFAULT 0,
                  `ashram_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payment_status` int(11) DEFAULT 0 COMMENT '0=Pending,1=Paid,2=Partially Paid',
                  `partial_payments_allowed` int(11) NOT NULL DEFAULT 0,
                  `payment_mode` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payment_alt_mode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `is_manual_payment` int(11) NOT NULL DEFAULT 0,
                  `firstname` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `middlename` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `lastname` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `preferred_name` varchar(205) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `email` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `phone` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address1` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address2` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address3` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `city` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `state` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `country` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `zipcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `donation_initials` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `trust_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `trust_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `trust_ashram_footer` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `tax_80g_501c3` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `donation_type` int(11) DEFAULT 0,
                  `indian` int(11) DEFAULT 1,
                  `need_tax_letter` int(11) DEFAULT 0,
                  `tokens` int(11) DEFAULT 0,
                  `dispatch_status` int(11) NOT NULL DEFAULT 0,
                  `dispatched` int(11) NOT NULL DEFAULT 0,
                  `dispatch_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `created_by_user_id` int(11) NOT NULL DEFAULT 0,
                  `tokens_issued_on` datetime DEFAULT NULL,
                  `tokens_issued_by` int(11) NOT NULL DEFAULT 0,
                  `old_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `app` int(11) NOT NULL DEFAULT 0,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;";
        $this->db->query($sql1);

        $sql2 = 'CREATE TABLE IF NOT EXISTS `order_items_temp` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `order_id` int(11) NOT NULL,
                  `item_id` int(11) NOT NULL,
                  `quantity` int(11) NOT NULL,
                  `item_name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
                  `category` int(11) NOT NULL DEFAULT 0,
                  `donor_id` int(11) NOT NULL DEFAULT 0,
                  `pet_id` int(11) NOT NULL DEFAULT 0,
                  `price` float NOT NULL,
                  `onetime_charge` int(11) NOT NULL DEFAULT 0,
                  `start_date` date DEFAULT NULL,
                  `end_date` date DEFAULT NULL,
                  `time_from` time DEFAULT NULL,
                  `time_to` time DEFAULT NULL,
                  `schedule_dates` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `options` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `assign_pet` int(11) NOT NULL DEFAULT 0,
                  `subscription` int(11) NOT NULL DEFAULT 0,
                  `period` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `frequency` int(11) NOT NULL DEFAULT 0,
                  `expiration_method` int(11) NOT NULL DEFAULT 0,
                  `num_of_payments` int(11) NOT NULL DEFAULT 0,
                  `given_expiry_date` date DEFAULT NULL,
                  `subscription_id` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `status` int(11) NOT NULL DEFAULT 1 COMMENT "0=Pending,1=Active,2=Cancelled,3=Expired",
                  `subscription_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `next_payment_date` date DEFAULT NULL,
                  `last_payment_date` date DEFAULT NULL,
                  `expiry_date` date DEFAULT NULL,
                  `last_read` date DEFAULT NULL,
                  `sequence` int(11) NOT NULL DEFAULT 0,
                  `note` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `gift_friend_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `gift_friend_email` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `prasadam_not_required` tinyint(2) NOT NULL DEFAULT 0,
                  `personal_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `name_of_family_type` int(11) NOT NULL,
                  `have_personal_note` int(2) NOT NULL DEFAULT 0,
                  `pooja_on_swamiji` tinyint(2) NOT NULL DEFAULT 0,
                  `pooja_on_teertha_swamiji` tinyint(2) NOT NULL DEFAULT 0,
                  `family_members` text COLLATE utf8mb4_unicode_ci NOT NULL,
                  `shipping` int(11) NOT NULL DEFAULT 0,
                  `shipping_price` int(11) NOT NULL DEFAULT 0,
                  `shipping_address1` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `shipping_address2` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `shipping_address3` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `shipping_city` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `shipping_state` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `shipping_country_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `shipping_country` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payment_mode` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;';
        $this->db->query($sql2);

        $sql3 = "CREATE TABLE IF NOT EXISTS `orders_failed` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `order_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `response_message` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `order_type` int(11) NOT NULL DEFAULT 1,
                  `date` datetime NOT NULL,
                  `user_id` int(10) NOT NULL DEFAULT 0,
                  `username` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `total_price` int(100) DEFAULT 0,
                  `paid` int(11) NOT NULL DEFAULT 0,
                  `total_paid` float NOT NULL DEFAULT 0,
                  `transaction_ids` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `price_in_words` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `status` int(11) DEFAULT 0,
                  `created_by` int(11) DEFAULT 0 COMMENT '0=Guest,1=Admin,2=User',
                  `ashram_id` int(11) DEFAULT 0,
                  `ashram_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payment_status` int(11) DEFAULT 0 COMMENT '0=Pending,1=Paid,2=Partially Paid',
                  `partial_payments_allowed` int(11) NOT NULL DEFAULT 0,
                  `payment_mode` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `payment_alt_mode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `is_manual_payment` int(11) NOT NULL DEFAULT 0,
                  `firstname` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `middlename` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `lastname` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `preferred_name` varchar(205) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `email` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `phone` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address1` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address2` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `address3` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `city` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `state` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `country` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `zipcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `donation_initials` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `trust_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `trust_address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `trust_ashram_footer` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `tax_80g_501c3` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `donation_type` int(11) DEFAULT 0,
                  `indian` int(11) DEFAULT 1,
                  `need_tax_letter` int(11) DEFAULT 0,
                  `tokens` int(11) DEFAULT 0,
                  `dispatch_status` int(11) NOT NULL DEFAULT 0,
                  `dispatched` int(11) NOT NULL DEFAULT 0,
                  `dispatch_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `created_by_user_id` int(11) NOT NULL DEFAULT 0,
                  `tokens_issued_on` datetime DEFAULT NULL,
                  `tokens_issued_by` int(11) NOT NULL DEFAULT 0,
                  `old_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                  `app` int(11) NOT NULL DEFAULT 0,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;";
        $this->db->query($sql3);

        if ($this->db->field_exists('subscription', 'cart_data'))
        {
        }
        else
        {
            $sql4 ="ALTER TABLE `cart_data` ADD `subscription` SMALLINT(2) NOT NULL DEFAULT '0' AFTER `cart_type`;";
            $this->db->query($sql4);
        }

        $this->db->cache_on();
        $sql5 = 'INSERT INTO `website_settings` (`id`, `meta_name`, `meta_value`) VALUES (NULL, "subscriptions", "1");';
        $this->db->query($sql5);
        $this->db->cache_off();
    }

    public function down()
    {
        $sql="DROP table `transaction_temp`; DROP table `orders_temp`; DROP table `order_items_temp`; DROP table `orders_failed`; ALTER table `cart_data` DROP `subscription`;";
        $sqls=explode(";",$sql);
        foreach ($sqls as $q)
        {
            if($q!='')
            $this->db->query($q);
        }
    }
}
?>