<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_20190801000004 extends CI_Migration {

	/**
	 * To Insert Mail Queue of Order Details and Transaction Details for both user and bcc email
	 * Only for ashram {{Ashram_id: 5}}
	 * And It is just to save template data in to respectivee queue's. Will not send any emails
	 * @author Baji Shaik [bajidotwork@gmail.com] - 30 Jul 2019
	 * ---Ticket: 467 (bajidotwwork_DPDEV-467)
	 */
    public function up()
    {

        $service_slug = 'payments_5_inr';

        $this->load->model("subscriptions/donors_model");
        $this->load->model("orders/orders_model");
        $this->load->model("general_model");
        $this->load->model('locations_model');

        ini_set('max_execution_time', 0);
        
        $q = $this->db->select('id,transaction_id')->from('orders')->where('ashram_id',5)->where('currency','inr')->where('transaction_id!=','')->get();

        if($q->num_rows() > 0)
        {
            $r = $q->result_array();
            if(!empty($r))
            {
                foreach ($r as $key => $value) 
                {
                    $sent_by = 0;
                    $orderData=$this->orderData($value['id']);
                    $data['orderData']=$orderData;
                    $data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
                    /**===================================Insert Data In to Mail Queue Table===========================**/

                    /*----------  User Emails Order Details  ----------*/

                    $data['name'] = $orderData['order']->firstname." ".$orderData['order']->lastname;
                    $data['signature'] = "";

                    if($orderData['order']->order_type==3)
                        $subject=$orderData['order']->ashram_name.' - Order Details for Order ID: '.$orderData['order']->order_number;
                    else
                        $subject=$orderData['order']->ashram_name.' - Seva Details - Seva ID: '.$orderData['order']->order_number;
                    
                    $body=$this->load->view("orders/public/_email_order_details_bcc",$data,true);
                    $content=$this->load->view("common/templates/email_template",array("body"=>$body),true);

                    $this->emailDb=$this->load->database("emails",true,false);

                    /*----------  BCC Emails Order Details  ----------*/

                    $mail_data=array('mail_to' => orders_email_cc, 'mail_subject' =>$subject, 'mail_content' =>$content, 'date' =>date("Y:m:d H:i:s"), 'sent_by'=>$sent_by, 'status'=>1, 'resent'=>0, 'resent_id'=>0, 'user_id'=>$orderData['order']->user_id, 'username'=>$orderData['order']->username, 'priority'=>1,'delivered'=>1,'viewed'=>1 );
                    $this->emailDb->insert('mail_track_'.$service_slug,$mail_data);

                    /*----------  BCC Emails Order Details  ----------*/
                    
                    /**===================================Insert Data In to Mail Queue Table===========================**/
                }
            }
        }
    }

    public function getTransactionByTx($tx)
    {
        $this->db->where("tx",$tx);
        $transaction=$this->db->get("transaction");
        $txrow=$transaction->row();

        if(empty($txrow))
            return array();

        if($txrow->sub_transaction==1)
        {
            $this->db->select("
                                *
                                ,t2.amount as amount
                                ,t2.id as id
                            ");
            $this->db->from("transaction as t");
            $this->db->join("transaction as t2","t.tx=t2.sub_tx");
            $this->db->where("t.tx",$txrow->sub_tx);
            $this->db->where("t2.tx",$tx);

            $transaction=$this->db->get();
            $txrow=$transaction->row();
        }
        return $txrow;
    }

    public function orderData($id)
    {
        $this->db->where("id",$id);
        $q=$this->db->get("orders");
        $result['order']=$q->row();
        $result['order_items']=array();
        $result['order_items_files']=array();
        if($q->num_rows())
        {
            $this->db->select("*,oi.id as id,oi.id as order_item_id,p.id as pet_id");
            $this->db->where("order_id",$id);
            $this->db->from("order_items as oi");
            $this->db->join("pets as p","p.id=oi.pet_id","left");
            $items=$this->db->get();
            $result['order_items']=$items->result();

            $this->db->where("order_id",$id);
            $items=$this->db->get("order_log");
            $result['order_log']=$items->result();

            $this->db->where("order_id",$id);
            $items=$this->db->get("order_items_files");
            if($items->num_rows())
            {
                $result['order_items_files']=$items->result();
                foreach ($result['order_items_files'] as $fileData)
                {
                    $this->db->where("file_id",$fileData->id);
                    $tempD=$this->db->get("order_items_downloads")->result();
                    $result['order_items_downloads'][$fileData->id]=$tempD;
                }
            }

            $this->db->where("order_id",$id);
            $payflow_card=$this->db->get("subscription_profiles_payflow")->row();
            $result['payflow_card']=$payflow_card;
        }
        return $result;
    }

    public function down()
    {
         $sql='';
        $sqls=explode(";",$sql);
        foreach ($sqls as $q)
        {
            if($q!='')
            $this->db->query($q);
        }
    }
}
?>