<?php if (!defined('BASEPATH'))	exit('No direct script access allowed');
require_once 'vendor/aws/aws-autoloader.php';
use Aws\Credentials\CredentialProvider;
use Aws\S3\S3Client;
use Aws\Sns\SnsClient; 
use Aws\Exception\AwsException;

class SMS
{
	public function __construct()
	{
		$this->CI =& get_instance();
        $this->CI->load->model("sms_model");
        $this->CI->load->model("services_model");
        $this->CI->load->library("userutil");
        $this->CI->load->model("logaction");
        $this->CI->load->model("failed_sms_model");
	}
	public function sendSMS($serviceSlug,$number,$message,$gateway=1,$userID=0,$username='',$countryCode="")
	{
		if($GLOBALS['site_settings']['sms_service']==0)
    	{
    		return true;
    	}
		if(trim($number)=='')
		{
			$data['flag']=0;
			$data['msg']="Number is empty";
			return $data;
		}
		if(trim($message)=='')
		{
			$data['flag']=0;
			$data['msg']="Message is empty";
			return $data;
		}
		if(is_numeric($userID) && $userID)
		{
			$userData=$this->CI->users_model->userData($userID);
			if(!empty($userData) && ($userData->block_sms ==0) )
			{
				if($this->CI->failed_sms_model->validateFailData($number) == 2)
				{
					if($countryCode != "" && ($countryCode == "91" || $countryCode == "IN"))
						$rr=$this->_sendSMSIndia($number,$message);
					else
						$rr=$this->_sendSMS($number,$message);
				}
				else
				{
					$rr = new stdClass();
					$rr->error = "Failed So many times";
					$rr->api_id = "N/A";
					$this->CI->failed_sms_model->saveFailedSMS($number);
				}
				if(!isset($rr->error) && isset($rr->message_uuid[0]))
				{
					$queueID=$rr->message_uuid[0];	
					$this->CI->sms_model->trackSMS($serviceSlug,$userID,$queueID,$number,$message,1,'',0,0,$username);
					$this->CI->logaction->log($serviceSlug,"SMS sent to ".$number." | ID: ".$queueID);
					$data['flag']=1;
					$data['smsid']=$queueID;
					$data['msg']="SMS sent successfully";
				}
				else
				{
					$queueID=$rr->api_id;
					$this->CI->sms_model->trackSMS($serviceSlug,$userID,$queueID,$number,$message,2,$rr->error,0,0,$username);
					$this->CI->logaction->log($serviceSlug,"SMS failed to ".$number." | ID: ".$queueID." | Reason: ".$rr->error);
					$data['flag']=0;
					$data['smsid']=$queueID;
					$data['msg']="SMS failed";
				}
				return $data;
			}
			else
			{
				$data['flag']=0;
				
				$this->CI->logaction->log($serviceSlug,"SMS to ".$number ." is rejected | Invalid user");
				$data['msg']="Invalid user";
				return $data;
			}
		}
		else
		{
			$data['flag']=0;
			$data['msg']="Invalid User ID";
			return $data;
		}
	}

	public function sendSMSNL($serviceSlug,$number,$message,$gateway=1,$userID=0,$username='',$countryCode="")
	{
		if($GLOBALS['site_settings']['sms_service']==0)
    	{
    		return true;
    	}
		if(trim($number)=='')
		{
			$data['flag']=0;
			$data['msg']="Number is empty";
			return $data;
		}
		if(trim($message)=='')
		{
			$data['flag']=0;
			$data['msg']="Message is empty";
			return $data;
		}
		if(is_numeric($userID) && $userID)
		{
			$userData=$this->CI->users_model->userData($userID);
			if(!empty($userData) && ($userData->block_sms ==0) )
			{
				if($this->CI->failed_sms_model->validateFailData($number) == 2)
				{
					if($countryCode != "" && ($countryCode == "91" || $countryCode == "IN"))
						$rr=$this->_sendSMSIndia($number,$message);
					else
						$rr=$this->_sendSMS($number,$message);
				}
				else
				{
					$rr = new stdClass();
					$rr->error = "Failed So many times";
					$rr->api_id = "N/A";
					$this->CI->failed_sms_model->saveFailedSMS($number);
				}

				if(!isset($rr->error) && isset($rr->message_uuid[0]))
				{
					$queueID=$rr->message_uuid[0];	
					//$this->CI->sms_model->trackSMS($serviceSlug,$userID,$queueID,$number,$message,1,'',0,0,$username);
					$this->CI->logaction->log($serviceSlug,"SMS sent to ".$number." | ID: ".$queueID);
					$data['flag']=1;
					$data['smsid']=$queueID;
					$data['msg']="SMS sent successfully";
				}
				else
				{
					$queueID=$rr->api_id;
					//$this->CI->sms_model->trackSMS($serviceSlug,$userID,$queueID,$number,$message,2,$rr->error,0,0,$username);
					$this->CI->logaction->log($serviceSlug,"SMS failed to ".$number." | ID: ".$queueID." | Reason: ".$rr->error);
					$data['flag']=0;
					$data['smsid']=$queueID;
					$data['msg']="SMS failed";
				}
				return $data;
			}
			else
			{
				$data['flag']=0;
				
				$this->CI->logaction->log($serviceSlug,"SMS to ".$number ." is rejected | Invalid user");
				$data['msg']="Invalid user";
				return $data;
			}
		}
		else
		{
			$data['flag']=0;
			$data['msg']="Invalid User ID";
			return $data;
		}
	}

	public function sendSMSGuest($serviceSlug,$country_code,$number,$message)
	{
		if($GLOBALS['site_settings']['sms_service']==0)
    	{
    		return true;
    	}
		if(trim($number)=='')
		{
			$data['flag']=0;
			$data['msg']="Number is empty";
			return $data;
		}
		if(trim($message)=='')
		{
			$data['flag']=0;
			$data['msg']="Message is empty";
		}
		if($country_code=='91')
		{
			if($this->CI->failed_sms_model->validateFailData($number) == 2)
			{
				$rr=$this->_sendSMSIndia($number,$message);
			}
			else
			{
				$rr = new stdClass();
				$rr->error = "Failed So many times";
				$rr->api_id = "N/A";
				$this->CI->failed_sms_model->saveFailedSMS($number);
			}
			
			if(!isset($rr->error) && isset($rr->message_uuid[0]))
			{
				$queueID=$rr->message_uuid[0];	
				$this->CI->sms_model->trackSMS($serviceSlug,0,$queueID,$number,$message,1,'',0,0,null);
				$this->CI->logaction->log($serviceSlug,"SMS sent to ".$number." | ID: ".$queueID);
				$data['flag']=1;
				$data['smsid']=$queueID;
				$data['msg']="SMS sent successfully";
			}
			else
			{
				$queueID=$rr->api_id;
				$this->CI->sms_model->trackSMS($serviceSlug,0,$queueID,$number,$message,2,$rr->error,0,0,null);
				$this->CI->logaction->log($serviceSlug,"SMS failed to ".$number." | ID: ".$queueID." | Reason: ".$rr->error);
				$data['flag']=0;
				$data['smsid']=$queueID;
				$data['msg']="SMS failed";
			}
		}
		else
		{
			if($this->CI->failed_sms_model->validateFailData($number) == 2)
			{
				$rr=$this->_sendSMS($number,$message);
			}
			else
			{
				$rr = new stdClass();
				$rr->error = "Failed So many times";
				$rr->api_id = "N/A";
				$this->CI->failed_sms_model->saveFailedSMS($number);
			}
			if(!isset($rr->error) && isset($rr->message_uuid[0]))
			{
				$queueID=$rr->message_uuid[0];	
				$this->CI->sms_model->trackSMS($serviceSlug,0,$queueID,$number,$message,1,'',0,0,null);
				$this->CI->logaction->log($serviceSlug,"SMS sent to ".$number." | ID: ".$queueID);
				$data['flag']=1;
				$data['smsid']=$queueID;
				$data['msg']="SMS sent successfully";
			}
			else
			{
				$queueID=$rr->api_id;
				$this->CI->sms_model->trackSMS($serviceSlug,0,$queueID,$number,$message,2,$rr->error,0,0,null);
				$this->CI->logaction->log($serviceSlug,"SMS failed to ".$number." | ID: ".$queueID." | Reason: ".$rr->error);
				$data['flag']=0;
				$data['smsid']=$queueID;
				$data['msg']="SMS failed";
			}
		}
		return $data;
	}

	public function sendSMSNoTrack($number,$message,$countryCode="")
	{
		if($GLOBALS['site_settings']['sms_service']==0)
    	{
    		return true;
    	}
		$data['flag']=0;
		$data['smsid']='';
		if(trim($number)=='')
		{
			$data['msg']="Number is empty";
			return $data;
		}
		if(trim($message)=='')
		{
			$data['msg']="Message is empty";
			return $data;
		}
		
		if($this->CI->failed_sms_model->validateFailData($number) == 2)
		{
			if($countryCode != "" && ($countryCode == "91" || $countryCode == "IN"))
				$rr=$this->_sendSMSIndia($number,$message);
			else
				$rr=$this->_sendSMS($number,$message);
		}
		else
		{
			$rr = new stdClass();
			$rr->error = "Failed So many times";
			$rr->api_id = "N/A";
			$this->CI->failed_sms_model->saveFailedSMS($number);
		}
		
		if(isset($rr->message_uuid))
		{
			$messageID=$rr->message_uuid[0];
			$data['flag']=1;
			$data['smsid']=$messageID;
			$data['msg']="SMS sent successfully";
		}
		else
		{
			if(isset($rr->api_id))
				$data['msg']="Failed. Api ID:".$rr->api_id.", ".$rr->error;
			else
				$data['msg']="Failure";
		}
		return $data;	
	}

	private function _sendSMSIndia($mobileNumber,$message)
	{
		$mobileNumberInitial = $mobileNumber[0];
		if($mobileNumberInitial == "+")
			$mobileNumber = $mobileNumber;
		else
			$mobileNumber = "+".$mobileNumber;

		$SnSclient = new SnsClient([
            //'profile' => 'default',
            'version' => 'latest',
            'region'  => india_aws_sns_sms_region,
            'credentials' => [
                            "key" => india_aws_sns_sms_access_key,
                            "secret" => india_aws_sns_sms_secret_key
                        ]
        ]);
        try 
        {
            $result = $SnSclient->publish([
                "MessageAttributes" => [
                    'AWS.SNS.SMS.SenderID' => [
                        'DataType' => 'String',
                        'StringValue' => india_aws_sns_sms_senderID
                    ],
                    'AWS.SNS.SMS.SMSType' => [
                        'DataType' => 'String',
                        'StringValue' => 'Transactional'
                    ]
                ],
                'Message' => $message,
                'PhoneNumber' => $mobileNumber,
            ]);
            $response = new stdclass ();
            $response->message_uuid[0] = $result["MessageId"];
            $response->api_id = $result['@metadata']['headers']["x-amzn-requestid"];
            $response->status = $result['@metadata']['statusCode'];
            return $response;
        }
        catch (AwsException $e) 
        {
            $response = new stdclass ();
            $response->error = $e->getMessage();
            $response->status = $e->getStatusCode();
            $response->api_id = "";
            return $response;
        }
	}

	private function _sendSMS($mobileNumber,$message)
	{
		$mobileNumberInitial = $mobileNumber[0];
		if($mobileNumberInitial == "+")
			$mobileNumber = $mobileNumber;
		else
			$mobileNumber = "+".$mobileNumber;

		$SnSclient = new SnsClient([
            //'profile' => 'default',
            'version' => 'latest',
            'region'  => other_countries_aws_sns_sms_region,
            'credentials' => [
                            "key" => other_countries_aws_sns_sms_access_key,
                            "secret" => other_countries_aws_sns_sms_secret_key
                        ]
        ]);
        try 
        {
            $result = $SnSclient->publish([
                "MessageAttributes" => [
                    'AWS.SNS.SMS.SenderID' => [
                        'DataType' => 'String',
                        'StringValue' => other_countries_aws_sns_sms_senderID
                    ],
                    'AWS.SNS.SMS.SMSType' => [
                        'DataType' => 'String',
                        'StringValue' => 'Transactional'
                    ]
                ],
                'Message' => $message,
                'PhoneNumber' => $mobileNumber,
            ]);
            $response = new stdclass ();
            $response->message_uuid[0] = $result["MessageId"];
            $response->api_id = $result['@metadata']['headers']["x-amzn-requestid"];
            $response->status = $result['@metadata']['statusCode'];
            return $response;
        }
        catch (AwsException $e) 
        {
            $response = new stdclass ();
            $response->error = $e->getMessage();
            $response->status = $e->getStatusCode();
            $response->api_id = "";
            return $response;
        }
	}

	private function _sendSMSTextLocalIndia($mobileNumber,$message)
	{
		$sender = ""; // This is who the message appears to be from.
		// 612 chars or less
		// A single number or a comma-seperated list of numbers
		$message = urlencode($message);
		$data = "username=".textlocal_username."&hash=".textlocal_hash."&message=".$message."&sender=".$sender."&numbers=".$mobileNumber;
		$ch = curl_init('http://api.textlocal.in/send/?');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($ch); // This is the result from the API
		curl_close($ch);
		return $result;
	}

	public function sendSMSWithoutUserId($serviceSlug,$number,$message,$gateway=1,$userID=0,$username='')
	{
		if($GLOBALS['site_settings']['sms_service']==0)
    	{
    		return true;
    	}
		if(trim($number)=='')
		{
			$data['flag']=0;
			$data['msg']="Number is empty";
			return $data;
		}
		if(trim($message)=='')
		{
			$data['flag']=0;
			$data['msg']="Message is empty";
			return $data;
		}
		if($this->CI->failed_sms_model->validateFailData($number) == 2)
		{
			$rr=$this->_sendSMS($number,$message);
		}
		else
		{
			$rr = new stdClass();
			$rr->error = "Failed So many times";
			$rr->api_id = "N/A";
			$this->CI->failed_sms_model->saveFailedSMS($number);
		}
		
		if(!isset($rr->error) && isset($rr->message_uuid[0]))
		{
			$queueID=$rr->message_uuid[0];	
			$this->CI->sms_model->trackSMS($serviceSlug,$userID,$queueID,$number,$message,1,'',0,0,$username);
			$this->CI->logaction->log($serviceSlug,"SMS sent to ".$number." | ID: ".$queueID);
			$data['flag']=1;
			$data['smsid']=$queueID;
			$data['msg']="SMS sent successfully";
		}
		else
		{
			$queueID=$rr->api_id;
			$this->CI->sms_model->trackSMS($serviceSlug,$userID,$queueID,$number,$message,2,$rr->error,0,0,$username);
			$this->CI->logaction->log($serviceSlug,"SMS failed to ".$number." | ID: ".$queueID." | Reason: ".$rr->error);
			$data['flag']=0;
			$data['smsid']=$queueID;
			$data['msg']="SMS failed";
		}
		return $data;
	}
}
?>