<?php if (!defined('BASEPATH'))	exit('No direct script access allowed');

require_once 'vendor/aws/aws-autoloader.php';
use Aws\Credentials\CredentialProvider;
use Aws\S3\S3Client;
use Aws\Ses\SesClient;
use Aws\Ses\Exception\SesException;

class SES
{
	public function __construct()
	{
		$this->CI =& get_instance();
		$this->CI->load->model("logaction");
		$this->CI->load->model("email_extension_model");
	}
	public function SendSESMail($queueID,$sender,$to,$subject,$html_body,$ses_bcc,$serviceSlug="")
	{
		if($this->CI->email_extension_model->validateBounceEmail($to) == 1)
		{
			return array("sent_flag"=>1111);
		}
		$tableService = $serviceSlug;
		if(preg_match("/mail_track_/i",$tableService))
		{
			
		}
		else
		{
			$tableService="mail_track_".$tableService;
		}
		ini_set('memory_limit','2048M');

		$ses = new SesClient([
		    'version' => 'latest',
		    'region'  => 'us-east-1',
		    'credentials' => [
		    				"key" => aws_ses_access_key,
		    				"secret" => aws_ses_secret_key
		    			]
		]);
		if(!empty($ses_bcc))
			$ses_bcc = [$ses_bcc];
		else
			$ses_bcc = [];
		$char_set = 'UTF-8';
		$recipient_emails = [$to];
		$result=null;
		$sent=0;
		try 
		{
			$result = $ses->sendEmail([
				'ConfigurationSetName' => aws_ses_configuration_set,
		        'Destination' => [
		        	'ToAddresses' => $recipient_emails,
		        	'BccAddresses' => $ses_bcc,
		        ],
		        'Source' => $sender,
		        'Message' => [
		          'Body' => [
		              'Html' => [
		                  'Charset' => $char_set,
		                  'Data' => $html_body,
		              ]
		          ],
		          'Subject' => [
		              'Charset' => $char_set,
		              'Data' => $subject,
		          ],
		        ],
		        'Tags' => [
                    [
                        'Name' => 'dp_email_service_table', // REQUIRED
                        'Value' => $tableService, // REQUIRED
                    ],
                ],
		    ]);
		    
		    $messageID = $result['MessageId'];

		    if(!empty($result['@metadata']))
		    {
		    	$json_data = json_encode($result['@metadata'], JSON_UNESCAPED_UNICODE);
		    	$debug = $json_data . "\n" . "Email sent! Message ID: $messageID";
		    }
		    else
		    {
		    	$debug = "Email sent! Message ID: $messageID";
		    }
		    $this->CI->logaction->log($serviceSlug,"Email sent to ".$to." | ID: ".$queueID);
		    $sent=1;
		}
		catch(SesException $error)
		{
			$debug=$error->getAwsErrorCode()." | ".$error->getAwsErrorMessage();
			$messageID=$error->getAwsRequestId();
			$this->CI->logaction->log($serviceSlug,"Email failed to ".$to." | ID: ".$queueID);
			$sent=2;
		}

		return array("sent_flag"=>$sent,"debug_data"=>$debug,"messageID"=>$messageID);
	}
}
?>