<?php if (!defined('BASEPATH'))	exit('No direct script access allowed');
class Email_extension
{
	public function __construct()
	{
		$this->CI =& get_instance();
        $this->CI->load->model("email_extension_model");
        $this->CI->load->model("user/users_model");
        $this->CI->load->library("userutil");
        $this->CI->load->model("logaction");
	}
	public function sendMail($serviceSlug,$userID,$subject,$content,$priority=0)
	{
		if($GLOBALS['site_settings']['email_service']==0)
    	{
    		return true;
    	}
		if(trim($subject)=='')
		{
			$data['flag']=0;
			$data['msg']="Subject is empty";
			return $data;
		}
		if(trim($content)=='')
		{
			$data['flag']=0;
			$data['msg']="Content is empty";
			return $data;
		}

		if(is_numeric($userID) && $userID)
		{
			$userData=$this->CI->users_model->userData($userID);
			if((!empty($userData) && $userData->email_verified==1) || $priority)
			{
				$settings=$this->CI->email_extension_model->getSettingsByService($serviceSlug);
				$to=$userData->email;
				
				$name=$userData->firstname." ".$userData->lastname;
				$viewData['ashram_name']=$settings->ashram_name;
				$viewData['name']=$name;
				$viewData['body']=$content;
				$viewData['signature']=nl2br($settings->signature);
				$viewData['serviceSlug']=$serviceSlug;
				$content=$this->CI->load->view("common/templates/email_template",$viewData,true);
				$queueID=$this->CI->email_extension_model->mailTrack($serviceSlug,$userData,$to,$subject,$content,0,0,0,0,$priority);
				$this->CI->logaction->log($serviceSlug,"Email sent to queue ".$to." | ID: ".$queueID);
				$data['flag']=1;
				$data['msg']="Email added to Queue successfully";
				return $data;
			}
			else
			{
				$data['flag']=0;
				if(!empty($userData))
				{
					$this->CI->logaction->log($serviceSlug,"Email to ".$userData->email ." is rejected | User's Email ID not verified");
					$data['msg']="User's Email ID not verified.";
				}
				else
				{
					$this->CI->logaction->log($serviceSlug,"Email not sent | User deleted or does not exist");
					$data['msg']="User deleted or does not exist.";
				}
				return $data;
			}
		}
		else
		{
			$data['flag']=0;
			$data['msg']="Invalid User ID";
			return $data;
		}
	}

	public function sendOrdersMail($serviceSlug,$userID=0,$name,$email,$subject,$content,$signature='',$priority=0,$cc='',$giftOrSeva='')
	{
		if($GLOBALS['site_settings']['email_service']==0)
    	{
    		return true;
    	}
    	if(trim($email)=='')
		{
			$data['flag']=0;
			$data['msg']="Email is empty";
			return $data;
		}
		if(trim($subject)=='')
		{
			$data['flag']=0;
			$data['msg']="Subject is empty";
			return $data;
		}
		if(trim($content)=='')
		{
			$data['flag']=0;
			$data['msg']="Content is empty";
			return $data;
		}
		$userData=array();

        	
       	if($userID)
       		$userData=$this->CI->users_model->userData($userID);

		$settings=$this->CI->email_extension_model->getSettingsByService($serviceSlug);

		if(empty($settings))
		{
			$data['flag']=0;
			$data['msg']="Invalid service";
			return $data;
		}

		$to=$email;
		$viewData['ashram_name']=$settings->ashram_name;
		$viewData['name']=$name;
		$viewData['body']=$content;
		$viewData['serviceSlug']=$serviceSlug;
		$viewData['giftOrSeva']=$giftOrSeva;
		if($signature=='')
			$viewData['signature']=nl2br($settings->signature);
		else
			$viewData['signature']=$signature;

		$content=$this->CI->load->view("common/templates/email_template",$viewData,true);
		
		$mailServiceSlug=$serviceSlug;
		$queueID=$this->CI->email_extension_model->mailTrack($mailServiceSlug,$userData,$to,$subject,$content,0,0,0,0,$priority,0,$cc,$giftOrSeva);
		$this->CI->logaction->log($serviceSlug,"Email sent to queue ".$to." | ID: ".$queueID);
		$data['flag']=1;
		$data['msg']="Email added to Queue successfully";
		return $data;
	}

	public function sendMailGuest($serviceSlug,$name,$email,$subject,$content,$signature='',$priority=0,$cc='',$giftOrSeva='')
	{
		if($GLOBALS['site_settings']['email_service']==0)
    	{
    		return true;
    	}
		if(trim($email)=='')
		{
			$data['flag']=0;
			$data['msg']="Email is empty";
			return $data;
		}
		if(trim($subject)=='')
		{
			$data['flag']=0;
			$data['msg']="Subject is empty";
			return $data;
		}
		if(trim($content)=='')
		{
			$data['flag']=0;
			$data['msg']="Content is empty";
			return $data;
		}
		$userData=array();

        	
       	if($this->CI->session->userdata('user_id'))
       		$userData=$this->CI->session->userdata("user_data");

		$settings=$this->CI->email_extension_model->getSettingsByService($serviceSlug);

		if(empty($settings))
		{
			$data['flag']=0;
			$data['msg']="Invalid service";
			return $data;
		}

		$to=$email;
		$viewData['ashram_name']=$settings->ashram_name;
		$viewData['name']=$name;
		$viewData['body']=$content;
		$viewData['serviceSlug']=$serviceSlug;
		$viewData['giftOrSeva']=$giftOrSeva;
		if($signature=='')
			$viewData['signature']=nl2br($settings->signature);
		else
			$viewData['signature']=$signature;

		$content=$this->CI->load->view("common/templates/email_template",$viewData,true);
		
		$mailServiceSlug=$serviceSlug;
		$queueID=$this->CI->email_extension_model->mailTrack($mailServiceSlug,$userData,$to,$subject,$content,0,0,0,0,$priority,1,$cc,$giftOrSeva);
		$this->CI->logaction->log($serviceSlug,"Email sent to queue ".$to." | ID: ".$queueID);
		$data['flag']=1;
		$data['msg']="Email added to Queue successfully";
		return $data;
	}
	public function processQueue($serviceSlug='')
	{
		$services=array("users",'techsupport','vedoktashanti');
		foreach ($services as $service)
		{
			$this->CI->logaction->log('system',"Email CRON initiated");
			$this->CI->email_extension_model->processQueue($service);
			$this->CI->logaction->log('system',"Email CRON completed");
		}
	}
	public function resendMail($serviceSlug,$emailID)
	{
		if($GLOBALS['site_settings']['email_service']==0)
    	{
    		return true;
    	}
		$emailData=$this->CI->email_extension_model->getEmailByID($serviceSlug,$emailID);
		if(!empty($emailData))
		{
			if($emailData->status==0)
			{
				$data['flag']=0;
				$data['msg']="Email in pending state cannot be resent";
				return $data;
			}
			$userData=[];
			$guest=1;
			if($emailData->user_id!=0)
			{
				$userData=$this->CI->userutil->getUserMetaData($emailData->user_id);
				if($userData['userid'])
				{
					$userData=$userData['userdata'];
					$guest=0;
				}
			}
			$queueID=$this->CI->email_extension_model->mailTrack($serviceSlug,$userData,$emailData->mail_to,$emailData->mail_subject,
								$emailData->mail_content,0,0,1,$emailID,$emailData->priority,$guest);
			$this->CI->logaction->log($serviceSlug,"Email re-sent to queue ".$emailData->mail_to." | ID: ".$queueID);
			$data['flag']=1;
			$data['msg']="Email re-sent to '".$emailData->mail_to."' successfully";
			return $data;
		}
		else
		{
			$data['flag']=0;
			$data['msg']="Invalid request";
			return $data;
		}
	}
}
?>