<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}
//use Restserver\Libraries\REST_Controller;
class Store extends REST_Controller {
    var $service='cart';
    var $currentUser='';
    public function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);

        $this->load->model('currencies_model');
        //$this->load->model('oauth_sessions_model');
        $this->load->model('ashrams/store_model');
        $this->load->model('ashrams/store_cover_photos_model');
        $this->load->model('ashrams/store_files_model');
        $this->load->model('ashrams/store_types_model');
        $this->load->model('ashrams/ashrams_trust_accounts_model');
        //$this->oauth_sessions_model->session_check();

        if(!$this->session->userdata("storeCartAshramId"))
        {
            $this->session->set_userdata("storeCartAshramId",default_ashram_id);
        }
        if(!$this->session->userdata("storeCartAshramIdSelection"))
        {
            $this->session->set_userdata("storeCartAshramIdSelection",default_ashram_id);
        }
        $this->currencies=$this->currencies_model->getByAshram($this->session->userdata("storeCartAshramIdSelection"));
        if(!$this->session->userdata("defaultCurrency"))
        {
            if(empty($this->currencies))
                $this->session->set_userdata("defaultCurrency",default_currency);
            else
            {
                $currency_keys=array_keys($this->currencies);
                $currency=$this->currencies[$currency_keys[0]];
                $this->session->set_userdata("defaultCurrency",$currency['currency']);
            }
        }
        else
        {
            $currency_valid=0;
            foreach($this->currencies as $temp_currency)
            {
                if($this->session->userdata("defaultCurrency")==$temp_currency['currency'])
                {
                    $currency_valid=1;
                    break;
                }
            }
            if($currency_valid==0)
            {
                $currency_keys=array_keys($this->currencies);
                $currency=$this->currencies[$currency_keys[0]];
                $this->session->set_userdata("defaultCurrency",$currency['currency']);
            }
        }
        $this->load->library('storecart');
        $this->load->model('cart_model');
        $this->cart_model->validateCart($this->storecart);

        //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
    }

    /**
    * @api {post} /items Get Store
    * @apiPermission User
    * @apiName List
    * @apiGroup Store
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   [
            {
                "id": "430",
                "item_name": "Digambara Dattatreya Puja",
                "description": "Digambara Dattatreya Puja",
                "start_date": "25 Jun 2016",
                "end_date": "31 Aug 2017",
                "time_from": "10:30 AM",
                "time_to": "01:00 PM",
                "close_before": "0",
                "image": "https://dev.dattapeetham.org/images/item_images/430.jpg",
                "days": "",
                "price_inr": "1008",
                "price_usd": "25",
                "price": "INR 1008",
                "item_status": 1
            }
        ]
    *
    * @apiSuccess {Integer} id  Unique identifier of Item
    * @apiSuccess {String} item_name Item Name
    * @apiSuccess {String} description Description
    * @apiSuccess {String} start_date Start Date in format dd MMM YYYY
    * @apiSuccess {String} end_date End Date in format dd MMM YYYY
    * @apiSuccess {String} time_from From time in format hh:mm A
    * @apiSuccess {String} time_to To time in format hh:mm A
    * @apiSuccess {Integer} close_before Number of minutes to close item before the end time
    * @apiSuccess {String} image Item Image
    * @apiSuccess {String} Days in a week
    * @apiSuccess {Integer} price_inr Price in INR
    * @apiSuccess {Integer} price_usd Price in USD
    * @apiSuccess {String} price Price with default Currency
    * @apiSuccess {Integer} status Store status
    **/

    public function index_post($id=null)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($id==null)
        {
            if($GLOBALS['site_settings']['store']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
            {
                goto end;
            }

            $response['currency']=strtoupper($this->session->userdata("defaultCurrency"));
            $response['ashram_id']=strtoupper($this->session->userdata("storeCartAshramIdSelection"));
            $items=$this->store_model->listPublic($this->session->userdata("storeCartAshramIdSelection"));

            $items_sorted=array();
            foreach ($items['categories'] as $key=> $category)
            {
                $items_sorted[$key]['category']=$category['category'];
                $items_sorted[$key]['items']=$items['categories_items'][$category['id']];
            }

            $response['categories']=$items_sorted;
            $response['status']=true;

            $this->cart_log_model->log("App: Store page opened",$this->session->userdata("storeCartAshramIdSelection"),3);
            
        }
        else
        {
            if(is_numeric($id) && $id)
            {
                $itemData=$this->store_model->itemData($id);
                if(!empty($itemData['item']) && $this->session->userdata("storeCartAshramIdSelection")==$itemData['item']->ashram_id)
                {
                    $itemData['item']->aws_s3_base_url=aws_s3_base_url;
                    $priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));
                    $itemData['item']->price=strtoupper($this->session->userdata("defaultCurrency"))." ".$itemData['item']->$priceCol;
                    $priceCol='shipping_domestic_'.strtolower($this->session->userdata("defaultCurrency"));
                    $itemData['item']->shipping_domestic=strtoupper($this->session->userdata("defaultCurrency"))." ".$itemData['item']->$priceCol;
                    $priceCol='shipping_international_'.strtolower($this->session->userdata("defaultCurrency"));
                    $itemData['item']->shipping_international=strtoupper($this->session->userdata("defaultCurrency"))." ".$itemData['item']->$priceCol;

                    foreach ($itemData['files'] as $key => $fileItem)
                    {
                        $itemData['files'][$key]->size=$this->general_model->fileSizeConvert($fileItem->size);
                    }

                    $response=$itemData;
                    $response['status']=true;
                }
            }
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /store/add_to_cart/:item_id Add item to cart
    * @apiDescription
    * Rules:<br>
    * 1. Can add same ashram items.<br>
    * 2. Maximum amounts are defined in currencies. Cart total cannot be greater than the specified amount.<br>
    * 3. Admin cannot add items to cart
    * @apiPermission User
    * @apiName Add to cart
    * @apiGroup Store
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    /*public function add_to_cart_post($id=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $response['message']="Orders are disabled currently";
            goto end;
        }
        if($GLOBALS['site_settings']['store']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
        {
            $response['message']="Store is disabled";
            goto end;
        }
        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==0)
            {
                if($this->currentUser->email_verified==0)
                {
                    $response['message']="Email ID is not verified for User";
                    goto end;
                }
            }
            else
            {
                $response['message']="You are admin! Cannot add items to cart.";
                goto end;
            }
        }
        if($GLOBALS['storeCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }
        if(is_numeric($id) && $id)
        {
            $cart=$this->storecart->contents();
            $amount=$this->cart_model->getTotalPrice($this->storecart);
            $itemData=$this->store_model->itemData($id);
            if(empty($itemData))
            {
                $response['message']="Invalid item ID";
                goto end;
            }

            $data['item']=$itemData;
            $data['type']='store';
            
            if(!$this->session->userdata('storeCartAshramId') || $itemData['item']->ashram_id==$this->session->userdata('storeCartAshramId') || count($cart)==0)
            {
                $qty=1;
                $resp=$this->cart_model->addItem($data,$qty,$this->storecart);
                $flag=$resp['flag'];
                if($flag==-2)
                {
                    $this->logaction->log($this->service,"Store Item added to cart _ Item ID:".$id." _ ".$itemData['item']->item_name." _ Row ID: ".$resp['rowid']);
                    $this->cart_log_model->log("Item added - Name:".$itemData['item']->item_name,$this->session->userdata("storeCartAshramId"),3);
                    $response['status']=true;
                    $this->session->set_userdata('storeCartAshramId',$itemData['item']->ashram_id);
                }
                else
                {
                    $response['message']="Invalid request";
                }
            }
            else
            {
                $this->load->model('ashrams/ashrams_model');
                $ashramData=$this->ashrams_model->ashramData($this->session->userdata('storeCartAshramId'));
                $response['message']="You can add items from ".$ashramData->name." only. If you want to add items from other ashram, delete the items and then add again.";
            }
        }
        //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /store/remove_from_cart/:row_id Remove item from cart
    * @apiPermission User
    * @apiName Remove from cart
    * @apiGroup Store
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true",
            "cart_count": 1
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Integer} cart_count Number of items remaining in cart. Set only if status is true
    **/
/*
    public function remove_from_cart_post($key='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['storeCartLocked']==1)
        {
            $response['message']="Cannot remove item, a transaction is already in progress";
            goto end;
        }
        if(isset($key) && $key!='')
        {
            $item=$this->storecart->get_item($key);
            if(!empty($item))
            {
                $upd= array(
                           'rowid' => $key,
                            'qty'   => 0
                            );
                $this->storecart->update($upd);
                $this->logaction->log($this->service,"Item removed from cart _ Item ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                $cc=$this->storecart->contents();
                $this->cart_log_model->log("App: Item removed - Name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
                if(count($cc)==0)
                {
                    $this->session->unset_userdata('storeCartAshramId');
                }
                $response['status']=true;
                $response['cart_count']=count($cc);
                //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            }
            else
            {
                $response['message']="Invalid request";
            }
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /store/get_cart Store cart
    * @apiPermission User
    * @apiName Cart
    * @apiGroup Store
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "7cbb43d3185e4e822ba1ecbc35612b22":
            {
                "id": "430",
                "qty": 1,
                "price": 10,
                "name": "Digambara Dattatreya Puja",
                "options": {
                    "checksum": "060c341cb3c23793ffca39a249494fe2",
                    "type": "item",
                    "note": "First name\r\nGothram\r\nNakshatram",
                    "ashram_id": "4",
                    "description": "Digambara Dattatreya Puja",
                    "start_date": "2016-06-25",
                    "end_date": "2017-08-31",
                    "time_from": "10:30:00",
                    "time_to": "13:00:00",
                    "close_before": "0",
                    "first_date": "31 Mar 2017",
                    "user_date": "31 Mar 2017",
                    "status": 1,
                    "result_date": "31 Mar 2017",
                    "price_inr": "1008",
                    "price_usd": "25"
                },
                "rowid": "7cbb43d3185e4e822ba1ecbc35612b22",
                "subtotal": 10
            }
        }
    *
    * @apiSuccess {Object} row_id Cart item object, row id will be the key
    * @apiSuccess {Integer} row_id.id Unique identifier of Item
    * @apiSuccess {Integer} row_id.qty Quantity
    * @apiSuccess {Integer} row_id.price Price (IGNORE)
    * @apiSuccess {String} row_id.name Item name
    * @apiSuccess {Object} row_id.options Item item options object
    * @apiSuccess {String} row_id.options.checksum Checksum value for current cart item
    * @apiSuccess {String} row_id.options.type=item Item type
    * @apiSuccess {String} row_id.options.note Family details
    * @apiSuccess {String} row_id.options.ashram_id Unique identifier of Ashram to which item belong
    * @apiSuccess {String} row_id.options.description Description of item
    * @apiSuccess {String} row_id.options.start_date Start date in format yyyy-mm-dd
    * @apiSuccess {String} row_id.options.end_date End date in format yyyy-mm-dd
    * @apiSuccess {String} row_id.options.time_from From time in format HH:mm:ss
    * @apiSuccess {String} row_id.options.time_to To time in format HH:mm:ss
    * @apiSuccess {String} row_id.options.close_before Number of minutes from end time before the item booking will be closed
    * @apiSuccess {String} row_id.options.first_date First occurance date of current item in format dd MMM YYYY
    * @apiSuccess {String} row_id.options.user_date First occurance date of current item in format dd MMM YYYY based on user selection
    * @apiSuccess {String} row_id.options.status Status of item in cart (To checkout, all items must have status=1)
    * @apiSuccess {String} row_id.options.result_date List of result dates separated with comma
    * @apiSuccess {String} row_id.options.price_inr Price in INR
    * @apiSuccess {String} row_id.options.price_usd Price in USD
    * @apiSuccess {String} row_id.rowid Row id of item in cart
    * @apiSuccess {String} row_id.subtotal Subtotal of items (IGNORE)
    **/
    /*public function get_cart_post()
    {
        $list['currency']=strtoupper($this->session->userdata("defaultCurrency"));
        $this->load->model("credit_cards_model");
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("storeCartAshramId"),3);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        if($this->session->userdata("defaultCurrency")=='inr' && !empty($trustsArray))
        {
            $list['trust_data']=$trustsArray['inr'];
        }
        if($this->session->userdata("defaultCurrency")=='usd' && !empty($trustsArray))
        {
            $list['trust_data']=$trustsArray['usd'];
        }
        $credit_cards=$this->credit_cards_model->getCards($this->currentUser->id);
        foreach ($credit_cards as $key => $credit_card)
        {
            unset($credit_cards[$key]->user_id);
            unset($credit_cards[$key]->payflow_pnref);
            unset($credit_cards[$key]->created_on);
            unset($credit_cards[$key]->modified_on);
            $credit_cards[$key]->card_expiry_month=substr($credit_cards[$key]->card_expiry,0,2);
            $credit_cards[$key]->card_expiry_year=substr($credit_cards[$key]->card_expiry,-2);
        }
        $list['credit_cards']=$credit_cards;
        $list['ip_address']=$_SERVER["REMOTE_ADDR"];
        $list['cart']=$this->storecart->contents();
        $this->response($list, REST_Controller::HTTP_OK);
        //$this->set_response($this->storecart->contents(), REST_Controller::HTTP_OK);
    }*/

   /* public function get_cart_item_post($key='')
    {
        if($key=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $options=$this->storecart->product_options($key);
        if(empty($options))
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $item=$this->storecart->get_item($key);
        $itemData=$this->store_model->itemData($item['id']);

        $response['status']=true;
        $response['item']=$item;
        $response['store']=$itemData;
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /*public function checkout_notify_post($tab_index=0)
    {
        if($tab_index!=null && in_array($tab_index,array(0,1,2)))
        {
            $data='';
            if($tab_index==2)
            {
                $countryData=$this->locations_model->getCountryByCode($this->input->post("country"));
                $data="<br>Data:<br>".$this->input->post("firstname")." ".$this->input->post("lastname")."<br>".
                    $this->input->post("city").", ".$this->input->post("state").", ".$this->input->post("country")."<br>".
                    "+".$countryData->isd_code." ".$this->input->post("phone")."<br>".
                    $this->input->post("email");
            }
            if($tab_index==0)
                $this->cart_log_model->log("App: Checkout page opened",$this->session->userdata("storeCartAshramId"),3);
            else
                $this->cart_log_model->log("App: Checkout - navigated to tab ".($tab_index+1).$data,$this->session->userdata("storeCartAshramId"),3);
        }
    }*/

    /*public function changeqty_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['storeCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }
        if(isset($_POST['key']) && $_POST['key']!='')
        {
            $item=$this->storecart->get_item($_POST['key']);
            if(!empty($item) && $item['options']['shipping']==1)
            {
                $qty=1;
                if(isset($_POST['qty']) && in_array($_POST['qty'],array(1,-1)))
                {
                    $qty=$_POST['qty'];
                }

                $upd= array(
                           'rowid' => $_POST['key'],
                            'qty'   => $item['qty']+$qty
                            );
                $this->storecart->update($upd);
                $this->logaction->log($this->service,"Qty changed for item _ Item ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$_POST['key']);
                $cc=$this->storecart->contents();
                if(count($cc)==0)
                {
                    $this->session->unset_userdata('storeCartAshramId');
                }
                $this->cart_log_model->log("Qty changed to ".($item['qty']+$qty).", Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
                $response['status']=true;
                $response['cart_count']=count($cc);
            }
            else
            {
                $response['message']="Invalid item";
            }
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /*public function updateaddress_post($key='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['storeCartLocked']==1)
        {
            $response['message']="Sorry, cannot add/update address, a transaction is already in progress";
            goto end;
        }
        if($key=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }


        $this->form_validation->set_rules('value[address1]', 'Address 1', 'trim|required|min_length[3]|max_length[200]');
        $this->form_validation->set_rules('value[address2]', 'Address 2', 'trim|min_length[3]|max_length[200]');
        $this->form_validation->set_rules('value[address3]', 'Address 3', 'trim|min_length[3]|max_length[200]');
        $this->form_validation->set_rules('value[city]', 'City', 'trim|required|min_length[2]|max_length[100]');
        $this->form_validation->set_rules('value[state]', 'State', 'trim|required|min_length[2]|max_length[100]');
        $this->form_validation->set_rules('value[country]', 'Country', 'trim|required|countryCheck');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $item=$this->storecart->get_item($key);
        $options=$this->storecart->product_options($key);
        if(!empty($options))
        {
            $options['shipping_address']['address1']=$_POST['value']['address1'];
            $options['shipping_address']['address2']=$_POST['value']['address2'];
            $options['shipping_address']['address3']=$_POST['value']['address3'];
            $options['shipping_address']['city']=$_POST['value']['city'];
            $options['shipping_address']['state']=$_POST['value']['state'];
            $options['shipping_address']['country']=$_POST['value']['country'];
            $countryData=$this->locations_model->getCountryByCode($_POST['value']['country']);
            $options['shipping_address']['country_name']=$countryData->country_name;
            $updateArray= array(
                       'rowid' => $key,
                           'options'   => $options
                        );
            //print_r($options);
            $this->storecart->update($updateArray);


            $options=$this->storecart->product_options($key);
            //print_r($options);
            $this->cart_log_model->log("App: Shipping address updated, Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
            //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            //print_r($this->session->all_userdata());
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /*public function updateemail_post($key='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['storeCartLocked']==1)
        {
            $response['message']="Sorry, cannot add/update email, a transaction is already in progress";
            goto end;
        }
        if($key=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }
        $this->form_validation->set_rules('value', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        $item=$this->storecart->get_item($key);
        $options=$this->storecart->product_options($key);
        if(!empty($options))
        {
            $options['gift_friend_email']=$_POST['value'];
            $updateArray= array(
                       'rowid' => $key,
                           'options'   => $options
                        );
            $this->storecart->update($updateArray);
            $this->cart_log_model->log("App: Gift email updated, Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /*public function checkitemsemail_post()
    {
        $response['status']=true;
        foreach ($this->storecart->contents() as $rowKey => $itemData)
        {
            if($itemData['options']['shipping']==0)
            {
                if($itemData['options']['gift_friend_email']=='')
                {
                    $data['flag']=0;
                    $data['token'][]=$rowKey;
                }
            }
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /store/pay Make Payment
    * @apiPermission User
    * @apiName Pay
    * @apiGroup Store
    * @apiParam {String=a-z,A-Z,spaces} firstname First Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam {String=a-z,A-Z,spaces} lastname Last Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam email Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:100
    * @apiParam phone Phone Number<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:10<br>
     *                            Digits only
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address1 Address line 1<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address2 Address line 2<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address3 Address line 3<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} state State Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} city City<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]'} zipcode ZIP/PIN Code<br>
                                    Minlength\:3<br>
    *                               Maxlength\:15
    * @apiParam {String} country Country Code
    * @apiParam {String} donation_initials Donation Initials<br>
                                    Minlength\:3<br>
    *                               Maxlength\:25
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status":true,
            "payment_status": 1,
            "order_id":100
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Integer} payment_status 1 if success otherwise 0 (Set only for USD/Paypal)
    * @apiSuccess {Integer} order_id Seva ID (Set only for USD/Paypal)
    * @apiSuccess {Integer} payment_status 1 if success otherwise 0 (Set only for USD/Paypal)
    * @apiSuccess {String} redirect_to URL to redirect to (Set only for INR/PayU)
    * @apiSuccess {Integer} time_exceed 1 Sets only when transaction is already in process and initiated more than 5 minutes ago 
    *
    */
    /*public function pay_post()
    {
        //Check site settings
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $response['message']='Orders are disabled.';
            goto end;
        }

        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
                $response['message']='Email ID not verified.';
                goto end;
            }   
        }

        //Get cart DB record
        if($GLOBALS['storeCartLocked']==1)
        {
            $startedOn=strtotime($GLOBALS['storeCartStartedOn']." +5 Minutes");
            if(time()>=$startedOn)
            {
                $response['time_exceed']=1;
            }
            $response['message']='Transaction already in progress.';
            goto end;
        }

        //Validate form data
        if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) ||
                !isset($_POST["preferred_name"]) ||
                !isset($_POST["email"]) || !isset($_POST["phone"]) ||
                !isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) ||
                !isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) ||
                !isset($_POST["donation_initials"]))
        {
            $response['message']='Some parameters are missing.';
            goto end;
        }

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            if(!isset($_POST["credit_card_id"]))
            {
                $response['message']='Some parameters are missing.';
                goto end;
            }
        }

        $this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
        $this->form_validation->set_rules('email', 'Email ID','trim|required|valid_email_custom|min_length[6]|max_length[100]');
        $this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
        $this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('country', 'Country','trim|required|checkoutCountry['.$this->session->userdata("defaultCurrency").']');
        $this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
        $this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            if($_POST["credit_card_id"]=='')
            {
                $this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
                $this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
                $this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
                $this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
            }
            else
            {
                $this->form_validation->set_rules('credit_card_id', 'Save Card ID','trim|required|numeric|max_length[20]');
            }
        }

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        //Validate Cart items
        $this->cart_model->validateCart($this->storecart);

        //Check cart items count
        $cartContents=$this->storecart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $response['message']='Cart is empty';
            goto end;
        }

        $totalItems=count($cartContents);
        $validItems=0;
        foreach ($cartContents as $cartItem)
        {
            if($cartItem['options']['status']==1)
            {
                $validItems++;
            }
        }

        //Check all items in cart are valid
        if($validItems!=$totalItems)
        {
            $response['message']='Some cart items are not valid.';
            goto end;
        }

        //Capture User ID
        $userId=0;

        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==1)
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $tData=$this->session->userdata('temp_checkout_user');
                    $userId=$tData->id;
                }
            }
            else
            {
                $userId=$this->currentUser->id;
            }
        }

        //Get trust accounts for Ashram and Currency defined
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("storeCartAshramId"),3);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }

        $amount=$this->cart_model->getTotalPrice($this->storecart);

        //Decide trust based on Currency
        if($this->session->userdata("defaultCurrency")=='inr')
        {
            $customData['trustData']=$trustsArray['inr'];
            if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
                $response['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
        }
        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $customData['trustData']=$trustsArray['usd'];
            if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
                //$response['flag']=10;
                $response['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
        }

        $this->load->model('ashrams/ashrams_model');

        //Define custom data before initializing transaction
        $created_by_user_id=0;
        $created_by=0;
        $userData=array();
        if($this->session->userdata('id'))
        {
            if($this->session->userdata('temp_checkout_user'))
            {
                $userData=$this->session->userdata('temp_checkout_user');
                $userId=$userData->id;
            }
            $created_by=1;
        }
        else if($this->session->userdata('user_id'))
        {
            $userId=$this->session->userdata('user_id');
            $userData=$this->currentUser;
            $created_by=2;
        }

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $creditCardData=array();
            if($_POST["credit_card_id"]!='')
            {
                $this->load->model("credit_cards_model");
                $creditCardData=$this->credit_cards_model->getCard($_POST['credit_card_id']);
                if(empty($creditCardData))
                {
                    goto end;
                }
                if($creditCardData->user_id!=$userId)
                {
                    goto end;
                }
            }
        }

        $this->cart_log_model->log("App: Payment initiated",$this->session->userdata("storeCartAshramId"),3);

        $paymentMode=$customData['trustData']->payment_mode;
        if($this->session->userdata('loggedIn'))
            $created_by_user_id=$this->currentUser->id;

        $customData['cartData']=$cartContents;
        $customData['formData']=$_POST;
        $customData['formData']['app']=1;
        $customData['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("storeCartAshramId"));
        $customData['cart_type']=1;
        $customData['paymentMode']=$paymentMode;
        $customData['created_by']=$created_by;
        $customData['created_by_user_id']=$created_by_user_id;
        $customData['model']="orders/orders_model";
        $customData['model_name']="orders_model";
        $customData['ip_address']=$_SERVER['REMOTE_ADDR'];
        
        $customData['amount_in_words']=$this->general_model->amountToWords($amount);
        //Load payment model
        $this->load->model("payment_model");
        $reference=$this->payment_model->setTempInfo(
            $userId,
            $userData,
            $amount,
            base_url."store/",
            base_url."store/checkout/",
            $customData,
            $this->session->userdata("defaultCurrency")
            );

        $response['status']=true;
        $response['reference']=$reference;
        $this->cart_model->updateReferenceId($reference,1);

        $response['payment_mode']=$paymentMode;
        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $response['currency']="USD";
            if($paymentMode=='paypal')
            {
                $this->load->model("paypal_model");
                $paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
                if($paypalResponse['flag']==1)
                {
                    $response['order_id']=$paypalResponse['order_id'];
                    $response['payment_status']=1;
                    $this->cart_log_model->log("App: Payment success:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);
                }
                else
                {
                    $response['payment_status']=0;
                    $response['message']=$paypalResponse['error_msg'];
                    $this->cart_model->updateReferenceId('',1);
                    $this->cart_log_model->log("App: Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("storeCartAshramId"),3);
                }
            }
            if($paymentMode=='razorpay')
            {
                $response['amount']=$amount*100;
                $response['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $response['prefill_email']=$this->input->post("email");
                $response['prefill_contact']=$this->input->post("phone");
            }
        }
        else
        {
            $response['currency']="INR";
            if($paymentMode=='payu')
            {
                $response['redirect_to']=base_url.'payment/direct/'.$reference."?app=1&type=1";
                $this->cart_log_model->log("App: Redirected to payment gateway:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);
            }
            if($paymentMode=='razorpay')
            {
                $response['amount']=$amount*100;
                $response['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $response['prefill_email']=$this->input->post("email");
                $response['prefill_contact']=$this->input->post("phone");
                $response['key']=$customData['trustData']->razorpay_key;
            }
        }
        //unset($response['reference']);

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/

    /**
    * @api {post} /store/cancel_previous Cancel previous transaction
    * @apiPermission User
    * @apiName Cancel transaction
    * @apiGroup Store
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status":true
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    *
    */
   
    /*public function cancel_previous_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['storeCartLocked']==1)
        {
            $startedOn=strtotime($GLOBALS['storeCartStartedOn']." +5 Minutes");
            if(time()>=$startedOn)
            {
                $this->cart_model->regenerateSession(1);
                //$this->oauth_sessions_model->update_session_id($this->server->access_token,session_id());
                //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
                $response['status']=true;
            }
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }*/
}
?>
