<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Speechesadmin extends REST_Controller {
    private $error=0;
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);

        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();

        if(!$this->session->userdata('id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }*/
        if($this->error==0)
        {
            //$this->currentUser=$this->session->userdata("admin_data");
            if(!in_array($this->currentUser->roles,array(1,7,9)))
            {
                $this->response([
                        'status' => FALSE,
                        'message' => 'Access denied'
                    ], REST_Controller::HTTP_NOT_FOUND);
                $this->error=1;
            }
        }
    }

    /**
    * @api {post} /speechesadmin Get speeches
    * @apiName Speeches list
    * @apiGroup Speeches Admin
    * @apiPermission Super Admin, Content Admin, Speeches Admin
    * @apiParam {String} [search_text] Search keyword(s)
    * @apiParam {Integer} [start=0] Number of record to start with 
    * @apiParam {Integer=20,50,100} [length]  Number of records to be displayed per page
    * @apiParam {Integer} [category]  Category ID
    * @apiParam {String} [from_date]  From Date in format dd MM YYYY
    * @apiParam {String} [to_date]  To Date in format dd MM YYYY
    * @apiParam {String=name,id,description} [search_col]  Column name to search in
    * @apiParam {String=contains,starts,ends} [wild]  Wild card pattern
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "recordsTotal": "1576",
              "data": [
                {
                    "id": "1561",
                    "name": "October 23, 2016",
                    "description": "October 23",
                    "categories": "560",
                    "slug": "swamiji-speech-031717",
                    "published_on": "13 Mar 2017",
                    "year": "2017",
                    "month": "3",
                    "day": "13",
                    "reads": "0",
                    "sno": 1
                }
        }
    *
    * @apiSuccess {Integer} recordsTotal  Total number of results
    * @apiSuccess {Object} data Speeches Object
    * @apiSuccess {Integer} data.id Unique Identifier
    * @apiSuccess {String} data.name Name
    * @apiSuccess {String} data.description Description in HTML format/code
    * @apiSuccess {String} data.slug Slug
    * @apiSuccess {String} data.categories Category ID(s) separated with comma
    * @apiSuccess {Date} data.published_on Published Date in format dd MMM YYYY
    * @apiSuccess {Integer} data.year Year
    * @apiSuccess {Integer} data.month Month
    * @apiSuccess {Integer} data.day Day
    * @apiSuccess {Integer} data.reads Number of times read by public
    * @apiSuccess {Integer} data.sno Serial Number
    */
    
    /**
    * @api {post} /speechesadmin/:id Get a speech
    * @apiName Get a speech
    * @apiGroup Speeches Admin
    * @apiPermission Super Admin, Content Admin, Speeches Admin
    * @apiExample {curl} Example usage:
      curl -i /speechesadmin/1561
    *
    * @apiSuccessExample {json} Success-Response:
    *     HTTP/1.1 200 OK
    *     {
            "id": "3348",
            "name": "Maha Shivaratri at Datta Peetham - 2016",
            "description": "<p>The annual festival, Maha Shivaratri</p>",
            "categories": "100,101",
            "month": "3",
            "year": "2016",
            "day": "3",
            "slug": "maha-shivaratri-at-datta-peetham-2016",
            "published_on": "2017-03-13 00:00:00",
            "seo_keywords": "seo_keywords",
            "seo_description": "",
            "parent_link": "0",
            "reads": "474",
        }
    * 
    * @apiSuccess {Integer} id  Unique Identifier
    * @apiSuccess {String} name Speech Name
    * @apiSuccess {String} description Description in HTML format/code
    * @apiSuccess {String} categories Category IDs with comma(,) separated
    * @apiSuccess {String} slug Slug value
    * @apiSuccess {String} parent_link Parent speech Unique identifier
    * @apiSuccess {Date} published_on Published Date in format YYYY-mm-dd HH:ii:ss
    * @apiSuccess {Integer} year Year
    * @apiSuccess {Integer} month Month
    * @apiSuccess {Integer} reads Number of reads/views
    * @apiSuccess {String} seo_keywords SEO Keywords
    * @apiSuccess {String} seo_description SEO Description
    */
   
    public function index_post($id=null)
    {
        if($this->error)
            return;

        $this->load->model('content/speeches_model');
        $this->load->model('content/speeches_images_model');
        $this->load->model('content/speeches_category_model');
        $this->load->model('category/categories_model');

        if ($id === NULL)
        {
            $list=$this->speeches_model->listAdmin();
            unset($list['recordsFiltered']);
            $users=$list;
            if ($users)
            {
                $this->response($users, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'No speeches were found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
        else
        {
            $id = (int) $id;
            if ($id <= 0)
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST);
            }
            $speechData=$this->speeches_model->speechData($id);

            if (!empty($speechData))
            {
                unset($speechData->wp_id);
                unset($speechData->created_on);
                unset($speechData->created_by);
                unset($speechData->modified_on);
                unset($speechData->modified_by);
            }

            if (!empty($speechData))
            {
                $this->set_response($speechData, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->set_response([
                    'status' => FALSE,
                    'message' => 'Speech could not be found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }

    /**
    * @api {post} /speechesadmin/post Create/Post a Speech
    * @apiName Post speech
    * @apiGroup Speeches Admin
    * @apiPermission Super Admin, Content Admin, Speeches Admin
    * @apiParam {String} name Speech name<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:200
    * @apiParam {Array} categories Category ID(s)
    * @apiParam {String} published_on Published date in format dd MMM YYYY
    * @apiParam {String} seo_keywords SEO Keywords<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} seo_description SEO Description<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} description Description
    * @apiParam {Integer} [parent_id] Unique identifier of Parent speech
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "speech_id": 4148
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    * @apiSuccess {Integer} speech_id Unique identifier of created speech
    */
    public function post_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if(!isset($_POST['description']))
        {
            $response['message']="Description field required";
            goto end;
        }
        if(!isset($_POST['categories']))
        {
            $response['message']="Categories field is required";
            goto end;
        }
        if(!isset($_POST['seo_keywords']))
        {
            $response['message']="SEO Keywords field is required";
            goto end;
        }
        if(!isset($_POST['seo_description']))
        {
            $response['message']="SEO Description field is required";
            goto end;
        }

        $this->load->model('content/speeches_model');
        $this->load->model('content/speeches_images_model');
        $this->load->model('content/speeches_category_model');
        $this->load->model('category/categories_model');

        $this->form_validation->set_rules('name', 'Speech Title', 'trim|required|min_length[6]|max_length[200]|speechNameCheck');
        $this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
        $this->form_validation->set_rules('published_on', 'Publish Date', 'trim|required|valid_date');
        $this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('parent_id', 'Parent Speech', 'trim|numeric|validate_speech_parent[0]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $speech_id=$this->speeches_model->save(0,array());
        $response['speech_id']=$speech_id;
        $response['status']=true;
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }


    /**
    * @api {post} /speechesadmin/update/:id Update a Speech
    * @apiName Update
    * @apiGroup Speeches Admin
    * @apiPermission Super Admin, Content Admin, Speeches Admin
    * @apiParam {String} name Speech name<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:200
    * @apiParam {Array} categories Category ID(s)
    * @apiParam {String} published_on Published date in format dd MMM YYYY
    * @apiParam {String} seo_keywords SEO Keywords<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} seo_description SEO Description<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} description Description
    * @apiParam {Integer} [parent_id] Unique identifier of Parent speech
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    */
    public function update_post($speechId=0)
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if(!is_numeric($speechId) || !$speechId)
        {
            $response['mmessage']="Invalid Speech ID";
            goto end;
        }
        else
        {
            $this->load->model('content/speeches_model');
            $this->load->model('content/speeches_images_model');
            $this->load->model('content/speeches_category_model');
            $this->load->model('category/categories_model');

            $speechData=$this->speeches_model->speechData($speechId);
            if(empty($eventData['event']))
            {
                $response['mmessage']="Invalid Speech ID";
                goto end;
            }
        }

        if(!isset($_POST['description']))
        {
            $response['message']="Description field required";
            goto end;
        }
        if(!isset($_POST['categories']))
        {
            $response['message']="Categories field is required";
            goto end;
        }
        if(!isset($_POST['seo_keywords']))
        {
            $response['message']="SEO Keywords field is required";
            goto end;
        }
        if(!isset($_POST['seo_description']))
        {
            $response['message']="SEO Description field is required";
            goto end;
        }

        
        $this->form_validation->set_rules('name', 'Speech Title', 'trim|required|min_length[6]|max_length[200]|speechNameCheck');
        $this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
        $this->form_validation->set_rules('published_on', 'Publish Date', 'trim|required|valid_date');
        $this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('parent_id', 'Parent Speech', 'trim|numeric|validate_speech_parent['.$speechId.']');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $speech_id=$this->speeches_model->save($speechId,$speechData);
        $response['status']=true;
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /speechesadmin/delete/:id Delete a Speech
    * @apiName Delete speech
    * @apiGroup Speeches Admin
    * @apiPermission Super Admin, Content Admin, Speeches Admin
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "name": "Speech Name"
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    * @apiSuccess {String} name Speech name
    */
   
    public function delete_post($speechId=0)
    {
        if($this->error)
            return;
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if(is_numeric($speechId) && $speechId)
        {
            $this->load->model('content/speeches_model');
            $this->load->model('content/speeches_images_model');
            $this->load->model('content/speeches_category_model');
            $this->load->model('category/categories_model');

            $speechData=$this->speeches_model->speechData($speechId);
            if(empty($speechData))
            {
                $response['message']="Invalid Speech ID";
                goto end;
            }
            $children=$this->speeches_model->getChildren($speechId);
            if(!empty($children))
            {
                $response['message']="Speech cannot be deleted. It is associated with other events.";
                goto end;
            }

            $r=$this->speeches_model->delete($speechId,$speechData);
            if($r)
            {
                $response['status']=true;
                $response['name']=$speechData->name;
            }
        }
        else
        {
            $response['message']="Invalid Event ID";
        }
        


        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /speechesadmin/check_name Check speech name
    * @apiDescription Check whether speech name forms a valid slug
    * @apiPermission Super Admin, Content Admin, Speeches Admin
    * @apiName  Check name
    * @apiGroup Speeches Admin
    * @apiParam {String} name Speech name<br>
    *                             Minlength\:6
    *                             Maxlength\:200
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    */   

    public function check_name_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('name', 'Speech Name', 'trim|required|min_length[6]|max_length[200]');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $slug=url_title($this->general_model->filtertext($_POST['name']));

        if(strlen($slug)<6)
        {
            $response['message']="Invalid slug";
            goto end;
        }
        else
        {
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>