<?php

defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

// use namespace
//use Restserver\Libraries\REST_Controller;

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @category        Api
 * @author          Manoj
 * @license         MIT
 */
class Speeches extends REST_Controller {

    function __construct()
    {
        // Construct the parent class
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");

        // Configure limits on our controller methods
        // Ensure you have created the 'limits' table and enabled 'limits' within application/config/rest.php
        $this->methods['users_get']['limit'] = 500; // 500 requests per hour per user/key
        $this->methods['users_post']['limit'] = 100; // 100 requests per hour per user/key
        $this->methods['users_delete']['limit'] = 50; // 50 requests per hour per user/key
    }

    /**
    * @api {post} /speeches/ Get speeches
    * @apiName Speeches
    * @apiGroup Speeches
    *
    * @apiParam {String} [search_text] Searches speeches
    * @apiParam {String} [per_page]  Page Number
    * @apiParam {Integer} [year]  Year
    * @apiParam {Integer} [month]  Month (Valid only if year is set)
    * @apiParam {Integer} [category]  Category ID
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "num": "1576",
              "res": [
                {
                  "id": "1561",
                  "name": "October 23, 2016",
                  "description": "October 23",
                  "categories": "561",
                  "slug": "october-23-2016",
                  "published_on": "26 Oct 2016",
                  "year": "2016",
                  "month": "10",
                  "day": "26"
                }
        }
    *
    * @apiSuccess {Integer} num  Total number of results
    * @apiSuccess {Object} res Speech Object
    * @apiSuccess {Integer} res.id Unique Identifier
    * @apiSuccess {String} res.name Name
    * @apiSuccess {String} res.description Description in HTML format/code
    * @apiSuccess {String} res.categories Category IDs with comma(,) separated
    * @apiSuccess {String} res.slug Slug
    * @apiSuccess {Date} res.published_on Published Date in format dd MMM YYYY
    * @apiSuccess {Integer} res.year Year
    * @apiSuccess {Integer} res.month Month
    * @apiSuccess {Integer} res.day Day
    */
    
    /**
    * @api {post} /speeches/:id Get a speech
    * @apiName Get
    * @apiGroup Speeches
    *
    * @apiExample {curl} Example usage:
      curl -i /speeches/1561
    *
    * @apiSuccessExample {json} Success-Response:
    *     HTTP/1.1 200 OK
    *     {
              "id": "1561",
              "name": "October 23, 2016",
              "description": "Some html description",
              "categories": "560",
              "slug": "bhagavatam-day-258",
              "published_on": "2016-10-26 00:00:00",
              "year": "2016",
              "month": "10",
              "day": "26",
              "parent_link": "1150",
              "reads": "0"
            }
    * 
    * @apiSuccess {Integer} id  Unique Identifier
    * @apiSuccess {String} name Speech Name
    * @apiSuccess {String} description Description in HTML format/code
    * @apiSuccess {String} categories Category IDs with comma(,) separated
    * @apiSuccess {String} slug Slug value
    * @apiSuccess {Date} published_on Published Date in YYYY-mm-dd HH:ii:ss
    * @apiSuccess {Integer} year Year
    * @apiSuccess {Integer} month Month
    * @apiSuccess {Integer} day Day
    * @apiSuccess {Integer} parent_link Unique Identifier of Parent speech
    * @apiSuccess {Integer} reads Number of time the speech is read
    */

    public function index_post($id=null)
    {
        $this->load->model('content/speeches_model');
        $this->load->model('category/categories_model');

       
        /*if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
        {
            $this->search_log_model->log(trim($_POST['search_text']),'speeches');
        }*/

        

        //$id = $this->get('id');

        // If the id parameter doesn't exist return all the users

        if ($id === NULL)
        {
            $list=$this->speeches_model->listPublic();
            unset($list['links']);
            $users=$list;
            // Check if the users data store contains users (in case the database result returns NULL)
            if ($users)
            {
                // Set the response and exit
                $this->response($users, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
            }
            else
            {
                // Set the response and exit
                $this->response([
                    'status' => FALSE,
                    'message' => 'No speeches were found'
                ], REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }

        // Find and return a single record for a particular user.
        else
        {
            $id = (int) $id;

            // Validate the id.
            if ($id <= 0)
            {
                // Invalid id, set the response and exit.
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST); // BAD_REQUEST (400) being the HTTP response code
            }

            // Get the user from the array, using the id as key for retrieval.
            // Usually a model is to be used for this.

            $user = NULL;

            $speechData=$this->speeches_model->speechData($id);

            if (!empty($speechData))
            {
                unset($speechData->wp_id);
                unset($speechData->created_on);
                unset($speechData->created_by);
                unset($speechData->modified_on);
                unset($speechData->modified_by);
                unset($speechData->color);
                unset($speechData->seo_keywords);
                unset($speechData->seo_description);
                unset($speechData->ashram_id);
                $speechData->published_on=date("d M Y",strtotime($speechData->published_on));
                $speechData->base_url=base_url;

                $parentInfo=$this->speeches_model->speechData($speechData->parent_link);
                if(!empty($parentInfo))
                {
                    $speechData->parent_info['id']=$parentInfo->id;
                    $speechData->parent_info['name']=$parentInfo->name;
                }

                $user=$speechData;
            }

            if (!empty($user))
            {
                $this->set_response($user, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
            }
            else
            {
                $this->set_response([
                    'status' => FALSE,
                    'message' => 'User could not be found'
                ], REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
            }
        }
    }

    /**
    * @api {post} /speeches/get_years_months Get possible years and months
    * @apiPermission User
    * @apiName Years and months list
    * @apiGroup Speeches
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "years": [
                {
                    "2016",
                    "2015"
                },
                "months": {
                    "1996":
                    [
                        "12"
                    ]
                ],
        }
    *
    * @apiSuccess {Array} years List of years
    * @apiSuccess {Object} months Months Object (Keys will be years)
    * @apiSuccess {Array} res['year'] List of months for that year
    */
    public function get_years_months_post()
    {
        $this->load->model('content/speeches_model');
        $years=$this->speeches_model->getYearMonths();
        if ($years)
        {
            $this->response($years, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response([
                'status' => FALSE,
                'message' => 'No records found'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }
    public function get_categories_post()
    {
        $this->load->model('category/categories_model');
        $this->categories_model->fetchCategories(1);
        $this->categories_model->sorted(0,1);
        $this->response($this->categories_model->sorted, REST_Controller::HTTP_OK);
    }
}
?>