<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Pledge extends REST_Controller {
    private $error=0;
    var $access_token_present=0;
    var $service="pledge";
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");

        $this->load->model("pledge/pledge_model");
        $this->load->model("pledge/pledge_categories_model");
        $this->load->model("currencies_model");
    }

    /**
    * @api {post} /pledge Post a Pledge
    * @apiPermission Logged in User
    * @apiName Pledge
    * @apiGroup Pledge
    
    * @apiParam {String} name Name<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:100<br>
    *                             Allowed characters\:[A-Z],[a-z] and spaces
    * @apiParam {String} email Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:100
    * @apiParam {String} phone Phone Number<br>
    *                             Minlength\:8<br>
    *                             Maxlength\:10
    *                             Allowed characters\:[0-9]
    * @apiParam {String} currency Currency
    * @apiParam {String} amount Amount<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:8
    *                             Allowed characters\:[0-9]
    * @apiParam {String} mode Payment mode<br>
    *                             Allowed values\:1,2,3<br>
    *                             (1=Cash,2=Cheque/DD,3=Online)
    * @apiParam {String} purpose Purpose
    * @apiParam {String} notes Notes<br>
    *                             Maxlength\:2500
    * @apiParam {String} address Address<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:1000
    * @apiParam {String} country Country
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    */
   
    public function index_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        
        if($GLOBALS['site_settings']['pledge_form']==0)
        {
            $response['message']="Pledge form is currently unavailable.";
            goto end;
        }
        $this->form_validation->set_rules('name', 'Name', 'trim|required|lettersonly|min_length[3]|max_length[200]');
        $this->form_validation->set_rules('notes', 'Notes', 'trim|required|max_length[2000]');
        $this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|pledgePurpose[1]');
        $this->form_validation->set_rules('email', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
        $this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
        $this->form_validation->set_rules('address', 'Address','trim|required|min_length[10]|max_length[2000]');
        $this->form_validation->set_rules('country', 'Country', 'trim|required|countryCheck');
        $this->form_validation->set_rules('currency', 'Currency', 'trim|required|currencyCheck');
        $this->form_validation->set_rules('amount', 'Amount', 'trim|required|numeric|min_length[2]|max_length[8]');
        $this->form_validation->set_rules('mode', 'Mode of payment', 'trim|required|pledgeCheckPaymentMode');
        if ($this->form_validation->run() == FALSE)
        {
            $response['error']=validation_errors();
            goto end;
        }
        $GLOBALS['app']=1;
        $this->pledge_model->save($_POST);
        $response['status']=true;
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {get} /pledge Get list of purposes
    * @apiPermission Logged in User
    * @apiName Pledge purposes
    * @apiGroup Pledge
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
            "status": true,
            "data": [
                {
                    "id": "3",
                    "name": "Ashrama Maintenance",
                    "order": "1",
                    "status": "1"
                }
            ]
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    */

    public function purposes_get()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        
        $response['data']=$this->pledge_categories_model->getCategories(1);
        $response['pledge_enabled']=$GLOBALS['site_settings']['pledge_form']?true:false;
        $response['currencies']=$this->currencies_model->getByAshram(0);
        $response['status']=true;
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>