<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Liveupdates extends REST_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
    }

    /**
    * @api {post} /liveupdates Get Live updates
    * @apiName List
    * @apiGroup Live Updates
    *
    * @apiParam {String} [search_text] Searches speeches
    * @apiParam {String} [per_page]  Page Number
    * @apiParam {Integer=1,2} [type] Type of message<br>
                                        Array(<br>
                                        1=>"Text Message",<br>
                                        2=>"Image"<br>
                                        )
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "num": "1576",
              "res": [
                {
                  "id": "1561",
                  "message": "Live update message",
                  "order": "0",
                  "status": "1",
                  "created_on": "26 Oct 2016",
                  "color": "red"
                }
        }
    *
    * @apiSuccess {Integer} num  Total number of results
    * @apiSuccess {Object} res Live updates Object
    * @apiSuccess {Integer} res.id Unique Identifier
    * @apiSuccess {String} res.message Live update message
    * @apiSuccess {Integer} res.order Order of message
    * @apiSuccess {Integer} res.status Status (default 1)
    * @apiSuccess {Date} res.created_on Date in format dd MMM YYYY
    * @apiSuccess {String} res.color Color of record (Possible values: red, blue, green, orange, purple)
    */
    public function index_post($id=null)
    {
        $this->load->model("live_updates_model");
        if ($id === NULL)
        {
            $list=$this->live_updates_model->listPublic();
            unset($list['links']);
            unset($list['n']);
            foreach ($list['res'] as $key => $row)
            {
                $list['res'][$key]->message=strip_tags($row->message,"<u><em><strong><a>");
                $list['res'][$key]->base_url=base_url;
                if($list['res'][$key]->filename!='')
                    $list['res'][$key]->filename=aws_s3_base_url."content/liveupdates/".$list['res'][$key]->filename;
            }
            if ($list)
            {
                $this->response($list, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'No updates were found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
        else
        {
            $id = (int) $id;
            if ($id <= 0)
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST);
            }
            $messageData=$this->live_updates_model->messageData($id);
            $messageData->base_url=base_url;
            $messageData->created_on=date("d M Y h:i A",strtotime($messageData->created_on));
            if($messageData->image_filename!='')
            $messageData->image_filename=aws_s3_base_url."content/liveupdates/".$messageData->image_filename;
            if($messageData->filename!='')
            $messageData->filename=aws_s3_base_url."content/liveupdates/".$messageData->filename;

            if (!empty($messageData))
            {
                $this->response($messageData, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'No records found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }
}
?>