<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

class Globalservice extends REST_Controller {
    private $error=0;
    var $service="";
    function __construct()
    {
        parent::__construct();
        $this->service = "global_mobile";

        if(1==1)
        {
            $accept = 0;
            $headers = [];
            foreach ($_SERVER as $name => $value) {
                if (substr($name, 0, 5) == 'HTTP_') {
                    $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
                }
            }
            if(!empty($headers['Globalapiuser']) && $headers['Globalapiuser'] == "DSQAwcTV9pU88uMilRWc9PQ")
            {
                $accept = 1;
            }
            if( !$accept)
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
                $this->error=1;
            }
        }
    }

    public function index_get()
    {

    }

    public function sendsms_post()
    {
        $response['status']=FALSE;

        if($this->error)
            return;

        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[8]|max_length[20]');
        $this->form_validation->set_rules('message', 'Message', 'trim|required|max_length[2500]');
        $this->form_validation->set_rules('country_code', 'Country', 'trim|required|countryCheck');
        $this->form_validation->set_rules('app_name', 'App Name', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        $countryData=$this->locations_model->getCountryByCode($_POST['country_code']);
        $this->load->library("sms");
        $message=
                "Message from ".$_POST['app_name'].": "."\n".
                $_POST['message']."\n".
                ""
                ;
        if($countryData)
        {
            $this->sms->sendSMSGuest(
                                    'global_mobile_service',
                                    $countryData->isd_code,
                                    $countryData->isd_code.$_POST['phone'],
                                    $message
                                );
            $response['status'] = TRUE;
            $response['message']="SMS Sent Successfully";
        }
        else
        {
            $response['message']="Country is not valid";
            goto end;
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function sendvoicesms_post()
    {
        $response['status']=FALSE;

        if($this->error)
            return;
        
        $response['message']="SMS Sent Successfully";
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[8]|max_length[20]');
        $this->form_validation->set_rules('message', 'Message', 'trim|required|max_length[2500]');
        $this->form_validation->set_rules('country_code', 'Country', 'trim|required|countryCheck');
        $this->form_validation->set_rules('app_name', 'App Name', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        $this->load->library("s3",array("accessKey"=>aws_s3_access_key,"secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
        $countryData=$this->locations_model->getCountryByCode($_POST['country_code']);
        
        if(isset($_FILES['voice_attachment']))
            if($_FILES['voice_attachment']['name']!='')
            {
                $name=$_FILES['voice_attachment']['name'];
                $pre=explode(".",$name);
                $ncnt=count($pre);
                $ext=$pre[$ncnt-1];
                $filename=time().".".$ext;
                
                $basePath=$_SERVER['DOCUMENT_ROOT']."/misc_services/global_mobile_service/".date("Y")."/";
                if(!is_dir($basePath))
                {
                    mkdir($basePath,0777,true);
                }
                
                $path=$_SERVER['DOCUMENT_ROOT']."/misc_services/global_mobile_service/".date("Y")."/".$filename;

                move_uploaded_file($_FILES['voice_attachment']['tmp_name'],$path);

                $amazonUri="global_mobile_service/".date("Y")."/".$filename;
                $this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri,S3::ACL_PUBLIC_READ, array(), array());

                unlink($path);
            }
            else
            {
                $response['message']="Attachment Required";
                goto end;
            }
        $this->load->library("sms");
        $message=
                "You received a voice message from ".$_POST['app_name'].": "."\n".
                $_POST['message']."\n".
                "Please click on link below to listen to message."."\n".
                "".aws_s3_base_url.$amazonUri."\n".
                ""
                ;
        if($countryData)
        {
            $this->sms->sendSMSGuest(
                                    'global_mobile_service',
                                    $countryData->isd_code,
                                    $countryData->isd_code.$_POST['phone'],
                                    $message
                                );
            $response['status'] = TRUE;
            $response['message']="SMS Sent Successfully";
        }
        else
        {
            $response['message']="User Not Available";
            goto end;
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>