<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Feedbackadmin extends REST_Controller {
    private $error=0;
    var $service="feedback";
    var $purposeArray=array(
                                1=>"Office/Billing",
                                2=>"Contact",
                                3=>"Abuse",
                                4=>"Complaint",
                                5=>"Question",
                                6=>"Feedback",
                                7=>"Other"
                                );
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();

        if(!$this->session->userdata('id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }
        if($this->error==0)
        {
            $this->currentUser=$this->session->userdata("admin_data");
            if(!in_array($this->currentUser->roles,array(1,8)))
            {
                $this->response([
                        'status' => FALSE,
                        'message' => 'Access denied'
                    ], REST_Controller::HTTP_NOT_FOUND);
                $this->error=1;
            }
        }

        $this->load->model('feedback_model');
        $this->load->model('feedback_replies_model');
    }

    /**
    * @api {post} /feedbackadmin Get feedback messages
    * @apiName list
    * @apiGroup Feedback Admin
    * @apiPermission Super Admin, Website Admin
    *
    * @apiParam {Integer=1,2} [guests] Guests filter<br>
    *                             Reference\:<br>array(
                                    1=>"Users",<br>
                                    2=>"Guests"
                                    )
    * @apiParam {Integer=1,2,3,4,5,6,7} [purpose] Purpose<br>
    *                             Reference\:<br>array(
                                    1=>"Office/Billing",<br>
                                    2=>"Technical Support",<Br>
                                    3=>"Abuse",<Br>
                                    4=>"Complaint",<Br>
                                    5=>"Question",<Br>
                                    6=>"Feedback",<Br>
                                    7=>"Other"<br>
                                    )
    * @apiParam {String} [search_text] Search keyword(s)
    * @apiParam {Integer} [start=0] Number of record to start with 
    * @apiParam {Integer=20,50,100} [length]  Number of records to be displayed per page
    * @apiParam {Integer=1,2,3,4} [fstatus]  Status<br>
    *                             Reference\:<br>array(
                                1=>"Open",<br>
                                2=>"Waiting Admin",<br>
                                3=>"Waiting User",<br>
                                4=>"Closed"<br>
                                )
    * @apiParam {String} [from_date]  From Date in format dd MM YYYY
    * @apiParam {String} [to_date]  To Date in format dd MM YYYY
    * @apiParam {String=feedback_id,content} [search_col]  Column name to search in
    * @apiParam {String=contains,starts,ends} [wild]  Wild card pattern
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "recordsTotal": "1576",
              "data": [
                {
                    "id": "9",
                    "feedback_id": "FB-2017-03-9",
                    "name": "Super Admin",
                    "email": "admin@email.com",
                    "phone": "9988999999",
                    "purpose": "Office/Billing",
                    "content": "message from API",
                    "ip_address": "117.98.217.92",
                     "url": null,
                    "username": "datta2",
                    "date": "30 Mar 2017",
                    "modified_on": "30 Mar 2017 03:23 PM",
                    "fstatus": "1",
                    "count": "0",
                    "read": "1",
                    "read_user": "0",
                    "checked_in": "1",
                    "checked_in_time": "2017-03-30 15:23:02",
                    "checked_in_username": "datta2",
                    "sno": 1
                }
        }
    *
    * @apiSuccess {Integer} recordsTotal  Total number of results
    * @apiSuccess {Object} data Events Object
    * @apiSuccess {Integer} data.id Unique Identifier
    * @apiSuccess {String} data.feedback_id Feedback ID
    * @apiSuccess {String} data.name Name of user
    * @apiSuccess {String} data.email Email ID of user
    * @apiSuccess {String} data.phone Phone number of user
    * @apiSuccess {String} data.purpose Purpose of feedback
    * @apiSuccess {String} data.content Feedback message
    * @apiSuccess {String} data.ip_address IP Address of user
    * @apiSuccess {String} data.url URL from which feedback posted (null for mobile)
    * @apiSuccess {String} data.username User ID of posted user
    * @apiSuccess {String} data.date Date in format dd MMM YYYY
    * @apiSuccess {String} data.modified_on Modified date in format dd MMM YYYY hh:mm A
    * @apiSuccess {Integer} data.fstatus Status of feedback message
    * @apiSuccess {Integer} data.count Number of replies
    * @apiSuccess {Integer=0,1} data.read 1 if Admin read the message otherwise 0
    * @apiSuccess {Integer=0,1} data.read_user 1 if User read the message otherwise 0
    * @apiSuccess {Integer=0,1} data.checked_in If admin checked in to message
    * @apiSuccess {String} data.checked_in_time Checked in time in format yyyy-mm-dd HH:ii:ss
    * @apiSuccess {String} data.checked_in_username User ID of checked in admin
    * @apiSuccess {Integer} data.sno Serial number
    */
    
    /**
    * @api {post} /feedbackadmin/:id Get a feedback message
    * @apiPermission Super Admin, Website Admin
    * @apiName Get
    * @apiGroup Feedback Admin
    *
    * @apiExample {curl} Example usage:
      curl -i /feedback/1561
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   {
            "id": "9",
            "feedback_id": "FB-2017-03-9",
            "name": "Super Admin",
            "email": "admin@admin.com",
            "phone": "9988999999",
            "purpose": "Office/Billing",
            "content": "message from API",
            "ip_address": "117.98.217.92",
            "user_agent": "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36",
            "url": "",
            "username": "datta2",
            "date": "2017-03-30 12:54:37",
            "fstatus": "1",
            "count": "0",
            "checked_in": "1",
            "checked_in_time": "2017-03-30 15:23:02",
            "checked_in_username": "datta2",
            "replies_data": {
                "replies": [
                    {
                        "id": "17",
                        "feedback_id": "9",
                        "content": "<p>This is a reply message</p>",
                        "date": "2017-03-30 14:11:27",
                        "userid": "308",
                        "admin": "1"
                    }
                ],
                "users": {
                    "308":
                    {
                        "id": "308",
                        "username": "datta2",
                        "firstname": "Super",
                        "lastname": "Admin",
                        "email": "admin@admin.com",
                        "profilepic": "",
                        "phoneno": "9989999899"
                    }
                }
            }
        }
    * 
    * @apiSuccess {Integer} id  Unique Identifier
    * @apiSuccess {String} feedback_id Feedback ID
    * @apiSuccess {String} name Name of user
    * @apiSuccess {String} email Email ID of user
    * @apiSuccess {String} phone Phone number of user
    * @apiSuccess {String} purpose Purpose
    * @apiSuccess {String} content Feedback Message
    * @apiSuccess {String} ip_address IP Address of the user
    * @apiSuccess {String} user_agent User agent string
    * @apiSuccess {String} url URL from where feedback sent. Empty for mobile app.
    * @apiSuccess {String} date Date in format YYYY-mm-dd HH:mm:ss
    * @apiSuccess {Integer} fstatus Status of message
    * @apiSuccess {Integer} count Number of feedback replies
    * @apiSuccess {Integer=0,1} checked_in If admin checked in to message
    * @apiSuccess {String} checked_in_time Checked in time in format yyyy-mm-dd HH:ii:ss
    * @apiSuccess {String} checked_in_username User ID of checked in admin
    * @apiSuccess {Object} replies_data Replies object contains replies and corresponding users data
    * @apiSuccess {Object} replies_data.replies Replies object
    * @apiSuccess {Integer} replies_data.replies.id Unique identifier of reply
    * @apiSuccess {Integer} replies_data.replies.feedback_id Unique identifier of feedback message
    * @apiSuccess {Integer} replies_data.replies.content Reply message
    * @apiSuccess {Integer} replies_data.replies.date Date of reply in format YYYY-mm-dd HH:mm:ss
    * @apiSuccess {Integer} replies_data.replies.user_id User ID of replied user
    * @apiSuccess {Integer} replies_data.replies.admin 1 if replied user is admin otherwise false
    * @apiSuccess {Object} replies_data.users Users object (User ID will be key for each user object)
    * @apiSuccess {Integer} replies_data.users.id Unique identifier of user
    * @apiSuccess {Integer} replies_data.users.username Username
    * @apiSuccess {Integer} replies_data.users.firstname First Name
    * @apiSuccess {Integer} replies_data.users.lastname Last Name
    * @apiSuccess {Integer} replies_data.users.email Email iD
    * @apiSuccess {Integer} replies_data.users.profilepic Path of profile picture
    * @apiSuccess {Integer} replies_data.users.phoneno Phone Number
    */
    public function index_post($id=null)
    {
        if($this->error)
            return;

        if ($id === NULL)
        {
            $list=$this->feedback_model->listMessagesAjax(0);
            foreach ($list['data'] as $key => $row)
            {
                unset($list['data'][$key]['user_id']);
                unset($list['data'][$key]['checked_in_user_id']);
                unset($list['data'][$key]['user_agent']);
                unset($list['data'][$key]['close_status']);
                unset($list['data'][$key]['admin']);
            }
            unset($list['recordsFiltered']);
            $users=$list;
            if ($users)
            {
                $this->response($users, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'No messages were found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
        else
        {
            $id = (int) $id;
            if ($id <= 0)
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST);
            }
            $feedbackData=$this->feedback_model->feedbackData($id);
            $response=null;
            if (!empty($feedbackData))
            {
                $this->feedback_model->messageRead($id);
                $this->feedback_model->checkIn($id);

                $feedbackData=$this->feedback_model->feedbackData($id);

                unset($feedbackData->modified_on);
                unset($feedbackData->close_status);
                unset($feedbackData->checked_in_user_id);
                unset($feedbackData->user_id);
                unset($feedbackData->admin);
                unset($feedbackData->read);
                unset($feedbackData->read_user);
                $feedbackData->purpose=$this->purposeArray[$feedbackData->purpose];
                $feedbackData->replies_data=$this->feedback_replies_model->getReplies($id);
                

                $this->set_response($feedbackData, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->set_response([
                    'status' => FALSE,
                    'message' => 'Message could not be found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }
    /**
    * @api {post} /feedbackadmin/close/:feedback_id Close a feedback request
    * @apiPermission Super Admin, Website Admin
    * @apiName  Close
    * @apiGroup Feedback Admin
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "feedback_id": 'FD-0099393'
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {String} feedback_id Feedback ID. This is set only if status is true
    */   
    public function close_post($feedbackId=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->load->model('feedback_model');

        if(is_numeric($feedbackId) && $feedbackId)
        {
            $feedbackData=$this->feedback_model->feedbackData($feedbackId);
            if(empty($feedbackData))
            {
                $response['message']="Invalid feedback ID";
                goto end;
            }
            
            $currentStatus=$feedbackData->fstatus;
            if(!in_array($currentStatus,array(1,2,3)))
            {
                $response['message']="Invalid request";
                goto end; 
            }

            $this->feedback_model->changeStatus($feedbackId,$feedbackData,4);
            
            $response['feedback_id']=$feedbackData->feedback_id;
            $response['status']=true;        
        }
        else
        {
            $response['message']="Invalid feedback ID";
        }
           
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }


    /**
    * @api {post} /feedbackadmin/checkout/:feedback_id Checkout from request
    * @apiPermission Super Admin, Website Admin
    * @apiName  Checkout
    * @apiGroup Feedback Admin
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    */   
    public function checkout_post($id=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if(is_numeric($id) && $id)
        {
            $feedbackData=$this->feedback_model->feedbackData($id);
            if(empty($feedbackData))
            {
                $response['message']="Invalid feedback ID";
                goto end;
            }
            
            $this->feedback_model->checkOut($id);

            $response['status']=true;        
        }
        else
        {
            $response['message']="Invalid feedback ID";
        }
           
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /feedbackadmin/reply/:feedback_id Reply to a feedback request
    * @apiPermission Super Admin, Website Admin
    * @apiDescription Admin can reply to a feedback message only when status is "Open or Waiting Admin".
    * @apiName  Reply
    * @apiGroup Feedback Admin
    * @apiParam {String} reply Reply message
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "feedback_id": 'FD-0099393'
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {String} feedback_id Feedback ID. This is set only if status is true
    */   
    public function reply_post($feedbackId=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->load->model('feedback_model');
        $this->load->model('feedback_replies_model');

        if(is_numeric($feedbackId) && $feedbackId)
        {
            $feedbackData=$this->feedback_model->feedbackData($feedbackId);
            if(empty($feedbackData))
            {
                $response['message']="Invalid feedback ID";
                goto end;
            }
            
            if(!in_array($feedbackData->fstatus,array(1,2)))
            {
                $response['message']="Invalid status";
                goto end;
            }
            if(!$feedbackData->user_id)
            {
                $response['message']="Invalid request";
                goto end;
            }
            
            $this->form_validation->set_rules('reply', 'Reply message', 'trim|required');

            if($this->form_validation->run() == FALSE)
            {
                $response['message']=strip_tags(validation_errors());
                goto end;
            }

            $this->feedback_replies_model->captureReply($feedbackId,$_POST['reply'],$feedbackData,1);
            $response['status']=true;
        }
        else
        {
            $response['message']="Invalid feedback ID";
        }
           
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /feedbackadmin/reply_guest/:feedback_id Reply to a feedback request (Guest)
    * @apiPermission Super Admin, Website Admin
    * @apiDescription Admin can reply to a feedback message only when status is "Open or Waiting Admin".
    * @apiName  Reply guest
    * @apiGroup Feedback Admin
    * @apiParam {String} subject Email subject<br>
                                        Minlength:6<br>
                                        Maxlength:200
    * @apiParam {String} reply Reply message
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "feedback_id": 'FD-0099393'
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {String} feedback_id Feedback ID. This is set only if status is true
    */   
    public function reply_guest_post($feedbackId=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->load->model('feedback_model');
        $this->load->model('feedback_replies_model');

        if(is_numeric($feedbackId) && $feedbackId)
        {
            $feedbackData=$this->feedback_model->feedbackData($feedbackId);
            if(empty($feedbackData))
            {
                $response['message']="Invalid feedback ID";
                goto end;
            }
            
            if(!in_array($feedbackData->fstatus,array(1,2)))
            {
                $response['message']="Invalid status";
                goto end;
            }

            if($feedbackData->user_id)
            {
                $response['message']="Invalid feedback ID";
                goto end;
            }
            
            $this->form_validation->set_rules('subject', 'Subject', 'trim|required|min_length[6]|max_length[200]');
            $this->form_validation->set_rules('reply', 'Reply message', 'trim|required');

            if($this->form_validation->run() == FALSE)
            {
                $response['message']=strip_tags(validation_errors());
                goto end;
            }

            $res=$this->feedback_replies_model->captureMailReply($feedbackId,$feedbackData,$_POST['subject'],$_POST['reply']);
            $response['status']=true;
        }
        else
        {
            $response['message']="Invalid feedback ID";
        }
           
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>