<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Currencies extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        
        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();

        if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");*/
    }
    /**
    * @api {post} /currencies List of currencies
    * @apiPermission Logged in User
    * @apiName Currencies
    * @apiGroup Currencies
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   [
            {
                "currency": "INR",
                "symbol": "₹",
                "min": "10",
                "max": "100000",
                "color": "black"
            },
            {
                "currency": "USD",
                "symbol": "$",
                "min": "10",
                "max": "2500",
                "color": "red"
            }
        ]
    */
    public function index_post()
    {
        $this->response($GLOBALS['currencies'], REST_Controller::HTTP_OK);
    }

    /**
    * @api {post} /currencies/get Get current currency value
    * @apiPermission Logged in User
    * @apiName Get
    * @apiGroup Currencies
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   
            {
                "currency": "INR",
                "symbol": "₹",
                "min": "10",
                "max": "100000",
                "color": "black"
            }
    */
    public function get_post()
    {
        $currency=$this->session->userdata("defaultCurrency");
        $result=array();
        foreach ($GLOBALS['currencies'] as $currencyData)
        {
            if(strtolower($currencyData['currency'])==strtolower($currency))
            {
                $result=$currencyData;
                break;
            }
        }
        $this->response($result, REST_Controller::HTTP_OK);
    }

    /**
    * @api {post} /currencies/change/:currency Change current currency
    * @apiPermission Logged in User
    * @apiName Change
    * @apiGroup Currencies
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   
            {
                "status": true
            }
    */
    public function change_post($currency='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($currency=='')
        {
            goto end;
        }

        $result=array();
        foreach ($GLOBALS['currencies'] as $currencyData)
        {
            if(strtolower($currencyData['currency'])==strtolower($currency))
            {
                $result=$currencyData;
                $this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());

                if($this->input->get("cart_type")==1)
                    $this->cart_log_model->log("App: Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("poojasCartAshramIdSelection"),1);
                else if($this->input->get("cart_type")==2)
                    $this->cart_log_model->log("App: Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("donationCartAshramIdSelection"),2);
                else if($this->input->get("cart_type")==3)
                    $this->cart_log_model->log("App: Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("storeCartAshramIdSelection"),3);
                
                $response['status']=true;
                break;
            }
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>