<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Videosadmin extends CI_Controller
{
	var $service='content';
	var $currentUser='';
    public function __construct() 
	{
        parent::__construct();
        $this->load->model('content/videos_model');
        $this->load->model('content/videos_albums_model');
        $this->load->model('ashrams/ashrams_model');
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
    }
	public function index()
	{
		$views = array( 'videos/admin/list');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listc()
	{
		$ashramId = $this->session->userdata("ashramId");
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
		{
			if($this->currentUser->ashram_id)
				$ashramId=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashramId=$this->currentUser->satsang_id;
		}
		$ashramId = isset($ashramId)?$ashramId:0;
		$list=$this->videos_albums_model->listAdmin($ashramId);
		echo json_encode($list);
	}
	public function listv($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$albumData=$this->videos_albums_model->albumData($id);
			if(!empty($albumData['album']))
			{
				$list=$this->videos_model->listAdmin($id);
				echo json_encode($list);
			}
		}
	}

	public function add_video($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$albumData=$this->videos_albums_model->albumData($id);
			if(empty($albumData['album']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			$this->form_validation->set_rules('video_id', 'Video ID', 'trim|required|min_length[3]|max_length[1000]');
			$this->form_validation->set_rules('type', 'Video Type', 'trim|required|checkVideoType');
			if($this->form_validation->run() == FALSE)
			{
				goto end;
			}
			$videoData=$this->videos_model->videoDataById($_POST['video_id'],$id);
			if(!empty($videoData))
			{
				$data['flag']=3;
				goto end;
			}
			$res=$this->videos_model->addVideo($albumData);
			$data['num']=$res;
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}
	public function add_edit_album($id=0)
	{
		if(isset($_POST['album_name']))
		{
			if($id)
			{
				$albumData=$this->videos_albums_model->albumData($id);
				if(empty($albumData['album']))
				{
					$this->session->set_flashdata("album_error",1);
					redirect('videosadmin');
				}
				if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
				{
					if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
					{
						$data['views'] = array('common/public/error');
	                	$this->load->view(FRONTEND_TEMPLATE,$data);
	                	return;
					}
				}
			}
			$this->form_validation->set_rules('album_name', 'Album Name', 'trim|required|min_length[6]|max_length[100]|checkVideoAlbumTitle['.$id.']');
			$this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[10]|max_length[1000]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("album_error",1);
				redirect("videosadmin/add_edit_album/".$id);
			}

			$r=$this->videos_albums_model->saveAlbum($id);

			if($r)
			{
				if($id)
				{
					$this->session->set_flashdata("album_saved",1);
				}
				else
				{
					$this->session->set_flashdata("album_created",1);
				}
				redirect("videosadmin/add_edit_album/".$r);
			}
			else
			{
				$this->session->set_flashdata("album_error",1);	
				redirect("videosadmin/add_edit_album/".$id);
			}
		}
		else
		{

			$views = array( 'videos/admin/add_edit_album');
			$data = array('views'=>$views,'id'=>$id);
			$data['ashrams']=$this->ashrams_model->getList();
			if($id)
			{
				$albumData=$this->videos_albums_model->albumData($id);
				if($albumData['album']->ashram_id)
					$data['ashramData']=$this->ashrams_model->ashramData($albumData['album']->ashram_id);
				if(empty($albumData['album']))
				{
					$this->session->set_flashdata("album_error",1);
					redirect('videosadmin');
				}
				$data['albumData']=$albumData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	function deletealbum($albumId=0)
	{
		$data['flag']=0;
		if(is_numeric($albumId) && $albumId)
		{
			$albumData=$this->videos_albums_model->albumData($albumId);
			if(empty($albumData['album']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			$r=$this->videos_albums_model->delete($albumData);
			if($r)
			{
				$data['flag']=1;
				$data['id']=$albumData['album']->name;
			}
		}
		end:
		echo json_encode($data);
	}
	function deletevideo($videoId=0)
	{
		$data['flag']=0;
		if(is_numeric($videoId) && $videoId)
		{
			$videoData=$this->videos_model->videoData($videoId);
			if(empty($videoData))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			
			$r=$this->videos_model->delete($videoData);
			if($r)
			{
				$data['flag']=1;
				$data['video_id']=$videoData->video_id;
			}
		}
		end:
		echo json_encode($data);
	}
	public function updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$videoData=$this->videos_model->videoData($_POST['pk']);
		if(empty($videoData))
		{
			echo 0;
		}
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
		{
			if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
			{
				echo 0;
				return;
			}
		}
		$this->videos_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function titlecheck($id=0)
	{
		if(isset($_POST['title']) && $_POST['title']!='')
		{
			$slug=url_title($this->general_model->filtertext($_POST['title']));
			if(strlen($slug)<6)
				echo "false";
			else
			{
				if(is_numeric($id))
				{
					$flag=$this->videos_albums_model->checkName($this->general_model->filtertext(trim($_POST['title'])),$id);
					if($flag==1)
						echo 'false';
					else
						echo 'true';
				}
				else
					echo "false";
			}
		}
		else
			echo "false";
	}
}
?>