<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Usersadmin extends CI_Controller 
{
	var $currentUser='';
	var $service="users";
	var $location='';
	var $logtrack='';
	var $statusArray=array(0=>"Inactive",
								1=>"Active",
								2=>"Suspended");
	var $statusResponse=array(
								1=>array('color'=>'lime',
										'info'=>"has been made Active"),
								2=>array('color'=>'ruby',
										'info'=>"has been Suspended"));
	function __construct()
    {
        parent::__construct();
		
		$this->load->model("user/users_model");
		$this->load->model("user/users_activity_model");
		$this->load->model("locations_model");
		$this->load->model('subscriptions_email_model');
		$this->load->library("userutil");
		$this->load->model("user/users_newsletters_model");
		$this->load->model("user/users_newsletter_images_model");
		$this->load->model("user/newsletters_que_model");
		$this->load->model("user/newsletters_sms_que_model");
		$this->load->model("sso_auth/prefill_user_ids_model");
		$this->currentUser=$this->session->userdata("admin_data");
    }

	public function index()
	{
		$data = array('views'=>array("users/admin/list_users"));
		$data['countries']=$this->users_model->getCountries();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function deleted_users()
	{
		$roles=$this->users_model->getRoles();
		$data = array('roles'=>$roles,'views'=>array("users/admin/list_deleted"));
		$data['countries']=$this->users_model->getCountriesDeleted();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function misc_reports()
	{
		$data = array('views'=>array("users/admin/list_misc_reports"));
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function loggedin()
	{
		$data = array('views'=>array("users/admin/list_users_loggedin"));
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function loggedin_day()
	{
		$data = array('views'=>array("users/admin/list_users_loggedin_day"));
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listusers($excel=0)
	{
		$list=$this->users_model->listUsersAjaxAdmin(0,$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Users listing ajax request");
	}
	public function passwordhistory()
	{
		$data = array('views'=>array("users/admin/list_password_report"));
		$data['countries']=$this->users_model->getCountries();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function bounced_emails()
	{
		$data = array('views'=>array("users/admin/list_bounced_emails"));
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function failed_sms()
	{
		$data = array('views'=>array("users/admin/list_failed_sms"));
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listpasswordhistory($excel=0)
	{
		$this->load->model('user/password_changing_history_model');
		$list=$this->password_changing_history_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Users password history ajax request");
	}
	public function listdeletedusers($excel=0)
	{
		$list=$this->users_model->listDeletedUsers($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Deleted Users listing ajax request");
	}
	public function listmiscreports($excel=0)
	{
		$this->load->model("user/login_record_model");
		$list=$this->login_record_model->listRecords($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Misc Reports listing ajax request");
	}
	public function listloggedin($excel=0)
	{
		$this->load->model("login_track_model");
		$list=$this->login_track_model->listRecords($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Loggedin Users Report listing ajax request");
	}
	public function listloggedin_day($excel=0)
	{
		$this->load->model("login_track_model");
		$list=$this->login_track_model->listRecordsDayWise($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Loggedin Users - Day wise Report listing ajax request");
	}

	public function adminusers()
	{
		$roles=$this->users_model->getRoles(1);
		$data = array('roles'=>$roles,'views'=>array("users/admin/list_users_admins"));
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listadmins($excel=0)
	{
		$list=$this->users_model->listUsersAjaxAdmin(1,$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Admin Users listing ajax request");
	}

	
	public function reserveduserids()
	{
		$data = array('views'=>array("users/admin/list_reserved_users"),'flag'=>1,
			"sub_title"=>"Reserved");
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function restricteduserids()
	{
		$data = array('views'=>array("users/admin/list_reserved_users"),'flag'=>0,
			"sub_title"=>"Restricted");
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listuserids($flag=1,$excel=0)
	{
		$this->load->model("user/users_reserved_model");
		$list=$this->users_reserved_model->getList($flag,$excel);
		echo json_encode($list);
	}
	public function listbouncedemails($excel=0)
	{
		$this->load->model("emails_sns_notifications_model");
		$list=$this->emails_sns_notifications_model->getBouncedEmailsList($excel);
		echo json_encode($list);
	}
	public function listfailedsms($excel=0)
	{
		$this->load->model("failed_sms_model");
		$list=$this->failed_sms_model->getFailedSMSList($excel);
		echo json_encode($list);
	}
	public function delete_userid($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)
		{
			$this->load->model("user/users_reserved_model");
			$userIdData=$this->users_reserved_model->userIdData($id,1);
			if(empty($userIdData))
			{
				goto end;
			}
			$this->users_reserved_model->delete($id);
			$result['flag']=1;
			$result['username']=$userIdData->username;
		}
		end:
		echo json_encode($result);
	}

	public function delete_bounced_email($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)
		{
			$this->load->model("emails_sns_notifications_model");
			$bounceData=$this->emails_sns_notifications_model->validateBounceData($id);
			if(empty($bounceData) || $bounceData["status"] == 2)
			{
				goto end;
			}
			$this->emails_sns_notifications_model->deleteBounceEmail($bounceData["bounced_email"],$bounceData["user_id"]);
			$result['flag']=1;
			$result['bounce_email']=$bounceData["bounced_email"];
		}
		end:
		echo json_encode($result);
	}

	public function delete_failed_sms($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)
		{
			$this->load->model("failed_sms_model");
			$bounceData=$this->failed_sms_model->validateFailData($id);
			if(empty($bounceData) || $bounceData["status"] == 2)
			{
				goto end;
			}
			$this->emails_sns_notifications_model->deleteFailedSMS($bounceData["failed_sms"],$bounceData["user_id"]);
			$result['flag']=1;
			$result['failed_sms']=$bounceData["failed_sms"];
		}
		end:
		echo json_encode($result);
	}
	
	public function changestatus($id=0,$status=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && is_numeric($status) && $id && $status)//Is ID and status are numeric value
		{
			$result['data']=array();
			$userData=$this->users_model->userData($id);

			if(empty($userData))
			{
				$this->logaction->log($this->service,"Change status - Invalid ID - ".$id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			
			$currentStatus=$userData->status;

			$granted=$this->checkStatus($currentStatus,$status);
			if(!$granted)
			{
				$this->logaction->log($this->service,"Change status - Invalid request - ".$userData->username);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			
			$flag=$this->users_model->changeStatus($id,$userData,$status);
			
			$result['data']=$userData;
			$result['flag']=1;
			$result['message']=$this->statusResponse[$status];

			$this->users_activity_model->insert($id,$this->currentUser->id,
						$this->statusArray[$currentStatus]." -> ".$this->statusArray[$status],
						$this->currentUser->username,
						$this->currentUser->firstname." ".$this->currentUser->lastname,1);

			$this->logaction->log($this->service,"Status changed from ".$this->statusArray[$currentStatus]." -> ".$this->statusArray[$status].
				" - ".$userData->username);
		}
		else
			$this->logaction->log($this->service,"Change Status - Invalid ID - ".$id);
		
		echo json_encode($result);
	}
	private function checkStatus($currentStatus,$newStatus)
	{
		if($currentStatus==0)
		{
			return 0;
		}
		if($currentStatus==1)
		{
			if($newStatus==2)
				return 1;
			else
				return 0;
		}
		if($currentStatus==2)
		{
			if($newStatus==1)
				return 1;
			else
				return 0;
		}
	}
	
	public function delete($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)//Is ID and status are numeric value
		{
			$result['data']=array();
			$userData=$this->users_model->userData($id);

			if(empty($userData))
			{
				$this->logaction->log($this->service,"Delete User - Invalid ID - ".$id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			
			if($userData->deleted==1 || $userData->admin==1)
			{
				$this->logaction->log($this->service,"Delete User - Invalid request - ".$userData->username);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			$this->load->model('subscriptions_email_model');
			$flag=$this->users_model->deleteUser($userData);
			
			$result['data']=$userData;
			$result['flag']=1;
			echo json_encode($result);
			$this->users_activity_model->insert($id,$this->currentUser->id,
						"Deleted",
						$this->currentUser->username,
						$this->currentUser->firstname." ".$this->currentUser->lastname,1);

			$this->logaction->log($this->service,"User deleted - ".$userData->username);
			return;
			
		}
		else
			$this->logaction->log($this->service,"Delete User - Invalid ID - ".$id);
		
		echo json_encode($result);
	}
	public function validate_users()
	{
		if($this->input->post("users_string")!='')
		{
			$users=$this->users_model->validateUsersByEmail($this->input->post("users_string"));
			header("Content-Type:application/json");
			echo json_encode($users);
		}
		else
		{
			header("Content-Type:application/json");
			json_encode(array());
		}
	}

	public function searchuser()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched users with - ".$query);
		//$this->load->model("user_model");
		$usersData=$this->users_model->searchUsers($query);
		$resultUsers = [];
		foreach ($usersData as $oneUser)
		{
		    $oneUser['avatar']='';
		    $oneUser['country_isd']='91';
		    if($oneUser['country_id'] !='')
		    {
		    	$userCountryData=$this->locations_model->getCountryByCode($oneUser['country_id']);
		    	if(!empty($userCountryData->isd_code) && $userCountryData->isd_code!='')
		    	{
		    		$oneUser['country_isd']=$userCountryData->isd_code;
		    		$oneUser['country_id']=$oneUser['country_id'];
		    	}
		    }
		    if($oneUser['country_id'] =='')
		    {
		    	$oneUser['country_id']='IN';
		    }
		    if($oneUser['profilepic']!='')
		    {
			    $uname=$oneUser['uusername'];
			    $fletter=strtolower($uname[0]);
			    $path=sso_aws_s3_base_url."users_profiles/".$fletter."/".md5($oneUser['sso_user_id'])."/thumb50_".$oneUser['profilepic'];
			    //if(file_get_contents($path))
			    if($oneUser['profilepic']!='')
			    {
			    	$oneUser['avatar']='<span class="avatar"><img src="'.$path.'"></span>';
			    }
			}
			if($this->input->post("type")=='users_newsletters')
			{
				$resultUsers[]=array("id"=>$oneUser['uid'],"text"=>$oneUser['firstname']." ".$oneUser['lastname']." (".$oneUser['uusername'].")");
			}
			else
				$resultUsers[] = $oneUser;
		}
		// Means no result were found
		if (empty($resultUsers)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "user"      => $resultUsers
		    )
		));
	}
	public function view($uid=null)
	{
		$referer='';
		if(isset($_SERVER['HTTP_REFERER']) && $_SERVER['HTTP_REFERER']!='')
		{
			$referer=str_replace(base_url,"",$_SERVER['HTTP_REFERER']);
		}
		
		if(!empty($uid))
		{
			if(!in_array($this->currentUser->roles, [1,5]))
			{
				$permittedReferers=array(
											"orders",
											"orders/view",
											"orders/poojas",
											"orders/donations",
											"orders/subscriptions",
											"orders/store",
											"orders/cancelled_orders",
											"orders/transactions",
											"orders/offline_transactions",
											"orders/failed_onetime",
											"orders/subscriptions_report",
											"orders/failed_subscriptions",
											"orders/failed_sevas",
											"orders/refund_transactions",
											"orders/cart_logs",
											"pledgeadmin",
											"registrationadmin",
											"techsupportadmin",
											"techsupportadmin/listemails",
											"techsupportadmin/view",
											"satsangadmin/members",
											"ashramadmin/members",
											"donorsadmin",
											"orders/cart_logs",
											"orders/listemails",
											"orders/listsms",
											"vedoktashantiadmin",
											"vedoktashantiadmin/listemails"
										);
				if(!in_array($referer,$permittedReferers))
				{
					if ( (strpos($referer, 'orders/cart_logs') !== false) || (strpos($referer, 'orders/view') !== false) )
					{
						
					}
					else
					{
						$data['views'] = array('status_message');
						$data['no_permission']=1;
						echo $this->load->view(FRONTEND_TEMPLATE,$data,true);
						exit;
					}
				}
			}

			$userData = $this->users_model->userDataByIDorUsername($uid);
			if(!empty($userData))
			{
		        $views = array( 'users/user/view_profile');
				$data = array('views'=>$views,'user'=>$userData,'id'=>$uid,"adminedit"=>1);
				$data['languages'] = $this->general_model->getLanguages();
				$this->load->view(ADMIN_TEMPLATE,$data);
			}
			else
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
		}
		else
		{
			end:
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
	public function add_edit_user($uid=0)
	{
		$referer='';
		if(isset($_SERVER['HTTP_REFERER']) && $_SERVER['HTTP_REFERER']!='')
		{
			$referer=str_replace(base_url,"",$_SERVER['HTTP_REFERER']);
		}
		if(!in_array($this->currentUser->roles, [1,5]))
		{
			$permittedReferers=array(
										"usersadmin/view"
									);
			if(!in_array($referer,$permittedReferers))
			{
				if (strpos($referer, 'usersadmin/view') !== false)
				{
					
				}
				else
				{
					$data['views'] = array('status_message');
					$data['no_permission']=1;
					echo $this->load->view(FRONTEND_TEMPLATE,$data,true);
					exit;
				}
			}
		}

		if($uid)
		{
			if(is_numeric($uid))
			{
				$userData=$this->users_model->userData($uid);
			
				if(empty($userData))
				{
					$this->session->set_flashdata("user_error",1);
					redirect('usersadmin');
				}
				if($userData->admin!=0)
				{
					$this->session->set_flashdata("user_error",1);
					redirect('usersadmin');
				}
			}
			else
			{
				$this->session->set_flashdata("user_error",1);
				redirect('usersadmin');
			}
		}
		if(isset($_POST['save_profile']))
		{
			if(!isset($_POST['address']) || !isset($_POST['address1']) || !isset($_POST['address2']) || !isset($_POST['gothram']) || !isset($_POST['profession']) || !isset($_POST['star']) || !isset($_POST['raasi']) || !isset($_POST['gender']) || !isset($_POST['dob']) || !isset($_POST['phone']) || !isset($_POST['pan_number']) || !isset($_POST['country']) || !isset($_POST['state']) || !isset($_POST['city']) || !isset($_POST['zip']) || !isset($_POST['lang']))
			{
				$this->session->set_flashdata("profile_error",1);
				goto end;
			}

			$file=0;
			
			if(!empty($userData->sso_user_id))
				$sso_id = $userData->sso_user_id;
			else
				$sso_id = 0;

			$userId=$this->currentUser->id;
			$this->form_validation->set_rules('user_email', 'Email ID', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]|emailCheck['.$sso_id.']|emailBounceCheck');
			$this->form_validation->set_rules('first_name', 'First Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
			$this->form_validation->set_rules('middlename', 'Middle Name', 'trim|max_length[50]|lettersonly');
			$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
			$this->form_validation->set_rules('profession', 'Profession', 'trim|professionCheck');
			$this->form_validation->set_rules('star', 'Birth Star', 'trim|starCheck');
			$this->form_validation->set_rules('raasi', 'Raasi', 'trim|raasiCheck');
			$this->form_validation->set_rules('gothram', 'Gothram', 'trim|min_length[3]|max_length[50]');
			$this->form_validation->set_rules('gender', 'Gender', 'trim|genderCheck');
			$this->form_validation->set_rules('dob', 'Date of Birth', 'trim|dobCheck');
			$this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');
			$this->form_validation->set_rules('pan_number', 'PAN Number', 'trim|min_length[6]|max_length[20]');
			$this->form_validation->set_rules('address', 'Address Line 1', 'trim|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('address1', 'Address Line 2', 'trim|min_length[3]|max_length[100]|noSpaces');
			$this->form_validation->set_rules('address2', 'Address Line 3', 'trim|min_length[3]|max_length[100]|noSpaces');
			$this->form_validation->set_rules('country', 'Country', 'trim|required|countryCheck');
			$this->form_validation->set_rules('state', 'State', 'trim|min_length[2]|max_length[100]|name_validate13');
			$this->form_validation->set_rules('city', 'City', 'trim|min_length[2]|max_length[100]|name_validate13');
			$this->form_validation->set_rules('zip', 'ZIP Code', 'trim|min_length[3]|max_length[15]');
			$this->form_validation->set_rules('lang', 'Language', 'trim|checkLanguage');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("profile_error",1);
				/*echo validation_errors();
				exit;*/
				goto end;
			}

			if(isset($_FILES['profile_image']))
			if($_FILES['profile_image']['name']!='')
			{
				if($_FILES['profile_image']['size']==0)
				{
					$this->session->set_flashdata("profile_error",1);
					goto end;
				}
				$ext=pathinfo ($_FILES['profile_image']['name'],PATHINFO_EXTENSION);

				if($ext=='')
				{
					$this->session->set_flashdata("profile_error",1);
					goto end;	
				}

				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['profile_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['profile_image']['size']==0 || $ext=='' || !in_array($_FILES['profile_image']['type'],$allowed_file_types) || $_FILES['profile_image']['size']>(10*1024*1024))
				{
					$this->session->set_flashdata("profile_error",1);
					goto end;
				}

				if(!getimagesize($_FILES['profile_image']['tmp_name']))
				{
					$this->session->set_flashdata("profile_error",1);
					goto end;
				}
				$file=1;
			}
			$this->load->model("user/user_debit_account_model");
			$this->users_model->updateProfile($uid,$_POST);
            $this->session->set_flashdata("profile_updated",1);

            $this->user_debit_account_model->setAccount($uid);

            end:
			redirect('/usersadmin/add_edit_user/'.$uid);
        }
		else
		{
		
			$this->session->unset_userdata('user_id');
			$this->session->unset_userdata('user_data');
			
			$languages = $this->general_model->getLanguages();
			$countries=$this->locations_model->getCountries();
			$states=array();
			$cities=array();
			if($uid)
			{
				$us = $this->users_model->userData($uid);
		        $views = array( 'users/user/editmyprofile');
		        $tempRoles=array_filter(explode(",",$this->session->userdata("admin_data")->roles));
		        if(!empty($tempRoles))
		        {
		        	if(in_array(109,$tempRoles))
		        	{
		        		$views = array( 'user/view_profile');	
		        	}
		        }
			}
			else
			{
				$us="";
				$views = array( 'users/admin/register');
			}
			$data = array('views'=>$views,'user'=>$us,'languages'=>$languages,'id'=>$uid,
			'country'=>$countries,"adminedit"=>1,'post_url'=>"");
			$data['security_questions']=$this->users_model->getSecurityQuestionsGroups();
			$data['user_security_questions']=$this->users_model->getSecurityQuestions($uid);
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}


	public function saveUpdateUser($uid=0)
	{
		if($uid)
		{
			if(is_numeric($uid))
			{
				$userData=$this->users_model->userData($uid);
			
				if(empty($userData))
				{
					$result['error']="Invalid Request";
					$result['flag']=0;
					goto end;
				}
				if($userData->admin!=0)
				{
					$result['error']="Invalid Request";
					$result['flag']=0;
					goto end;
				}
			}
			else
			{
				$result['error']="Invalid Request";
				$result['flag']=0;
				goto end;
			}
		}
		if(!isset($_POST['address']) || !isset($_POST['address1']) || !isset($_POST['address2']) || !isset($_POST['gothram']) || !isset($_POST['profession']) || !isset($_POST['star']) || !isset($_POST['raasi']) || !isset($_POST['gender']) || !isset($_POST['dob']) || !isset($_POST['phone']) || !isset($_POST['pan_number']) || !isset($_POST['country']) || !isset($_POST['state']) || !isset($_POST['city']) || !isset($_POST['zip']) || !isset($_POST['lang']))
		{
			$result['error']="Invalid Request";
			$result['flag']=0;
			goto end;
		}

		$file=0;
		
		if(!empty($userData->sso_user_id))
			$sso_id = $userData->sso_user_id;
		else
			$sso_id = 0;

		$userId=$this->currentUser->id;
		$this->form_validation->set_rules('user_email', 'Email ID', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]|emailCheck['.$sso_id.']|emailBounceCheck');
		$this->form_validation->set_rules('first_name', 'First Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('middlename', 'Middle Name', 'trim|max_length[50]|lettersonly');
		$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('profession', 'Profession', 'trim|professionCheck');
		$this->form_validation->set_rules('star', 'Birth Star', 'trim|starCheck');
		$this->form_validation->set_rules('raasi', 'Raasi', 'trim|raasiCheck');
		$this->form_validation->set_rules('gothram', 'Gothram', 'trim|min_length[3]|max_length[50]');
		$this->form_validation->set_rules('gender', 'Gender', 'trim|genderCheck');
		$this->form_validation->set_rules('dob', 'Date of Birth', 'trim|dobCheck');
		$this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');
		$this->form_validation->set_rules('pan_number', 'PAN Number', 'trim|min_length[6]|max_length[20]');
		$this->form_validation->set_rules('address', 'Address Line 1', 'trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address1', 'Address Line 2', 'trim|min_length[3]|max_length[100]|noSpaces');
		$this->form_validation->set_rules('address2', 'Address Line 3', 'trim|min_length[3]|max_length[100]|noSpaces');
		$this->form_validation->set_rules('country', 'Country', 'trim|required|countryCheck');
		$this->form_validation->set_rules('state', 'State', 'trim|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('city', 'City', 'trim|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('zip', 'ZIP Code', 'trim|min_length[3]|max_length[15]');
		$this->form_validation->set_rules('lang', 'Language', 'trim|checkLanguage');

		if($this->form_validation->run() == FALSE)
		{
			$result['error']="Something wrong! Please refresh page and try again";
			$result['error_data']=validation_errors();
			$result['flag']=0;
			goto end;
		}

		if(isset($_FILES['profile_image']))
		{
			if($_FILES['profile_image']['name']!='')
			{
				if($_FILES['profile_image']['size']==0)
				{
					$result['error']="Invalid Profile Image";
					$result['flag']=0;
					goto end;
				}
				$ext=pathinfo ($_FILES['profile_image']['name'],PATHINFO_EXTENSION);

				if($ext=='')
				{
					$result['error']="Invalid Profile Image Extenction";
					$result['flag']=0;
					goto end;	
				}

				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['profile_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['profile_image']['size']==0 || $ext=='' || !in_array($_FILES['profile_image']['type'],$allowed_file_types) || $_FILES['profile_image']['size']>(10*1024*1024))
				{
					$result['error']="Invalid Profile Image Size";
					$result['flag']=0;
					goto end;
				}

				if(!getimagesize($_FILES['profile_image']['tmp_name']))
				{
					$result['error']="Invalid Profile Image";
					$result['flag']=0;
					goto end;
				}
				$file=1;
			}
		}
		$this->load->model("user/user_debit_account_model");
		$this->users_model->updateProfile($uid,$_POST);
        $this->session->set_flashdata("profile_updated",1);
        $this->user_debit_account_model->setAccount($uid);
        $result['userid']=$uid;
		$result['flag']=1;
        end:
		echo json_encode($result);
	}

	/**
	 * [add_edit_adminuser Creat admin User]
	 * @param integer $uid [Auto Increment Id]
	 * @author Baji Shaik <bajidotwork@gmail.com>
	 */
	public function add_edit_adminuser($id=0)
	{
		if($id)
		{
			$us = $this->users_model->adminUserData($id);
			if(!empty($us) && empty($us->admin))
			{
				$this->session->set_flashdata("user_error",1);
				redirect('usersadmin/adminusers');
			}
		}
		else
		{
			$us = "";
		}

		if(!empty($_POST))
		{
			$userId=$this->currentUser->id;

			if(!empty($us->sso_user_id))
				$sso_id = $us->sso_user_id;
			else
				$sso_id = 0;

			$this->form_validation->set_rules('email', 'Email ID', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]|emailCheck['.$sso_id.']|emailBounceCheck');
			$this->form_validation->set_rules('firstname', 'First Name', 'trim|required|min_length[2]|max_length[50]|name_validate4');
			$this->form_validation->set_rules('middlename', 'Middle Name', 'trim|max_length[50]|name_validate4');
			$this->form_validation->set_rules('lastname', 'Last Name', 'trim|min_length[2]|max_length[50]|name_validate4');
			$this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');
			$this->form_validation->set_rules('username', 'User ID', 'trim|required|min_length[6]|max_length[60]|alphabetsnumbers2');
			$this->form_validation->set_rules('roles', 'Role', 'required|validateAdminRoles');
			$this->form_validation->set_rules('admin_user_check', 'Admin user belong to?', 'required|numeric|checkAdminUserType');

			if(isset($_POST['admin_user_check']) && $_POST['admin_user_check'] == "2")
				$this->form_validation->set_rules('ashram_id', 'Ashram', 'required|numeric|validateAshrams');
			if(isset($_POST['admin_user_check']) && $_POST['admin_user_check'] == "3")
				$this->form_validation->set_rules('satsang_id', 'Satsang', 'required|numeric|validateSatsangs');

			if( (isset($_POST['roles']) && $_POST['roles'] == "4") && (isset($_POST['admin_user_check']) && $_POST['admin_user_check'] == "2") && (isset($_POST['currency_specific']) && $_POST['currency_specific'] == "1") )
			{
				$this->form_validation->set_rules('currencies[]', 'Currencies', 'required');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("user_error",1);
				redirect('usersadmin/add_edit_adminuser/'.$id);
			}
			$this->load->model('userutil_model');
			$saved=$this->userutil_model->saveadminuser($id);
			if($saved)
			{

				if($id)
					$this->session->set_flashdata('userid_saved',1);
				else
					$this->session->set_flashdata('userid_created',1);
			}
			else
				$this->session->set_flashdata('user_error',1);

			redirect('usersadmin/add_edit_adminuser/'.$saved);
        }
		else
		{
			if($id!='' && (empty($us)) )
			{
				redirect('usersadmin/adminusers');
			}
			$this->load->model('ashrams_model');
			$this->load->model('satsangs_model');
			$this->load->model("user_model");
			$roles=$this->user_model->getAdminRoles();
			$ashrams = $this->ashrams_model->getList();
			$satsangs = $this->satsangs_model->getList();
			$countries=$this->locations_model->getCountries();
			$ashram_currencies = [];
			if(isset($us->ashram_id) && $us->ashram_id>0)
			{
				$this->load->model('currencies_model');
            	$ashram_currencies=$this->currencies_model->getByAshram($us->ashram_id);
			}
			$views = array( 'users/admin/add_adminuser');
			$data = array('views'=>$views,'result'=>$us,'ashrams'=>$ashrams,'satsangs'=>$satsangs,'id'=>$id,
			'country'=>$countries,"adminedit"=>1,'post_url'=>"","roles"=>$roles, "ashram_currencies"=> $ashram_currencies);
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	public function register()
	{
		$this->form_validation->set_rules('firstname', 'First Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('middlename', 'Middle Name', 'trim|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('lastname', 'Last Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('email', 'Email ID', 'trim|required|no_uppercase|min_length[6]|max_length[100]|valid_email_custom|emailCheck[0]|emailBounceCheck');
        
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]|max_length[50]');
        $this->form_validation->set_rules('rpassword', 'Retype Password', 'trim|required|matches[password]');
        $this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');
        $this->form_validation->set_rules('pan_number', 'PAN Number', 'trim|min_length[6]|max_length[20]');
        $this->form_validation->set_rules('country', 'Country', 'trim|countryCheck');
        $this->form_validation->set_rules('zip', 'ZIP Code', 'trim|min_length[3]|max_length[15]');
        if(!empty($_POST['prefill-user-id']) && $_POST['prefill-user-id'] == "on")
        {
        	$this->form_validation->set_rules('username', 'User ID', 'trim|required|min_length[6]|max_length[60]|numeric|usernameCheck');
        }
        else
        {
        	$this->form_validation->set_rules('username', 'User ID', 'trim|required|min_length[6]|max_length[60]|alphabetsnumbers2|usernameCheck');
        }
		if($this->form_validation->run() == FALSE)
		{
			$result['error']="Something wrong! Please refresh page and try again";
			$result['error_data']=validation_errors();
			goto end;
		}
		if(!empty($_POST['prefill-user-id']) && $_POST['prefill-user-id'] == "on")
        {
        	$user_id = $this->prefill_user_ids_model->getId();
        	$_POST['username'] = $user_id;
        }
		$data=$this->userutil->register($_POST);
		if($data['flag']==1)
		{
			if(!empty($_POST['prefill-user-id']) && $_POST['prefill-user-id'] == "on")
        	{
        		$user_id = (int)$user_id;
        		$user_id = $user_id + 1;
        		$this->prefill_user_ids_model->updateLatestID($user_id);
        	}
			$result['userid']=$data['userid'];
			$result['flag']=1;
			$this->session->set_flashdata("user_created_admin",1);
		}
		end:
		echo json_encode($result);
	}

	public function populate_user_id()
	{
		$user_id = $this->prefill_user_ids_model->getId();
		header("Content-Type:application/json");
		echo json_encode($user_id);
	}
	
	public function statement($uid=0)
	{
		$data['flag']=0;
		if($uid)
		{
			if(is_numeric($uid))
			{
				$userData=$this->users_model->userData($uid);
			
				if(empty($userData))
				{
					goto end;
				}
				if($userData->admin!=0)
				{
					goto end;
				}
				$this->load->model("user/user_account_transactions_model");
				$result=$this->user_account_transactions_model->getTransactions($uid,1);
				echo json_encode($result);
				return;
			}
		}
		end:
		echo json_encode($data);
	}
	public function loginhistory_user($uid=0)
	{
		$data['flag']=0;
		if($uid)
		{
			if(is_numeric($uid))
			{
				$userData=$this->users_model->userData($uid);
			
				if(empty($userData))
				{
					goto end;
				}
				if($userData->admin!=0)
				{
					goto end;
				}
				$this->load->model("login_track_model");
				$result=$this->login_track_model->getHistory($uid);
				echo json_encode($result);
				return;
			}
		}
		end:
		echo json_encode($data);
	}

	public function add_edit_reserved_userid($id=0)
	{
		$this->load->model("user/users_reserved_model");
		if(isset($_POST['add_userid']))
		{
			$this->form_validation->set_rules('username', 'User ID', 'trim|required|min_length[6]|checkReservedUserId');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("user_error",1);
				redirect('/usersadmin/add_edit_reserved_userid');
			}

            $uid=$this->users_reserved_model->save($_POST['username'],1);
            if($id)
            	$this->session->set_flashdata("userid_saved",1);
            else
            	$this->session->set_flashdata("userid_created",1);
			redirect('/usersadmin/add_edit_reserved_userid');
        }
		else
		{
			$views = array( 'users/admin/add_edit_userid');
			$data = array('views'=>$views,"flag"=>1,'sub_title'=>"Reserved");
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function add_edit_restricted_userid($id=0)
	{
		$this->load->model("user/users_reserved_model");
		if(isset($_POST['add_userid']))
		{
			$this->form_validation->set_rules('username', 'User ID(s)', 'trim|required|min_length[3]|checkRestrictedUserId');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("user_error",1);
				redirect('/usersadmin/add_edit_restricted_userid');
			}
            $uid=$this->users_reserved_model->save($_POST['username'],0);
            if($id)
            	$this->session->set_flashdata("userid_saved",1);
            else
            	$this->session->set_flashdata("userid_created",1);
			redirect('/usersadmin/add_edit_restricted_userid');
        }
		else
		{
			$views = array( 'users/admin/add_edit_userid');
			$data = array('views'=>$views,"flag"=>0,'sub_title'=>"Restricted");
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function bulk_user_invite()
	{
		$views = array( 'users/admin/bulk_user_invite');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function user_invite()
	{
		if(isset($_POST['invite_button']))
		{
			$cnt=0;
			$fail=0;

			$this->load->library("email_extension");
			
			foreach($_POST['emailids'] as $email)
			{
				$subject="You are invited to create an account on ".site_name_string1;
				ob_start();
				$this->load->view("users/admin/_email_invite");
				$content=ob_get_clean();
				$response=$this->email_extension->sendMailGuest($this->service,$email,$email,$subject,$content);
				if($response['flag']==1)
				{
					$cnt++;
				}
				else
				{
					$fail++;
				}
			}
			
			$this->session->set_flashdata("invites_sent",$cnt);
			$this->session->set_flashdata("invites_fail",$fail);
			$this->session->set_flashdata("invites_status",1);
			redirect("usersadmin/bulk_user_invite");
		}
	}

	public function add_bulk_users()
	{
		if(isset($_POST['save_csv']))
		{
			$this->load->model('subscriptions_email_model');

			if(!isset($_FILES['csvuser']['name']) || $_FILES['csvuser']['name']=='')
			{
				$this->session->set_flashdata("upload_error1","Invalid file");
				redirect("usersadmin/add_bulk_users");
			}
			$this->load->model("user/users_reserved_model");
			
			$name=$_FILES['csvuser']['name'];
			$tmp=$_FILES['csvuser']['tmp_name'];
			move_uploaded_file($tmp,dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name);
			
			$this->load->library("Excel");
			$inputFileName = dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name;
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objReader->setReadDataOnly(true);//Get the area of data inserted
			$objPHPExcel = $objReader->load($inputFileName);
			$sheetData=$objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

			$cols=$sheetData[1];

			if(count($cols)!=7)
			{
				$this->session->set_flashdata("upload_error1","Invalid data format.");
				redirect("usersadmin/add_bulk_users");
			}
			if($cols['A']!='userid' || $cols['B']!='email' || $cols['C']!='firstname' || 
				$cols['D']!='middlename' ||	$cols['E']!='lastname' || $cols['F']!='phone' || $cols['G']!='country'
			)
			{
				$this->session->set_flashdata("upload_error1","Invalid data format");
				redirect("usersadmin/add_bulk_users");
			}

			unset($sheetData[1]);

			if(count($sheetData)==0)
			{
				$this->session->set_flashdata("upload_error1","File contains no data.");
				redirect("usersadmin/add_bulk_users");
			}
			
			$rownum=1;
			$error='';
			$skipped=0;
			$done=0;
			$e=0;
			$tempnum=0;
			// A = Username
			// B = Phone
			// C = Email
			// D = First name
			// E = Middle Name
			// F = Last Name
			// G = DOB
			// H = Gender
			//if($result)
			foreach($sheetData as $rr)
			{
				if(trim($rr['A'])=='' || trim($rr['B'])=='' || trim($rr['C'])=='' || 
					trim($rr['E'])=='' ||  trim($rr['G'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Insufficient data";
					$rownum++;
					$skipped++;
					continue;
				}
				$e=0;
				$eUserID=trim($rr['A']);
				$eEmail=trim($rr['B']);
				$eFname=trim($rr['C']);
				$eMname=trim($rr['D']);
				$eLname=trim($rr['E']);
				$ePhone=trim($rr['F']);
				$eCountry=trim($rr['G']);

				if(strlen(trim($rr['A']))<6)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Userid must be at least 6 character";
				}
				else if(strlen(trim($rr['A']))>60)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Userid must not be more than 60 characters";
				}
				else if (!preg_match('/^[a-z0-9]+$/i', trim($rr['A'])))
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Userid must contain letters and numbers only";
				}
				else
				{
					$restricted=$this->users_reserved_model->check_restricted_reserved($rr['A']);
					$uch=$this->users_model->usernameCheck($rr['A']);
					if($uch || $restricted)
					{
						if($tempnum && $tempnum!=$rownum) $error.=' ,';
						$error.="Row No:$rownum Userid: $eUserID already exists ";
						$e=1;
					}
				}


				//Email Validations
				
				if(strlen($eEmail)<6)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Email ID must be at least 6 character";
				}
				else if(strlen($eEmail)>200)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Email ID must not be more than 200 characters";
				}
				else if ($this->form_validation->valid_email_custom($eEmail)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$e=1;
					$error.="Row No:$rownum Email ID is invalid";
				}
				else
				{
					$uch=$this->users_model->emailCheck($eEmail,0);
					if($uch)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Email ID: $eEmail already exists ";
						$e=1;
					}
				}
				

				if($ePhone!='')
				{
					if(strlen($ePhone)<8)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must be at least 8 characters";
						$e=1;
					}
					
					else if(strlen($ePhone)>15)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must not be more than 15 characters ";
						$e=1;
					}
					else if ($this->form_validation->numeric($ePhone)==false)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must be numeric ";
						$e=1;
					}
					else
					{
						$uch=$this->users_model->phoneCheck($ePhone,0);
						if($uch)
						{
							if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
							if($e==0) $error.=" Row No: $rownum";
							else $error.=" | ";
							$error.=" Phone number already exists ";
							$e=1;
						}
					}
				}

				if(strlen($eFname)<2)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" First Name must be at least 2 characters";
					$e=1;
				}
				
				else if(strlen($eFname)>50)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" First Name must not be more than 50 characters ";
					$e=1;
				}
				if($eMname!='')
				{
					if(strlen($eMname)<1)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Middle Name must be at least 1 character";
						$e=1;
					}
					
					else if(strlen($eMname)>50)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Middle Name must not be more than 50 characters ";
						$e=1;
					}
				}

				if(strlen($eLname)<2)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" Last Name must be at least 2 characters";
					$e=1;
				}
				
				else if(strlen($eLname)>50)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" Last Name must not be more than 50 characters ";
					$e=1;
				}

				if ($this->form_validation->countryCheck($eCountry)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" Country is invalid ";
					$e=1;
				}

				
				$tempnum=$rownum;
				
				
				$this->load->helper('string');
				$pass=random_string('alnum', 5);
				$rownum++;
				if($e==0)
				{
					$rInfo['username']=$eUserID;
					$rInfo['firstname']=$eFname;
					$rInfo['middlename']=$eMname;
					$rInfo['lastname']=$eLname;
					$rInfo['country']='';
					$rInfo['password']=$pass;
					$rInfo['email']=strtolower($eEmail);
					$rInfo['phone']=$ePhone;
					$rInfo['country']=$eCountry;
					$rInfo['user_type']="import";

					$data=$this->userutil->register($rInfo);

					$this->users_model->sendResetPasswordLink($data['userid']);
					$done++;
				}
				else $skipped++;
				
			}
			$this->session->set_flashdata("upload_error",$error);
			$this->session->set_flashdata("upload_done",1);
			$this->session->set_flashdata("skipped",$skipped);
			$this->session->set_flashdata("done",$done);
			redirect("usersadmin/add_bulk_users");
		}
		$views = array( 'users/admin/bulk_user_upload');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function send_email_verification_link($uid)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$userData=$this->users_model->userData($uid);
			if(empty($userData))
			{
				goto end;
			}
			if($userData->email_verified==1 || $userData->status==2)
			{
				goto end;
			}
			$this->userutil->sendEmailVerificationLink($uid);
			$data['flag']=1;
			$data['email']=$userData->email;
		}
		end:
		echo json_encode($data);
	}
	public function send_reset_password_link($uid)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$userData=$this->users_model->userData($uid);
			if(empty($userData))
			{
				goto end;
			}
			if($userData->email_verified==0 || $userData->status==2)
			{
				goto end;
			}
			$this->users_model->sendResetPasswordLink($uid);
			$data['flag']=1;
			$data['email']=$userData->email;
		}
		end:
		echo json_encode($data);
	}

	public function load_lookup()
	{
		$this->load->view("users/admin/_user_lookup_public");
	}

	public function loadusers()
	{
		$list=$this->users_model->listUsersPublicAdmin();
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Public Users listing ajax request");
	}

	public function clear_temp_user()
	{
		$tempUser=$this->session->userdata('temp_checkout_user');
		//$this->logaction->log_action("Admin: Cleared User _ User ID: ".$tempUser->id." _ Username: ".$tempUser->username,"Order");
		$this->session->unset_userdata('temp_checkout_user');
	}

	public function resetpass($uid=0)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$userData=$this->users_model->userData($uid);
			if(empty($userData))
			{
				goto end;
			}
			if($userData->roles==1)
			{
				goto end;
			}
			$this->form_validation->set_rules('pass', 'New Password','trim|required|min_length[8]|max_length[50]');
			if($this->form_validation->run() == FALSE)
			{
		 		goto end;
			}
			$this->users_model->resetAdminPassword($userData,$_POST['pass']);
			$data['flag']=1;
			$data['username']=$userData->username;
		}
		end:
		echo json_encode($data);
	}

	//-===============================================================================================================================
	//-===============================================================================================================================
	//-===============================================================================================================================
	//-===============================================================================================================================
	//-===============================================================================================================================

	public function verifyusername($username='')
	{
		if($username!='')
		{
			$this->load->model('user/users_reserved_model');
			$restricted=$this->users_reserved_model->check_restricted_reserved($username);
			if($restricted)
			{
				echo 0;
				return;
			}
			$flag=$this->userutil->verifyUsername($username,0);
			if($flag)
			{
				echo 0;
			}
			else
			{
				echo 1;
			}
		}
		else
		{
			echo 0;
		}
	}
	public function verifyemail($email='',$uid=0)
	{
		if($email!='')
		{
			$flag=$this->userutil->verifyEmail($email,$uid);
			if($flag)
			{
				echo 0;
			}
			else
			{
				echo 1;
			}
		}
		else
			echo 0;
	}

	public function load_user($uid=0)
	{
		if(!$uid)
		{
			$this->session->set_flashdata('user_error',1);
			redirect('usersadmin');
		}
		$userData=$this->users_model->userData($uid);
		if(!empty($userData))
		{
			$this->session->unset_userdata('user_id');
			$this->session->unset_userdata('user_data');

			$this->session->set_userdata('user_id',$uid);
			$this->session->set_userdata('user_data',$userData);
			
			redirect('myaccount');
		}
		else
		{
			$this->session->set_flashdata('user_error',1);
			redirect('usersadmin');
		}
	}
	function emailCheck()
	{
		$exists=$this->users_model->emailCheck($_POST['email'],$_POST['id']);
		if(!$exists)
		{
			echo 'true';
		}
		else echo 'false';
	}
	
	function usernamecheck()
	{
		$this->load->model('user/users_reserved_model');
        $restricted=$this->users_reserved_model->check_restricted_reserved($_POST['username']);
        if($restricted)
        {
            echo "false";
            return;
        }

		$exists=$this->users_model->usernameCheck($_POST['username']);
		if(!$exists)
		{
			echo 'true';
		}
		else echo 'false';
	}
	
	function adminusernamecheck()
	{
		$exists=$this->users_model->adminusernameCheck($_POST['username'],$_POST['id']);
		if(!$exists)
		{
			echo 'true';
		}
		else echo 'false';
	}
	///================================Newsletters ================================//

	public function newsletters()
	{
		$views = array( 'users/admin/list_newsletters' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed newsletters page");
	}
	public function listns($excel=0)
	{
		$list=$this->users_newsletters_model->listNewsletters($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed newsletters ajax request");
	}

	public function mail_queue($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->users_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("usersadmin/newsletters");
			}
			if($newsletterData->type==1)
				$views = array( 'users/admin/list_newsletter_queue');
			if($newsletterData->type==2)
				$views = array( 'users/admin/list_newsletter_sms_queue');
			$data = array('views'=>$views);
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect('usersadmin/newsletters');
		}
	}
	public function listqueue($id=0,$excel=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->users_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				return;
			}
			if($newsletterData->type==1)
				$list=$this->newsletters_que_model->listQueue($newsletterData,$excel);
			if($newsletterData->type==2)
				$list=$this->newsletters_sms_que_model->listQueue($newsletterData,$excel);
			echo json_encode($list);
		}
	}

	public function resend($id=0,$qid=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($qid) && $qid)
		{
			$newsletterData=$this->users_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				goto end;
			}
			if($newsletterData->type==1)
			{
				$mailData=$this->newsletters_que_model->mailData($qid);
				if(empty($mailData) || $mailData->newsletter_id!=$id || $mailData->status==0)
				{
					goto end;
				}
				$r=$this->newsletters_que_model->resend($qid,$mailData);
				if($r)
				{
					$data['flag']=1;
					$data['email']=$mailData->mail_to;
				}
			}
			if($newsletterData->type==2)
			{
				$smsData=$this->newsletters_sms_que_model->smsData($qid);
				if(empty($smsData) || $smsData->newsletter_id!=$id || $smsData->status==0)
				{
					goto end;
				}
				$r=$this->newsletters_sms_que_model->resend($qid,$smsData);
				if($r)
				{
					$data['flag']=1;
					$data['email']=$smsData->to;
				}
			}
		}
		end:
		echo json_encode($data);
	}

	public function add_edit_newsletter($id=0)
	{
		if(isset($_POST["add_newsletter"]) || isset($_POST["send_newsletter"]))
		{
			if(!isset($_POST['content']))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('usersadmin/add_edit_newsletter/'.$id);
			}
			$this->form_validation->set_rules('type', 'Type', 'trim|numeric|newsletterType');
			if($this->input->post("type")==1)
			{
				$this->form_validation->set_rules('subject', 'Newsletter Subject', 'trim|required|min_length[6]|max_length[200]');
			}
			else if($this->input->post("type")==2)
			{
				$this->form_validation->set_rules('message', 'Message', 'trim|required|min_length[6]|max_length[200]');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('usersadmin/add_edit_newsletter/'.$id);
				return;
			}
			if($id)
			{
				$newsletterData=$this->users_newsletters_model->newsletterData($id);

				if(empty($newsletterData))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("usersadmin/newsletters");
				}
				if($newsletterData->status!=1)
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("usersadmin/newsletters");
				}
			}
			$saved=$this->users_newsletters_model->save($id);
			
			if($saved)
			{
				if($id)
				{
					$this->session->set_flashdata("newsletter_saved",1);
				}
				else
				{
					$this->session->set_flashdata("newsletter_created",1);
				}
				if(isset($_POST['send_newsletter']))
				{
					$this->users_newsletters_model->sendNewsletter($saved);
					redirect('usersadmin/view_newsletter/'.$saved);
					return;
				}
			}
			redirect('usersadmin/add_edit_newsletter/'.$saved);
		}
		else
		{
		 	$views = array( 'users/admin/add_edit_newsletter' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['countries']=$this->users_model->getCountries();
			if($id)
			{
				$data['newsletterData']=$this->users_newsletters_model->newsletterData($id);
				if($data['newsletterData']->field_userids!='')
			 	{
			 		$data['users']=$this->users_model->getUsersByIds(explode(",",$data['newsletterData']->field_userids));
			 	}
				if(empty($data['newsletterData']))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("usersadmin/newsletters");
				}
				if($data['newsletterData']->status==2)
				{
					redirect("usersadmin/view_newsletter/".$id);
				}
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function view_newsletter($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->users_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("usersadmin/newsletters");
			}
			if($newsletterData->status!=2)
			{
				redirect("usersadmin/add_edit_newsletter/".$id);
			}
		 	$views = array('users/admin/view_newsletter');
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['countries']=$this->users_model->getCountries();
		 	if($newsletterData->field_userids!='')
		 	{
		 		$data['users']=$this->users_model->getUsersByIds(explode(",",$newsletterData->field_userids));
		 	}
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect("usersadmin/newsletters");
		}
	}
	///================================Newsletters ================================//

	public function user_form($id=0)
	{
		/*if(is_numeric($id) && $id)
		{
			$userData=$this->users_model->userData($id);
			if(empty($userData))
			{
				$id=0;
			}
		}
		else
		{
			$userData=array();
		}*/
		$data['id']=$id;
		//$data['userData']=$userData;
		$data['admin']=1;
		$data['country']=$this->locations_model->getCountries();
		echo $this->load->view("users/admin/_add_user_modal",$data,true);
	}

	public function subscribe_unsubscribe_user($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$userData=$this->users_model->userData($id);
			if(empty($userData))
			{
				goto end;
			}
			$this->users_model->updateReceiveNewslettersStatus($id, $status);
			$data['flag']=1;
			$data['username']=$userData->username;
		}
		end:
		echo json_encode($data);
	}


	public function listemails(){}
	public function email_data(){}
	public function email_resend(){}
	public function bulk_resend(){}
}
?>