<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Techsupportadmin extends CI_Controller 
{
	var $currentUser='';
	var $service="techsupport";
	var $statusArray=array(
							1=>"Open",
							2=>"Waiting Admin",
							3=>"Waiting User",
							4=>"Closed");
	var $statusResponse=array(
								1=>array('color'=>'lime',
										'info'=>"has been Approved"),
								2=>array('color'=>'ruby',
										'info'=>"has been Closed"),
								3=>array(
										'color'=>'lime',
										'info'=>"has been Re-Opened"),
								4=>array('color'=>'ruby',
										'info'=>"has been Closed"));
	var $purposeArray=array(
								1=>"Office/Billing",
								2=>"Contact",
								3=>"Abuse",
								4=>"Complaint",
								5=>"Question",
								6=>"Technical Support",
								7=>"Other"
								);
    function __construct()
    {
        parent::__construct();
		$this->load->model('techsupport/techsupport_model');
		$this->load->model('techsupport/techsupport_admin_user_replies_model');
		$this->load->model('techsupport/techsupport_standard_replies_model');
		$this->load->model('techsupport/techsupport_standard_replies_category_model');
		$this->load->model('user/users_model');
		$this->currentUser=$this->session->userdata("admin_data");
    }
	public function listusers($excel='')
	{
		$list=$this->techsupport_model->listUsersAjax($excel);
		echo json_encode($list);
	}
	
	public function index()
	{
		$views = array( 'techsupport/admin/list_messages');
		$data = array('views'=>$views,'user_data'=>array());
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listmessages($excel=0)
	{
		$list=$this->techsupport_model->listMessagesAjax(1,$excel);
		echo json_encode($list);
	}
	public function changestatus($id=0,$status=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && is_numeric($status) && $id && $status)//Is ID and status are numeric value
		{
			$result['data']=array();
			//Retrieve Blog with that ID
			$techsupportData=$this->techsupport_model->techsupportData($id);

			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Change status - Invalid ID - ".$id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			
			$currentStatus=$techsupportData->fstatus;

			$granted=$this->checkStatus($currentStatus,$status);
			if(!$granted)
			{
				$this->logaction->log($this->service,"Change status - Invalid request - ".$techsupportData->techsupport_id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}

			$flag=$this->techsupport_model->changeStatus($id,$techsupportData,$status);
			
			$result['data']=$techsupportData;
			$result['flag']=1;
			$result['message']=$this->statusResponse[$status];
			echo json_encode($result);

			$this->logaction->log($this->service,"Status changed from ".$this->statusArray[$currentStatus]." -> ".$this->statusArray[$status].
				" - ".$techsupportData->techsupport_id);
			return;
			
		}
		else
			$this->logaction->log($this->service,"Change Status - Invalid ID - ".$id);
		
		echo json_encode($result);
	}
	
	private function checkStatus($currentStatus,$newStatus)
	{
		if(in_array($currentStatus,array(1,2,3))) //Close
		{
			if($newStatus==4)
			{
				return 1;
			}
		}
		return 0;
	}

	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Admin View - Invalid ID - ".$id);
				redirect('techsupportadmin');
			}
			$repliesData=$this->techsupport_admin_user_replies_model->getReplies($id);
			$views = array( 'techsupport/admin/view');
			$data = array('views'=>$views,'techsupportData'=>$techsupportData,'id'=>$id,'repliesData'=>$repliesData);

			$this->load->view(ADMIN_TEMPLATE,$data);
			$this->techsupport_model->messageRead($id);
			$this->techsupport_model->checkIn($id);
		}
		else
		{
			$this->logaction->log($this->service,"Admin View - Invalid ID format - ".$id);
			redirect('techsupportadmin');
		}
	}
	public function checkout($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Admin Checkout - Invalid ID - ".$id);
				redirect('techsupportadmin');
			}
			
			$this->techsupport_model->checkOut($id);
			redirect('techsupportadmin');
		}
		else
		{
			$this->logaction->log($this->service,"Admin View - Invalid ID format - ".$id);
			redirect('techsupportadmin');
		}
	}

	public function checkout_close($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Admin Checkout - Invalid ID - ".$id);
				redirect('techsupportadmin');
			}
			
			$this->techsupport_model->checkOut($id);
			ob_start();
			$this->changestatus($id,4);
			$v=ob_get_clean();
			redirect('techsupportadmin');
		}
		else
		{
			$this->logaction->log($this->service,"Admin View - Invalid ID format - ".$id);
			redirect('techsupportadmin');
		}
	}
	public function techsupport_reply($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Reply page - Invalid ID - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');
			}
			if($techsupportData->fstatus!=1 || $techsupportData->user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');
			}
			if($techsupportData->checked_in==0)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');
			}

			if($this->currentUser->id!=$techsupportData->checked_in_user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');
			}

			$views = array( 'techsupport/admin/reply');
			$data = array('views'=>$views,'techsupportData'=>$techsupportData,'id'=>$id);

			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->logaction->log($this->service,"Reply - Invalid ID format - ".$id);
			redirect('techsupportadmin');
		}
	}

	public function reply_ts($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Tech Support Reply - Invalid ID - ".$id);
				goto end;
			}
			if($techsupportData->fstatus==4)
			{
				$this->logaction->log($this->service,"Tech Support Reply - Invalid Status - ".$id);
				goto end;
			}
			if($techsupportData->checked_in==0)
			{
				$this->logaction->log($this->service,"Tech Support Reply - Invalid checkin - ".$id);
				goto end;
			}

			if($this->currentUser->id!=$techsupportData->checked_in_user_id)
			{
				$this->logaction->log($this->service,"Tech Support Reply - Not checkedin user - ".$id);
				goto end;
			}

			$this->form_validation->set_rules('reply', 'Reply', 'trim|max_length[10000]');
			if($this->form_validation->run() == FALSE)
			{
				goto end;
			}

			$data['date']=$this->techsupport_admin_user_replies_model->captureReply($id,$_POST['reply'],$techsupportData,1);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}
	
	public function reply_mail($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Reply page - Invalid ID - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');
			}
			if($techsupportData->fstatus!=1 || $techsupportData->user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');	
			}

			if($techsupportData->checked_in==0)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid checkedin - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');
			}

			if($this->currentUser->id!=$techsupportData->checked_in_user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid not checkedin user - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin');
			}

			if(!isset($_POST['content']))
			{
				$this->session->set_flashdata("techsupport_error",1);
				redirect('techsupportadmin/techsupport_reply/'.$id);
			}
			// $this->form_validation->set_rules('subject', 'Subject', 'trim|min_length[6]|max_length[200]');
			// if($this->form_validation->run() == FALSE)
			// {
			// 	$this->session->set_flashdata("techsupport_error",1);
			// 	redirect('techsupportadmin/techsupport_reply/'.$id);
			// }

			if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
			{
				if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
				{
					$this->session->set_flashdata("techsupport_error",1);
					redirect('techsupportadmin/techsupport_reply/'.$id);
				}
			}
			if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
			{
				if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
				{
					$this->session->set_flashdata("techsupport_error",1);
					redirect('techsupportadmin/techsupport_reply/'.$id);
				}
			}
			if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
			{
				if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
				{
					$this->session->set_flashdata("techsupport_error",1);
					redirect('techsupportadmin/techsupport_reply/'.$id);
				}
			}

			$res=$this->techsupport_admin_user_replies_model->captureMailReply($id,$techsupportData, site_name_string1." -  Update to TechSupport request: ".$techsupportData->techsupport_id,$_POST['content']);
			$this->session->set_flashdata("email_sent",1);
			redirect("techsupportadmin/view/".$id);
		}
		else
		{
			$this->logaction->log($this->service,"Reply - Invalid ID format - ".$id);
			redirect('techsupportadmin');
		}
	}

	public function send_to($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"TechSupport Reply - Invalid ID - ".$id);
				goto end;
			}
			
			$this->form_validation->set_rules('send_to', 'Email ID', 'trim|min_length[6]|max_length[100]|valid_email_custom');
			if($this->form_validation->run() == FALSE)
			{
				goto end;
			}

			$this->techsupport_model->sendTo($id,$_POST['send_to'],$techsupportData);
			$data['flag']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($data);
	}

	public function attachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			$filename = $techsupportData->file;
			if($no==2)
				$filename = $techsupportData->file2;
			if($no==3)
				$filename = $techsupportData->file3;
			$amazonUri="support/".date("Y",strtotime($techsupportData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function replyattachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$replyData=$this->techsupport_admin_user_replies_model->replyData($id);
			if(empty($replyData))
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			$filename = $replyData->file;
			if($no==2)
				$filename = $replyData->file2;
			if($no==3)
				$filename = $replyData->file3;
			$amazonUri="support_replies/".date("Y",strtotime($replyData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function uploadthreadattachments($id=0)
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				goto end;
			}
			if(empty($_FILES['file1']) && empty($_FILES['file2']) && empty($_FILES['file3']))
			{
				goto end;
			}
			if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
			{
				if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
			{
				if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
			{
				if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
					goto end;
			}
			$uploaded = $this->techsupport_model->uploadthreadattachments($id);
			if($uploaded == 1)
			{
				$this->session->set_flashdata("upload_success",1);
			}
			else
			{
				$this->session->set_flashdata("upload_error",1);
			}
			redirect('techsupportadmin/view/'.$id);
			return;
		}
		end:
		if($flag==0)
		{
			$this->session->set_flashdata("upload_error",1);
			redirect('techsupportadmin/view/'.$id);
		}
	}

	public function createticket()
	{
		$views = array( 'techsupport/admin/add_edit_techsupport');
		$data = array('views'=>$views);
		$countries=$this->locations_model->getCountries();
        $data["country"]=$countries;
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function standardreplies()
	{
		$views = array( 'techsupport/admin/standardreplieslist');
		$data = array('views'=>$views);
		$data['categories']=$this->techsupport_standard_replies_category_model->getCategories();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function liststandardreplies($excel=0)
	{
		$list=$this->techsupport_standard_replies_model->listStandardRepliesAjaxAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Standard Replies listing ajax request");
	}

	public function add_edit_standardreply($id=0)
	{
		if(isset($_POST["add_standardreply"]))
		{	
			$this->form_validation->set_rules('standardreply', 'Standard Reply', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('answer', 'Answer', 'trim|required|min_length[10]|max_length[5000]');
			$this->form_validation->set_rules('standardreply_category', 'Standard Reply Category', 'trim|required|checkStandardReplyCategory');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("standardreply_error",1);
				redirect('techsupportadmin/add_edit_standardreply/'.$id);
				return;
			}
			if($id)
			{
				$standardreplyData=$this->techsupport_standard_replies_model->standardreplyData($id);
				if(empty($standardreplyData))
				{
					$this->session->set_flashdata("standardreply_error",1);
					redirect("/techsupportadmin");
				}
			}

			$saved=$this->techsupport_standard_replies_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("standardreply_saved",1);
				else
				{
					$this->session->set_flashdata("standardreply_created",1);
				}
			}
			redirect('techsupportadmin/add_edit_standardreply/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'techsupport/admin/add_edit_standardreply' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['categories']=$this->techsupport_standard_replies_category_model->getCategories();
			if($id)
			{
				$data['standardreply_data']=$this->techsupport_standard_replies_model->standardreplyData($id);
				if(empty($data['standardreply_data']))
				{
					$this->session->set_flashdata("standardreply_error",1);
					redirect("/techsupportadmin");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function deletestandardreply($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$standardreplyData=$this->techsupport_standard_replies_model->standardreplyData($id);
			if(!empty($standardreplyData))
			{
				$r=$this->techsupport_standard_replies_model->delete($id,$standardreplyData);
				if($r)
				{
					$data['flag']=1;
					$data['id']=$standardreplyData->fid;
				}
			}
		}
		echo json_encode($data);
	}

	public function standardreplycategories()
	{
		$views = array( 'techsupport/admin/standardreplycategorieslist' );
		$data = array('views'=>$views);
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function liststandardreplycategories($excel=0)
	{
		$list=$this->techsupport_standard_replies_category_model->listCatsAjaxAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Standard Reply Categories listing ajax request");
		
	}

	public function add_edit_standardreply_category($id=0)
	{
		if(isset($_POST["add_standardreplycat"]))
		{	
			$this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[3]|max_length[20]|checkStandardReplyCategoryExist['.$id.']');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("standardreplycat_error",1);
				redirect('techsupportadmin/add_edit_standardreply_category/'.$id);
				return;
			}
			if($id)
			{
				$catData=$this->techsupport_standard_replies_category_model->catData($id);
				if(empty($catData))
				{
					$this->session->set_flashdata("standardreplycat_error",1);
					redirect("/techsupportadmin/standardreplycategories");
				}
			}

			$saved=$this->techsupport_standard_replies_category_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("category_saved",1);
				else
				{
					$this->session->set_flashdata("category_created",1);
				}
			}
			redirect('techsupportadmin/add_edit_standardreply_category/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'techsupport/admin/add_edit_standardreply_category' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['cat_data']=$this->techsupport_standard_replies_category_model->catData($id);
				if(empty($data['cat_data']))
				{
					$this->session->set_flashdata("standardreplycat_error",1);
					redirect("/techsupportadmin/standardreplycategories");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);  
		}
	}

	public function updatestandardreplycategoryorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|checkStandardReplyCategory');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->techsupport_standard_replies_category_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	
	function deletestandardreplycategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->techsupport_standard_replies_category_model->catData($id);
			if(!empty($catData))
			{
				$standardreplies=$this->techsupport_standard_replies_model->getStandardRepliesByCategory($id);
				if(empty($standardreplies))
				{
					$r=$this->techsupport_standard_replies_category_model->delete($id,$catData);
					if($r)
					{
						$data['flag']=1;
						$data['category']=$catData->category;
					}
				}
				else
				{
					$data['flag']=2;
					$data['category']=$catData->category;
				}
			}
		}
		echo json_encode($data);
	}

	public function standardreplycategory_check()
	{
		$exist=$this->techsupport_standard_replies_category_model->standardreplycat_exist($_POST['id'],$_POST['category']);
		if($exist) echo 0;
		else echo 1;
	}

	public function listemails(){}
	public function email_data(){}
	public function email_resend(){}
	public function bulk_resend(){}
}
?>