<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Techsupport extends CI_Controller
{
    function __construct() 
	{
        parent::__construct();
        if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");
    }

    public function index()
    {
    	$data['views'] = array('techsupport/public/add_edit_techsupport');
        $countries=$this->locations_model->getCountries();
        $data["country"]=$countries;
		$this->load->view(FRONTEND_TEMPLATE,$data);
    }

    public function attachment($key="", $id=0, $no="")
    {
        if($key =='' || $key == 'NULL')
        {
           goto end;
        }
        $this->load->model('techsupport/techsupport_model');
        $flag=0;
        if( (is_numeric($id) && $id) && ($key!='' && $key!='NULL') )
        {
            $techsupportData = $this->techsupport_model->techsupportData($id);
            if(empty($techsupportData))
            {
                goto end;
            }
            if($techsupportData->support_key != $key)
            {
                goto end;
            }
            $this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
            $filename = $techsupportData->file;
            if($no==2)
                $filename = $techsupportData->file2;
            if($no==3)
                $filename = $techsupportData->file3;
            $amazonUri="support/".date("Y",strtotime($techsupportData->date))."/".$filename;
            header("Cache-Control: public");
            header("Content-Disposition: attachment; filename=".$filename);
            $obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
            echo $obj->body;
            return;
        }
        end:
        if($flag==0)
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }

    public function replyattachment($key="",$id=0,$no="")
    {
        if($key =='' || $key == 'NULL')
        {
           goto end;
        }
        $this->load->model('techsupport/techsupport_model');
        $this->load->model('techsupport/techsupport_admin_user_replies_model');
        $flag=0;
        if( (is_numeric($id) && $id) && ($key!='' && $key!='NULL') )
        {
            $replyData=$this->techsupport_admin_user_replies_model->replyData($id);
            if(empty($replyData))
            {
                goto end;
            }
            $techsupportData = $this->techsupport_model->techsupportData($replyData->techsupport_id);
            if(empty($techsupportData))
            {
                goto end;
            }
            if($techsupportData->support_key != $key)
            {
                goto end;
            }
            $this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
            $filename = $replyData->file;
            if($no==2)
                $filename = $replyData->file2;
            if($no==3)
                $filename = $replyData->file3;
            $amazonUri="support_replies/".date("Y",strtotime($replyData->date))."/".$filename;
            header("Cache-Control: public");
            header("Content-Disposition: attachment; filename=".$filename);
            $obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
            echo $obj->body;
            return;
        }
        end:
        if($flag==0)
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }

    public function capture()
    {
        $data['flag']=0;
        if($GLOBALS['site_settings']['techsupport_enable']==0)
        {
            $data['flag']=2;
            goto end;
        }
        if($GLOBALS['site_settings']['techsupport_enable']==1)
        {
            $this->load->model('techsupport/techsupport_model');
            if(isset($GLOBALS['site_settings']['banned_emails_contact_techsupport']) && ($GLOBALS['site_settings']['banned_emails_contact_techsupport']!=''))
            {
                $banned_emails=array_filter(explode(",",$GLOBALS['site_settings']['banned_emails_contact_techsupport']));
                if(!empty($banned_emails) && in_array($this->input->post("support_email"),$banned_emails))
                {
                    goto success;
                }
            }
            if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
            {
                if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
                    goto end;
            }
            if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
            {
                if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
                    goto end;
            }
            if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
            {
                if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
                    goto end;
            }
            if(!$this->session->userdata('loggedIn'))
            {
                $this->form_validation->set_rules('support_name', 'Name', 'trim|required|min_length[3]|max_length[100]');
                $this->form_validation->set_rules('support_email', 'Email ID', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
            }
            $this->form_validation->set_rules('support_phone', 'Phone', 'trim|required|undefinedCheckforPhone|min_length[8]|max_length[20]');
            $this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|checkTechsupportPurpose');
            $this->form_validation->set_rules('support_msg', 'Message', 'trim|required|strip_tags|max_length[12000]');
            $this->form_validation->set_rules('country_code', 'Country', 'trim|required|countryCheck');

            if($this->form_validation->run() == FALSE)
            {
                $data['msg']="Something wrong, please refresh the page and try again.";
                $data['error_data']=validation_errors();
                echo json_encode($data);
                return;
            }
            if(!empty($this->currentUser) && $this->currentUser->admin == 1)
            {
                if($_POST["support_email"] != $this->currentUser->email)
                {
                    $this->form_validation->set_rules('support_user_id', 'Support User', 'trim|required');
                    if($_POST["support_user_name"] == "undefined")
                    {
                        $data['msg']="Something wrong, please refresh the page and try again.";
                        $data['error_data']="Please select user";
                        echo json_encode($data);
                        return;
                    }
                }
            }
            $this->techsupport_model->post($_POST);
            success:
            {
                $data['flag']=1;
            }
            $this->session->set_flashdata("ticket_captured",1);
        }
        end:
        echo json_encode($data);
    }
}
?>