<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH. '/third_party/stripe_package/init.php';
class Stripe extends CI_Controller 
{
	var $currentUser='';
	var $service="payments";
	var $user_type = "";
	private $Module = "";
	var $newCardTypes = array();
	function __construct()
	{
		parent::__construct();
		$this->load->model('payment_model');
		$this->load->model('orders/orders_model');
		//Model Added by Baji To save subscription ids
		$this->load->model('stripe_subscriptions_model','stripesubscriptions');
		$this->load->model('orders/subscription_payments_model');
		$this->load->model('stripe_logs_model','stripelogs');
		$this->load->model('stripe_orders_sessions_model');
		$this->load->model("subscriptions/donors_model");
		//Done by Baji's newly Added models
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->model('temp_payments_model');
		$this->load->library("userutil");
		$this->load->model("temp_payments_model");
		// Helper Added By Baji
		$this->load->helper('Stripelog_helper');

		if(isset($_GET['app']))
		{
			$this->load->library("server");
	        $this->server->require_scope("user");
	        $this->load->model('currencies_model');
	        $this->load->model('oauth_sessions_model');
	        $this->oauth_sessions_model->session_check();
		}
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
			{
				$this->user_type = "admin side";
				$this->currentUser=$this->session->userdata('admin_data');
			}
			else
			{
				$this->user_type = "user side";
				$this->currentUser=$this->session->userdata('user_data');
			}
		}
		$this->Module = 'Stripe Payment';

		$this->newCardTypes=array(
								0=>"visa",
								1=>"mastercard",
								2=>"discover",
								3=>"amex",
								4=>"diners_club",
								5=>"jcb"
							);
	}

	public function checksubsc()
	{
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId(4,4);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray["inr"];

    	\Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
		$subscription = \Stripe\Subscription::retrieve("sub_JJMfZ2vd5VWJLb");
		$payment_method_data = \Stripe\PaymentMethod::retrieve($subscription->default_payment_method);
		$method_type = $payment_method_data->type;

		if($method_type == "card")
		{
			$cardObject = $payment_method_data[$method_type];
			$stripecardType = $cardObject->networks->available[0];
			$card_type = "";
			foreach($this->newCardTypes as $key=>$val)
			{
				if($val == $stripecardType)
				{
					$card_type = $key;
					break;
				}
			}
			$method_data = array("payment_method_id"=>$payment_method_data->id,"customer_id"=>$payment_method_data->customer,"exp_year"=>$cardObject->exp_year,"exp_month"=>$cardObject->exp_month,"user_id"=>$user_id,"card_type"=>$card_type,"card_last4_digits"=>$cardObject->last4,"subscription_id"=>$subscription_id,"created_on"=>date("Y-m-d H:i:s"),"card_exp_date"=>$cardObject->exp_month."/".$cardObject->exp_year);
			$this->stripe_orders_sessions_model->saveCardDetails($method_data);
		}
		
		echo "<pre>";
		print_r($subscription);
		exit();
	}
	
	public function capture()
	{
		$apiReturn['flag']=0;
		$session_id = $_GET["session_id"];
		$isTranresponseUpdate = false;
		//Get stripe_orders_sessions data from session id
		$tempOrderData = $this->stripe_orders_sessions_model->getTempInfo($session_id);

		//Set user id, user name, email and user type
		$stripelog['user_id'] 	= $this->currentUser->id;
		$stripelog['user_name'] = $this->currentUser->username;
		$stripelog['email'] 	= $this->currentUser->email;
		$stripelog['user_type'] = $this->user_type;
		
		// If empty of order data or empty of session id then redirect to subscription page
		if(!empty($tempOrderData) && !empty($session_id))
		{
			// Get order data
			$customData=unserialize($tempOrderData->order_data);
			//Get trust data
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	//Trust data based on currency
	    	$trustData=$trustsArray[$tempOrderData->currency];

	    	// Get stripe checkout session details by session id

	    	\Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
			try 
			{ 
	            $checkout_session = \Stripe\Checkout\Session::retrieve($session_id);
	        }
	        catch(Exception $e) 
	        {  
	            $api_error = $e->getMessage();  
	        }
	        // Get temp payment info by reference id
	        $tempInfo=$this->payment_model->getTempInfo($checkout_session->client_reference_id);
	        $sub =0;
	        if(empty($api_error) && $checkout_session && !empty($tempInfo))
	        {
	        	try 
		        { 
		            // Create the PaymentIntent 
		            $customer = \Stripe\Customer::retrieve($checkout_session->customer); 
		        }
		        catch (\Stripe\Exception\ApiErrorException $e) 
		        { 
		            $api_error = $e->getMessage(); 
		        }
		        if($checkout_session->mode == "subscription")
		        {
		        	$sub =1;
		        	try 
			        { 
			            $subscription = \Stripe\Subscription::retrieve($checkout_session->subscription);
			            $invoice = \Stripe\Invoice::retrieve($subscription->latest_invoice);
			            $payment_method_data = \Stripe\PaymentMethod::retrieve($subscription->default_payment_method);
			            if(!empty($invoice->payment_intent))
			            {
			            	$intent = \Stripe\PaymentIntent::retrieve($invoice->payment_intent);
			            	$invoice_date = date("Y-m-d",$invoice->period_start);							
			            }
			            else
			            	$intent = ""; 
			        }
			        catch (\Stripe\Exception\ApiErrorException $e) 
			        { 
			            $api_error = $e->getMessage(); 
			        }
		        }
		        else
		        {
		        	try 
			        { 
			            $intent = \Stripe\PaymentIntent::retrieve($checkout_session->payment_intent); 
			        }
			        catch (\Stripe\Exception\ApiErrorException $e) 
			        { 
			            $api_error = $e->getMessage(); 
			        }
		        }
		        $orderId=0;
	    		if(isset($customData['order_id']))
	    			$orderId=$customData['order_id'];

	    		if(!empty($intent->charges->data[0]))
	    			$charge = $intent->charges->data[0];
	    		else
	    			$charge = "";

	    		if($sub == 1)
	    		{
	    			if((isset($charge) && !empty($charge) && $intent["status"] == "succeeded") || $invoice->status == "paid")
	    			{
	    				if(isset($charge) && !empty($charge) && $intent["status"] == "succeeded")
	    				{
	    					$txnid = $charge->id;
			    			$sub_amount = $charge->amount_captured/100;
			    			$transaction=new stdClass();
							$transaction->tx=$txnid;
							$tempIpn=new stdClass();
							$tempIpn->status='approved';
							$tempIpn->amount=$charge->amount_captured/100;

	    					$in_line_items = $invoice->lines->data;
	    					$onetime_sub = 1;
	    					if(!empty($in_line_items))
	    					{
	    						foreach ($in_line_items as $key => $value) 
	    						{
	    							if($value->type == "invoiceitem" && empty($value->plan))
	    							{
	    								$onetime_sub = 0;
	    								$sub_amount = $value->amount/100;
	    								$tempIpn->amount = $value->amount/100;
	    							}
	    							if($value->type == "subscription" && $value->plan != "")
	    							{
	    								$r_sub_amount = $value->amount/100;
	    							}
	    						}
	    					}
	    					if($onetime_sub == 1)
	    					{
	    						$sub_amount = 0;
	    						$tempIpn->amount = 0;
	    					}
	    					if($r_sub_amount == 0)
	    					{
	    						$tData = $this->payment_model->createTransaction($txnid,$tempOrderData->user_id,$tempOrderData->temp_reference_id,'approved',null,$orderId);
					    		$tData = $this->payment_model->tempInfoUpdateTx($tempOrderData->temp_reference_id,$txnid,$sub_amount,$tData);
					    		$tData['t_status'] = 1;
					    		$tData['modified_on'] = date("Y:m:d H:i:s");
								//saving transaction table 
								$this->payment_model->saveTransaction($tData);
								//$this->payment_model->updateStripeTransaction($txnid,$charge);
								//saving payment response into archives database
								$this->payment_model->savingPaymentResponse($txnid,$charge,$tempOrderData->user_id,"stripe",$orderId);
								$isTranresponseUpdate = true;
	    					}
	    				}
	    				else if(empty($intent) && $invoice->status == "paid")
	    				{
	    					$txnid = "str".date("YmdHisu").rand(1,6);
			    			$sub_amount = 0;
							$tData = $this->payment_model->createTransaction($txnid,$tempOrderData->user_id,$tempOrderData->temp_reference_id,'approved',null,$orderId);
				    		$tData = $this->payment_model->tempInfoUpdateTx($tempOrderData->temp_reference_id,$txnid,$sub_amount,$tData);
							$tData['t_status'] = 1;
					    	$tData['modified_on'] = date("Y:m:d H:i:s");
							//saving transaction table 
							$this->payment_model->saveTransaction($tData);
				    		//$this->payment_model->updateStripeTransaction($txnid,$invoice);
							//saving payment response into archives database
							$this->payment_model->savingPaymentResponse($txnid,$charge,$tempOrderData->user_id,"stripe",$orderId);
							$isTranresponseUpdate = true;
				    		$transaction=new stdClass();
							$transaction->tx=$txnid;
							$tempIpn=new stdClass();
							$tempIpn->status='approved';
							$tempIpn->amount=0;
	    				}
						
						if(isset($customData['cartData']))
						{
							//saving payment response into archives database
							if(!$isTranresponseUpdate)
								$this->payment_model->savingPaymentResponse($transaction->tx,$charge,$tempOrderData->user_id,"stripe");
							$orderId = $this->payment_model->processPurchase($tempOrderData->temp_reference_id,$transaction,$tempInfo,$tempIpn);

							//subscription_payments change payment date

							$this->stripe_orders_sessions_model->getTempInfo($session_id,1);
							if($this->currentUser->roles == 2)
							{
								$r_url = base_url."myorders/view/".$orderId;
							}
							else
							{
								$r_url = base_url."orders/view/".$orderId;
							}
							$method_type = $payment_method_data->type;

							if($method_type == "card")
							{
								$cardObject = $payment_method_data[$method_type];
								$stripecardType = $cardObject->networks->available[0];
								$card_type = "";
								foreach($this->newCardTypes as $key=>$val)
								{
									if($val == $stripecardType)
									{
										$card_type = $key;
										break;
									}
								}
								$method_data = array("payment_method_type"=>$method_type,"payment_method_id"=>$payment_method_data->id,"customer_id"=>$payment_method_data->customer,"exp_year"=>$cardObject->exp_year,"exp_month"=>$cardObject->exp_month,"user_id"=>$tempOrderData->user_id,"card_type"=>$card_type,"card_last4_digits"=>$cardObject->last4,"subscription_id"=>$subscription->id,"created_on"=>date("Y-m-d H:i:s"),"card_exp_date"=>$cardObject->exp_month."/".$cardObject->exp_year,"order_id"=>$orderId);
								$this->stripe_orders_sessions_model->saveCardDetails($method_data);
							}

							$orderData=$this->orders_model->orderData($orderId);

							foreach ($orderData['order_items'] as $original_itemData)
							{
								if($orderData['order']->order_type==4 && $original_itemData->subscription==1)
								{
									$original_transactionAmounts[]=array( "itemData"=>$original_itemData );
								}
							}
							foreach ($original_transactionAmounts as $original_transactionDetail)
							{
								$this->stripesubscriptions->updateOrderItemSubscription($original_transactionDetail['itemData']->order_item_id,$subscription->id,$original_transactionDetail['itemData']);
								$subInsertData = array("order_id"=>$orderId,"order_item_id"=>$original_transactionDetail['itemData']->order_item_id,"ashram_id"=>$orderData['order']->ashram_id,"customer_id"=>$checkout_session->customer,"stripe_subscription_id"=>$subscription->id,"total_payments_count"=>$original_transactionDetail['itemData']->num_of_payments,"completed_payments_count"=>0,"status"=>"Satrted/Activated","payment_and_subscription_info"=>$subscription,"item_id"=>$original_transactionDetail['itemData']->item_id,"user_id"=>$orderData['order']->user_id,"plan_id"=>$subscription->plan->id,"currency"=>$tempOrderData->currency,"amount"=>$tempOrderData->amount,"created_on"=>date("Y-m-d H:i:s"));
								$this->stripesubscriptions->insert($subInsertData);
							}

							$actiondata = array('log_event'=>'This is only one time charge  not reccuring donation (user completed)','module'=>$this->Module,'order_id'=>$orderId);
							stripelog($actiondata,$stripelog);

							if($orderData['order']->order_type!=4)
		                    {
		                    	$this->order_log_model->log($orderId,
								"Paid amount: ".strtoupper($tempOrderData->currency)." ".$tempOrderData->amount."\nStripe\nTx ID:".$txnid);
		                    	$this->orders_model->sendTransactionReceiptEmail($orderId,$transaction->tx);
		                    }
		                    else
		                    {
		                    	if($orderData['order']->order_type!=4)
		                			$this->order_log_model->log($orderId,"One time payment item(s) charged.");
		                		else
		                		{
		                			if(!empty($onetime_sub) && $onetime_sub == 1)
		                				$this->order_log_model->log($orderId,"Subscription One time payment charged.");
		                		}
		                		$this->orders_model->calculateDue($orderId);
		                    }
		                    if($invoice->status == "paid" && $r_sub_amount > 0)
		                    {
		                    	$this->updateFirstSubPayment($invoice,$subscription,$intent,$orderData,$r_sub_amount,$checkout_session,$txnid);
		                    }
		                    $this->session->set_flashdata("order_placed",1);
		                    if($customData['cart_type']==1)
		                    {
		                    	$this->session->unset_userdata("poojas_temp_reference");
		                        $this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("poojasCartAshramId"),$customData['cart_type']);
		                    }
		                    if($customData['cart_type']==2)
		                    {
		                    	$this->session->unset_userdata("donations_temp_reference");
		                    	$this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("donationCartAshramId"),$customData['cart_type']);
		                    }
		                    if($customData['cart_type']==4)
		                    {
		                    	$this->session->unset_userdata("subscriptions_temp_reference");
		                    	$this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("subscriptionCartAshramId"),$customData['cart_type']);
		                    }
		                    if($customData['cart_type']==3)
		                    {
		                    	$this->session->unset_userdata("store_items_temp_reference");
		                        $this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("storeCartAshramId"),$customData['cart_type']);
		                    }
						}
						else
						{
							//Calculate  order due
							$this->orders_model->calculateDue($orderId);
							//Update order total paid amount
							$this->payment_model->updateOrderTotalPaid($orderId,$tempOrderData->amount,$txnid);
							$this->order_log_model->log($orderId,"Paid amount: ".strtoupper($tempOrderData->currency)." ".$tempOrderData->amount."\nStripe\nTx ID:".$txnid);
							$this->session->set_flashdata("order_placed",1);
		                    $this->session->set_userdata("payment_success","Payment processed successfully.");
						}
						// Get Transaction details and redirect to success/cancel url
						$transactionRecord=$this->payment_model->getTransaction($txnid);
						if(isset($customData['cartData']))
						{
							if(empty($transactionRecord->redirect_url))
							{
								redirect($r_url);
							}
							else
							{
								redirect($transactionRecord->redirect_url);
							}
						}
						else
							redirect($checkout_session->cancel_url);
	    			}
	    		}
	    		else
	    		{
	    			if(isset($charge) && !empty($charge) && $intent["status"] == "succeeded")
		    		{
		    			$txnid = $charge->id;
						$tData = $this->payment_model->createTransaction($txnid,$tempOrderData->user_id,$tempOrderData->temp_reference_id,'approved',null,$orderId);
			    		$tData = $this->payment_model->tempInfoUpdateTx($tempOrderData->temp_reference_id,$txnid,$tempOrderData->amount,$tData);
						$tData['t_status'] = 1;
					    $tData['modified_on'] = date("Y:m:d H:i:s");
						//saving transaction table 
						$this->payment_model->saveTransaction($tData);
						//saving payment response into archives database
						$this->payment_model->savingPaymentResponse($txnid,$charge,$tempOrderData->user_id,"stripe",$orderId);
						$isTranresponseUpdate = true;
			    		//$this->payment_model->updateStripeTransaction($txnid,$charge);

			    		$transaction=new stdClass();
						$transaction->tx=$txnid;
						$tempIpn=new stdClass();
						$tempIpn->status='approved';
						$tempIpn->amount=$charge->amount_captured/100;
						
						if(isset($customData['cartData']))
						{
							$orderId = $this->payment_model->processPurchase($tempOrderData->temp_reference_id,$transaction,$tempInfo,$tempIpn);
							if($this->currentUser->roles == 2)
							{
								$r_url = base_url."myorders/view/".$orderId;
							}
							else
							{
								$r_url = base_url."orders/view/".$orderId;
							}
							$transactionRecord=$this->payment_model->getTransaction($txnid);

							$orderData=$this->orders_model->orderData($orderId);

							$actiondata = array('log_event'=>'This is only one time charge  not reccuring donation (user completed)','module'=>$this->Module,'order_id'=>$orderId);
							stripelog($actiondata,$stripelog);

							if($orderData['order']->order_type!=4)
		                    {
		                    	$this->order_log_model->log($orderId,
								"Paid amount: ".strtoupper($tempOrderData->currency)." ".$tempOrderData->amount."\nStripe\nTx ID:".$txnid);
		                    	$this->orders_model->sendTransactionReceiptEmail($orderId,$transaction->tx);
		                    }
		                    else
		                    {
		                    	if($orderData['order']->order_type!=4)
		                			$this->order_log_model->log($orderId,"One time payment item(s) charged.");
		                		else
		                			$this->order_log_model->log($orderId,"Subscription One time payment charged.");
		                		$this->orders_model->calculateDue($orderId);
		                    }
		                    $this->session->set_flashdata("order_placed",1);
		                    if($customData['cart_type']==1)
		                    {
		                    	$this->session->unset_userdata("poojas_temp_reference");
		                        $this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("poojasCartAshramId"),$customData['cart_type']);
		                    }
		                    if($customData['cart_type']==2)
		                    {
		                    	$this->session->unset_userdata("donations_temp_reference");
		                    	$this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("donationCartAshramId"),$customData['cart_type']);
		                    }
		                    if($customData['cart_type']==4)
		                    {
		                    	$this->session->unset_userdata("subscriptions_temp_reference");
		                    	$this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("subscriptionCartAshramId"),$customData['cart_type']);
		                    }
		                    if($customData['cart_type']==3)
		                    {
		                    	$this->session->unset_userdata("store_items_temp_reference");
		                        $this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("storeCartAshramId"),$customData['cart_type']);
		                    }
						}
						else
						{
							$this->orders_model->calculateDue($orderId);
							$this->order_log_model->log($orderId,"Paid amount: ".strtoupper($tempOrderData->currency)." ".$tempOrderData->amount."\nStripe\nTx ID:".$txnid);
							$this->session->set_flashdata("order_placed",1);
							$this->payment_model->updateOrderTotalPaid($orderId,$tempOrderData->amount,$txnid);
		                    $this->session->set_userdata("payment_success","Payment processed successfully.");
						}
						$this->stripe_orders_sessions_model->getTempInfo($session_id,1);
						
						if(isset($customData['cartData']))
						{
							if(empty($transactionRecord->redirect_url))
							{
								redirect($r_url);
							}
							else
							{
								redirect($transactionRecord->redirect_url);
							}
						}
						else
							redirect($checkout_session->cancel_url);
		    		}
	    		}
		    }
	    }
	    else
	    {
	    	redirect(base_url."subscriptions");
	    }
	}

	public function updateFirstSubPayment($invoice,$subscription,$payment_intent,$orderData,$r_sub_amount,$checkout_session,$txnid)
	{
		$query = $this->stripesubscriptions->getSubscription($subscription->id);
		if($query->num_rows() > 0)
		{
			$data = array('log_event'=>'this is in hook now in num rows'.$subscription->id. ' and customer is '.$checkout_session->customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

			$this->stripelogs->savelogs($data);

			$invoice_date = date("Y-m-d",$invoice->created);

			$query1 = $this->stripesubscriptions->getSubPaymentNumber($query->result()[0]->order_item_id,$invoice_date);

			if($query1->num_rows() > 0 && empty($query->result()[0]->tx))
			{
				$completed_count = $query->result()[0]->completed_payments_count;
				$completed_count = isset($completed_count) ? $completed_count : 0;
				$total_count = $query->result()[0]->total_payments_count;

				if($completed_count != $total_count && $total_count >= $completed_count)
				{
					$data = array('log_event'=>'this is in hook now in satisfying'.$subscription->id. ' and customer is '.$checkout_session->customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

					$this->stripelogs->savelogs($data);
					$updateData = array('completed_payments_count'=>$completed_count+1);
					$itemData=$this->orders_model->itemData($query->result()[0]->order_item_id);
					if($itemData->pay_till_cancel == 1)
					{
						$this->load->model("orders/subscription_payments_model");
						$paymentRow = $this->subscription_payments_model->getPrevRow($query->result()[0]->order_item_id);
						$start = strtotime($itemData->schedule_dates);
						$start=strtotime("+".$itemData->frequency." ".$itemData->period,$start);
						$this->createduplicateRecord($paymentRow,$itemData,$query->result()[0]->order_item_id,$itemData->order_id,$start);
					}
					$accuratecount = $completed_count+1;
					$this->stripesubscriptions->updatesubscriptions($query1->result()[0]->payment_number,$txnid,$query->result()[0]->order_item_id,$r_sub_amount,$orderData['order']->currency,$subscription->id,$payment_intent);
					// Developer Note - After order is created Update order with total_paid, transaction_ids at runtime
					$this->payment_model->updateOrderTotalPaid($orderData['order']->id,$r_sub_amount,$txnid);
					$this->stripesubscriptions->updateStripesubId($updateData,$subscription->id);
				}
				else
				{
					$orderData=$this->orders_model->orderData($query->result()[0]->order_id);

					$trustData = $this->getStripeTrustDetails($orderData['order']->ashram_id,$orderData['order']->currency,$orderData['order']->order_type);

					\Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
					$subscription = \Stripe\Subscription::retrieve($subscription->id);
					$subscription->cancel();

					$updateData = array('status'=>'Completed','completed_on'=>date('Y-m-d'));
					$this->stripesubscriptions->updateStripesubId($updateData,$subscription->id);
				}
			}
		}
	}
	
	public function createduplicateRecord($subData,$itemData,$itemId,$orderId,$paymentDate)
	{
		$this->load->model("stripe_webhook_model");
		$paymentnumber = $subData->payment_number+1;
		$dataArray = array(
            "order_item_id"=>$itemId,
            "order_id"=>$orderId,
            "payment_date"=>date("Y:m:d",$paymentDate),
            "amount"=>$itemData->price,
            "payment_number"=>$paymentnumber,
            "created_on"=>date("Y:m:d H:i:s")
        );
        $this->stripe_webhook_model->createSubRow($dataArray);
        $this->stripe_webhook_model->updateNumPayments($itemId,$paymentnumber);
	}

	public function changeCustomerCreditCard()
	{
		$apiReturn['flag']=0;
		$session_id = $_GET["session_id"];
		$paymentData = $this->stripe_orders_sessions_model->getPaymentDetails($session_id);
		if(empty($session_id) || empty($paymentData))
		{
			$this->session->set_flashdata("card_error",1);
		    if($this->currentUser->roles != 2)
			{
				redirect(base_url.'orders/view/'.$paymentData->order_id);
			}
			else
			{
				redirect(base_url.'myorders/view/'.$paymentData->order_id);
			}
		}
		$orderData=$this->orders_model->orderData($paymentData->order_id);
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($orderData["order"]->ashram_id,$orderData["order"]->order_type);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray[strtolower($orderData["order"]->currency)];

    	\Stripe\Stripe::setApiKey($trustData->stripe_secret_key);

		try 
		{ 
            $checkout_session = \Stripe\Checkout\Session::retrieve($session_id);
        }
        catch(Exception $e) 
        {  
            $api_error = $e->getMessage();  
        }

        if(empty($api_error) && $checkout_session)
        {
        	try 
	        { 
	        	$intent = \Stripe\SetupIntent::retrieve($checkout_session->setup_intent);
	        	$payment_method_data = \Stripe\PaymentMethod::retrieve($intent->payment_method);
	            \Stripe\Customer::update(
				$checkout_session->customer,
				  	[
				    	'invoice_settings' => ['default_payment_method' => $intent->payment_method],
				  	]
				);
	        }
	        catch (\Stripe\Exception\ApiErrorException $e) 
	        { 
	            $api_error = $e->getMessage(); 
	        }
	        if(empty($api_error) && $checkout_session && !empty($intent))
        	{
        		$method_type = $payment_method_data->type;
				if($method_type == "card")
				{
					$cardObject = $payment_method_data[$method_type];
					$stripecardType = $cardObject->networks->available[0];
					$card_type = "";
					foreach($this->newCardTypes as $key=>$val)
					{
						if($val == $stripecardType)
						{
							$card_type = $key;
							break;
						}
					}
		    		$method_data = array("payment_method_id"=>$payment_method_data->id,"exp_year"=>$cardObject->exp_year,"exp_month"=>$cardObject->exp_month,"card_type"=>$card_type,"card_last4_digits"=>$cardObject->last4,"card_exp_date"=>$cardObject->exp_month."/".$cardObject->exp_year);
					$this->stripe_orders_sessions_model->updateCardDetails($method_data,$paymentData->subscription_id);
					$this->session->set_flashdata("card_updated",1);
					if($this->currentUser->roles != 2)
					{
						redirect(base_url.'orders/view/'.$paymentData->order_id);
					}
					else
					{
						redirect(base_url.'myorders/view/'.$paymentData->order_id);
					}
				}
        	}
	    }
	    $this->session->set_flashdata("card_error",1);
	    if($this->currentUser->roles != 2)
		{
			redirect(base_url.'orders/view/'.$paymentData->order_id);
		}
		else
		{
			redirect(base_url.'myorders/view/'.$paymentData->order_id);
		}
	}

	public function getStripeTrustDetails($ashramId,$currency,$orderType)
	{
		if($ashramId)
		{
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$orderType);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	$trustData=$trustsArray[$currency];
	    	return $trustData;
		}
		return false;
	}
}
?>