<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * AWS API Ref: 	https://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.prepare.html
 * SES Email Ref 	https://docs.aws.amazon.com/aws-sdk-php/v3/api/api-email-2010-12-01.html#sendemail
 * Service:			Emails
 * Class:			Snsnotifications
 * @author 			Baji Shaik <bajidotwork@gmail.com>
 * @version 		1.1 18th Feb 2021
 */

/*------------WebHook (Http) to read SNS Notifications from aws when email got triggered from dattapeetham Web/Mobile Application-----*/
class Snsnotifications extends CI_Controller 
{
    function __construct() 
	{
        parent::__construct();
        $this->load->model("emails_sns_notifications_model");

        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
    }
    function index()
	{
		$mail_content = file_get_contents("php://input");

		if(empty($mail_content))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}

		$mail_content = json_decode(file_get_contents("php://input"));
		
		if(!empty($mail_content->eventType))
			$m_eventType = strtolower($mail_content->eventType);
		else if(!empty($mail_content->notificationType))
			$m_eventType = strtolower($mail_content->notificationType);
		else if(!empty($mail_content->Type))
			$m_eventType = strtolower($mail_content->Type);
		else
			$m_eventType = "";

		if($m_eventType == "open")
		{
			//When user opens mail
			$this->emails_sns_notifications_model->eventUpdate($m_eventType,$mail_content);
		}
		else if($m_eventType == "bounce")
		{
			//When mail got bounced
			$this->emails_sns_notifications_model->eventUpdate($m_eventType,$mail_content);
			 
			$this->emails_sns_notifications_model->saveBounceEmails($mail_content);
		}
		else if($m_eventType == "delivery")
		{
			//When mail delivered
			$this->emails_sns_notifications_model->eventUpdate($m_eventType,$mail_content);
		}
		else if($m_eventType == "subscriptionconfirmation")
		{
			//RESPOND TO SUBSCRIPTION NOTIFICATION BY CALLING THE URL
			$curl_handle=curl_init();
			curl_setopt($curl_handle,CURLOPT_URL,$mail_content->SubscribeURL);
			curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,10);
			curl_exec($curl_handle);
			curl_close($curl_handle);	
		}
		else
		{
			$this->emails_sns_notifications_model->eventUpdate($m_eventType,$mail_content);
		}
		$this->emails_sns_notifications_model->saveNotifications($mail_content);
	}
}
?>