<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Shukavana extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
			$this->currentUser=$this->session->userdata("user_data");
		$this->load->model('shukavana/shukavana_model', 'shukavana');
	}
	
	public function voting()
	{
		if($GLOBALS['site_settings']['shukavana_voting_enable']==0)
        {
        	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
        }
		if($_POST)
		{
			$langUrl = "";
			if(isset($_GET['lang']) && $_GET['lang']!='')
			{
				$langUrl = "?lang=".$_GET['lang'];
			}
			$emailExists = 0;
			$emailExists = $this->shukavana->verifyEmail($_POST['user_email']);
			if($emailExists)
			{
				$this->session->set_flashdata('error_message','Sorry, you have already voted');
				redirect(base_url('shukavana/voting'.$langUrl));
				exit;
			}
			$_POST['created_on'] = date('Y-m-d H:i:s');	
			$this->shukavana->save($_POST);
			$this->session->set_flashdata('message','Thank you for your vote');
			redirect(base_url('shukavana/voting'.$langUrl));
		} 
		else 
		{
			$countries=$this->locations_model->getCountries();
			$data["country"]=$countries;
			
			$this->load->config('shukavana-english');
			// if(!isset($_GET['lang']) || $_GET['lang']=='en')
			// 	$this->load->config('shukavana-english');
			// else if($_GET['lang']=='kn')
			// 	$this->load->config('shukavana-kannada');
			// else 
			// 	$this->load->config('shukavana-telugu');

			$data['pets'] = $this->config->item('pets');
			
			$data['views'] = array('shukavana/voting');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function results()
	{
		$this->shukavana->runqueries();
		$usersresult = $this->shukavana->getusersvoting();
		$totalresult = $this->shukavana->getpetranks();
		$rankcountresults = $this->shukavana->gettopvotingbirds();
		$data['petvotingresults'] = $totalresult;
		$data['rankcountresults'] = $rankcountresults;
		$data['usersresult'] = $usersresult;
		$this->load->view('shukavana/results',$data);
	}

	public function checkemail(){
		if(isset($_POST['email']) && trim($_POST['email'])!='')
        {
			$flag = $this->shukavana->verifyEmail($_POST['email']);
			echo $flag;
        }
        else
            echo "false";

	}

	public function array_orderby() {
	    $args = func_get_args();
	    $data = array_shift($args);
	    foreach ($args as $n => $field) {
	        if (is_string($field)) {
	            $tmp = array();
	            foreach ($data as $key => $row)
	                $tmp[$key] = $row[$field];
	            $args[$n] = $tmp;
	            }
	    }
	    $args[] = &$data;
	    call_user_func_array('array_multisort', $args);
	    return array_pop($args);
	}
}
?>