<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Registrationadmin extends CI_Controller 
{
	var $service='content';
	var $currentUser='';
    function __construct() 
    {
    	parent::__construct();
		$this->load->model("registrations/register_model");
       	$this->load->model("registrations/register_categories_model");
       	$this->load->model("currencies_model");
		$this->currentUser=$this->session->userdata("admin_data");
    }
	public function index()
	{
		$views = array( 'registrations/admin/list');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	
	public function categories()
	{
		$views = array( 'registrations/admin/list_categories' );
		$data = array('views'=>$views);
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listc($excel=0)
	{
		$list=$this->register_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Registrations listing ajax request");
		
	}
	public function listcats($excel=0)
	{
		$list=$this->register_categories_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Registration Categories listing ajax request");
		
	}

	public function view($id=0)
	{
	 	$views = array( 'registrations/admin/view' );
	 	$data = array('views'=>$views,'id'=>$id);
		if($id)
		{
			$data['registerData']=$this->register_model->registerData($id);
			if(empty($data['registerData']))
			{
				$this->session->set_flashdata("register_error",1);
				redirect("/registrationadmin");
			}
		}
		else
		{
			$this->session->set_flashdata("register_error",1);
			redirect("/registrationadmin");
		}
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function add_edit_category($id=0)
	{
		if(isset($_POST["add_cat"]))
		{	
			$this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[3]|max_length[50]|checkRegistrationCategoryExist['.$id.']');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('registrationadmin/add_edit_category/'.$id);
				return;
			}
			if($id)
			{
				$catData=$this->register_categories_model->catData($id);
				if(empty($catData))
				{
					$this->session->set_flashdata("cat_error",1);
					redirect("/registrationadmin/categories");
				}
			}


			$saved=$this->register_categories_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("category_saved",1);
				else
				{
					$this->session->set_flashdata("category_created",1);
				}
			}
			redirect('registrationadmin/add_edit_category/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'registrations/admin/add_edit_category' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['cat_data']=$this->register_categories_model->catData($id);
				if(empty($data['cat_data']))
				{
					$this->session->set_flashdata("cat_error",1);
					redirect("/registrationadmin/categories");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);  
		}
	}

	function deletecategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->register_categories_model->catData($id);
			if(!empty($catData))
			{
				$registrations=$this->register_model->getRegistrationsByCategory($id);
				if(empty($registrations))
				{
					$r=$this->register_categories_model->delete($id,$catData);
					if($r)
					{
						$data['flag']=1;
						$data['category']=$catData->name;
					}
				}
				else
				{
					$data['flag']=2;
					$data['category']=$catData->name;
				}
			}
		}
		echo json_encode($data);
	}

	public function hidecategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->register_categories_model->catData($id);
			if(!empty($catData))
			{
				$data['category']=$catData->name;
				if($catData->status==0)
				{
					$data['flag']=2;	
					goto end;
				}
				$r=$this->register_categories_model->hide($id,$catData);
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}

	public function unhidecategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->register_categories_model->catData($id);
			if(!empty($catData))
			{
				$data['category']=$catData->name;
				if($catData->status==1)
				{
					$data['flag']=2;	
					goto end;
				}
				$r=$this->register_categories_model->unhide($id,$catData);
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}
	
	public function updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|registrationPurpose');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->register_categories_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function update_admin_notes()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|max_length[2000]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|registrationExist');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->register_model->updateAdminNotes($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function category_check()
	{
		$exist=$this->register_categories_model->cat_exist($_POST['id'],$_POST['category']);
		if($exist) echo 0;
		else echo 1;
	}

	public function changestatus($id=0,$status=0)
	{
		$result['status']=0;
		if(is_numeric($id) && is_numeric($status) && in_array($status,array(0,1,2)))
		{
			$registerData=$this->register_model->registerData($id);
			if(empty($registerData))
				goto end;
			if($registerData->pstatus==$status)
			{
				$result['status']=2;
				goto end;
			}
			$this->register_model->changeStatus($id,$status);
			$result['register_id']=$registerData->register_id;
			$result['status']=1;
		}
		end:
		echo json_encode($result);
	}
}
?>