<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Register extends CI_Controller 
{
	function __construct()
	{
        parent::__construct();
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");

       	$this->load->model("registrations/register_model");
       	$this->load->model("registrations/register_categories_model");
       	$this->load->model("currencies_model");
    }
	public function index()
	{
		$data['views'] = array('registrations/public/form');
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function send()
	{
		$data['flag']=0;
		if($GLOBALS['site_settings']['registration_form']==0)
		{
			$data['flag']=2;
			goto end;
		}
		$this->form_validation->set_rules('name', 'Name', 'trim|required|lettersonly|min_length[3]|max_length[200]');
		$this->form_validation->set_rules('notes', 'Notes', 'trim|required|max_length[2000]');
		$this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|registrationPurpose[1]');
		$this->form_validation->set_rules('email', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
		$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
		$this->form_validation->set_rules('address', 'Address','trim|required|min_length[10]|max_length[2000]');
		$this->form_validation->set_rules('country', 'Country', 'trim|required|countryCheck');
		
		if ($this->form_validation->run() == FALSE)
		{
			$data['errors']=validation_errors();
			goto end;
		}
		$this->register_model->save($_POST);
		
        $data['flag']=1;


		end:
		echo json_encode($data);
	}
}
?>