<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
#Author : Baji shaik
#Created On : 20th Oct 2018
#Reason : To save/update the data when application get the responce from Razorpay Gateway(Technically Webhook Url). Razorpay call this url when an event occured from razorpay

require_once APPPATH. '/third_party/razorpay/Razorpay.php';
use Razorpay\Api\Api;

class Razorpaywebhook extends CI_Controller 
{
	var $archivesDb = "";
	function __construct()
	{
		parent::__construct();
		$this->load->model('payment_model');
		$this->load->model('orders/orders_model');
		//Model Added by Baji To save subscription ids
		$this->load->model('orders/subscription_payments_model');
		$this->load->model("subscriptions/donors_model");
		$this->load->model("razorpay_webhook_model");
		//Done by Baji's newly Added models
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');

		$this->load->model('Razorpay_customers_model','razorpaycustomers');
		$this->load->model('Razorpay_subscriptions_model','razorpaysubscriptions');

		$this->archivesDb = $this->load->database("data_archives",true,false);
	}

	public function checksub()
	{
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId(4,4);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$trustData=$trustsArray['inr'];
    	if($trustData->razorpay_key && $trustData->razorpay_secret)
    	{
			$api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);
			$order  = $api->invoice->fetch('inv_G3pXC1fLpMspI6');
			echo $order->subscription_id;
			echo "<pre>";
			print_r($order);
		}
	}

	public function index()
	{
		// retrieve the request's body and parse it as JSON
		$body = @file_get_contents('php://input');
		$event_json = json_decode($body);
		//echo $event_json->data->object->customer;exit();
		$subscription_id = "";
		$tx = "";
		$customer = "";
		$amount="";
		$payment_status = "";
		$plan_id = "";
		$currency = "";
		$paid_count = "";
		$decode_response = json_decode($body);

		// $trustId = 0;
		// if(isset($decode_response->payload->payment->entity->notes->trust_id))
		// 	$trustId = $decode_response->payload->payment->entity->notes->trust_id;
		// log_message("error","Razorpay webhook trust_id: ".$trustId);
		
		$webhook_secret_key = razorpay_webhook_secret_key;
		$received_signature = "";
		if(!empty($_SERVER['x-xero-signature']))
			$received_signature = $_SERVER['x-xero-signature'];
		if(!empty($_SERVER['HTTP_X_XERO_SIGNATURE']))
			$received_signature = $_SERVER['HTTP_X_XERO_SIGNATURE'];
		if(!empty($_SERVER['HTTP_X_RAZORPAY_SIGNATURE']))
			$received_signature = $_SERVER['HTTP_X_RAZORPAY_SIGNATURE'];
		$expected_signature = hash_hmac('sha256', $body, $webhook_secret_key);
		if ($expected_signature != $received_signature)
		{
			log_message("error","Razorpay webhook authentication failed");
			exit();
		}

		if($decode_response->event)
		{
			$subscription_entity = "";
			if(!empty($decode_response->payload->subscription))
				$subscription_entity = $decode_response->payload->subscription->entity;
			
			$payment_entity = "";
			if(!empty($decode_response->payload->payment))
				$payment_entity = $decode_response->payload->payment->entity;

			//Main Status is under payload entity status
			$amount 			= isset($payment_entity->amount)?$payment_entity->amount/100:"";
			$tx 				= isset($payment_entity->id)?$payment_entity->id:"";
			$currency 			= isset($payment_entity->currency)?$payment_entity->currency:"";
			$subscription_id 	= isset($subscription_entity->id)?$subscription_entity->id:"";
			$customer 			= isset($subscription_entity->customer_id)?$subscription_entity->customer_id:"";
			$plan_id 			= isset($subscription_entity->plan_id)?$subscription_entity->plan_id:"";
			$payment_status 	= isset($payment_entity->status)?$payment_entity->status:"";
			$paid_count 		= isset($subscription_entity->paid_count)?$subscription_entity->paid_count:"";
		}
		$data = array('transaction_id'=>$tx,'customer_id'=>$customer,'subscription_id'=>$subscription_id,'data'=>$body,'amount'=>$amount,'created_on'=>date('Y-m-d H:i:s'),'status'=>$payment_status,'currency'=>$currency,'event_type'=>$decode_response->event,'plan_id'=>$plan_id,'paid_count'=>$paid_count);

		if($decode_response->event == "subscription.charged" && $decode_response->payload->payment->entity->status == "captured")
		{
			$check = $this->razorpay_webhook_model->checktriggeredEvent(array("event_type"=>"subscription.charged","status"=>"captured"),$tx);
			if($check)
			{
				$this->razorpay_webhook_model->save($data);
				$this->razorpay_webhook_model->updatecaptureFlag($tx);
				$this->razorpay_webhook_model->checksubscription($paid_count,$tx,$amount,$currency,$subscription_id,$body);
				$this->razorpay_webhook_model->updateReconciliationReport($data, 'razorpay');
			}
		}
		else if($decode_response->event != "subscription.charged" && $decode_response->event == "payment.captured" && $decode_response->payload->payment->entity->status == "captured")
		{
			$check = $this->razorpay_webhook_model->checktriggeredEvent(array("event_type"=>"payment.captured","status"=>"captured"),$tx);
			if($check)
			{
				$this->razorpay_webhook_model->save($data);
				$this->razorpay_webhook_model->updatecaptureFlag($tx);
				$this->razorpay_webhook_model->updateOrerID($tx);
				$this->razorpay_webhook_model->updateReconciliationReport($data, 'razorpay');
			}
		}

		else if($decode_response->event != "subscription.charged" && $decode_response->event == "payment.authorized" && $decode_response->payload->payment->entity->status == "authorized")
		{
			$check = $this->razorpay_webhook_model->checktriggeredEvent(array("event_type"=>"payment.authorized","status"=>"authorized"),$tx);
			if($check)
			{
				$this->razorpay_webhook_model->save($data);
			}
		}

		else if($decode_response->event == "invoice.paid" && $decode_response->payload->payment->entity->status == "captured")
		{
			$onetimecheckUp = $decode_response->payload->invoice->entity->user_id;
			$onetimecheckUp = isset($onetimecheckUp)?"no":"yes";
			$subscription_id = $decode_response->payload->invoice->entity->subscription_id;
			if($subscription_id)
			{
				if($onetimecheckUp == "yes")
				{
					$check = $this->razorpay_webhook_model->checktriggeredEvent(array("event_type"=>"invoice.paid","status"=>"captured"),$tx);
					if($check)
					{
						$this->razorpay_webhook_model->save($data);
						$this->razorpay_webhook_model->updateOrerID($tx);
					}
				}
			}
			$this->razorpay_webhook_model->updatecaptureFlag($tx);
			$this->razorpay_webhook_model->updateReconciliationReport($data, 'razorpay');
		}

		else if($decode_response->event == "payment.failed" && $decode_response->payload->payment->entity->status == "failed")
		{
			if(!empty($subscription_id))
			{
				$ashram_id = $this->get_ashram_id($subscription_id);
				if(!empty($ashram_id))
				{
					$sub_and_date_Data = $this->getRazorpayKeys($ashram_id,$currency,$tx);

					$ashram_subscription_id = $sub_and_date_Data["subscription_id"];
					$payment_date = $sub_and_date_Data["paymentDate"];

					$customer_id = $payment_entity->customer_id;
					$check = $this->razorpay_webhook_model->checktriggeredEvent(array("event_type"=>"payment.failed","status"=>"failed"),$tx);
					if($check)
					{
						$this->razorpay_webhook_model->save($data);
						if($ashram_subscription_id)
						{
							$query = $this->razorpaysubscriptions->checkSubscription($ashram_subscription_id);
							if($query->num_rows() > 0)
							{
								$this->razorpay_webhook_model->paymentFail($tx,$ashram_subscription_id,$query->result()[0]->order_item_id,$query->result()[0]->order_id,$amount,$currency,$body,$payment_date);
							}
						}
					}
					$this->razorpay_webhook_model->updateReconciliationReport($data, 'razorpay');
				}
			}
		}

		else if($decode_response->event == "subscription.pending")
		{
			$attempts = $subscription_entity->auth_attempts;
			$query = $this->razorpaysubscriptions->checkSubscription($subscription_id);
			if($query->num_rows() > 0)
			{
				$paid_count = $paid_count+1;
				$this->razorpay_webhook_model->save($data);
				$this->razorpay_webhook_model->updatefailedsubscriptions($paid_count,$tx,$query->result()[0]->order_item_id,$query->result()[0]->item_id,$amount,$currency,$subscription_id,$body,$attempts);
				$this->razorpay_webhook_model->updateOrderItemStatus($query->result()[0]->order_item_id,0);
			}
		}

		else if($decode_response->event == "subscription.cancelled")
		{
			$query = $this->razorpaysubscriptions->checkSubscription($subscription_id);
			if($query->num_rows() > 0)
			{
				$this->razorpay_webhook_model->subscriptionCancelledHookEvent($subscription_id);
                $this->razorpay_webhook_model->save($data);
                $this->razorpay_webhook_model->updateOrderItemStatus($query->result()[0]->order_item_id,2);
			}
		}

		else if($decode_response->event == "subscription.activated")
		{
			$query = $this->razorpaysubscriptions->checkSubscription($subscription_id);
			if($query->num_rows() > 0)
			{
                $this->razorpay_webhook_model->save($data);
                $this->razorpay_webhook_model->updateOrderItemStatus($query->result()[0]->order_item_id,1);
			}
		}
		

		else if($decode_response->event == "subscription.completed" && $payment_status == "captured")
		{
			$query = $this->razorpaysubscriptions->checkSubscription($subscription_id);
			if($query->num_rows() > 0)
			{
				$itemData = new stdClass();
				$itemData->subscription_id = "";
				$result = $query->result()[0];
				$updatecheck = $this->razorpaysubscriptions->updateOrderItemSubscription($result->order_item_id,$subscription_id,$itemData,3);
				$this->razorpay_webhook_model->save($data);
				$this->razorpay_webhook_model->updatecaptureFlag($tx);
				if($updatecheck)
				{
					$this->orders_model->sendSubscriptionCompletedMail($result->order_id,$result->order_item_id);
				}
				$this->order_log_model->log($result->order_id,"Subscription Completed.");
				$this->razorpay_webhook_model->updateReconciliationReport($data, 'razorpay');
			}
		}

		else if($decode_response->payload->payment->entity->status == "refunded")
		{
			$this->razorpay_webhook_model->save($data);
			$this->razorpay_webhook_model->updatecaptureFlagZero($tx);
			$this->razorpay_webhook_model->updateReconciliationReport($data, 'razorpay');
		}
		else
		{
			if(!empty($data["event"]) && !empty($data["status"]))
			{
				$check = $this->razorpay_webhook_model->checktriggeredEvent(array("event_type"=>$data["event_type"],"status"=>$data["status"]),$tx);
				if($check)
				{
					$this->razorpay_webhook_model->save($data);
					$this->razorpay_webhook_model->updateOrerID($tx);
				}
			}
		}
		http_response_code(200);
	}

	public function get_ashram_id($subscription_id)
	{
		$ashram_id = $this->razorpay_webhook_model->getAshramID($subscription_id);
		return $ashram_id;
	}

	public function getRazorpayKeys($ashramId,$currency,$tx)
	{
		if($ashramId)
		{
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,4);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	$currency = strtolower($currency);
	    	$trustData=$trustsArray[$currency];
	    	if($trustData->razorpay_key && $trustData->razorpay_secret)
	    	{
		    	return $this->getSubsriptionKey($trustData->razorpay_key,$trustData->razorpay_secret,$tx);
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}

	private function getSubsriptionKey($razorpay_key, $razorpay_secret,$tx)
	{
		try
		{
			$api = new Api($razorpay_key, $razorpay_secret);
	    	$payid = $api->payment->fetch($tx);
	    	if($payid->invoice_id)
	    	{
				$invoice = $api->invoice->fetch($payid->invoice_id);
				$paid_count = $invoice['line_items'][0]->quantity;
				$subscription_id = $invoice->subscription_id;
				$paymentDate = date("Y-m-d",$invoice->billing_start);
				return array("subscription_id"=>$subscription_id,"paymentDate"=>$paymentDate);
			}
			else
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			return false;
		}
	}
		
}