<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Poojas extends CI_Controller 
{
	var $service="cart";
	var $currentUser='';
	var $pageName="Poojas";
	var $currencies;
    function __construct()
	{
        parent::__construct();
        $this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/poojas_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->model('currencies_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/payflow_logs_model');
		$this->load->model("offline_model");
        $this->load->model("subscriptions/donors_model");
        $this->load->model("credit_cards_model");
        $this->load->model("foreign_currencies_model");
        
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       	{
       		if($this->session->userdata("force_change_password")==1)
			{
				$this->session->set_flashdata("reset_password_force",1);
				redirect("myaccount/change_password");
			}
       		$this->currentUser=$this->session->userdata("user_data");
       	}
       	if(empty($this->session->userdata("poojasCartAshramIdSelection")))
       	{
       		$this->session->unset_userdata("defaultCurrency");
       	}
        if(in_array(global_site_flag, [7]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("poojas?ashram_id=1&currency=usd");
        }
        if(in_array(global_site_flag, [2]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("poojas?ashram_id=1&currency=inr");
        }
        if(in_array(global_site_flag, [4]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("poojas?ashram_id=1&currency=usd");
        }
        if(in_array(global_site_flag, [1]) && (isset($_GET['special_pooja']) && $_GET['special_pooja']=='navagraha-poojas'))
        {
            redirect("poojas?ashram_id=".$this->session->userdata("poojasCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
        }
        if(is_single_currency_site==1 && $this->input->get("currency")!='' && default_currency!=strtolower($this->input->get("currency")))
        {
            if(in_array(global_site_flag, [2,4]))
            {
                redirect("poojas?ashram_id=".default_ashram_id."&currency=".default_currency);
            }
            else
            {
                $this->session->unset_userdata("poojasCartAshramIdSelection");
	    		$this->session->unset_userdata("defaultCurrency");
	    		redirect("poojas");
            }
        }
       	if($this->input->get("ashram_id")!='')
       	{
       		$ashramData=$this->ashrams_model->ashramData($this->input->get("ashram_id"));
            if(!empty($ashramData) && (is_numeric($this->input->get("ashram_id")) && $this->input->get("ashram_id") > 0) )
            {
       			$this->session->set_userdata("poojasCartAshramIdSelection",$this->input->get("ashram_id"));
                $this->session->set_userdata("poojasCartAshramId",$this->input->get("ashram_id"));
            }
       		else
            {
                $this->session->unset_userdata("poojasCartAshramIdSelection");
                $this->session->unset_userdata("defaultCurrency");
       			redirect("poojas");
            }
       	}

       	if($this->session->userdata("poojasCartAshramIdSelection"))
       	{
       		$this->currencies=$this->currencies_model->getByAshram($this->session->userdata("poojasCartAshramIdSelection"));
       	}
       	if($this->input->get("currency")!='')
       	{
       		if(isset($this->currencies[$this->input->get("currency")]))
       			$this->session->set_userdata("defaultCurrency",$this->input->get("currency"));
       	}
       	if($this->input->get("view")!='')
       	{
       		if(in_array($this->input->get("view"),array("itemView","listView")))
       			$this->session->set_userdata('poojas_list_type', $this->input->get("view"));
       	}
       	$this->load->model('cart_model');
       	$this->load->library('poojascart');
       	if(!empty($this->session->userdata("poojasCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
       	{
	       	$this->cart_model->validateCart($this->poojascart);
	    }
    }
    public function index()
    {
    	if(empty($this->input->get("ashram_id")) && !empty($this->session->userdata("poojasCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
    	{
    		$this->session->unset_userdata("poojasCartAshramIdSelection");
    		$this->session->unset_userdata("defaultCurrency");
    		redirect("poojas");
    	}
    	if(!empty($this->session->userdata("poojasCartAshramIdSelection")) && empty($this->input->get("ashram_id")))
    	{
    		redirect("poojas?ashram_id=".$this->session->userdata("poojasCartAshramIdSelection"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && empty($this->input->get("currency")))
    	{
    		redirect("poojas?ashram_id=".$this->session->userdata("poojasCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && !empty($this->session->userdata("poojasCartAshramIdSelection")) && !empty($this->session->userdata("poojas_list_type")) && empty($this->input->get("view")))
    	{
    		redirect("poojas?ashram_id=".$this->session->userdata("poojasCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency")."&view=".$this->session->userdata('poojas_list_type'));
    	}
    	if($GLOBALS['site_settings']['poojas']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
    	if(!empty($this->session->userdata("poojasCartAshramIdSelection")))
    	{
    		if($this->checkpublicdisplay()=="0")
	    	{
	    		$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
	    	}
    	}
    	$this->load->model('ashrams/ashrams_model');
		$data['slug']="poojas";
		if(empty($this->session->userdata("poojasCartAshramIdSelection")) || empty($this->session->userdata("defaultCurrency")))
		{
			$data['views'] = array('ashrams/public/cart_ashram_selection');
    		$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("poojasCartAshramIdSelection"));
		}
		else
		{
			$data['cartObject']=$this->poojascart;
			$data['views'] = array('ashrams/public/list_poojas');
		}

        $cart=$this->poojascart->contents();
        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('poojasCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }
    	
    	// $data['ashrams']=$this->ashrams_model->getList();
    	$data['ashrams']=$this->ashrams_model->getOnlyActivePoojaItemsAshramList();
	    $ashramids = array_column($data['ashrams'], 'id');
	    if($this->session->userdata("poojasCartAshramIdSelection")>0 && !in_array($this->session->userdata("poojasCartAshramIdSelection"),$ashramids))
	    {
	    	redirect("poojas");
	    }
		$this->load->view(FRONTEND_TEMPLATE,$data);
		if($this->session->userdata("poojasCartAshramIdSelection"))
			$this->cart_log_model->log("Navigated to poojas Ashrams page :".current_url(),$this->session->userdata("poojasCartAshramIdSelection"),1);
    }
    public function changecurrency()
    {
    	if(isset($_POST['currency']) && $_POST['currency']!='')
    	{
            if(empty($this->currencies))
            {
                echo 0;
                return;
            }
    		foreach ($this->currencies as $currencyData)
    		{
    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
    			{
    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("poojasCartAshramIdSelection"),1);
    				if($this->session->userdata("poojasCartAshramIdSelection") && $this->session->userdata("defaultCurrency"))
    					$this->cart_model->validateCart($this->poojascart);
    				echo 1;
    				return;
    			}
    		}
    	}
    	echo 0;
    }

    public function removeAshramSession()
    {
    	$this->session->unset_userdata("poojasCartAshramIdSelection");
    	echo 1;
    }

    public function changeashram()
    {
    	if(!empty($this->poojascart->contents()))
    	foreach($this->poojascart->contents() as $key=>$val)
    	{
    		$poojaData=$this->poojas_model->poojaData($val['id']);
    		break;
    	}
    	if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='' && (empty($this->poojascart->contents()) || isset($poojaData) && $poojaData->ashram_id == $_POST['ashram_id']))
    	{
    		$this->load->model('ashrams/ashrams_model');
    		$ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
    		if(!empty($ashramData))
    		{
    			$this->session->set_userdata("poojasCartAshramIdSelection",$_POST['ashram_id']);
                $this->session->set_userdata("poojasCartAshramId",$_POST['ashram_id']);
    			$this->cart_log_model->log("Changed ashram to :".$ashramData->name,$this->session->userdata("poojasCartAshramIdSelection"),1);
    			$data['flag']=1;
    			echo json_encode($data);
    			return;
    		}
    	}
    	else
    	{
    		$data['flag']=2;
    		if($poojaData->ashram_id)
    		{	
    			$ashramData=$this->ashrams_model->ashramData($poojaData->ashram_id);
    			$data['ashram_name']=$ashramData->name;
    		}
    		echo json_encode($data);
    		return;
    	}
    	$data['flag']=0;
    	echo json_encode($data);
    }
    public function checkout()
    {
    	if(empty($this->input->get("ashram_id")) || empty($this->input->get("currency")))
    	{
    		redirect("poojas");
    	}
    	$cart=$this->poojascart->contents();
    	if(empty($cart))
    	{
    		if(!empty($this->session->userdata("poojasCartAshramId")) && !empty($this->session->userdata("defaultCurrency")))
            {
                redirect("poojas?ashram_id=".$this->session->userdata("poojasCartAshramId")."&currency=".$this->session->userdata("defaultCurrency"));
            }
            else
            {
                redirect("poojas");
            }
    	}

        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('poojasCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }


    	$this->load->model("credit_cards_model");
    	$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("poojasCartAshramId"),1);
        $data['ashramData'] = $this->ashrams_model->ashramData($this->session->userdata("poojasCartAshramId"));
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		$data['trustData'] = isset($trustsArray['inr']) ? $trustsArray['inr'] : "";
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		$data['trustData'] = isset($trustsArray['usd']) ? $trustsArray['usd'] : "";
    	}

    	// If trust data is not available then redirect to back
    	if(empty($data['trustData']))
    	{
    		if(!empty($this->session->userdata("poojasCartAshramId")) && !empty($this->session->userdata("defaultCurrency")))
            {
                redirect("poojas?ashram_id=".$this->session->userdata("poojasCartAshramId")."&currency=".$this->session->userdata("defaultCurrency"));
            }
            else
            {
                redirect("poojas");
            }
    	}

        $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
        $this->session->set_userdata("poojas_temp_reference",$temp_reference);

    	$total=$this->cart_model->getTotalPrice($this->poojascart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	$data ['family_donors'] = [];
    	if($this->session->userdata("loggedIn"))
    	{

    		if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$cUserId=$this->session->userdata('temp_checkout_user')->id;
					$checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
					$data['credit_cards']=$this->credit_cards_model->getCards($cUserId);
				}
			}
			else
			{
				$checkoutUserId = $this->currentUser->sso_user_id;
				$data['credit_cards']=$this->credit_cards_model->getCards($this->currentUser->id);
			}
			$this->load->model("subscriptions/donors_model");
            $data ['family_donors'] = $this->donors_model->getUserUnhideDonors($checkoutUserId);
    	}
    	$data['views'] = array('ashrams/public/checkout_poojas');
		$this->load->view(FRONTEND_TEMPLATE,$data);
		$this->cart_log_model->log("Navigated to poojas checkout page :".current_url(),$this->session->userdata("poojasCartAshramId"),1);
    }
    public function getcart()
    {
    	ob_start();

    	$data ['family_donors'] = [];
		if($this->session->userdata("loggedIn"))
    	{
    		if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
				}
			}
			else
			{
				$checkoutUserId = $this->currentUser->sso_user_id;
			}
			$this->load->model("subscriptions/donors_model");
            $data ['family_donors'] = $this->donors_model->getUserUnhideDonors($checkoutUserId);
    	}

    	$this->load->view("ashrams/public/_cart_template", $data);
    	$data['cart_template']=ob_get_clean();
    	$total=$this->cart_model->getTotalPrice($this->poojascart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	echo json_encode($data);
    }
    public function checkpublicdisplay()
    {
    	$ashramData=$this->ashrams_model->ashramData($this->session->userdata('poojasCartAshramIdSelection'));
        if($ashramData->is_public_display==0)
        {
            if(empty($this->currentUser))
                return "0";
            if(!empty($this->currentUser) && $this->currentUser->roles !=1 && $this->currentUser->roles !=3 && $this->currentUser->roles !=4)
				return "0";
        }
        else
        {
            return $this->session->userdata('poojasCartAshramIdSelection');
        }
    }
    public function listitems()
	{
		if($this->session->userdata("poojas_list_type") == 'date')
		{
			$list=$this->poojas_model->listPublicByDate($this->session->userdata("poojasCartAshramIdSelection"),$this->session->userdata("admin_data"),$this->session->userdata("user_data"));
		} else if($this->session->userdata("poojas_list_type") == 'pooja')
		{
			$list=$this->poojas_model->listPublicByPoojas($this->session->userdata("poojasCartAshramIdSelection"),$this->session->userdata("admin_data"),$this->session->userdata("user_data"));
		} else {
			$list=$this->poojas_model->listPublic($this->session->userdata("poojasCartAshramIdSelection"),$this->session->userdata("admin_data"),$this->session->userdata("user_data"));
		}
		echo json_encode($list);
	}
	public function carttoptemplate()
	{
		$data['cartObject']=$this->poojascart;
		$data['slug']="poojas";
		$response_data['cart_template']=$this->load->view("ashrams/public/_cart_top_template",$data,true);
		$response_data['count']=count($this->poojascart->contents());
		echo json_encode($response_data);
	}

	public function additem($id=0, $pooja_on_date='',$row_key='')
	{
		$data['flag']=0;
		if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=55;
			goto end;
		}
		if($GLOBALS['site_settings']['poojas']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['flag']=12;
    		$data['error_msg']="Poojas are disabled";
			goto end;
    	}
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
		{
			if(!$this->session->userdata('temp_checkout_user'))
			{
				$data['flag']=12;
				$data['error_msg']='Please select user before adding Pooja to cart.';
				goto end;
			}
		}

		if($GLOBALS['poojaCartLocked']==1)
		{
			$data['flag']=11;
			goto end;
		}
		if(is_numeric($id) && $id)
		{
			$cart=$this->poojascart->contents();
			$amount=$this->cart_model->getTotalPrice($this->poojascart);
			$poojaData=$this->poojas_model->poojaData($id);
            $cartCount = count($cart);
            if($cartCount>0)
            {
                foreach($cart as $thiscartitem)
                {
                    if($this->session->userdata('poojasCartAshramId')!=$thiscartitem['options']['ashram_id'])
                    {
                        $this->load->model('ashrams/ashrams_model');
                        $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                        $data['ashram_name']=$ashramData->name;
                        $data['flag']=2;
                        goto end;
                    }
                }
            }
            if($cartCount >= 50)
            {
                $data['flag']=111;
                $data['error_msg']='MAX 50 items are allowed to cart.';
                goto end;
            }

            if($poojaData->display_only_popup==1)
            {
                $data['flag']=112;
                goto end;
            }
            
			$data['item']=$poojaData;
			$data['type']='pooja';
			$data['note']='';
			$data['personal_note']='';
            $data['pitru_paksha_deceased_person_name']='';
            $data['poornaphala_tie_by']='';
            $data['is_poornaphala_seva']=0;
            $data['is_attend_in_person']=0;
            $data['attend_pooja_in_person']='';
            $data['in_person_note']='';
            if(isset($poojaData->is_poornaphala_seva) && $poojaData->is_poornaphala_seva==1)
            {
                // $data['poornaphala_tie_by']='Priest';
                $data['is_poornaphala_seva']=1;
            }
			//checking for pooja attend or not
            if(isset($poojaData->attend_pooja_in_person) && $poojaData->attend_pooja_in_person==1)
            {
                $data['is_attend_in_person']=1;
				$data['in_person_note'] = $poojaData->in_person_note;
            }
            $data['other_name1']='';
            $data['other_name2']='';
            $data['other_name3']='';
            $data['other_name4']='';
            $data['other_name5']='';
            $data['other_name6']='';
			if($this->session->userdata("loggedIn"))
			{
				if($this->currentUser->admin==0)
				{
					$data['note']=$this->currentUser->family_details;
				}
				else
				{
					if($this->session->userdata('temp_checkout_user'))
					{
						$data['note']=$this->session->userdata('temp_checkout_user')->family_details;
					}
				}
			}
			if(empty($poojaData))
			{
				$data['flag']=10;
				goto end;
			}
			$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
			if($poojaData->$displayCol==0)
			{
				$data['flag']=10;
				goto end;
			}
			$col="price_".strtolower($this->session->userdata("defaultCurrency"));

			$netAmount=$amount+$poojaData->$col;

			if(strtolower($this->session->userdata("defaultCurrency"))=='inr' && 
				$netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
			{
				$data['flag']=12;
				$data['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
				goto end;
			}
			if(strtolower($this->session->userdata("defaultCurrency"))=='usd' && $netAmount>
				$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
			{
				$data['flag']=12;
				$data['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
				goto end;
			}

			if(!$this->session->userdata('poojasCartAshramId') || $poojaData->ashram_id==$this->session->userdata('poojasCartAshramId') || count($cart)==0)
			{
				$data['pooja_on_date']=$pooja_on_date;
				$response=$this->cart_model->addItem($data,1,$this->poojascart,$row_key);
				$flag=$response['flag'];
                if(isset($response['rowid']) && $response['rowid']!='')
                {
                    $data['rowKey'] = $response['rowid'];
                }
				if($flag==-2)
				{
					$this->logaction->log($this->service,"Pooja added to cart _ Pooja ID:".$id." _ ".$poojaData->pooja_name." _ Row ID: ".$response['rowid']);
					$data['flag']=1;
					$this->session->set_userdata('poojasCartAshramId',$poojaData->ashram_id);
					$this->cart_log_model->log("Item added - Name:".$poojaData->pooja_name.", Price:".strtoupper($this->session->userdata("defaultCurrency"))." ".$poojaData->$col,$this->session->userdata("poojasCartAshramId"),1);
				}
				else
				{
					$data['flag']=$flag;
				}
			}
			else
			{
				$this->load->model('ashrams/ashrams_model');
				$ashramData=$this->ashrams_model->ashramData($this->session->userdata('poojasCartAshramId'));
				$data['ashram_name']=$ashramData->name;
				$data['flag']=2;
			}
		}
		end:
		ob_start();
		$cdata['cartObject']=$this->poojascart;
		$cdata['slug']="poojas";
		$this->load->view("ashrams/public/_cart_top_template",$cdata);
		$data['cart_template']=ob_get_clean();
		echo json_encode($data);
	}

	public function removeitem()
	{
		$result['flag']=0;
		if($GLOBALS['poojaCartLocked']==1)
		{
			$result['flag']=11;
			goto end;
		}
		$cart=$this->poojascart->contents();
		if(empty($cart))
    	{
    		$result['flag']=3;
    		goto end;
    	}
		if(isset($_POST['key']) && $_POST['key']!='')
		{
			$item=$this->poojascart->get_item($_POST['key']);
            // echo '<pre>'; print_r($item); die();
			if(!empty($item))
			{
				$upd= array(
			               'rowid' => $_POST['key'],
               				'qty'   => 0
				            );
				$this->poojascart->update($upd);
				$this->logaction->log($this->service,"Pooja removed from cart _ Pooja ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$_POST['key']);
				$cc=$this->poojascart->contents();
				$this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);
				if(count($cc)==0)
				{
					$this->session->unset_userdata('poojasCartAshramId');
				}
				$result['flag']=1;
				$result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('poojasCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('poojasCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
			}
			else
			{
				$result['flag']=2;
			}
		}
		end:
		echo json_encode($result);
	}
	
	public function change_dates()
	{
		$result['flag']=0;
		if($GLOBALS['poojaCartLocked']==1)
		{
			$result['flag']=11;
			goto end;
		}
		if(isset($_POST['poojaid']) && is_numeric($_POST['poojaid']) && $_POST['poojaid'] && 
			isset($_POST['rowid']) && $_POST['rowid']!='')
		{
			$poojaData=$this->poojas_model->poojaData($_POST['poojaid']);
			if(!empty($poojaData) && $poojaData->status==1)
			{
				$data['item']=$poojaData;
				$data['options']=$this->poojascart->product_options($_POST['rowid']);
				ob_start();
				$this->load->view('ashrams/public/_select_dates_poojas',$data);
				$result['template']=ob_get_clean();
				$result['flag']=1;
			}
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}

	public function dates_validate()
	{
		if($GLOBALS['poojaCartLocked']==1)
		{
            echo 'cartLocked';
			exit;
		}
		if(isset($_POST['poojaid']) && is_numeric($_POST['poojaid']) && $_POST['poojaid'])
		{
			$poojaData=$this->poojas_model->poojaData($_POST['poojaid']);
			if(!empty($poojaData) && $poojaData->status==1)
			{
				$dates_set=$this->cart_model->getPoojaValidDates($poojaData);
				$final=array();
				if($_POST['selected_dates']!='')
					$selected=explode(",",$_POST['selected_dates']);
				else
					$selected=array();
				
				if(!empty($selected))
				foreach($selected as $pdate)
				{
					if(in_array($pdate,$dates_set))
					$final[]=$pdate;
				}
				
				foreach($final as $key=>$tms)
				{
					$final[$key]=strtotime($tms);
				}
				
				asort($final);
				
				$store_array=array();
				
				$cnt=0;
				$first='';
				
				
				foreach($final as $key=>$tms)
				{
					if($cnt==0)
					$first=date("d M Y",$tms);
					
					$final[$key]=date("d M Y (D)",$tms);
					$store_array[]=date("d M Y",$tms);
					$cnt++;
				}
				
				if($_POST['save']==1)
				{
					$opt=$this->poojascart->product_options($_POST['rowid']);

					$opt['result_date']=implode(",",$store_array);
					$opt['schedule_options']=$_POST;
					$opt['user_date']=$first;

					$upd= array(
							 'rowid' => $_POST['rowid'],
							 'options'   => $opt,
							 'qty'=>$cnt					);

					//$this->logaction->log_action("Pooja dates updated _ Row ID: ".$_POST['cartid'],"Order");
					$this->poojascart->update($upd);
					$this->cart_log_model->log("Dates changed - Name:".$poojaData->pooja_name,$this->session->userdata("poojasCartAshramId"),1);

					$this->cart_model->validateCart($this->poojascart);
				}
				echo implode("<br>",$final);
			}
		}
	}

	public function updatenote()
    {
		if($GLOBALS['poojaCartLocked']==1)
		{
			echo 2;
			return;
		}

    	$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->poojascart->get_item($_POST['pk']);
		$options=$this->poojascart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['note']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );

	        foreach ($options as $key => $val)
			{
				$temp[$key] = $val;
			}

			$this->poojascart->update($updateArray);

			$this->cart_log_model->log("Family details updated - Name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);

			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updatePersonalnote()
    {
		if($GLOBALS['poojaCartLocked']==1)
		{
			echo 2;
			return;
		}

    	$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->poojascart->get_item($_POST['pk']);
		$options=$this->poojascart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['personal_note']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );

	        foreach ($options as $key => $val)
			{
				$temp[$key] = $val;
			}

			$this->poojascart->update($updateArray);

			$this->cart_log_model->log("Personal Note updated - Name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);

			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updatePitruPakshaDeceasedPersonName()
    {
        if($GLOBALS['poojaCartLocked']==1)
        {
            echo 2;
            return;
        }

        $this->form_validation->set_rules('value', 'Value', 'trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('pk', 'ID', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            echo 0;
            return;
        }
        $item=$this->poojascart->get_item($_POST['pk']);
        $options=$this->poojascart->product_options($_POST['pk']);
        if(!empty($options))
        {
            $options['pitru_paksha_deceased_person_name']=$_POST['value'];
            $updateArray= array(
                       'rowid' => $_POST['pk'],
                           'options'   => $options
                        );

            foreach ($options as $key => $val)
            {
                $temp[$key] = $val;
            }

            $this->poojascart->update($updateArray);

            $this->cart_log_model->log("Deceased person name updated - Name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);

            echo 1;
        }
        else
        {
            echo 0;
        }
    }

    public function cancelprevious()
    {
    	$result['flag']=0;
    	if($GLOBALS['poojaCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['poojaCartStartedOn']);
			if(time()>=$startedOn)
			{
				$this->cart_model->regenerateSession(1);
				$result['flag']=1;
				goto end;
			}
		}
		end:
		echo json_encode($result);
    }
    public function checkout_notify($tab_index=null)
    {
    	if($tab_index!=null && in_array($tab_index,array(0,1,2)))
    	{
    		$data='';
    		if($tab_index==2)
    		{
    			$countryData=$this->locations_model->getCountryByCode($this->input->post("country"));
    			$data="<br>Data:<br>".$this->input->post("firstname")." ".$this->input->post("lastname")."<br>".
    				$this->input->post("city").", ".$this->input->post("state").", ".$this->input->post("country")."<br>".
    				"+".$countryData->isd_code." ".$this->input->post("phone")."<br>".
    				$this->input->post("email");
    		}
    		$this->cart_log_model->log("Checkout - navigated to tab ".($tab_index+1).$data,$this->session->userdata("poojasCartAshramId"),1);
    	}
    }

    public function check_pooja_modifications()
    {
    	$result['flag']=1;
    	//Validate Cart items
		$this->cart_model->validateCart($this->poojascart);

		//Check cart items count
		$cartContents=$this->poojascart->contents();
		if(empty($cartContents)) //If cart is empty
		{
			$result['flag']=0;
	 		goto end;
		}
		if(is_single_currency_site==1 && default_currency!=strtolower($this->session->userdata("defaultCurrency")))
        {
            $result['flag']=5;
            $result['alertMessage'] = '<strong>JGD. You cart not supporting the currency.</strong>';
            goto end;
        }
        $partialPayCount = 0;
        $noPartialPayCount = 0;
		$totalItems=count($cartContents);
		$validItems=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['status']==1)
			{
				$validItems++;
			}
            if($cartItem['options']['partial_payments_allowed'] == 1)
            {
                $partialPayCount++;
            }
            else
            {
                $noPartialPayCount++;
            }

            if($this->session->userdata('poojasCartAshramId')!=$cartItem['options']['ashram_id'])
            {
                $ashramData=$this->ashrams_model->ashramData($cartItem['options']['ashram_id']);
                $result['flag']=5;
                $result['alertMessage'] = '<strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>';
                goto end;
            }
		}

        // dont allow more than one partial payments, if all cart items are partial pay items
        if($partialPayCount>1 && $partialPayCount == $validItems)
        {
            $this->session->set_flashdata("partial_payment_error",1);
            $result['flag']=2;
            goto end;
        }


		//Check all items in cart are valid
		if($validItems!=$totalItems)
		{
			$result['flag']=0;
	 		goto end;
		}

		end:
		echo json_encode($result);

	}
    public function pay()
    {
   		//Check site settings
    	$result['flag']=0;
    	if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=3;
			goto end;
		}
    	if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}

		//Get cart DB record
		if($GLOBALS['poojaCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['poojaCartStartedOn']);
			if(time()>=$startedOn)
			{
				$result['time_exceed']=1;
			}
			$result['flag']=5;
			goto end;
		}
		

	 	//Validate form data
	 	if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) ||
	 			!isset($_POST["preferred_name"]) ||
				!isset($_POST["email"]) || !isset($_POST["phone"]) ||
				!isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) ||
				!isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) ||
				!isset($_POST["donation_initials"]))
		{
	 		goto end;
		}

		//Get trust accounts for Ashram and Currency defined
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("poojasCartAshramId"),1);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$customData['trustData']=$trustsArray[strtolower($this->session->userdata("defaultCurrency"))];

		$this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
		$this->form_validation->set_rules('email', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
		$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
		$this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('country', 'Country','trim|required|checkCountry');
		$this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
		$this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');
		if($this->currentUser->admin==1)
		{
			$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkAdminPaymentMode');
			$paymentMode=$this->input->post("payment_mode");
		}
		else
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

        if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode=='paypal')
        {
            if(isset($_POST["credit_card_id"]) && $_POST["credit_card_id"] !='')
            {
                $creditCardData=$this->credit_cards_model->getCard($_POST["credit_card_id"]);
                if(empty($creditCardData))
                {
                    goto end;
                }
            }
            else
            {
                if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode!='stripe' && $paymentMode!='cash')
                {
                    $this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
                    $this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
                    $this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
                    $this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
                }
            }
        }

		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
	 		goto end;
		}

		//Validate Cart items
		$this->cart_model->validateCart($this->poojascart);

		//Check cart items count
		$cartContents=$this->poojascart->contents();
		if(empty($cartContents)) //If cart is empty
		{
			$result['flag']=2;
	 		goto end;
		}

		$totalItems=count($cartContents);
		$validItems=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['status']==1)
			{
				$validItems++;
			}
		}

		//Check all items in cart are valid
		if($validItems!=$totalItems)
		{
			$result['flag']=4;
	 		goto end;
		}

		//Capture User ID
		$userId=0;

		if($this->session->userdata("loggedIn"))
		{
			if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$tData=$this->session->userdata('temp_checkout_user');
					$userId=$tData->id;
				}
			}
			else
			{
				$userId=$this->currentUser->id;
			}
		}

		

    	$amount=$this->cart_model->getTotalPrice($this->poojascart);

    	//Decide trust based on Currency
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		//$customData['trustData']=$trustsArray['inr'];
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		//$customData['trustData']=$trustsArray['usd'];
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}

    	$this->load->model('ashrams/ashrams_model');

    	//Define custom data before initializing transaction
    	$created_by_user_id=0;
    	$created_by=0;
		$userData=array();
		if($this->session->userdata('id'))
		{
			if($this->session->userdata('temp_checkout_user'))
			{
				$userData=$this->session->userdata('temp_checkout_user');
				$userId=$userData->id;
			}
			$created_by=1;
		}
		else if($this->session->userdata('user_id'))
		{
			$userId=$this->session->userdata('user_id');
			$userData=$this->currentUser;
			$created_by=2;
		}

		$this->cart_log_model->log("Payment initiated",$this->session->userdata("poojasCartAshramId"),1);

		//If payment mode not set or payment mode is default
		if(!isset($paymentMode) || $paymentMode=='default')
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

		if($this->session->userdata('loggedIn'))
			$created_by_user_id=$this->currentUser->id;

		$customData['cartData']=$cartContents;
		$customData['formData']=$_POST;
		$customData['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("poojasCartAshramId"));
		$customData['cart_type']=1;
		$customData['paymentMode']=$paymentMode;
		$customData['created_by']=$created_by;
		$customData['created_by_user_id']=$created_by_user_id;
		$customData['model']="orders/orders_model";
		$customData['model_name']="orders_model";
		$customData['ip_address']=$_SERVER['REMOTE_ADDR'];
		$customData['formData']['ashram_id']=$this->session->userdata("poojasCartAshramId");

		$customData['formData']['is_manual_payment']=0;
		if($this->input->post("is_manual_payment"))
		{
			$customData['formData']['is_manual_payment']=1;
		}

        #--------------------------------------------------------------------------------------#
        //Which will validate Item Ashram ID and Order Ashram ID if any item mismatch with order Ashram ID It will returns flag 4 (Item modified warning and stop creating order).
        $this->load->helper("validate_order_ashram");
		$ashramCheck = validate_order_ashram(1,$cartContents,$this->session->userdata("poojasCartAshramId"),$this->session->userdata("poojasCartAshramIdSelection"));
        if($ashramCheck)
        {
            $result['flag']=4;
            goto end;
        }
        #--------------------------------------------------------------------------------------#


		$customData['amount_in_words']=$this->general_model->amountToWords($amount);
		//Load payment model
		$this->load->model("payment_model");
		//Load Temp payments model
		$this->load->model("temp_payments_model");
		$reference=$this->payment_model->setTempInfo(
			$userId,
			$userData,
			$amount,
			base_url."poojas/",
			base_url."poojas/checkout?ashram_id=".$this->session->userdata("poojasCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"),
			$customData,
			$this->session->userdata("defaultCurrency")
			);
		$result['flag']=1;
		$result['reference']=$reference;
		$this->cart_model->updateReferenceId($reference,1);

		$result['payment_mode']=$paymentMode;

        $tempOrderId = 0;
        $tempPaymentId = "";
        if($paymentMode=='razorpay')
        {
            $this->load->model("razorpay_webhook_model");
            $tempData = $this->razorpay_webhook_model->createTempOrders($reference,$this->session->userdata("poojas_temp_reference"));

            $tempOrderId = $tempData["order_id"];
            $tempPaymentId = $tempData["payment_id"];
        }

        if($paymentMode=='stripe')
        {
            $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
            $result['temp_reference']=$temp_reference;
            $this->load->model("stripe_webhook_model");
            $str_amount = $amount*100;
            $tempData = $this->stripe_webhook_model->createTempOrders($reference,$temp_reference);
            $checkoutSession = $this->stripe_webhook_model->createStripeSession($this->session->userdata("defaultCurrency"),$this->input->post("email"),$customData['trustData'],1,$cartContents,$str_amount,$reference,$customData,$userId,$this->session->userdata("poojasCartAshramIdSelection"));
            if($checkoutSession["status"] == "error")
            {
                $result['flag']=10023;
                $result['error_msg']=$checkoutSession['status_message'];
                goto end;
            }
        }
		if($this->session->userdata("defaultCurrency")=='usd')
		{
			$result['currency']="USD";
			if($paymentMode=='paypal')
			{
				$result['flag']=101;

				$this->load->model("paypal_model");
                $creditCardData = array();
				$paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
				if($paypalResponse['flag']==1)
				{
					$result['redirect_to']=$paypalResponse['redirect_url'];
					$result['payment_status']=1;
					$this->session->set_flashdata("order_placed",1);
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
				}
				else
				{
					$result['payment_status']=0;
					$result['error_msg']=$paypalResponse['error_msg'];
					$this->cart_model->updateReferenceId('',1);
					$this->cart_log_model->log("Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("poojasCartAshramId"),1);
				}
			}
			if($paymentMode=='authorize.net')
			{
				$this->load->model("authorizenet_model");
				$authnetResponse=$this->authorizenet_model->processOneTimePayment($reference);
				if($authnetResponse['flag']==1)
				{
					$result['redirect_to']=$authnetResponse['redirect_url'];
					$result['payment_status']=1;
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
					$this->session->set_flashdata("order_placed",1);
				}
				else
				{
					$result['payment_status']=0;
					$result['error']="Error making payment";//$authnetResponse['error_msg'];
					$this->cart_model->updateReferenceId('',1);
					$this->cart_log_model->log("Payment failure:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
				}
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
				$result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
				$result['prefill_email']=$this->input->post("email");
				$result['prefill_contact']=$this->input->post("phone");
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
			}

			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}
		else if($this->session->userdata("defaultCurrency")=='inr')
		{
			if($paymentMode=='payu')
			{
				$result['payment_mode']="payu";
				$result['redirect_to']='/payment/direct/'.$reference;
				$this->cart_log_model->log("Redirected to payment gateway:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
				$result['currency']="INR";
				$result['payment_mode']="razorpay";
				$result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
				$result['prefill_email']=$this->input->post("email");
				$result['prefill_contact']=$this->input->post("phone");
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
			}
			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}
		else
		{
			$result['flag']=0;
			unset($result['reference']);
			$result['error_msg']='Invalid request. Please try again later.';
		}

		end:
		echo json_encode($result);
    }

    public function receipt($tx='')
	{
		if($tx!='')
		{
			$this->load->model('orders/orders_model');
			$orderData=$this->orders_model->orderDataByTx($tx);
			if(!empty($orderData))
			{
				$this->load->model('locations_model');
				$data = array('orderData'=>$orderData,"tx"=>$tx);
				$data['views'] = array('orders/public/receipt');
				$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
			else
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
		}
		else
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function load_user_temp($uid=0)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$userData=$this->users_model->userData($uid);
			if(!empty($userData))
			{
				if($userData->status==1 && $userData->deleted==0 && $userData->email_verified==1)
				{
					unset($userData->pin);
					unset($userData->pass);
					unset($userData->conf_key);
					unset($userData->forgot_key);
					unset($userData->pin_copy);
					unset($userData->first_logged_in);
					unset($userData->security_complete);
					unset($userData->pin_set);
					unset($userData->role);
					unset($userData->roles);
					unset($userData->last_logged_in);
					$this->session->set_userdata('temp_checkout_user',$userData);
					$data['flag']=1;
					$data['userdata']=$userData;

					$this->load->library('donationscart');
					$this->load->library('storecart');
					$this->load->library('subscriptionscart');
					// $this->cart_model->emptyAllCarts();

				}
				else
				{
					$data['flag']=2;
				}
			}
			else
			{
				$data['flag']=2;
			}
		}
		header("Content-Type:application/json");
		echo json_encode($data);
	}

	public function poojaonSwamiji()
	{
		$cartId = $this->input->post('cartId');
		$check = $this->input->post('check');
		$cartsessId = $this->input->post('cartsessId');
		if($cartId && $check && $cartsessId)
		{
			if($check == "yes")
			{
				$poojacart = $this->session->userdata('swamijipooja');
				$arrays = isset($poojacart)?$poojacart:array();
				$array_merge['swamijipooja'] = array_merge($arrays,array($cartsessId=>$cartId));
	       		$this->session->set_userdata($array_merge);
			}
			if($check == "no")
			{
				unset($_SESSION['swamijipooja'][$cartsessId]);
			}
		}	
	}


	public function poojaOnFamilyTypeChange()
	{
        $result['flag']=1;
        if($GLOBALS['poojaCartLocked']==1)
        {
            echo 11;
            goto end;
        }
        //Get Pooja Item Key
        $poojaItemRowKey = "";
        $poojaItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
        if(!$poojaItemRowKey || $poojaItemRowKey=='' )
        {
            echo 12;
            goto end;
        }
        $this->form_validation->set_rules('pooja_on_family_type', 'Pooja on Family Type', 'trim|required|checkPoojaOnFamilyType');
         if($this->form_validation->run() == FALSE)
        {
            echo 12;
            goto end;
        }
        //Get cart item options
        $itemOpt=$this->poojascart->product_options($poojaItemRowKey);
        if(empty($itemOpt))
        {
            echo 13;
            goto end;
        }
        //Update pooja on family type to cart
        $itemOpt['pooja_on_family_type']=$this->input->post('pooja_on_family_type');
        $upd= array(
                 'rowid' => $poojaItemRowKey,
                 'options'   => $itemOpt);
        $this->poojascart->update($upd);
        end:
        return $result;
	}

    /*
    public function poojaOnFamilyTypeChange_old()
    {
        $result['flag']=1;
        if($GLOBALS['poojaCartLocked']==1)
        {
            echo 11;
            goto end;
        }
        $cartId = $this->input->post('cartId');
        $poojaonFamilyType = $this->input->post('poojaonFamilyType');
        $cartsessId = $this->input->post('cartsessId');
        if($cartId && $poojaonFamilyType && $cartsessId)
        {
            $poojacart = $this->session->userdata('poojaonFamilyType');
            $arrays = isset($poojacart)?$poojacart:array();
            $array_merge['poojaonFamilyType'] = array_merge($arrays,array($cartsessId=>$poojaonFamilyType));
            $this->session->set_userdata($array_merge);
        }

        end:
        return $result;
    }
    */

    public function poojaOnFamilyMemberChange()
    {
        $result['flag']=1;
        if($GLOBALS['poojaCartLocked']==1)
        {
            echo 11;
            goto end;
        }
        //Get Pooja item row key
        $poojaItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
        //Get Pooja on family members
        $poojaonFamilyMembers = ($this->input->post('pooja_on_family_members')) ? $this->input->post('pooja_on_family_members'): "";
        //Get cart item options
        $itemOpt=$this->poojascart->product_options($poojaItemRowKey);
        if(empty($itemOpt))
        {
            echo 13;
            goto end;
        }
        // echo '<pre>'; print_r($itemOpt);die();
        if($poojaItemRowKey && $poojaonFamilyMembers && isset($itemOpt['pooja_on_family_type']) && in_array($itemOpt['pooja_on_family_type'], array('2','3')))
        {
            if(!$poojaItemRowKey || $poojaItemRowKey=='' || !$poojaonFamilyMembers || $poojaonFamilyMembers=='')
            {
                echo 12;
                goto end;
            }

            if($this->currentUser->admin==1)
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
                }
            }
            else
            {
                $checkoutUserId = $this->currentUser->sso_user_id;
            }
            $donors = $this->donors_model->getUserDonorIds($checkoutUserId);
            $poojaonFamilyMembersarr = $poojaonFamilyMembers;
            foreach($poojaonFamilyMembersarr as $familyMember)
            {
                if($familyMember=='' || !is_numeric($familyMember) || $familyMember==0 || !in_array($familyMember, $donors))
                {
                    echo 14;
                    goto end;
                }
            }
            if($itemOpt['pooja_on_family_type']==2)
            {
                $poojaonFamilyMembersarr = $donors;
            }
            //Update pooja on family member to cart
            $itemOpt['pooja_on_family_members']=$poojaonFamilyMembersarr;
            $upd= array(
                     'rowid' => $poojaItemRowKey,
                     'options'   => $itemOpt);

            $this->poojascart->update($upd);
        }
        end:
        return $result;
    }


    /*
	public function poojaOnFamilyMemberChange_old()
	{
        $result['flag']=1;
        if($GLOBALS['poojaCartLocked']==1)
        {
           echo 11;
            goto end;
        }
		$cartId = $this->input->post('cartId');
		$poojaonFamilyMembers = $this->input->post('poojaonFamilyMembers');
		$cartsessId = $this->input->post('cartsessId');
		if($cartId && $poojaonFamilyMembers && $cartsessId)
		{
			$poojacart = $this->session->userdata('poojaonFamilyMembers');
			$arrays = isset($poojacart)?$poojacart:array();
			$array_merge['poojaonFamilyMembers'] = array_merge($arrays,array($cartsessId=>$poojaonFamilyMembers));
       		$this->session->set_userdata($array_merge);
		}

        end:
        return $result;
	}
    */


    public function poojaOnPoornaphalaTieByChange()
    {
        $result['flag']=1;
        if($GLOBALS['poojaCartLocked']==1)
        {
           echo 11;
            goto end;
        }
        $cartId = $this->input->post('cartId');
        $poornaphalaTieBy = $this->input->post('poornaphala_tie_by');
        //Get Pooja item row key
        $poojaItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
        //Get cart item options
        $itemOpt=$this->poojascart->product_options($poojaItemRowKey);
        if(empty($itemOpt))
        {
          echo 13;
          goto end;
        }
        //Update poornaphala_tie_by to cart
        $itemOpt['poornaphala_tie_by']=$poornaphalaTieBy;
        $upd= array(
              'rowid' => $poojaItemRowKey,
              'options'   => $itemOpt);
        $this->poojascart->update($upd);

        end:
        return $result;
    }

	//Attend Pooja in-person
    public function attendPoojaInPersonChange()
    {
        $result['flag']=1;
        if($GLOBALS['poojaCartLocked']==1)
        {
           echo 11;
            goto end;
        }
        $attendpoojaInPerson = $this->input->post('attend_pooja_in_person');
		 //Get Pooja item row key
		 $poojaItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
		  //Get cart item options
		  $itemOpt=$this->poojascart->product_options($poojaItemRowKey);
		  if(empty($itemOpt))
		  {
			  echo 13;
			  goto end;
		  }
         //Update pooja on family member to cart
		 $itemOpt['attend_pooja_in_person']=$attendpoojaInPerson;
		 $upd= array(
				  'rowid' => $poojaItemRowKey,
				  'options'   => $itemOpt);
		 $this->poojascart->update($upd);

        end:
        return $result;
    }


	public function clearCart()
	{
		$result['flag']=0;
		$cart=$this->poojascart->contents();
		if(empty($cart))
    	{
    		$result['flag']=2;
    	} else {
    		foreach ($cart as $key => $value)
    		{
    			if(isset($key) && $key!='')
				{
					$item=$this->poojascart->get_item($key);
					if(!empty($item))
					{
						$upd= array(
			               'rowid' => $key,
               				'qty'   => 0
				            );
						$this->poojascart->update($upd);
						$this->logaction->log($this->service,"Pooja removed from cart _ Pooja ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
						$cc=$this->poojascart->contents();
						$this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);
					}
				}
    		}
    		$cc=$this->poojascart->contents();
			if(count($cc)==0)
			{
				$this->session->unset_userdata('poojasCartAshramId');
				$result['flag']=1;
				$result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('poojasCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('poojasCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
			} else {
				$result['flag']=3;
				$result['cart_count']=count($cc);
			}
            $this->cart_model->regenerateSession(1);
    	}
		
		end:
		echo json_encode($result);
	}



	public function changeListType()
    {
    	$list_type = $this->input->post('list_type');
		if($list_type)
		{
			$this->session->set_userdata('poojas_list_type', $list_type);
			$data['flag']=1;
			echo json_encode($data);
			return;
		} else {
			$data['flag']=0;
			echo json_encode($data);
			return;
		}
    }

    public function addItemAgain()
    {
        $result['flag']=0;
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $result['flag']=55;
            goto end;
        }
        if($GLOBALS['site_settings']['poojas']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
        {
            $result['flag']=12;
            $result['error_msg']="Poojas are disabled";
            goto end;
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
                $result['flag']=51;
                goto end;
            }
            
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
        {
            if(!$this->session->userdata('temp_checkout_user'))
            {
                $result['flag']=12;
                $result['error_msg']='Please select user before adding Pooja to cart.';
                goto end;
            }
        }

        if($GLOBALS['poojaCartLocked']==1)
        {
            $result['flag']=11;
            goto end;
        }

        //Check cart items count
        $cartContents=$this->poojascart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $result['flag']=56;
            goto end;
        }

        if(isset($_POST['key']) && $_POST['key']!='')
        {
            $item=$this->poojascart->get_item($_POST['key']);
            if(!empty($item))
            {
                $result = $this->addItem($item['id'],'',$_POST['key']);
                exit;
            }
            else
            {
                $result['flag']=2;
            }
        }
        end:
        echo json_encode($result);
    }

    public function updateOtherName($othernamefor=0)
    {
        if($GLOBALS['poojaCartLocked']==1)
        {
            echo 2;
            return;
        }
        if(!in_array($othernamefor, [1,2,3,4,5,6,7,8,9,10]))
        {
            echo 0;
            return;
        }

        $this->form_validation->set_rules('value', 'Name','trim|required|min_length[2]|max_length[60]');
        $this->form_validation->set_rules('pk', 'ID', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            echo 0;
            return;
        }
        $item=$this->poojascart->get_item($_POST['pk']);
        $options=$this->poojascart->product_options($_POST['pk']);
        if(!empty($options))
        {
            $options['other_name'.$othernamefor]=$_POST['value'];
            $updateArray= array(
                       'rowid' => $_POST['pk'],
                           'options'   => $options
                        );
            $this->poojascart->update($updateArray);
            $this->cart_log_model->log("Other name updated, Item name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);
            echo 1;
        }
        else
        {
            echo 0;
        }
    }

    public function removeOtherName()
    {
        $rowKey = '';
        $otherNameId = '';
        if(isset( $_POST['rowKey']) &&  $_POST['rowKey']>0)
        {
            $rowKey = $_POST['rowKey'];
        }
        if(isset( $_POST['otherNameId']) &&  $_POST['otherNameId']>0)
        {
            $otherNameId = $_POST['otherNameId'];
        }
        if($GLOBALS['poojaCartLocked']==1)
        {
            echo 2;
            return;
        }
        if(!in_array($otherNameId, [1,2,3,4,5,6,7,8,9,10]))
        {
            echo 0;
            return;
        }

        $this->form_validation->set_rules('rowKey', 'Row Key', 'trim|required');
        $this->form_validation->set_rules('otherNameId', 'Other Name ID', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            echo 0;
            return;
        }
        $item=$this->poojascart->get_item($_POST['rowKey']);
        $options=$this->poojascart->product_options($_POST['rowKey']);
        if(!empty($options))
        {  
            if($otherNameId>0)
            {
                $deletedName = $options['other_name'.$otherNameId];
                $deletingId = $otherNameId;
                for($deletingId = $otherNameId; $deletingId<=10; $deletingId++)
                {
                    if($deletingId==10)
                    {
                        $options['other_name'.$deletingId] = "";
                    } else {
                        if(isset($options['other_name'.($deletingId+1)]) && $options['other_name'.($deletingId+1)]!='')
                        {
                            $options['other_name'.$deletingId] = $options['other_name'.($deletingId+1)];
                        }
                        else
                        {
                            $options['other_name'.$deletingId] = '';
                        }
                    }
                }
                $updateArray= array(
                       'rowid' => $_POST['rowKey'],
                           'options'   => $options
                        );
                $this->poojascart->update($updateArray);
                $this->cart_log_model->log($deletedName." name deleted, Item name:".$item['name'],$this->session->userdata("poojasCartAshramId"),1);
                echo 1;
            }
        }
        else
        {
            echo 0;
        }
    }

}
?>
