<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Petsadmin extends CI_Controller 
{
	var $currentUser='';
	var $service="pets";
	function __construct()
    {
        parent::__construct();
		
		$this->load->model("user/users_model");
		$this->load->model("pets_model");
		$this->currentUser=$this->session->userdata("admin_data");
    }

	public function index()
	{
		$data = array('views'=>array("pets/admin/list"));
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listc($excel=0)
	{
		$list=$this->pets_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Pets listing ajax request");
	}

	public function pet_form($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$petData=$this->pets_model->petData($id);
			if(empty($petData))
			{
				$id=0;
			}
		}
		else
		{
			$petData=array();
		}
		$data['id']=$id;
		$data['petData']=$petData;
		$data['admin']=1;
		echo $this->load->view("pets/admin/_pet_modal",$data,true);
	}

	public function edit_pet($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)
		{
			$petData=$this->pets_model->petData($id);
			if(empty($petData))
			{
				$result['msg']="Invalid pet";
				goto end;
			}
		}
		else
		{
			$petData=array();
		}


		if(!isset($_POST['pet_name']))
		{
			$result['msg']="Invalid request";
			goto end;
		}

		$this->form_validation->set_rules('pet_name', 'Name', 'trim|required|min_length[2]|max_length[200]');
		$this->form_validation->set_rules('pet_type', 'Type', 'trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('pet_serial_number', 'Serial Number', 'trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('pet_species', 'Species', 'trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('pet_description', 'Description', 'trim|required|max_length[2500]');

		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
			$result['msg']="Invalid request";
			goto end;
		}

		if(isset($_FILES['pet_profile_image']))
			if($_FILES['pet_profile_image']['name']!='')
			{
				if($_FILES['pet_profile_image']['size']==0)
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$ext=pathinfo ($_FILES['pet_profile_image']['name'],PATHINFO_EXTENSION);

				if($ext=='')
				{
					$result['msg']="Invalid photo type";
					goto end;	
				}
				if(!getimagesize($_FILES['pet_profile_image']['tmp_name']))
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$file=1;
			}

		$saved=$this->pets_model->save($id,$petData);
		if($saved)
		{
			$result['flag']=1;
		}
		else
		{
			$result['flag']=2;
		}


		end:
		echo json_encode($result);
	}

	public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$petData=$this->pets_model->petData($id);
			if(empty($petData))
			{
				goto end;
			}
			$this->load->model("orders/orders_model");
			$count=$this->orders_model->orderItemsCountByPetId($id);
			if($count>0)
			{
				$data['flag']=2;
				$data['name']=$petData->pet_name;
				goto end;
			}
			$r=$this->pets_model->delete($id,$petData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$petData->pet_name;
				$this->logaction->log($this->service,"Petsadmin - Pet '".$petData->pet_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
}
?>