<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Paypal extends CI_Controller 
{
	var $currentUser='';
	var $service="payments";
	public function __construct() 
	{
		parent::__construct();
		$this->load->library("userutil");
		if($this->session->userdata('loggedIn'))
			$this->currentUser=$this->session->userdata('user_data');
		$this->load->model('payment_model');
	}
	
	public function add_funds()
	{
		$tx=$_GET['tx'];
		$transaction=$this->payment_model->getTransaction($tx);
		sleep(10);
		$ok=0;
		if(!empty($transaction))
		{
			if($transaction->status=='Completed')
			{
				$ok=1;
				$this->session->set_flashdata("transaction_ok",1);
				$this->session->set_flashdata("transaction_currency",$transaction->paypal_currency);
				$this->session->set_flashdata("transaction_amount",round($transaction->amount,0));
			}
			else
			{
				$this->session->set_flashdata("transaction_failed",'1');
			}
			if($this->session->userdata("user_id"))
			{
				redirect($transaction->redirect_url);
			}
			else
			{
				$this->logaction->log($this->service,"PayPal receive payments - Session expired | Redirected to Status page | Txnid: ".$_GET['tx']);
				redirect("status");
			}
		}
		else
		{
			if(isset($_GET['st']) && $_GET['st']=='Completed')
			{
				$this->session->set_flashdata("transaction_pending",'1');
			}
			else
			{
				$this->session->set_flashdata("transaction_failed",'1');
			}
			$this->logaction->log($this->service,"PayPal Browser redirect - Payment not yet received - Redirected to Status page - Txnid: ".$_GET['tx']." - Status: ".$_GET['st']);
			redirect("status");
			exit;
		}
		$this->session->unset_userdata("transaction_process_online");
	}

	public function ipn()
	{
		if(isset($_POST['txn_type']) && $_POST['txn_type']=='cart')
		{
			$ipn=$this->payment_model->getPaypalIpn($_POST['txn_id']);		
			if(empty($ipn))
			{
				$archivesDb = $this->load->database("data_archives",true,false);
				$archivesDb->insert("paypal_ipn",
						  array(
							'info'=> serialize($_POST),
						  'residence_country'=> $_POST['residence_country'],
						  'invoice'=> $_POST['invoice'],
						  'address_city'=> $_POST['address_city'],
						  'first_name'=> $_POST['first_name'],
						  'last_name'=> $_POST['last_name'],
						  'payer_id'=> $_POST['payer_id'],
						  'txn_id'=> $_POST['txn_id'],
						  'receiver_email'=> $_POST['receiver_email'],
						  'custom'=> $_POST['custom'],
						  'payment_date'=> date("Y:m:d H:i:s",strtotime($_POST['payment_date'])),
						  'address_country_code'=> $_POST['address_country_code'],
						  'item_name'=> $_POST['item_name1'],
						  'tax'=> $_POST['tax'],
						  'address_name'=> $_POST['address_name'],
						  'receiver_id'=> $_POST['receiver_id'],
						  'verify_sign'=> $_POST['verify_sign'],
						  'address_country'=> $_POST['address_country'],
						  'payment_status'=> $_POST['payment_status'],
						  'address_status'=> $_POST['address_status'],
						  'business'=> $_POST['business'],
						  'payer_email'=> $_POST['payer_email'],
						  'notify_version'=> $_POST['notify_version'],
						  'txn_type'=> $_POST['txn_type'],
						  'payer_status'=> $_POST['payer_status'],
						  'mc_currency'=> $_POST['mc_currency'],
						  'item_number'=> $_POST['item_number1'],
						  'address_state'=> $_POST['address_state'],
						  'payment_type'=> $_POST['payment_type'],
						   'amount'=> $_POST['mc_gross'],
						  'address_street'=> $_POST['address_street'],
						  'dt'=> date("Y:m:d H:i:s")
						  
						  )
						  
						  
						  );
				$this->logaction->log($this->service,"Paypal IPN - IPN received | Txnid:".$_POST['txn_id']." | Amount: ".$_POST['mc_gross'].
					" | Status: ".$_POST['payment_status']);

				$transaction=$this->payment_model->getTransaction($_POST['txn_id']);
				if(empty($transaction))
				{
					$tempIpn=$this->payment_model->getPaypalIpn($_POST['txn_id']);
					$reference=$_POST['custom'];
					$tempInfo=$this->payment_model->getTempInfo($reference);
					if(!empty($tempInfo) && $tempInfo->status==0)
					{
						$transaction=$this->payment_model->getTransaction($_POST['txn_id']);
						$transaction->tx=$_POST['txn_id'];
						$tempIpn->status=$tempIpn->payment_status;
						$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
					}
					else
					{
						$this->logaction->log($this->service,"PayPal receive payments - Error: Direct payment reference invalid | Ref:".$reference." | Txnid: ".$_POST['txn_id']);
						goto end;
					}
				}
				else
				{
					goto end;
				}
			}
			else
			{
				goto end;
			}
		}
		else
		{
			$this->logaction->log($this->service,"Paypal IPN - IPN Error | Txnid:".$_POST['txn_id']);
			$archivesDb = $this->load->database("data_archives",true,false);
			$archivesDb->insert("paypal_ipn",
						  array(
								'info'=> serialize($_REQUEST))
						  );
			goto end;
		}
		if(0)
		{
			end:
			$vdata['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$vdata);
		}
	}
}
?>