<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Payment extends CI_Controller 
{
	var $currentUser=array();
	var $service="payments";
	function __construct() 
	{
		parent::__construct();
		$this->load->model("payment_model");
		$this->load->library("userutil");
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata('user_data');
		}
	}
	public function direct($reference='')
	{
		if($reference!='')
		{
			$tempInfo=$this->payment_model->getTempInfo($reference);
			if(!empty($tempInfo))
			{
				$data['amount']=$tempInfo->amount;
				$data['uid']=$tempInfo->user_id;
				$data['currency']=$tempInfo->currency;
				$data['customData']=unserialize($tempInfo->data);
				$data["txnid"]=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
				$data['reference']=$reference;
				$orderId=0;
	    		if(isset($data['customData']['order_id']))
	    			$orderId=$data['customData']['order_id'];

				if(strtolower($tempInfo->currency)=='inr')
				{
					$this->logaction->log($this->service,"Direct payment method for - Ref:".$reference.", redirected to PayU - Txnid:".$data['txnid']);
					$tData = $this->payment_model->createTransaction($data['txnid'],$tempInfo->user_id,$reference,'initiated',null,$orderId);
					$tData = $this->payment_model->tempInfoUpdateTx($reference,$data['txnid'],$data['amount'],$tData);
					//saving transaction table 
					$this->payment_model->saveTransaction($tData);

					$body=$this->load->view("users/user/_transaction_initiated_notification",$data,true);
				    $subject=$data['customData']['trustData']->ashram_name." - Transaction # ".$data['txnid'];
				    $this->email_extension->sendMailGuest($this->service,$data['customData']['formData']['firstname'],$data['customData']['formData']['email'],$subject,$body,'',1);
				    $this->logaction->log($this->service,"Email sent _ Sub: ".$subject);
				    if(isset($customData['cartData']))
				    	$this->cart_log_model->log("PayU Tx ID:".$data['txnid'],$data['customData']['ashramData']->id,$data['customData']['cart_type']);
					$this->load->view('users/user/payu_add_funds',$data);
				}
				else
				{
					//$this->logaction->log($this->service,"Direct payment method for - Ref:".$reference.", redirected to PayPal - Txnid:".$data['txnid']);
					$tData = $this->payment_model->createTransaction($data['txnid'],$tempInfo->user_id,$reference,'initiated',null,$orderId);
					$tData = $this->payment_model->tempInfoUpdateTx($reference,$data['txnid'],$data['amount'],$tData);
					//saving transaction table 
					$this->payment_model->saveTransaction($tData);
					$this->logaction->log($this->service,"Direct payment method for - Ref:".$reference.", redirected to PayPal");

					ob_start();
					$this->load->view("users/user/_transaction_initiated_notification",$data);
					$body=ob_get_clean();
				    $subject=site_name_string1." - Transaction # ".$data['txnid'];
				    $this->email_extension->sendMailGuest($this->service,$data['customData']['formData']['firstname'],$data['customData']['formData']['email'],$subject,$body,'',1);
				    $this->logaction->log($this->service,"Email sent _ Sub: ".$subject);
					$this->load->view('users/user/paypal_add_funds',$data);
				}
			}
			else
			{
				$this->logaction->log($this->service,"Direct payment method - Invalid Ref:".$reference."  - redirected back");
				redirect(urldecode($_GET['redirect']));
			}
		}
		else
		{
			$this->logaction->log($this->service,"Direct payment method - Reference id is empty  - redirected back");
			redirect($_SERVER['HTTP_REFERER']);
		}
	}
}
?>