<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Page extends CI_Controller 
{
	var $currentUser='';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/pages_model');
		$this->load->model('content/page_attachments_model');
		$this->load->model('content/album_model');
        $this->load->model('content/album_images_model');
        $this->load->model('category/categories_model');
        $this->categories_model->fetchCategories();
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
       	$this->load->driver('cache');
    }
   	public function view($slug='')
	{
		if($slug!='')
		{
			$pageData=$this->pages_model->pageDataBySlug($slug);
			if(!empty($pageData['page']) && strtotime($pageData['page']->published_on)<=time())
			{
				$this->pages_model->fetchPages();
				/*if($this->session->userdata("loggedIn") && $this->currentUser->role!=1)
				{
					$this->pages_model->updateReadCount($pageData['page']->id,($pageData['page']->reads+1));
				}*/

				$data = array('pageData'=>$pageData);
				$data['views'] = array('pages/public/view');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
			}
		}
		$data['views'] = array('common/public/error');
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function category($category='') 
	{
		$data = array('category'=>$category);
		if(isset($this->categories_model->categoriesList['categories'][$category]))
		{
			$data['categoryExist']=1;
			$data['categoryName']=htmlentities($this->categories_model->categoriesList['categories'][$category]->category);
			$data['categoryId']=$this->categories_model->categoriesList['categories'][$category]->id;
		}
		else
		{
			$data['categoryName']="All Categories";
			$data['categoryId']=0;
		}
		$data['views'] = array('pages/public/category_view');
		$this->load->view(FRONTEND_TEMPLATE,$data);
    }
    public function listbycategory($categorySlug='')
	{
		$categoryId=0;
		if(isset($_POST['category']))
		{
			$category=$_POST['category'];
			if(isset($this->categories_model->categoriesList['categories'][$category]))
			{
				$categoryId=$this->categories_model->categoriesList['categories'][$category]->id;
			}
		}
		$list=$this->pages_model->listPublicByCategory($categoryId);
		echo json_encode($list);
	}
}
?>
