<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Myswamijifiles extends CI_Controller
{
	var $currentUser='';
    function __construct()
	{
        parent::__construct();
       	if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		if($this->session->userdata("force_change_password")==1)
		{
			$this->session->set_flashdata("reset_password_force",1);
			redirect("myaccount/change_password");
		}
		$this->load->model("swamijifiles/user_files_model");
    }
	public function index()
	{
		$data['files']=$this->user_files_model->getFilesUser($this->currentUser->id);
		$data['views']=array("swamijifiles/user/upload");
		$this->load->view(USER_TEMPLATE,$data);
	}
	function uploadattachments()
	{
		$exts=$GLOBALS['site_settings']['blocked_file_types'];
		$excludedExtensions=explode("|",$exts);
		
		$json['files']=[];
		if(isset($_FILES['files']))
		{
			foreach ($_FILES['files']['name'] as $key => $file) 
			{
				$ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);

				if($_FILES['files']['size'][$key]==0)
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Invalid File Size",
		            'status'=>0
		        	);
				}
				else if($_FILES['files']['size'][$key]>(100*1024*1024))
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "File Size exceeded 100MB",
		            'status'=>0
		        	);
				}	
				else if($ext=='' || in_array($ext,$excludedExtensions))
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Extension not allowed",
		            'status'=>0
		        	);
				}
				else
				{	
	        		$json['files'][0]=$this->user_files_model->uploadFile($this->currentUser->id);
	        		$json['files'][0]['name']=$file;
	        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
	        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
	        		$json['files'][0]['status']=1;
	        	}
			}
			echo json_encode($json);
		}
	}

	function deleteattachment($attachmentId=0)
	{
		$data['flag']=0;
		if(is_numeric($attachmentId) && $attachmentId)
		{
			$attachmentData=$this->user_files_model->attachmentData($attachmentId);
			if(!empty($attachmentData) && $attachmentData->user_id==$this->currentUser->id)
			{
				$r=$this->user_files_model->delete($attachmentData);
				if($r)
				{
					$data['flag']=1;
					$data['filename']=$attachmentData->filename;
				}
			}
		}
		echo json_encode($data);
	}

	public function updatefileinfoattachments()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|max_length[200]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->user_files_model->updateInfo($_POST['pk'],'description',$_POST['value']);
		echo 1;
	}

	public function updatefileorderattachments()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|numeric|max_length[3]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->user_files_model->updateInfo($_POST['pk'],'order',$_POST['value']);
		echo 1;
	}

	public function download($fileId=0)
	{
		$flag=0;
		if(is_numeric($fileId) && $fileId)
		{
			$fileData=$this->user_files_model->attachmentData($fileId);
			if(empty($fileData))
			{
				goto end;
			}
			
			if($fileData->user_id==$this->currentUser->id)
			{
				$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
				
				$amazonUri="private_files/user_swamiji_files/".$fileData->user_id."/".$fileData->filename;
				header("Cache-Control: public");
		        header("Content-Disposition: attachment; filename=".$fileData->filename);
				$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
				echo $obj->body;
				return;
			}
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
}
?>