<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Mysatsangs extends CI_Controller 
{
	var $currentUser='';
	var $service='satsangs';
	var $months=array(1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December");
    function __construct()
	{
        parent::__construct();

		if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		if($this->session->userdata("force_change_password")==1)
		{
			$this->session->set_flashdata("reset_password_force",1);
			redirect("myaccount/change_password");
		}
		$this->load->model("satsangs/satsangs_model");
        $this->load->model("satsangs/satsang_members_model");
        $this->load->model('satsangs/satsang_calendar_model');
		$this->load->model('content/album_model');
        $this->load->model('content/album_images_model');
    }
    public function index()
	{
		$views = array( 'satsangs/user/list' );
		$data = array('views'=>$views);
		$data['satsang_countries']=$this->satsangs_model->getCountries();
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed satsangs list page");
	}
	public function listc()
	{
		$list=$this->satsangs_model->listUser();
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed satsangs list ajax request");
	}
	public function accept_invite($satsangId=0)
	{
		$data['flag']=0;
		if(is_numeric($satsangId) && $satsangId)
		{
			$satsangData=$this->satsangs_model->satsangData($satsangId);
			if(!empty($satsangData))
			{
				$iStatus=$this->satsang_members_model->checkInvite($satsangId,$this->currentUser->id);
				if($iStatus==0)
				{
					$this->satsang_members_model->acceptInvite($satsangId,$this->currentUser->id);
					$this->logaction->log($this->service,"User - Satsang invitation accepted - Satsang ID:".$satsangId);
					$data['flag']=1;
					$data['name']=$satsangData->name;
				}
				else
				{
					$data['flag']=2;
				}
			}
		}
		end:
		echo json_encode($data);
	}
	public function join($satsangId=0)
	{
		$data['flag']=0;
		if(is_numeric($satsangId) && $satsangId)
		{
			$satsangData=$this->satsangs_model->satsangData($satsangId);
			if(!empty($satsangData))
			{
				$iStatus=$this->satsang_members_model->checkInvite($satsangId,$this->currentUser->id);
				if($iStatus==-1)
				{
					$this->satsang_members_model->join($satsangId,$this->currentUser->id);
					$data['flag']=1;
					$data['name']=$satsangData->name;
				}
				else
				{
					$data['flag']=2;
				}
			}
		}
		end:
		echo json_encode($data);
	}
	public function unjoin($satsangId=0)
	{
		$data['flag']=0;
		if(is_numeric($satsangId) && $satsangId)
		{
			$satsangData=$this->satsangs_model->satsangData($satsangId);
			if(!empty($satsangData))
			{
				$iStatus=$this->satsang_members_model->checkInvite($satsangId,$this->currentUser->id);

				if($iStatus==0 || $iStatus==1 || $iStatus==2)
				{
					$this->satsang_members_model->unjoin($satsangId,$this->currentUser->id);
					$data['flag']=1;
					$data['name']=$satsangData->name;
				}
				else
				{
					$data['flag']=2;
				}
			}
		}
		end:
		echo json_encode($data);
	}

	public function calendar($slug='') 
    {
        if($slug!='')
        {
            $satsangData=$this->satsangs_model->satsangDataBySlug($slug);
            if(!empty($satsangData))
            {
            	$memberData=$this->satsang_members_model->getMember($satsangData->id,$this->currentUser->id);
            	if(!empty($memberData))
            	{
	                $yearmonths=$this->satsang_calendar_model->getYearMonths($satsangData->id);
	                $data = array('satsangData'=>$satsangData);
	                $data['yearmonths']=$yearmonths;
	                $data['views'] = array('satsangs/user/list_calendar');
	                $this->load->view(USER_TEMPLATE,$data);
	            }
	            else
	            {
	            	goto end;
	            }
            }
            else
            {
                goto end;
            }
        }
        else
        {
        	end:
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }
    public function listcalendar($slug='')
    {
        if($slug!='')
        {
            $satsangData=$this->satsangs_model->satsangDataBySlug($slug);
            if(!empty($satsangData))
            {
            	$memberData=$this->satsang_members_model->getMember($satsangData->id,$this->currentUser->id);
            	if(!empty($memberData))
            	{
	                $list=$this->satsang_calendar_model->listPublic($satsangData->id);
	                echo json_encode($list);
	            }
            }
        }
    }

    public function subscribe_satsang($satsangId=0)
	{
		$data['flag']=0;
		if(is_numeric($satsangId) && $satsangId)
		{
			$satsangData=$this->satsangs_model->satsangData($satsangId);
			if(!empty($satsangData))
			{
				$this->satsang_members_model->subscribe($satsangId,$this->currentUser->id);
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}
	public function unsubscribe_satsang($satsangId=0)
	{
		$data['flag']=0;
		if(is_numeric($satsangId) && $satsangId)
		{
			$satsangData=$this->satsangs_model->satsangData($satsangId);
			if(!empty($satsangData))
			{
				$iStatus=$this->satsang_members_model->checkInvite($satsangId,$this->currentUser->id);

				if($iStatus==0 || $iStatus==1 || $iStatus==2)
				{
					$this->satsang_members_model->unsubscribe($satsangId,$this->currentUser->id);
					$data['flag']=1;
					$data['name']=$satsangData->name;
				}
				else
				{
					$data['flag']=2;
				}
			}
		}
		end:
		echo json_encode($data);
	}
}
?>