<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Myreminders extends CI_Controller 
{
	var $currentUser='';
    function __construct() 
	{
        parent::__construct();	
		$this->load->model('others/reminders_model');
		if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		if($this->session->userdata("force_change_password")==1)
		{
			$this->session->set_flashdata("reset_password_force",1);
			redirect("myaccount/change_password");
		}
    }
	function index()
	{
		$views = array( 'reminders/user/list');
		$data = array('views'=>$views);
		$this->load->view(USER_TEMPLATE,$data);
	}
	public function listc()
	{
		$list=$this->reminders_model->listReminders();
		echo json_encode($list);
	}
	public function add_edit_reminder($id=0)
	{
		if(isset($_POST["add_reminder"]))
		{
			$this->form_validation->set_rules('title', 'Reminder Title', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('timezone', 'Timezone', 'trim|required|validTimezone');
			$this->form_validation->set_rules('reminder_date', 'Reminder Date', 'trim|required|reminderDate');
			$this->form_validation->set_rules('reminder_time', 'Reminder Time', 'trim|required');
			$this->form_validation->set_rules('remind_before', 'Remind Before', 'trim|required|numeric|remindBeforeValue');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("reminder_error",1);
				redirect('myreminders/add_edit_reminder/'.$id);
				return;
			}
			if($id)
			{
				$reminderData=$this->reminders_model->reminderData($id);
				if(empty($reminderData) || $this->currentUser->id!=$reminderData->user_id)
				{
					$this->session->set_flashdata("reminder_error",1);
					redirect("/myreminders");
				}
			}
			$saved=$this->reminders_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("reminder_saved",1);
				else
				{
					$this->session->set_flashdata("reminder_created",1);
				}
			}
			redirect('myreminders/add_edit_reminder/'.$saved);
			
		}
		else
		{
		 	$views = array( 'reminders/user/add_edit_reminder' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['reminderData']=$this->reminders_model->reminderData($id);
				if(empty($data['reminderData']) || $this->currentUser->id!=$data['reminderData']->user_id)
				{
					$this->session->set_flashdata("reminder_error",1);
					redirect("/myreminders");
				}
			}
			$this->load->view(USER_TEMPLATE,$data);
		}
	}
	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$reminderData=$this->reminders_model->reminderData($id);
			if(!empty($reminderData) && $this->currentUser->id==$reminderData->user_id)
			{
				$r=$this->reminders_model->delete($id,$reminderData);
				if($r)
				{
					$data['flag']=1;
					$data['title']=$reminderData->title;
				}
			}
		}
		echo json_encode($data);
	}
	public function myreminder()
	{
		$timezone="Asia/Kolkata";
		if(isset($_POST['timezone']))
			$timezone=$_POST['timezone'];
		$res=$this->reminders_model->getRemindersDisplay($this->currentUser->id,$timezone);
		echo json_encode($res);
	}
	
	public function myreminder_shown($id=0)
	{
		$this->load->model("others/reminders_log_model");
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$reminderData=$this->reminders_model->reminderData($id);
			if(!empty($reminderData) && $this->currentUser->id==$reminderData->user_id)
			{
				$r=$this->reminders_model->markShown($id,$reminderData);
				$data['flag']=1;
			}
		}
		echo json_encode($data);
	}
}
?>