<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Myorders extends CI_Controller 
{
	var $currentUser='';
	var $service='orders';
	var $currencies;
	var $payment_success_statuses=array("completed",'success','release payment','approved','captured','paid','Release Payment','Success');
    function __construct()
	{
        parent::__construct();
		$this->load->model("orders/orders_model");
		
		if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}

		if($this->session->userdata("force_change_password")==1)
		{
			$this->session->set_flashdata("reset_password_force",1);
			redirect("myaccount/change_password");
		}
		$this->load->model('currencies_model');
		$this->currencies=$this->currencies_model->getByAshram(0);
		$this->load->model('orders/order_log_model');
		$this->load->model('payment_model');
		$this->load->model("orders/transaction_model");
		$this->load->model("orders/subscription_payments_model");
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->model("subscriptions/donors_model");
		$this->load->model('orders/payflow_logs_model');
		$this->load->model("pets_model");
		$this->load->model('paypal_model');
		$this->load->model("refunds_history_model");
		$this->load->model('ashrams/poojas_categories_model');
		$this->load->model('ashrams/subscriptions_categories_model');
		$this->load->model('ashrams/subscriptions_categories_model');
		$this->load->model('ashrams/store_categories_model');
		$this->load->model('ashrams/donations_categories_model');
		$this->load->model('ashrams/donations_groups_model');
		//==========Load encryption library=============//

    	$this->load->library('encryption');

		$this->encryption->initialize(
		        array(
		                'cipher' => 'aes-256',
		                'mode' => 'cbc',
		                'key' => file_get_contents("../app_configs/aes_key")
		        )
		);

    	//==========Load encryption library=============//
    }
    public function index()
	{
		if(!empty($_GET["action"]) && $_GET["action"] != "no_tx_orders")
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
		$views = array( 'orders/user/list' );
		$data = array('views'=>$views);
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserPaidOrdersAshramsByUserIdByModuleId($this->session->userdata('user_id'));
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Sevas Listing");
	}

	public function no_tx_sevas()
	{
		$views = array( 'orders/user/list_no_tx_orders' );
		$data = array('views'=>$views);
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserPaidOrdersAshramsByUserIdByModuleId($this->session->userdata('user_id'), 0, 'Yes');
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed No TX Sevas Listing");
	}

	public function poojas()
	{
		if($GLOBALS['site_settings']['poojas']==0)
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
		$views = array( 'orders/user/list_poojas' );
		$data = array('views'=>$views);
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserPaidOrdersAshramsByUserIdByModuleId($this->session->userdata('user_id'), 1);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		($this->session->userdata("ashramId")) ?
			$data['categories'] = $this->poojas_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId")) :
			$data['categories'] = $this->poojas_categories_model->getList();
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Pooja Sevas Listing");
	}

	public function donations()
	{
		if($GLOBALS['site_settings']['donations']==0)
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
		$views = array( 'orders/user/list_donations' );
		$data = array('views'=>$views);
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserPaidOrdersAshramsByUserIdByModuleId($this->session->userdata('user_id'), 2);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		($this->session->userdata("ashramId")) ? $data['categories'] = $this->donations_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId")) : $data['categories'] = $this->donations_categories_model->getList();
		($this->session->userdata("ashramId")) ? $data['groups'] = $this->donations_groups_model->getGroupsListByAshramId($this->session->userdata("ashramId")) : $data['groups'] = $this->donations_groups_model->getList();
			
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Donation Sevas Listing");
	}

	public function store()
	{
		if($GLOBALS['site_settings']['store']==0)
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}

		$views = array( 'orders/user/list_store' );
		$data = array('views'=>$views);
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserPaidOrdersAshramsByUserIdByModuleId($this->session->userdata('user_id'), 3);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		($this->session->userdata("ashramId")) ?
			$data['categories'] = $this->store_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId")) : 
			$data['categories'] = $this->store_categories_model->getList($this->session->userdata("ashramId"));
		
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Store Orders Listing");
	}

	public function subscriptions()
	{
		if($GLOBALS['site_settings']['subscriptions']==0)
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}

		$views = array( 'orders/user/list_subscriptions' );
		$data = array('views'=>$views);
		if($this->session->userdata("ashramId"))
		{
			$data['donations']="";
		}
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserPaidOrdersAshramsByUserIdByModuleId($this->session->userdata('user_id'), 4);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		($this->session->userdata("ashramId")) ?
			$data['categories'] = $this->subscriptions_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId")) : $data['categories'] = $this->subscriptions_categories_model->getList();
		
		$data['pets']="";
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Subscriptions Sevas Listing");
	}

	public function summary()
	{
		$this->load->model('user_model');
		$views = array( 'orders/user/list_statement' );
		$data = array('views'=>$views);

		$currency_segment = $this->uri->segment(3);
		if(empty($currency_segment))
		    $currency_segment = "inr";

		if(in_array(global_site_flag, [4]))
        {
        	$currency_segment = "usd";
        }

		$yearData = [];
		$y=date("Y");
        if(global_site_flag==1)
        {
            $n='2015';
        }
        else
        {
            $n='2021';
        }
        for($i=$y;$i>=$n;$i--)
        {
            if($currency_segment == "inr")
            {
                
                if(date("Y") == $i && date('m')>=4)
                {
                    $inrstartdate = $i."-".financial_year_start_month_date;
                    $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                    $inrenddate = ($i+1)."-".financial_year_end_month_date;
                    $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                    $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;

                    $inrstartdate = ($i-1)."-".financial_year_start_month_date;
                    $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                    $inrenddate = ($i)."-".financial_year_end_month_date;
                    $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                	$yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                }
                else
                {
                    $inrstartdate = ($i-1)."-".financial_year_start_month_date;
                    $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                    $inrenddate = ($i)."-".financial_year_end_month_date;
                    $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                	$yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                }
                
            }
            else
            {
            	$yearData[$i] = $i;
            }
        }

		$year_segment = $this->uri->segment(4);
		if(empty($year_segment))
		{
			$yearcount = 0;
			foreach ($yearData as $key =>  $thisYear)
			{
				$yearcount++;
				if($yearcount==1)
				{
					$year_segment = $key;
				}
			}
		}
		$year_segment_string = $year_segment;
		if(isset($yearData[$year_segment]))
		{
			$year_segment_string = $yearData[$year_segment];
		}
		
		$data['year_data'] = $yearData;
		$data['currency_segment'] = $currency_segment;
		$data['year_segment'] = $year_segment;
		$data['year_segment_string'] = $year_segment_string;
		$data['ashrams'] = [];

		$data['trusts']=$this->orders_model->getTrustsByCurrencyAndYear($currency_segment, $year_segment);

		$basic_trust_segment = $this->uri->segment(5);
		if(empty($basic_trust_segment))
		{
			if(isset($data['trusts'][0]->trust_basic_id))
			{
				$basic_trust_segment = $data['trusts'][0]->trust_basic_id;
			}
		}
		$data['basic_trust_segment'] = $basic_trust_segment;

		if($basic_trust_segment)
		{
			$data['ashrams']=$this->orders_model->getAshramsByCurrencyAndYear($currency_segment, $year_segment, $basic_trust_segment);
		}
		$data['user_details'] = [];
		if($this->session->userdata('user_id')!='')
		{
			$data['user_details']=$this->user_model->userData($this->session->userdata('user_id'));
		}
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Sevas statement");
	}

	public function failed_sevas()
	{
		$views = array( 'orders/user/list_failed_sevas' );
		$data = array('views'=>$views);
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserFailedOrdersAshramsByUserIdByModuleId($this->session->userdata('user_id'));
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Failed Sevas Listing");
	}

	public function listfs($excel=0)
	{
		$this->load->model("orders/orders_temp_model");
		$list=$this->orders_temp_model->listUser($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Failed Sevas Listing ajax request");
	}

	public function listc($excel=0)
	{
		$list=$this->orders_model->listUser($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Sevas Listing ajax request");
	}
	public function list_no_tx($excel=0)
	{
		$list=$this->orders_model->listUsernoTXSevas($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Seva No TX Listing ajax request");
	}
	public function listp($excel=0)
	{
		if($GLOBALS['site_settings']['poojas']==0)
    	{
    		echo json_encode(array());
			exit;
    	}
		$list=$this->orders_model->listUserPoojas($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Pooja Sevas Listing ajax request");
	}
	public function listd($excel=0)
	{
		if($GLOBALS['site_settings']['donations']==0)
    	{
    		echo json_encode(array());
			exit;
    	}
		$list=$this->orders_model->listUserDonations($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Donation Sevas Listing ajax request");
	}

	public function listsubs($excel=0)
	{
		$list=$this->orders_model->listUserSubscriptions($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Subscription Sevas Listing ajax request");
	}

	public function lists($excel=0)
	{
		if($GLOBALS['site_settings']['store']==0)
    	{
    		echo json_encode(array());
			exit;
    	}
		$list=$this->orders_model->listUserStore($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Store Orders Listing ajax request");
	}


	public function listc_st($excel=0)
	{
		$list=$this->orders_model->listUserSummary($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Orders statement ajax request");
	}
	

	public function view_old($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				$this->session->set_flashdata("order_error",1);
				redirect("myorders");
			}
			if($orderData['order']->user_id!=$this->currentUser->id)
			{
				$this->session->set_flashdata("order_error",1);
				redirect("myorders");
			}
			if($orderData['order']->order_type==1)
			{
				if($GLOBALS['site_settings']['poojas']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			if($orderData['order']->order_type==2)
			{
				if($GLOBALS['site_settings']['donations']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			if($orderData['order']->order_type==4)
			{
				if($GLOBALS['site_settings']['subscriptions']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			if($orderData['order']->order_type==3)
			{
				if($GLOBALS['site_settings']['store']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			$this->load->model("locations_model");
			$this->load->model("payment_model");
			// $this->load->model("credit_cards_model");
			$views = array( 'orders/user/view' );
			$data = array('views'=>$views);
			$data['orderData']=$orderData;
			$data['txData']=$this->payment_model->getTransaction($orderData['order']->transaction_id);
			// $data['transactions']=$this->transaction_model->getTransactionsByOrderAlt($id);
			$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
			// $data['credit_cards']=$this->credit_cards_model->getCards($orderData['order']->user_id);
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($orderData['order']->ashram_id,$orderData['order']->order_type);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	$data['trustData']=$trustsArray[$orderData['order']->currency];

			$this->load->view(USER_TEMPLATE,$data);
			$this->logaction->log($this->service,"User - Viewed Seva ");
		}
		else
		{
			$this->session->set_flashdata("order_error",1);
			redirect("myorders");
		}
	}

	public function failed_subscriptions()
	{
		$views = array( 'orders/user/list_failed_subscription_payments' );
		$data = array('views'=>$views);
		if($this->session->userdata("ashramId"))
		{
			$this->load->model('ashrams/donations_model');
			$data['donations']=$this->donations_model->getSubscriptionsByAshramId($this->session->userdata("ashramId"));
		}
		// $data['ashrams']=$this->ashrams_model->getList();
		$data['ashrams']=$this->ashrams_model->getUserFailedSubscriptionsAshramsByUserIdByModuleId($this->session->userdata('user_id'));
		$data['pets']=$this->pets_model->getAll();
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed Failed Subscription Sevas Listing");
	}

	public function listfailedsubs($excel=0)
	{
		$list=$this->orders_model->listUserFailedSubscriptions($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Failed Subscriptions Sevas Listing ajax request");
	}

	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderDataRow=$this->orders_model->orderRowById($id);
			if(empty($orderDataRow))
			{
				$this->session->set_flashdata("order_error",1);
				redirect("myorders");
			}
			if($orderDataRow->user_id!=$this->currentUser->id)
			{
				$this->session->set_flashdata("order_error",1);
				redirect("myorders");
			}
			if($orderDataRow->order_type==1)
			{
				if($GLOBALS['site_settings']['poojas']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			if($orderDataRow->order_type==2)
			{
				if($GLOBALS['site_settings']['donations']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			if($orderDataRow->order_type==4)
			{
				if($GLOBALS['site_settings']['subscriptions']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			if($orderDataRow->order_type==3)
			{
				if($GLOBALS['site_settings']['store']==0)
				{
					$this->session->set_flashdata("order_error",1);
					redirect("myorders");
				}
			}
			$views = array( 'orders/user/view' );
			$data = array('views'=>$views);
			$orderData['order'] = $orderDataRow;
			$orderData['order_items'] = $this->orders_model->orderItemsByOrderId($id);
			if($orderDataRow->order_type==3)
			{
				$orderData['order_items_files'] = $this->orders_model->orderFilesByOrderId($id);
			}
			if($orderDataRow->trust_id>0)
			{
				$data['trustData']=$this->ashrams_trust_accounts_model->trustData($orderDataRow->trust_id);
			}
			else
			{
				$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($orderDataRow->ashram_id,$orderDataRow->order_type);
		    	$trustsArray=array();
		    	foreach ($trusts as $trustData)
		    	{
		    		$trustsArray[$trustData->currency]=$trustData;
		    	}
		    	$data['trustData']=$trustsArray[$orderDataRow->currency];
		    }

			$data['orderData']=$orderData;

			$this->load->view(USER_TEMPLATE,$data);
			$this->logaction->log($this->service,"User - Viewed Seva ");
		}
		else
		{
			$this->session->set_flashdata("order_error",1);
			redirect("myorders");
		}
	}

	public function checkOrderExists($id=0)
	{
		$tobeReturndata = [];
		$tobeReturndata['status'] = 1;
		$tobeReturndata['error_message'] = "";
		$orderData=$this->orders_model->orderData($id);
		if(empty($orderData['order']))
		{
			$tobeReturndata['status'] = 0;
			$tobeReturndata['error_message'] = "This seva is not availoable";
		}
		if($orderData['order']->user_id!=$this->currentUser->id)
		{
			$tobeReturndata['status'] = 0;
			$tobeReturndata['error_message'] = "You can not access this seva";
		}
		if($orderData['order']->order_type==1)
		{
			if($GLOBALS['site_settings']['poojas']==0)
			{
				$tobeReturndata['status'] = 0;
				$tobeReturndata['error_message'] = "Pooja sevas are disabled";
			}
		}
		if($orderData['order']->order_type==2)
		{
			if($GLOBALS['site_settings']['donations']==0)
			{
				$tobeReturndata['status'] = 0;
				$tobeReturndata['error_message'] = "Donation sevas are disabled";
			}
		}
		if($orderData['order']->order_type==4)
		{
			if($GLOBALS['site_settings']['subscriptions']==0)
			{
				$tobeReturndata['status'] = 0;
				$tobeReturndata['error_message'] = "Subscription sevas are disabled";
			}
		}
		if($orderData['order']->order_type==3)
		{
			if($GLOBALS['site_settings']['store']==0)
			{
				$tobeReturndata['status'] = 0;
				$tobeReturndata['error_message'] = "Store orders are disabled";
			}
		}
		if($tobeReturndata['status']==1)
		{
			$tobeReturndata['orderData'] = $orderData;
		}
		return $tobeReturndata;
	}

	public function order_summary($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			if($resultdata['orderData']['order']->trust_id>0)
			{
				$data['trustData']=$this->ashrams_trust_accounts_model->trustData($resultdata['orderData']['order']->trust_id);
			}
			else
			{
				$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($resultdata['orderData']['order']->ashram_id,$resultdata['orderData']['order']->order_type);
		    	$trustsArray=array();
		    	foreach ($trusts as $trustData)
		    	{
		    		$trustsArray[$trustData->currency]=$trustData;
		    	}
		    	$data['trustData']=$trustsArray[$resultdata['orderData']['order']->currency];
		    }
	    	$this->load->model("credit_cards_model");
			$data['credit_cards']=$this->credit_cards_model->getCards($resultdata['orderData']['order']->user_id);
			echo $this->load->view("orders/user/_order_summary",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}


	public function order_donation_receipt($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			echo $this->load->view("orders/user/_order_donation_receipt",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_downloads($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			echo $this->load->view("orders/user/_order_downloads",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_payments($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$this->load->model("credit_cards_model");
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			$data['transactions']=$this->transaction_model->getTransactionsByOrderAlt($id);
			$data['credit_cards']=$this->credit_cards_model->getCards($resultdata['orderData']['order']->user_id);
			if(isset($data['orderData']['order']->trust_id) && $data['orderData']['order']->trust_id>0)
			{
				$data['trustData']=$this->ashrams_trust_accounts_model->trustData($data['orderData']['order']->trust_id);
			}
			echo $this->load->view("orders/user/_order_payments",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_all_transactions($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$this->load->model("credit_cards_model");
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			$data['transactions']=$this->transaction_model->getTransactionsByOrderAlt($id);
			$data['credit_cards']=$this->credit_cards_model->getCards($resultdata['orderData']['order']->user_id);
			echo $this->load->view("orders/user/_order_all_transactions",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function make_payment($order_id=0)
	{
		$result['flag']=0;
		if(is_numeric($order_id) && $order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				$result['error']="Invalid request";
				goto end;
			}
			if($orderData['order']->user_id!=$this->currentUser->id)
			{
				$result['error']="Invalid request";
				goto end;
			}
			/*if((strtolower($orderData['order']->payment_alt_mode)!='cash' || $orderData['order']->payment_status==1 ||
				$orderData['order']->total_price==$orderData['order']->paid) || ($orderData['order']->no_transactions == "Yes" && $orderData['order']->total_paid == 0 && $orderData['order']->paid == 0))
			{
				$result['error']="Invalid request";
				goto end;
			}*/

			$contains_subscription=0;
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($orderItem->subscription==1)
				{
					$contains_subscription=1;
					break;
				}
			}

			if($contains_subscription)
			{
				$result['error']="Partial payments are not allowed";
				goto end;
			}

			if($orderData['order']->partially_refunded==0)
				if($orderData['order']->partial_payments_allowed==0)
				{
					if($this->input->post("charge_amount")==0 || $this->input->post("charge_amount")!=$orderData['order']->total_price)
					{
						$result['error']="Partial payments are not allowed";
						goto end;
					}
				}

			if($this->input->post("charge_amount")!='')
			{
				if($this->input->post("charge_amount")==0 || $this->input->post("charge_amount")>($orderData['order']->total_price-$orderData['order']->paid))
				{
					$result['error']="Invalid amount";
					goto end;
				}
			}
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($orderData['order']->ashram_id,$orderData['order']->order_type);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	$customData['trustData']=$trustsArray[$orderData['order']->currency];
	    	$customData['trustData']=$this->ashrams_trust_accounts_model->removeCredentials($customData['trustData']);

			/*if($orderData['order']->payment_status==$this->input->post("payment_status"))
			{
				goto end;
			}*/
			//$this->form_validation->set_rules('payment_status', 'Payment Status','trim|required|numeric|checkPaymentStatus');
			$this->form_validation->set_rules('charge_amount', 'Amount','trim|required|numeric');
			$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkCashModes');
			//No need for online payments
			if($this->input->post("payment_mode")!='online')
				$this->form_validation->set_rules('payment_note', 'Note','trim|required|min_length[10]|max_length[1000]');

			if($orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online' && $customData['trustData']->payment_mode=='paypal')
			{
				if($this->input->post("credit_card_id")=='')
				{
					$this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
					$this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
					$this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
					$this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
				}
				else
				{
					$this->form_validation->set_rules('credit_card_id', 'Save Card ID','trim|required|numeric|max_length[20]');
				}
			}

	    	if($this->form_validation->run() == FALSE)
			{
				$result['error']="Invalid request";
				$result['error']=validation_errors();
				goto end;
			}
			if($this->input->post("payment_mode")=='online')
			{
				//Get trust accounts for Ashram and Currency defined
		    	$customData['ashramData']=$this->ashrams_model->ashramData($orderData['order']->ashram_id);

		    	//Check credit card details
		    	if($orderData['order']->currency=='usd')
				{
					$creditCardData=array();
					if($this->input->post("credit_card_id")!='')
					{
						$this->load->model("credit_cards_model");
						$creditCardData=$this->credit_cards_model->getCard($this->input->post("credit_card_id"));
						if(empty($creditCardData))
						{
							$result['error']="Invalid credit card";
							goto end;
						}
						if($creditCardData->user_id!=$orderData['order']->user_id)
						{
							$result['error']="Invalid credit card";
							goto end;
						}
					}
				}

				$paymentMode=$customData['trustData']->payment_mode;

				$formData['firstname']=$orderData['order']->firstname;
                $formData['lastname']=$orderData['order']->lastname;
                $formData['email']=$orderData['order']->email;
                $formData['phone']=$orderData['order']->phone;
                $formData['address1']=$orderData['order']->address1;
                $formData['address2']=$orderData['order']->address2;
                $formData['zipcode']=$orderData['order']->zipcode;
                $formData['city']=$orderData['order']->city;
                $formData['state']=$orderData['order']->state;
                $formData['country']=$orderData['order']->country;
                $formData['ashram_id']=$orderData['order']->ashram_id;

                if(empty($this->input->post("credit_card_id")) &&
                	($customData['trustData']->payment_mode=='paypal' || $customData['trustData']->payment_mode=='authorize.net') &&
            		$orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online' )
                {
                	$formData['card_number']=$this->input->post("card_number");
                	$formData['card_name']=$this->input->post("card_name");
                	$formData['card_expiry']=$this->input->post("card_expiry");
                	$formData['card_cvv']=$this->input->post("card_cvv");
                }
                if(!empty($this->input->post("credit_card_id")) && $customData['trustData']->payment_mode=='paypal' && $orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online')
                {
                	$formData['credit_card_id']=$this->input->post("credit_card_id");
                }

                if($customData['trustData']->payment_mode=='paypal' && $orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online' && !empty($formData['card_number']))
                {
                	$formData['save_credit_card']=$this->input->post("save_credit_card");
                }

                $formData['declaration_type'] = 'Donation';
				$formData['selected_template'] = '';
				if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
				{
					$formData['declaration_type'] = trim($orderData['order']->declaration_type);
				}
				if(isset($orderData['order']->declaration_template) && $orderData['order']->declaration_template!='' && $formData['declaration_type']=='Gift')
				{
					$formData['selected_template'] = trim($orderData['order']->declaration_template);
				}

                $customData['formData']=$formData;
				$customData['model']="orders/orders_model";
				$customData['model_name']="orders_model";
				$customData['ip_address']=$_SERVER['REMOTE_ADDR'];
				$customData['subscription']=0;
				$customData['additional_payment']=1;
				$customData['order_id']=$order_id;
				$customData['paymentMode']=$paymentMode;
				$customData['created_by']=2;
				$customData['cart_type']=$orderData['order']->order_type;

				$this->load->model("payment_model");
				//Load Temp payments model
				$this->load->model("temp_payments_model");
				$reference=$this->payment_model->setTempInfo(
					$orderData['order']->user_id,
					$this->currentUser,
					$this->input->post("charge_amount"),
					base_url."myorders/view/".$order_id,
					base_url."myorders/view/".$order_id,
					$customData,
					$orderData['order']->currency
					);
				$payment_result['flag']=1;
				$payment_result['reference']=$reference;
				$payment_result['payment_mode']=$paymentMode;

				if($paymentMode=='stripe')
		        {
		        	$ref_url = base_url."myorders/view/".$order_id;
		        	$this->load->model("stripe_webhook_model");
		            $str_amount = $this->input->post("charge_amount")*100;
		            $checkoutSession = $this->stripe_webhook_model->createStripeSession($orderData['order']->currency,$orderData['order']->email,$customData['trustData'],$orderData['order']->order_type,array(),$this->input->post("charge_amount"),$reference,$customData,$orderData['order']->user_id,$orderData['order']->ashram_id,1,$ref_url);
		            if($checkoutSession["status"] == "error")
		            {
		                $result['flag']=0;
		                $result['error']=$checkoutSession['status_message'];
		                goto end;
		            }
		        }

				if($orderData['order']->currency=='usd')
				{
					$payment_result['currency']="USD";
					if($paymentMode=='paypal')
					{
						$this->load->model("paypal_model");
						$paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
						if($paypalResponse['flag']==1)
						{
							$payment_result['redirect_to']=$paypalResponse['redirect_url'];
							$payment_result['payment_status']=1;
							$this->session->set_flashdata("payment_success",1);
							$this->orders_model->calculateDue($order_id);
							$this->orders_model->update_no_transactions($order_id);
							$this->order_log_model->log($orderData['order']->id,
								"Paid amount: ".strtoupper($orderData['order']->currency)." ".
							$this->input->post("charge_amount")."\n".$paymentMode."\nTx ID:".$paypalResponse['tx']);
							$this->session->set_userdata("payment_success","Payment processed successfully.");
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
						else
						{
							$payment_result['payment_status']=0;
							$payment_result['error']=$paypalResponse['error_msg'];
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
					}
					if($paymentMode=='authorize.net')
					{
						$this->load->model("authorizenet_model");
						$authnetResponse=$this->authorizenet_model->processOneTimePayment($reference);
						if($authnetResponse['flag']==1)
						{
							$payment_result['redirect_to']=$authnetResponse['redirect_url'];
							$payment_result['payment_status']=1;
							$this->session->set_flashdata("payment_success",1);
							$this->orders_model->calculateDue($order_id);
							$this->order_log_model->log($orderData['order']->id,
								"Paid amount: ".strtoupper($orderData['order']->currency)." ".
							$this->input->post("charge_amount")."\n".$paymentMode."\nTx ID:".$authnetResponse['tx']);
							$this->session->set_userdata("payment_success","Payment processed successfully.");
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
						else
						{
							$payment_result['payment_status']=0;
							$payment_result['error']=$authnetResponse['error_msg'];
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
					}
					if($paymentMode=='razorpay')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result['prefill_name']=$orderData['order']->firstname." ".$orderData['order']->lastname;
						$payment_result['prefill_email']=$orderData['order']->email;
						$payment_result['prefill_contact']=$orderData['order']->phone;
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
					if($paymentMode=='stripe')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result["session_id"]=$checkoutSession["session"]->id;
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
				}
				if($orderData['order']->currency=='inr')
				{
					$payment_result['currency']="INR";
					if($paymentMode=='razorpay')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result['prefill_name']=$orderData['order']->firstname." ".$orderData['order']->lastname;
						$payment_result['prefill_email']=$orderData['order']->email;
						$payment_result['prefill_contact']=$orderData['order']->phone;
						//$this->session->set_userdata("payment_success","Payment processed successfully.");
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
					if($paymentMode=='payu')
					{
						$result['payment_mode']="payu";
						$result['redirect_to']='/payment/direct/'.$reference;
						//$this->cart_log_model->log("Redirected to payment gateway:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
					if($paymentMode=='stripe')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result["session_id"]=$checkoutSession["session"]->id;
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
				}

			}
			else //Offline payments
			{
				$this->session->set_userdata("payment_success","Payment processed successfully.");
				$this->orders_model->charge_amount(
													$orderData,
													$this->input->post("charge_amount"),
													$this->input->post("payment_mode"),
													$this->input->post("payment_note")
												);
			}
			$result['flag']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function subscription_cancel($orderId=0,$orderItemId=0)
	{
		$result['status']=0;
		if(is_numeric($orderId) && $orderId && is_numeric($orderItemId) && $orderItemId)
		{
			$orderData=$this->orders_model->orderData($orderId);
			if(empty($orderData['order']))
			{
				goto end;
			}
			if($orderData['order']->user_id!=$this->currentUser->id)
			{
				$result['error']="Invalid request";
				goto end;
			}
			if($orderData['order']->payment_alt_mode=='cash')
			{
				$result['error']="Invalid request";
				goto end;
			}
			$itemData=$this->orders_model->itemData($orderItemId,$orderId);
			if(empty($itemData))
			{
				goto end;
			}
			$this->load->model("paypal_model");
			$result=$this->orders_model->subscriptionCancel($orderData,$itemData);
			$this->session->set_flashdata("subscription_item",$itemData->item_name);
			if($result==1)
			{
				$this->session->set_flashdata("subscription_cancelled",1);
				redirect("myorders/view/".$orderId);
				exit;
			}
			else
			{
				$this->session->set_flashdata("subscription_error","Error cancelling subscription.");
				redirect("myorders/view/".$orderId);
				exit;
			}
		}
		end:
		{
			redirect("myorders");
		}
	}
	
	public function updatePersonalnote($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->order_item_id)
				{
					$item=$orderItem;
					break;
				}
			}
			
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$this->orders_model->updatePersonalNote($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}
	public function change_card($order_id=0)
	{
		$result['flag']=0;
		$orderData=$this->orders_model->orderData($order_id);
		if(empty($orderData['order']))
		{
			$result['error']="Invalid request";
			goto end;
		}
		if($orderData['order']->user_id!=$this->currentUser->id)
		{
			$result['error']="Invalid request";
			goto end;
		}
		$has_subscription=0;
		$cancel_item_count = 0;
		$all_sub_items = 0;
		foreach ($orderData['order_items'] as $itemData)
		{

			if(($orderData['order']->order_type==2 || $orderData['order']->order_type==4) && $itemData->subscription==1)
			{
				$all_sub_items++;
				$has_subscription=1;
				if($itemData->status == 2)
				{
					$cancel_item_count++;
				}
			}
		}
		if($has_subscription==0)
		{
			$result['error']="Invalid request";
			goto end;
		}

		if($cancel_item_count > 0 && $all_sub_items > 0 && $has_subscription==1)
		{
			if($cancel_item_count == $all_sub_items)
			{
				$result['error']="Subscription has been cancelled. Credit card cannot be changed.";
				goto end;
			}
		}

		$this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
		$this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
		$this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
		$this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
		if($this->form_validation->run() == FALSE)
		{
			$result['error']="Invalid request";
			goto end;
		}

		$flag=$this->orders_model->changeCard($order_id);
		if($flag==1)
		{
			$result['flag']=1;
			$this->session->set_userdata("card_updated",1);
		}
		else
		{
			$result['error']="Error changing card.";
		}

		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function updateStripeCard($paymentMethodId,$orderId)
	{
		$result['flag']=0;
		$orderData=$this->orders_model->orderData($orderId);
		if(empty($orderData['order']))
		{
			$result['error_msg']="something wrong, Please try again..";
			goto end;
		}
		if($orderData['stripe_card']->payment_method_id != $paymentMethodId)
		{
			$result['error_msg']="something wrong, Please try again..";
			goto end;
		}
		else
		{
			$this->load->model("stripe_webhook_model");
			$ref_url = base_url."orders/view/".$orderId;
			$currency = strtolower($orderData["order"]->currency);
			$customer_id = $orderData["stripe_card"]->customer_id;
			$subscription_id = $orderData["stripe_card"]->subscription_id;
			$ashram_id = $orderData["order"]->ashram_id;
			$order_type = $orderData["order"]->order_type;
			$checkoutSession = $this->stripe_webhook_model->createcardUpdateSession($currency,$customer_id,$subscription_id,$ashram_id,$order_type,$ref_url);
			$result['flag']=1;
			$result['session_id']=$checkoutSession["session"]->id;
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}

	public function printAllAshramUsdShortSummary()
	{
		$this->load->model("ashrams/ashrams_trust_accounts_model");
		$for_the_year = $_POST['for_the_year'];
		$trust_basic_id = $_POST['trust_basic_id'];
		$data['trustBasicData']=$this->ashrams_trust_accounts_model->trustBasicDataById($trust_basic_id);
		$data['total_price'] = $this->orders_model->getAllAshramUsdAmount($for_the_year,$trust_basic_id);
		$data['total_price_in_words']= $this->general_model->amountToWords($data['total_price']);
		$data['for_the_year'] = $for_the_year;
		$data['trust_basic_id'] = $trust_basic_id;
		$this->load->view('orders/user/all_ashram_usd_short_summary',$data, false);
	}

	public function printTrustInrShortSummary()
	{
		$this->load->model("ashrams/ashrams_trust_accounts_model");
		$for_the_year = $_POST['for_the_year'];
		$trust_basic_id = $_POST['trust_basic_id'];
		$data['trustBasicData']=$this->ashrams_trust_accounts_model->trustBasicDataById($trust_basic_id);
		$data['trustBasic80gData']=$this->ashrams_trust_accounts_model->getTrust80gByTrustIdAndYear($trust_basic_id, $for_the_year);
		$data['total_price'] = $this->orders_model->getTrustInrAmount($for_the_year,$trust_basic_id);
		$data['total_price_in_words']= $this->general_model->amountToWords($data['total_price']);
		$data['for_the_year'] = $for_the_year;
		$data['trust_basic_id'] = $trust_basic_id;
		$this->load->view('orders/user/trust_inr_short_summary',$data, false);
	}

	// setting category based on ashram
	public function switchUserCategory($categoryId,$cart_type){
		if(is_numeric($categoryId)) {
			if($cart_type == 1)
				$this->session->set_userdata("pooja_categoryId",$categoryId);
			if($cart_type == 2)
				$this->session->set_userdata("donation_categoryId",$categoryId);
			if($cart_type == 3)
				$this->session->set_userdata("store_categoryId",$categoryId);
			if($cart_type == 4)
				$this->session->set_userdata("subscription_categoryId",$categoryId);
		}else {
			if($cart_type == 1)
				$this->session->unset_userdata("pooja_categoryId");
			if($cart_type == 2)
				$this->session->unset_userdata("donation_categoryId");
			if($cart_type == 3)
				$this->session->unset_userdata("store_categoryId");
			if($cart_type == 4)
				$this->session->unset_userdata("subscription_categoryId");
		}
		if($this->session->userdata("groupId"))
			$this->session->unset_userdata("groupId");
	}

	// setting group id based on ashram and category
	public function switchUserGroup($groupId){
		if(is_numeric($groupId))
			$this->session->set_userdata("groupId",$groupId);
		else
			$this->session->unset_userdata("groupId");
	}
}
?>