<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Mynotes extends CI_Controller 
{
	var $service="others";
	var $currentUser='';
    function __construct()
    {
        parent::__construct();
		if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		if($this->session->userdata("force_change_password")==1)
		{
			$this->session->set_flashdata("reset_password_force",1);
			redirect("myaccount/change_password");
		}
		$this->load->model('others/notes_model');
    }
	public function index()
	{
		$views = array( 'notes/user/list' );
		$data = array('views'=>$views);
		$this->load->view(USER_TEMPLATE,$data);
	}
	public function listnotes()
	{
		$list=$this->notes_model->listAjaxAdmin();
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Notes listing ajax request");
		
	}
	public function add_edit_note($id=0)
	{
		if(isset($_POST["add_note"]))
		{
			$this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('content', 'Content', 'trim|required|min_length[3]|max_length[5000]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("note_error",1);
				redirect('mynotes/add_edit_note/'.$id);
				return;
			}
			if($id)
			{
				$noteData=$this->notes_model->noteData($id);
				if(empty($noteData) || $this->currentUser->id!=$noteData->user_id)
				{
					$this->session->set_flashdata("note_error",1);
					redirect("/mynotes");
				}
			}
			$saved=$this->notes_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("note_saved",1);
				else
				{
					$this->session->set_flashdata("note_created",1);
				}
			}
			redirect('mynotes/add_edit_note/'.$saved);
		}
		else
		{
		 	$views = array( 'notes/user/add_edit_note' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['note_data']=$this->notes_model->noteData($id);
				if(empty($data['note_data']) || $this->currentUser->id!=$data['note_data']->user_id)
				{
					$this->session->set_flashdata("note_error",1);
					redirect("/mynotes");
				}
			}
			$this->load->view(USER_TEMPLATE,$data);
		}
	}
	
	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$noteData=$this->notes_model->noteData($id);
			if(!empty($noteData) && $this->currentUser->id==$noteData->user_id)
			{
				$r=$this->notes_model->delete($id,$noteData);
				if($r)
				{
					$data['flag']=1;
					$data['title']=$noteData->title;
				}
			}
		}
		echo json_encode($data);
	}
}
?>