<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Mygreetings extends CI_Controller
{
	var $currentUser='';
	var $service="myaccount";
    function __construct()
	{
        parent::__construct();
       	if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		if($this->session->userdata("force_change_password")==1)
		{
			$this->session->set_flashdata("reset_password_force",1);
			redirect("myaccount/change_password");
		}
			
		$this->load->model("greetings/greetings_model");
    }
	public function index()
	{
		if(isset($_GET['gid']) && is_numeric($_GET['gid']) && $_GET['gid'])
		{
			$greetingData=$this->greetings_model->greetingData($_GET['gid']);
			if(empty($greetingData))
			{
				redirect("mygreetings");
			}
			$data['greetingData']=$greetingData;
			$data['views']=array("greetings/user/send");
			$this->load->view(USER_TEMPLATE,$data);
		}
		else
		{
			$data['greetings']=$this->greetings_model->getAll();
			$data['views']=array("greetings/user/select");
			$this->load->view(USER_TEMPLATE,$data);
		}
	}
	public function send()
	{
		if(isset($_GET['gid']) && is_numeric($_GET['gid']) && $_GET['gid'])
		{
			if(!isset($_POST['message']))
			{
				$this->session->set_flashdata("greeting_error",1);
				goto end;
			}
			$greetingData=$this->greetings_model->greetingData($_GET['gid']);
			if(empty($greetingData))
			{
				$this->session->set_flashdata("greeting_error",1);
				goto end;
			}
			$data['greetingData']=$greetingData;

			$this->form_validation->set_rules('recipients', 'Recipients', 'trim|required|valid_emails_custom');
			$this->form_validation->set_rules('subject', 'Subject', 'trim|required|min_length[3]|max_length[200]');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("greeting_error",1);
				goto end;
			}
			$this->load->model("greetings/greetings_user_model");
			$this->greetings_model->sendGreeting($greetingData);
			$this->session->set_flashdata("greeting_sent",1);
		}
		end:
		redirect("mygreetings");
	}
	public function report()
	{
		$data['views']=array("greetings/user/report");
		$this->load->view(USER_TEMPLATE,$data);
	}
	public function listreport()
	{
		$this->load->model("greetings/greetings_user_model");
		$list=$this->greetings_user_model->listReport($this->currentUser->id);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Greetings report listing ajax request");
	}
}
?>