<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Liveupdates extends CI_Controller 
{
	var $currentUser='';
	public function __construct()
	{
		parent::__construct();
		if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
		$this->load->model("live_updates_model");
		$this->load->model("mobile/mobileNotifications_model");
	}
	public function index()
	{
		$data['views'] = array('live_updates/public/list');
        $this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function listm()
	{
		$list=$this->live_updates_model->listPublic();
		echo json_encode($list);
	}
	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$messageData=$this->live_updates_model->messageData($id);
			if(empty($messageData))
			{
				goto end;
			}
			$data['views'] = array('live_updates/public/view');
			$data['messageData']=$messageData;
        	$this->load->view(FRONTEND_TEMPLATE,$data);
		}
		else
		{
			end:
			redirect("liveupdates");
		}
	}
	public function admin()
	{
		$views = array('live_updates/admin/list');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listmessages()
	{
		$list=$this->live_updates_model->listMessages();
		echo json_encode($list);
	}
	
	function post()
	{
		if(isset($_POST["save_update"]))
		{
			$this->form_validation->set_rules('type', 'Update Type', 'trim|required|numeric|liveupdate_type_check');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("message_error",1);
				redirect('liveupdates/post');
				return;
			}
			if(!isset($_POST['message']))
			{
				$this->session->set_flashdata("message_error",1);
				redirect('liveupdates/post');
			}
			if(isset($_POST['type']) && $_POST['type']==2)
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				if(isset($_FILES['message_image']))
				if($_FILES['message_image']['name']!='')
				{
					$ext=pathinfo ($_FILES['message_image']['name'],PATHINFO_EXTENSION);
					if($_FILES['message_image']['size']==0)
					{
						$this->session->set_flashdata("message_error",1);
						redirect('liveupdates/post');
						return;
					}
					if($_FILES['message_image']['size']>1*1024*1024)
					{
						$this->session->set_flashdata("message_error",1);
						redirect('liveupdates/post');
						return;
					}

					if($ext==''|| !in_array($_FILES['message_image']['type'],$allowed_file_types))
					{
						$this->session->set_flashdata("message_error",1);
						redirect('liveupdates/post');
						return;
					}
					if(!getimagesize($_FILES['message_image']['tmp_name']))
					{
						$this->session->set_flashdata("message_error",1);
						redirect('liveupdates/post');
						return;
					}
				}

			}
			if(isset($_POST['type']) && $_POST['type']==4)
			{
				if(isset($_FILES['update_file']))
				{
					$ext=pathinfo ($_FILES['update_file']['name'],PATHINFO_EXTENSION);
					$exts=$GLOBALS['site_settings']['blocked_file_types'];
					$excludedExtensions=explode("|",$exts);

					if($_FILES['update_file']['name']!='')
					{
						if($_FILES['update_file']['size']==0)
						{
							$this->session->set_flashdata("message_error",1);
							redirect('liveupdates/post');
							return;
						}
						if($_FILES['update_file']['size']>1*1024*1024)
						{
							$this->session->set_flashdata("message_error",1);
							redirect('liveupdates/post');
							return;
						}

						if($ext=='' || in_array($ext,$excludedExtensions))
						{
							$this->session->set_flashdata("message_error",1);
							redirect('liveupdates/post');
							return;
						}
					}
				}

			}
			$this->load->library("one_signal");
			
			$saved=$this->live_updates_model->save();
			if($saved==1)
			{
				$this->session->set_flashdata("message_posted",1);
				redirect('liveupdates/admin');
			}
			else
			{
				$this->session->set_flashdata("message_data",$_POST);
				$this->session->set_flashdata("message_error",$saved);
				redirect('liveupdates/post');
			}
		}
		else
		{
			$views = array('live_updates/admin/post');
			$data = array('views'=>$views);
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	/*public function add()
	{
		if(isset($_POST['message']))
		{
			$this->form_validation->set_rules('message', 'Message', 'trim|required|min_length[3]|max_length[100]');
			if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$this->live_updates_model->addMessage($_POST['message']);
			echo 1;
		}
		else
			echo 0;
	}*/
	public function updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->live_updates_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	/*public function updateorder()
	{
		if(isset($_POST['name']) && $_POST['value'])
		{
			$this->live_updates_model->updateOrder($_POST['pk'],$_POST['value']);
		}
	}*/
	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$messageData=$this->live_updates_model->messageData($id);
			if(!empty($messageData))
			{
				$r=$this->live_updates_model->delete($id,$messageData);
				if($r)
				{
					//deleting related notification data also
					$this->mobileNotifications_model->remove($id,'liveupdates');
					$data['flag']=1;
				}
			}
		}
		echo json_encode($data);
	}
	public function bulk()
	{
		$result['flag']=0;
		if(isset($_POST['bulk_actions']) && $_POST['bulk_actions']=="delete")
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			foreach($_POST['ids'] as $id)
			{
				$messageData=$this->live_updates_model->messageData($id);
				if(!empty($messageData))
				{
					$this->live_updates_model->delete($id,$messageData);
					$count++;
				}
			}
			$result['flag']=1;
			$result['num']=$count;
		}
		echo json_encode($result);
	}
}
?>