<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Japamadmin extends CI_Controller 
{
	var $service="japams";
	var $currentUser='';
    function __construct() 
    {
        parent::__construct();
		$this->load->model("japams/japams_model");
		$this->load->model("japams/mantra_japam_notes_model");
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
    }

    public function index() 
	{
        $data = array('views'=>array("japams/admin/list"));
        $this->load->view(ADMIN_TEMPLATE,$data);
    }
    public function listc($excel=0)
	{
		$list=$this->japams_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Mantras listing ajax request");
		
	}
	public function add_edit_mantra($id=0)
	{
		if($id)
		{
			$mantraData=$this->japams_model->mantraData($id);
			if(empty($mantraData))
			{
				$this->session->set_flashdata("japam_error",1);
				redirect('japamadmin');
			}
		}
		else
			$mantraData=array();

		if(isset($_POST["name"]))
		{
			if(isset($_FILES['mantra_image']['name']) && $_FILES['mantra_image']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['mantra_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['mantra_image']['size']==0 || $ext=='' || !in_array($_FILES['mantra_image']['type'],$allowed_file_types) ||
						$_FILES['mantra_image']['size']>(1024*1024))
				{
					$this->session->set_flashdata("japam_error",1);
					redirect('japamadmin/add_edit_mantra/'.$id);
				}
			}

			$this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[50]');
			$this->form_validation->set_rules('mantra', 'Mantra', 'trim|required|min_length[3]|max_length[2000]');
			$this->form_validation->set_rules('description', 'Description', 'trim|min_length[3]|max_length[200]');
			$this->form_validation->set_rules('start_date', 'Start Date', 'trim|required|valid_date');
			$this->form_validation->set_rules('end_date', 'End Date', 'trim|required|valid_date|checkMantraDates');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("japam_error",1);
				redirect('japamadmin/add_edit_mantra/'.$id);
				return;
			}
			
			$saved=$this->japams_model->save($id,$mantraData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("japam_saved",1);
				else
				{
					$this->session->set_flashdata("japam_created",1);
				}
			}
			redirect('japamadmin/add_edit_mantra/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'japams/admin/add_edit_mantra' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['mantraData']=$mantraData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	public function add_edit_japanote()
	{
		$noteData=$this->mantra_japam_notes_model->noteData();
		if(empty($noteData))
		{
			$noteData=array();
		}
		if(isset($_POST["note"]) && isset($_POST["status"]))
		{
			$this->form_validation->set_rules('status', 'Status', 'trim|required|numeric');
			$this->form_validation->set_rules('note', 'Description', 'trim|required|min_length[3]|max_length[2000]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("note_error",1);
				redirect('japamadmin/add_edit_note');
				return;
			}
			$saveData = array("status"=>$this->input->post("status"),"note"=>$this->input->post("note"),"created_on"=>date("Y-m-d H:i:s"),"updated_on"=>date("Y-m-d H:i:s"));
			$saved=$this->mantra_japam_notes_model->saveUpdate($saveData);
			if($saved)
			{
				if($saved == 2)
					$this->session->set_flashdata("note_saved",1);
				else
				{
					$this->session->set_flashdata("note_created",1);
				}
			}
			redirect('japamadmin/add_edit_japanote');
			
		}
		else
		{
			
		 	$views = array( 'japams/admin/add_edit_note' );
		 	$data = array('views'=>$views);
			if($noteData)
			{
				$data['noteData']=$noteData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	function changestatus($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($status) && in_array($status,array(0,1)))
		{
			$mantraData=$this->japams_model->mantraData($id);
			if(!empty($mantraData) && $mantraData->status!=$status)
			{
				$r=$this->japams_model->changeStatus($id,$status);
				if($r)
				{
					$data['flag']=1;
					$data['name']=$mantraData->name;
				}
			}
		}
		echo json_encode($data);
	}
	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$mantraData=$this->japams_model->mantraData($id);
			if(!empty($mantraData))
			{
				$r=$this->japams_model->delete($id,$mantraData);
				if($r)
				{
					$data['flag']=$r;
					$data['name']=$mantraData->name;
				}
			}
		}
		echo json_encode($data);
	}

	public function report() 
	{
        $data = array('views'=>array("japams/admin/report"));
        $data['japams']= $this->japams_model->getJapamsAdmin();
        $data['japam_countries']= $this->japams_model->getCountries();
        $this->load->view(ADMIN_TEMPLATE,$data);
    }
    public function listreport($excel=0)
	{
		$list=$this->japams_model->adminReport($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Mantras report listing ajax request");
	}

	public function user_report($username='')
	{
		$japa_id = "";
		if(!empty($_GET["japam_id"]))
		{
			$japa_id = $_GET["japam_id"];

			$mantraData=$this->japams_model->mantraData($japa_id);
			if(empty($mantraData))
			{
				goto end;
			}
		}

		if($username!='')
		{
			$userData=$this->users_model->userDataByUserName($username);
			if(!empty($userData))
			{
		        $data = array('views'=>array("japams/admin/user_report"));
		        $data['japa_id']=$japa_id;
		        $data['userData']=$userData;
		        $data['japams']= $this->japams_model->getJapamsAdmin($userData->id);
		        $data['japam_countries']= $this->japams_model->getCountries();
		        $this->load->view(ADMIN_TEMPLATE,$data);
		    }
		    else
		    	goto end;
	    }
	    else
	    {
	    	end:
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
	    }
    }

	public function namecheck($id=0)
	{
		if(isset($_POST['name']) && $_POST['name']!='' && is_numeric($id))
		{
			if(is_numeric($id))
			{
				$flag=$this->japams_model->checkName($this->general_model->filtertext(trim($_POST['name'])),$id);

				if($flag==0)
					echo "true";
				else
					echo "false";
			}
			else
				echo "false";
		}
		else
		{
			echo "false";
		}
	}
	public function mantra_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->japams_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
}
?>