<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Fifthgendevoteesadmin extends CI_Controller 
{
	var $currentUser='';
	var $service="Forms";
	function __construct()
	{
		parent::__construct();
		$this->load->model('Fifth_generation_devotees_model');
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$this->currentUser=$this->session->userdata('admin_data');
			else
				$this->currentUser=$this->session->userdata('user_data');
		}
	}

	public function index()
	{
		$countries=$this->locations_model->getCountries();
		$views = array( 'fifth_generation_devotees/admin/list' );
		$data = array('views'=>$views,'countries'=>$countries);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Forms Listing");
	}

	public function add_edit_devotee($id=0)
	{
		$countries=$this->locations_model->getCountries();
        if(isset($_POST["add_devotee"]))
		{
			$this->form_validation->set_rules('fifth_generation', 'Fifth Generation', 'trim|required|min_length[2]|max_length[200]|name_validate13');
            $this->form_validation->set_rules('fourth_generation', 'Fourth Generation', 'trim|required|min_length[2]|max_length[200]|name_validate13');
            $this->form_validation->set_rules('third_generation', 'Third Generation', 'trim|required|min_length[2]|max_length[200]|name_validate13');
            $this->form_validation->set_rules('second_generation', '2nd Generation', 'trim|required|min_length[2]|max_length[200]|name_validate13');
            $this->form_validation->set_rules('first_generation', '1st Generation', 'trim|required|min_length[2]|max_length[200]|name_validate13');
            $this->form_validation->set_rules('gender', 'Gender', 'required');
            $this->form_validation->set_rules('phone', 'Mobile', 'trim|required|numeric|min_length[8]|max_length[15]');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
            $this->form_validation->set_rules('city', 'City', 'trim|required|min_length[2]|max_length[100]|name_validate13');
            $this->form_validation->set_rules('state', 'State', 'trim|required|min_length[2]|max_length[100]|name_validate13');
            $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[2]|max_length[250]');
            $this->form_validation->set_rules('country_isd_code', 'Country', 'trim|required');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("devotee_error",1);
				redirect('fifthgendevoteesadmin/add_edit_devotee/'.$id);
				return;
			}
			if($id)
			{
				$result = $this->Fifth_generation_devotees_model->get($id);

				if(empty($result))
				{
					$this->session->set_flashdata("devotee_error",1);
					redirect("fifthgendevoteesadmin");
				}
			}
			$saved=$this->Fifth_generation_devotees_model->save($id);
			if($saved)
			{

				if($id)
					$this->session->set_flashdata('devotee_saved',1);
				else
					$this->session->set_flashdata('devotee_created',1);
			}
			else
				$this->session->set_flashdata('devotee_error',1);
			redirect('fifthgendevoteesadmin/add_edit_devotee/'.$saved);
		}
		else
		{
			$result = $this->Fifth_generation_devotees_model->get($id);
			if($id!='' && (empty($result)) )
			{
				redirect('fifthgendevoteesadmin');
			}
		 	$views = array('fifth_generation_devotees/admin/add_edit_devotee');
			$data = array('views'=>$views,'countries'=>$countries,'id'=>$id);
			if($id && !empty($result))
			{
				$data['result']=$result;
			}
			if($id && empty($result))
			{
				$this->session->set_flashdata('devotee_error',1);
				redirect('fifthgendevoteesadmin/add_edit_devotee/'.$id);
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function listc($excel=0)
	{
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=3)
		{
			if(!$this->input->post("user_id"))
			{
				echo 0;
				exit;
			}
		}
		$list=$this->Fifth_generation_devotees_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Donors listing ajax request");
	}

	public function results($secret_key="")
	{
		if($secret_key=="" || $secret_key!=fifthgendevotees_public_display_secret_key)
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		// $results = $this->Fifth_generation_devotees_model->results();
		$data = array();
		$data['secret_key']=$secret_key;
		$this->load->view('fifth_generation_devotees/public/results',$data);
		$this->logaction->log($this->service,"Public - Viewed Donation Sevas Listing with secret key");
	}

	public function listPublucResults($excel=0)
	{
		if(isset($_POST['secret_key']) && $_POST['secret_key']==fifthgendevotees_public_display_secret_key)
		{
			$list=$this->Fifth_generation_devotees_model->listPublic($excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Public - Viewed Fifth generation devotees Listing ajax request with secret key");
		}
		else
		{
			echo 'login';
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$DevoteeData=$this->Fifth_generation_devotees_model->get($id);
			if(empty($DevoteeData))
			{
				goto end;
			}
			$r=$this->Fifth_generation_devotees_model->delete($id,$DevoteeData);
			if($r)
			{
				$data['flag']=1;
				$data['devotee_name']=$DevoteeData->fifth_generation;
				$this->logaction->log($this->service,"Admin - Fifth generation devotee '".$DevoteeData->fifth_generation."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
}