<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Faqadmin extends CI_Controller 
{
	var $service='content';
	var $currentUser='';
    function __construct() 
    {
    	parent::__construct();
		$this->load->model('content/faq_model');
		$this->load->model('content/faq_category_model');
		$this->currentUser=$this->session->userdata("admin_data");
    }
	public function index()
	{
		$views = array( 'faqs/admin/list');
		$data = array('views'=>$views);
		$data['categories']=$this->faq_category_model->getCategories();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	
	public function categories()
	{
		$views = array( 'faqs/admin/list_categories' );
		$data = array('views'=>$views);
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listfaqs($excel=0)
	{
		$list=$this->faq_model->listFaqAjaxAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - FAQs listing ajax request");
		
	}
	public function listcats($excel=0)
	{
		$list=$this->faq_category_model->listCatsAjaxAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - FAQ Categories listing ajax request");
		
	}
	public function add_edit_faq($id=0)
	{
		if(isset($_POST["add_faq"]))
		{	
			$this->form_validation->set_rules('faq', 'FAQ', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('answer', 'Answer', 'trim|required|min_length[10]|max_length[5000]');
			$this->form_validation->set_rules('faq_category', 'FAQ Category', 'trim|required|checkFaqCategory');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("faq_error",1);
				redirect('faqadmin/add_edit_faq/'.$id);
				return;
			}
			if($id)
			{
				$faqData=$this->faq_model->faqData($id);
				if(empty($faqData))
				{
					$this->session->set_flashdata("faq_error",1);
					redirect("/faqadmin");
				}
			}

			$saved=$this->faq_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("faq_saved",1);
				else
				{
					$this->session->set_flashdata("faq_created",1);
				}
			}
			redirect('faqadmin/add_edit_faq/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'faqs/admin/add_edit_faq' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['categories']=$this->faq_category_model->getCategories();
			if($id)
			{
				$data['faq_data']=$this->faq_model->faqData($id);
				if(empty($data['faq_data']))
				{
					$this->session->set_flashdata("faq_error",1);
					redirect("/faqadmin");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	
	public function add_edit_faq_category($id=0)
	{
		if(isset($_POST["add_faqcat"]))
		{	
			$this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[3]|max_length[20]|checkFaqCategoryExist['.$id.']');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('faqadmin/add_edit_faq_category/'.$id);
				return;
			}
			if($id)
			{
				$catData=$this->faq_category_model->catData($id);
				if(empty($catData))
				{
					$this->session->set_flashdata("cat_error",1);
					redirect("/faqadmin/categories");
				}
			}

			$saved=$this->faq_category_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("category_saved",1);
				else
				{
					$this->session->set_flashdata("category_created",1);
				}
			}
			redirect('faqadmin/add_edit_faq_category/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'faqs/admin/add_edit_faq_category' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['cat_data']=$this->faq_category_model->catData($id);
				if(empty($data['cat_data']))
				{
					$this->session->set_flashdata("cat_error",1);
					redirect("/faqadmin/categories");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);  
		}
	}
	function deletecategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->faq_category_model->catData($id);
			if(!empty($catData))
			{
				$faqs=$this->faq_model->getFaqsByCategory($id);
				if(empty($faqs))
				{
					$r=$this->faq_category_model->delete($id,$catData);
					if($r)
					{
						$data['flag']=1;
						$data['category']=$catData->category;
					}
				}
				else
				{
					$data['flag']=2;
					$data['category']=$catData->category;
				}
			}
		}
		echo json_encode($data);
	}
	public function updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|checkFaqCategory');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->faq_category_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	
	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$faqData=$this->faq_model->faqData($id);
			if(!empty($faqData))
			{
				$r=$this->faq_model->delete($id,$faqData);
				if($r)
				{
					$data['flag']=1;
					$data['id']=$faqData->fid;
				}
			}
		}
		echo json_encode($data);
	}
	public function category_check()
	{
		$exist=$this->faq_category_model->faqcat_exist($_POST['id'],$_POST['category']);
		if($exist) echo 0;
		else echo 1;
	}
}
?>