<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Eventsadmin extends CI_Controller 
{
	var $location='';
	var $service='content';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/events_model');
		$this->load->model('content/events_category_model');
		$this->load->model('content/events_images_model');
		$this->load->model('content/events_description_images_model');
		$this->load->model('content/event_attachments_model');
		$this->load->model('category/categories_model');
		$this->load->model('ashrams/ashrams_model');
		$this->load->model("mobile/mobileNotifications_model");
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				$this->categories_model->fetchCategories(0,$this->currentUser->ashram_id);
			}
			else
			{
				if($this->session->userdata("ashramId"))
					$this->categories_model->fetchCategories(0,$this->session->userdata("ashramId"));
				else
					$this->categories_model->fetchCategories();
			}
		}
		else
		{
			$this->categories_model->fetchCategories();	
		}
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
    }
	function index()
	{
		$views = array( 'events/admin/list' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Events Listing");
	}

	public function listc($excel=0)
	{
		$ashramId = $this->session->userdata("ashramId");
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
		{
			if($this->currentUser->ashram_id)
				$ashramId=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashramId=$this->currentUser->satsang_id;
		}
		$ashramId = isset($ashramId)?$ashramId:'';
		$list=$this->events_model->listAdmin($ashramId,$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Events Listing ajax request");
	}

	public function changestatus($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($status) && in_array($status,array(0,1)))
		{
			$eventData=$this->events_model->eventData($id);
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					$data['views'] = array('common/public/error');
                	$this->load->view(FRONTEND_TEMPLATE,$data);
                	return;
				}
			}
			if(!empty($eventData['event']) && $eventData['event']->status!=$status)
			{
				$r=$this->events_model->changeStatus($id,$status);
				if($r)
				{
					$data['flag']=1;
					$data['name']=$eventData['event']->name;
				}
			}
		}
		echo json_encode($data);
	}
	public function notify($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$eventData=$this->events_model->eventData($id);
			if(empty($eventData['event']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			if($eventData['event']->mobile_notification == 1)
			{
				$data['flag']=2;
				goto end;
			}
			$this->load->library("one_signal");
			$this->one_signal->sendNotification("New Event - ".$eventData['event']->name,1,array('key'=>'events','id'=>$id));
			$r=$this->events_model->changenotifyStatus($id,1);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$eventData['event']->name;
				$this->logaction->log($this->service,"Admin - Event '".$eventData['event']->name."' notified - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function add_edit_event($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$eventData=$this->events_model->eventData($id);
			if(empty($eventData['event']))
			{
				$this->session->set_flashdata("event_error",1);
				redirect('eventsadmin');
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					$data['views'] = array('common/public/error');
                	$this->load->view(FRONTEND_TEMPLATE,$data);
                	return;
				}
			}
		}
		else
		{
			$eventData=array();
		}

		if($this->input->post("save_event"))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("event_error",1);
				redirect('eventsadmin/add_edit_event/'.$id);
			}

			$this->form_validation->set_rules('name', 'Event Title', 'trim|required|min_length[6]|max_length[200]|eventNameCheck['.$id.']');
			$this->form_validation->set_rules('location', 'Event Location', 'trim|required|min_length[3]|max_length[100]');
			/*if($this->input->post("ashram_id")!=0)
			{
				$this->form_validation->set_rules('ashram_id', 'Ashram', 'trim|required|numeric|checkAshramId');
			}*/
			$this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
			$this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
			if($this->input->post('start_date'))
				$this->form_validation->set_rules('end_date', 'End Date', 'trim|required|eventDateRangeCheck['.$this->input->post('start_date').']');
			$this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
			$this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("event_error",1);
				redirect('eventsadmin/add_edit_event/'.$id);
				return;
			}
			$this->load->library("one_signal");
			$saved=$this->events_model->save($id,$eventData);
			if($id==0)
			{
				$this->session->set_flashdata("event_created",1);
			}
			else
				$this->session->set_flashdata("event_saved",1);
			redirect('eventsadmin/add_edit_event/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($eventData['event'])) )
			{
				redirect('eventsadmin');
			}
			$views = array('events/admin/add_edit_event');
			$data = array('views'=>$views,'id'=>$id);
			$data['ashrams']=$this->ashrams_model->getList();
			if(is_numeric($id) && $id)
			{
				$data['eventData']=$eventData;
				if($eventData['event']->ashram_id)
					$data['ashramData']=$this->ashrams_model->ashramData($eventData['event']->ashram_id);
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	public function uploadimages($eventId=0)
	{
		$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
		$json['files']=[];
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			if(!empty($eventData['event']) && isset($_FILES['files']))
			{
				foreach ($_FILES['files']['name'] as $key => $file)
				{
					$ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);
					if($ext=='' || !in_array($_FILES['files']['type'][$key],$allowed_file_types))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Extension not allowed",
			            'status'=>0
			        	);
					}
					else if($_FILES['files']['size'][$key]==0)
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Invalid File Size",
			            'status'=>0
			        	);
					}
					else if($_FILES['files']['size'][$key]>(5*1024*1024))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "File Size exceeded 5 MB",
			            'status'=>0
			        	);
					}
					else
					{	
		        		$json['files'][0]=$this->events_images_model->uploadFile($eventData);
		        		$json['files'][0]['name']=$file;
		        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
		        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
		        		$json['files'][0]['status']=1;
		        	}
				}
				echo json_encode($json);
			}
			else
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Invalid Event ID",
		            'status'=>0
		        	);
				}
				end:
				echo json_encode($json);
			}
		}
	}

	function uploadattachments($eventId=0)
	{
		$exts=$GLOBALS['site_settings']['blocked_file_types'];
		$excludedExtensions=explode("|",$exts);
		
		$json['files']=[];
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			if(!empty($eventData['event']) && isset($_FILES['files']))
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);

					
					if($ext=='' || in_array($ext,$excludedExtensions))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Extension not allowed",
			            'status'=>0
			        	);
					}
					else if($_FILES['files']['size'][$key]==0)
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Invalid File Size",
			            'status'=>0
			        	);
					}
					else if($_FILES['files']['size'][$key]>(5*1024*1024))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "File Size exceeded 5 MB",
			            'status'=>0
			        	);
					}
					else
					{	
		        		$json['files'][0]=$this->event_attachments_model->uploadFile($eventData);
		        		$json['files'][0]['name']=$file;
		        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
		        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
		        		$json['files'][0]['status']=1;
		        	}
				}
				echo json_encode($json);
			}
			else
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Invalid Event ID",
		            'status'=>0
		        	);
				}
				end:
				echo json_encode($json);
			}
		}
	}

	function deleteimage($eventId=0,$imageId=0)
	{
		$data['flag']=0;
		if(is_numeric($eventId) && $eventId && is_numeric($imageId) && $imageId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				goto end;
			}

			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}

			$imageData=$this->events_images_model->imageData($imageId,$eventId);
			if(!empty($imageData))
			{
				$r=$this->events_images_model->delete($eventData,$imageData);
				if($r)
				{
					$data['flag']=1;
					$data['filename']=$imageData->filename;
				}
			}
		}
		end:
		echo json_encode($data);
	}

	function deleteattachment($eventId=0,$attachmentId=0)
	{
		$data['flag']=0;
		if(is_numeric($eventId) && $eventId && is_numeric($attachmentId) && $attachmentId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			$attachmentData=$this->event_attachments_model->attachmentData($attachmentId,$eventId);
			if(!empty($attachmentData))
			{
				$r=$this->event_attachments_model->delete($eventData,$attachmentData);
				if($r)
				{
					$data['flag']=1;
					$data['filename']=$attachmentData->filename;
				}
			}
		}
		end:
		echo json_encode($data);
	}

	public function bulk_delete($eventId=0)
	{
		$data['flag']=0;
		$data['count']=0;
		$data['ids']=array();
		if(is_numeric($eventId) && $eventId && $this->input->post('ids') && !empty($this->input->post('ids')))
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			foreach ($this->input->post('ids') as $imageId)
			{
				$imageData=$this->events_images_model->imageData($imageId,$eventId);
				if(!empty($imageData))
				{
					$r=$this->events_images_model->delete($eventData,$imageData);
					if($r)
					{
						$data['count']++;
						$data['ids'][]=$imageId;
					}
				}
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}

	public function bulk_delete_attachments($eventId=0)
	{
		$data['flag']=0;
		$data['count']=0;
		$data['idsa']=array();
		if(is_numeric($eventId) && $eventId && $this->input->post('idsa') && !empty($this->input->post('idsa')))
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			foreach ($this->input->post('idsa') as $attachmentId)
			{
				$attachmentData=$this->event_attachments_model->attachmentData($attachmentId,$eventId);
				if(!empty($attachmentData))
				{
					$r=$this->event_attachments_model->delete($eventData,$attachmentData);
					if($r)
					{
						$data['count']++;
						$data['idsa'][]=$attachmentId;
					}
				}
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}
	
	public function updatefileinfoimages($eventId=0)
	{
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				echo 0;
				exit;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					echo 0;
					exit;
				}
			}
			$this->form_validation->set_rules('value', 'Value', 'trim|max_length[200]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$this->events_images_model->updateInfo($this->input->post('pk'),'description',$this->input->post('value'));
		}
	}
	public function updatefileinfoimagesorder($eventId=0)
	{
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				echo 0;
				exit;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					echo 0;
					exit;
				}
			}
			$this->form_validation->set_rules('value', 'Value', 'trim|numeric|max_length[3]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$this->events_images_model->updateInfo($this->input->post('pk'),'order',$this->input->post('value'));
		}
	}

	public function updatefileinfoattachments($eventId=0)
	{
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				echo 0;
				exit;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					echo 0;
					exit;
				}
			}
			$this->form_validation->set_rules('value', 'Value', 'trim|max_length[200]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$this->event_attachments_model->updateInfo($this->input->post('pk'),'description',$this->input->post('value'));
		}
	}
	public function updatefileinfoattachmentsorder($eventId=0)
	{
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(empty($eventData['event']))
			{
				echo 0;
				exit;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					echo 0;
					exit;
				}
			}
			$this->form_validation->set_rules('value', 'Value', 'trim|numeric|max_length[3]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$this->event_attachments_model->updateInfo($this->input->post('pk'),'order',$this->input->post('value'));
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$eventData=$this->events_model->eventData($id);
			if(empty($eventData['event']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($eventData['event']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			$children=$this->events_model->getChildren($id);
			if(!empty($children))
			{
				$data['flag']=2;
				goto end;
			}
			$r=$this->events_model->delete($id,$eventData);
			if($r)
			{
				//deleting related notification data also
				$this->mobileNotifications_model->remove($id,'events');
				$data['flag']=1;
				$data['name']=$eventData['event']->name;
				$this->logaction->log($this->service,"Admin - Event '".$eventData['event']->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function event_validate($eid=0,$pid=0)
	{
		if(is_numeric($eid) && is_numeric($pid) && $pid)
		{
			if($eid==$pid)
			{
				echo 2;
			}
			else
			{
				$ashramId = $this->session->userdata("ashramId");
				if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
				{
					if($this->currentUser->ashram_id)
						$ashramId=$this->currentUser->ashram_id;
				}
				$ashramId = isset($ashramId)?$ashramId:0;
				$parentEventData=$this->events_model->checkEventId($pid,$ashramId);
				if(!empty($parentEventData['event']))
				{
					echo $parentEventData['event']->name."<br>".date("d M Y",strtotime($parentEventData['event']->start_date));
				}
				else
					echo 0;
			}
		}
		else
			echo 0;
	}
	public function titlecheck($id=0)
	{
		if($this->input->post('title')!='')
		{
			$slug=url_title($this->general_model->filtertext($this->input->post('title')));
			if(strlen($slug)<6)
				echo 0;
			else
			{
				if(is_numeric($id))
				{
					$flag=$this->events_model->checkEventName($this->general_model->filtertext(trim($this->input->post('title'))),$id);
					if($flag==1)
						echo 2;
					else
						echo 1;
				}
				else
					echo 0;
			}
		}
	}

	public function report()
	{
		$views = array( 'events/admin/report' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Events Report");
	}

	public function listreport($excel=0)
	{
		$ashramId = $this->session->userdata("ashramId");
		if($this->currentUser->roles!=1)
		{
			if($this->currentUser->ashram_id)
				$ashramId=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashramId=$this->currentUser->satsang_id;
		}
		$ashramId = isset($ashramId)?$ashramId:0;
		$list=$this->events_model->listReport($excel,$ashramId);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Events Report ajax request");
	}

	public function fb_posts()
	{
		$views = array( 'events/admin/fb_posts_cron' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Opened FB Posts Cron page");
	}

	public function fb_albums()
	{
		$views = array( 'events/admin/fb_albums_cron' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Opened FB Albums Cron page");
	}

	public function fb_get_posts()
	{
		header('Content-Type: text/html; charset=utf-8');
		$this->events_model->getFBPosts();
	}

	public function fb_get_albums()
	{
		header('Content-Type: text/html; charset=utf-8');

		$this->events_model->getFBAlbums();
	}
}
?>