<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Events extends CI_Controller 
{
	var $currentUser='';
	var $months=array(1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December");
    function __construct() 
	{
        parent::__construct();
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
		$this->load->model('content/events_model');
		$this->load->model('content/event_attachments_model');
		$this->load->model('content/events_images_model');
        $this->load->model('category/categories_model');
        $this->load->model('content/album_model');
        $this->load->model('content/album_images_model');
        $this->categories_model->fetchCategories();
    }
    public function index($year=0)
    {
    	$data = array('year'=>$year);
    	$yearmonths=$this->events_model->getYearMonths();
    	if(isset($_GET['year']) && $_GET['year']!='' && !in_array($_GET['year'], $yearmonths['years']))
    	{
    		$redirectUrl = 'events?';
    		if(isset($_GET['category']) && $_GET['category']>0)
    		{
    			$redirectUrl .= "category=".$_GET['category'];
    		}
    		else
    		{
    			$redirectUrl .= "category=";
    		}
    		$redirectUrl .= "&year=&month=";
    		if(isset($_GET['text']) && $_GET['text']!="")
    		{
    			$redirectUrl .= "&text=".$_GET['text'];
    		}
    		redirect($redirectUrl);
    	}
    	$data['yearmonths']=$yearmonths;
    	$data['views'] = array('events/public/list');
		$this->load->view(FRONTEND_TEMPLATE,$data);
    }
    public function listc()
	{
        $list=$this->events_model->listPublic();
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$this->search_log_model->log(trim($_POST['search_text']),'events');
		}
		echo json_encode($list);
	}
   	public function view($year=0,$slug='')
	{
		if($slug!='')
		{
			$eventData=$this->events_model->eventDataBySlug($slug);
			if(empty($eventData['event']))
			{
				goto end;
			}
			if($eventData['event']->status!=1)
			{
				goto end;
			}
			if(!empty($eventData['event']))
			{
				if($eventData['event']->year!=$year)
				{
					goto end;
				}
				/*$countUpdate=1;
				if($this->session->userdata("loggedIn") && $this->currentUser->role==1)
				{
					$countUpdate=0;
				}*/
				/*if($countUpdate==1)
				$this->events_model->updateReadCount($eventData['event']->id,($eventData['event']->reads+1));*/
				$data = array('eventData'=>$eventData);
				if($eventData['event']->ashram_id)
				{
					$data['ashramData']=$this->ashrams_model->ashramData($eventData['event']->ashram_id);
					if($eventData['event']->ashram_id != default_ashram_id)
					{
						redirect('ashrams/'.$data['ashramData']->slug.'/events/'.$eventData['event']->year.'/'.$eventData['event']->slug);
					}
				}
				if($eventData['event']->satsang_id)
					$data['satsangData']=$this->satsangs_model->satsangData($eventData['event']->satsang_id);
				$data['views'] = array('events/public/view');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
			}
		}
		end:
		$data['views'] = array('common/public/error');
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function category($category='')
	{
		$data = array('category'=>$category,'service'=>'');
		if(isset($this->categories_model->categoriesList['categories'][$category]))
		{
			$data['categoryExist']=1;
			$data['categoryName']=htmlentities($this->categories_model->categoriesList['categories'][$category]->category);
			$data['categoryId']=$this->categories_model->categoriesList['categories'][$category]->id;
		}
		else
		{
			$data['categoryName']="All Categories";
			$data['categoryId']=0;
		}
		$data['views'] = array('events/public/category_view');
		$this->load->view(FRONTEND_TEMPLATE,$data);
    }
    public function listbycategory($categorySlug='')
	{
		$categoryId=0;
		if(isset($_POST['category']))
		{
			$category=$_POST['category'];
			if(isset($this->categories_model->categoriesList['categories'][$category]))
			{
				$categoryId=$this->categories_model->categoriesList['categories'][$category]->id;
			}
		}
		$list=$this->events_model->listPublicByCategory($categoryId);
		echo json_encode($list);
	}
}
?>
