<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Emailsmssubscriptionsadmin extends CI_Controller 
{
	var $service='websiteadmin';
	var $groups = '';
    function __construct()
    {
        parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model("subscriptions_email_model");
		$this->load->model("subscriptions_sms_model");
		$this->load->model("subscriptions/subscription_groups_model");
		$this->load->model("subscriptions/newsletters_model");
		$this->load->model("subscriptions/newsletter_images_model");
		$this->load->model("subscriptions/newsletters_que_model");
		$this->load->model("subscriptions/newsletters_sms_que_model");
		$this->groups = $this->subscription_groups_model->getAllGroups();
    }
    public function index()
	{
		$views = array( 'subscriptions/admin/list' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);  
	}
	public function sms()
	{
		$views = array( 'subscriptions/admin/list_sms' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);  
	}
	public function liste($excel=0)
	{
		$list=$this->subscriptions_email_model->getList($excel);
		echo json_encode($list);
	}
	public function lists($excel=0)
	{
		$list=$this->subscriptions_sms_model->getList($excel);
		echo json_encode($list);
	}
	public function sms_delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$subscriptionData=$this->subscriptions_sms_model->subscriptionData($id);
			if(empty($subscriptionData))
			{
				goto end;
			}
			$this->subscriptions_sms_model->delete($id);
			$data['flag']=1;
			$data['phone']='+'.$subscriptionData->isd_code."-".$subscriptionData->phone;
		}
		end:
		echo json_encode($data);
	}
	public function group_delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$groupData = $this->subscription_groups_model->getGroupById($id);
			if(empty($groupData))
			{
				goto end;
			}
			$smscheck = $this->subscription_groups_model->subsmsDatabyGroupId($id);
			$emailcheck = $this->subscription_groups_model->subemailDatabyGroupId($id);
			if($smscheck || $emailcheck)
			{
				$data['flag']=2;
				$data['group']=$groupData->group_name;
			}
			else
			{
				$this->subscription_groups_model->delete($id);
				$data['flag']=1;
				$data['group']=$groupData->group_name;
			}
		}
		end:
		echo json_encode($data);
	}
	public function email_delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$subscriptionData=$this->subscriptions_email_model->subscriptionData($id);
			if(empty($subscriptionData))
			{
				goto end;
			}
			$this->subscriptions_email_model->delete($id);
			$data['flag']=1;
			$data['email']=$subscriptionData->email;
		}
		end:
		echo json_encode($data);
	}
	public function newsletters()
	{
		$views = array( 'subscriptions/admin/list_newsletters' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed newsletters page");
	}
	public function listns($excel=0)
	{
		$list=$this->newsletters_model->listNewsletters($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed newsletters ajax request");
	}

	public function mail_queue($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("emailsmssubscriptionsadmin");
			}
			if($newsletterData->type==1)
				$views = array( 'subscriptions/admin/list_newsletter_queue');
			if($newsletterData->type==2)
				$views = array( 'subscriptions/admin/list_newsletter_sms_queue');
			$data = array('views'=>$views);
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect('emailsmssubscriptionsadmin');
		}
	}
	public function listqueue($id=0,$excel=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				return;
			}
			if($newsletterData->type==1)
				$list=$this->newsletters_que_model->listQueue($newsletterData,$excel);
			if($newsletterData->type==2)
				$list=$this->newsletters_sms_que_model->listQueue($newsletterData,$excel);

			echo json_encode($list);
		}
	}

	public function add_edit_newsletter($id=0)
	{
		if(isset($_POST["add_newsletter"]) || isset($_POST["send_newsletter"]))
		{
			if(!isset($_POST['content']))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('emailsmssubscriptionsadmin/add_edit_newsletter/'.$id);
			}
			$this->form_validation->set_rules('type', 'Type', 'trim|numeric|newsletterType');
			if($this->input->post("type")==1)
			{
				$this->form_validation->set_rules('subject', 'Newsletter Subject', 'trim|required|min_length[6]|max_length[200]');
			}
			else if($this->input->post("type")==2)
			{
				$this->form_validation->set_rules('message', 'Message', 'trim|required|min_length[6]|max_length[300]');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('emailsmssubscriptionsadmin/add_edit_newsletter/'.$id);
				return;
			}
			if($id)
			{
				$newsletterData=$this->newsletters_model->newsletterData($id);

				if(empty($newsletterData))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("emailsmssubscriptionsadmin");
				}
				if($newsletterData->status!=1)
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("emailsmssubscriptionsadmin");
				}
			}
			$saved=$this->newsletters_model->save($id);
			
			if($saved)
			{
				if($id)
				{
					$this->session->set_flashdata("newsletter_saved",1);
				}
				else
				{
					$this->session->set_flashdata("newsletter_created",1);
				}
				if(isset($_POST['send_newsletter']))
				{
					$this->newsletters_model->sendNewsletter($saved);
					redirect('emailsmssubscriptionsadmin/view_newsletter/'.$saved);
					return;
				}
			}
			redirect('emailsmssubscriptionsadmin/add_edit_newsletter/'.$saved);
		}
		else
		{
		 	$views = array( 'subscriptions/admin/add_edit_newsletter' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	
			if($id)
			{
				$data['newsletterData']=$this->newsletters_model->newsletterData($id);
				if($data['newsletterData']->field_userids!='')
			 	{
			 		if($data['newsletterData']->type==1)
			 		{
			 			$data['users']=$this->subscriptions_email_model->getByIds(explode(",",$data['newsletterData']->field_userids));
			 			$data['groupids']=$this->subscription_groups_model->getGroupNamesbyIds(explode(",",$data['newsletterData']->field_groups));
			 		}

			 		else if($data['newsletterData']->type==2)
			 		{
			 			$data['countries']=$this->locations_model->getCountriesByCode(explode(",",$data['newsletterData']->field_country));
			 			$data['users']=$this->subscriptions_sms_model->getByIds(explode(",",$data['newsletterData']->field_userids));
			 			$data['groupids']=$this->subscription_groups_model->getGroupNamesbyIds(explode(",",$data['newsletterData']->field_groups));
			 		}
			 	}

				if(empty($data['newsletterData']))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("emailsmssubscriptionsadmin");
				}
				if($data['newsletterData']->status==2)
				{
					redirect("emailsmssubscriptionsadmin/view_newsletter/".$id);
				}
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function view_newsletter($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->newsletters_model->newsletterData($id);
			if($newsletterData->field_groups)
				$newsletterData->field_groups = $this->subscription_groups_model->getGroupNames($newsletterData->field_groups);
			else
				$newsletterData->field_groups = "";

			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("emailsmssubscriptionsadmin");
			}
			if($newsletterData->status!=2)
			{
				redirect("emailsmssubscriptionsadmin/add_edit_newsletter/".$id);
			}
		 	$views = array('subscriptions/admin/view_newsletter');
		 	$data = array('views'=>$views,'id'=>$id);
			$data['newsletterData']=$newsletterData;
			$data['countries']=$this->locations_model->getCountriesByCode(explode(",",$data['newsletterData']->field_country));
			if($data['newsletterData']->type==1)
			{
	 			$data['users']=$this->subscriptions_email_model->getByIds(explode(",",$data['newsletterData']->field_userids));
			}
	 		else if($data['newsletterData']->type==2)
	 		{
	 			$data['users']=$this->subscriptions_sms_model->getByIds(explode(",",$data['newsletterData']->field_userids));
	 		}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect("emailsmssubscriptionsadmin");
		}
	}

	public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->newsletters_model->newsletterData($id);
			if(!empty($newsletterData) && $newsletterData->status==1)
			{
				$r=$this->newsletters_model->delete($id,$newsletterData);
				if($r)
				{
					$data['flag']=1;
					$data['unique_id']=$newsletterData->unique_id;
				}
			}
		}
		echo json_encode($data);
	}

	public function resend($id=0,$qid=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($qid) && $qid)
		{
			$newsletterData=$this->newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				goto end;
			}
			$mailData=$this->newsletters_que_model->mailData($qid);
			if(empty($mailData) || $mailData->newsletter_id!=$id || $mailData->status==0)
			{
				goto end;
			}
			$r=$this->newsletters_que_model->resend($qid,$mailData);
			if($r)
			{
				$data['flag']=1;
				$data['email']=$mailData->mail_to;
			}
		}
		end:
		echo json_encode($data);
	}

	public function groups()
	{
		$views = array( 'subscriptions/admin/list_groups' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data); 
	}

	public function listg($excel=0)
	{
		$list=$this->subscription_groups_model->getList($excel);
		echo json_encode($list);
	}

	public function add_edit_group($id = 0)
	{
		
		if(isset($_POST["add_group"]))
		{
			$this->form_validation->set_rules('group_name', 'Group', "trim|required|min_length[3]|max_length[100]|name_validate11|groupCheck[$id]");
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('group_error',1);
				redirect('emailsmssubscriptionsadmin/add_edit_group/'.$id);
			}
			$saved=$this->subscription_groups_model->saveGroup($id);
			if($saved)
			{
				if($id)
					$this->session->set_flashdata('group_saved',1);
				else
					$this->session->set_flashdata('group_created',1);
			}
			else
				$this->session->set_flashdata('group_error',1);
			redirect('emailsmssubscriptionsadmin/add_edit_group/'.$saved);
		}
		else
		{
		 	$views = array( 'subscriptions/admin/add_edit_group' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$groupData = $this->subscription_groups_model->getGroupById($id);
			if($id && !empty($groupData))
			{
				$data['groupData']=$groupData;
			}
			if($id && empty($groupData))
			{
				$this->session->set_flashdata('group_error',1);
				redirect('emailsmssubscriptionsadmin/groups');
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function group_exists($groupID=0)
	{
		if(is_numeric($groupID))
			echo $this->subscription_groups_model->groupexistCheck(trim($_POST['name']),$groupID);
		else
			echo 0;
	}

	public function update($service)
	{
		$subscriptionId = $this->input->post('pk'); #PrimaryKey
		$inputName = $this->input->post('name');
		$groups = $this->input->post('value');
		if($subscriptionId && $inputName && $groups && $service)
		{
			if($inputName == "name")
			{
				if (!preg_match('/^[a-zA-Z0-9 \.\-\,\"]+$/i', $this->input->post('value')))
				{
					echo "please enter valid Name";
					return false;
				}
				$updatedata = array('name'=>$groups);
			}
			if($inputName == "mobile")
			{
				if($this->form_validation->numeric($this->input->post('value'))==false)
				{
					echo "please enter valid Phone";
					return false;
				}
				$uch=$this->subscriptions_sms_model->phoneCheck($this->input->post('value'),$subscriptionId);
				if($uch)
				{
					echo "Mobile Number Already Existed";
					return false;
				}
				$updatedata = array('phone'=>$groups);
			}
			if($inputName == "country")
			{
				if($this->form_validation->countryCheck($this->input->post('value'))==false)
				{
					echo "please enter valid Country";
					return false;
				}
				$updatedata = array('country_code'=>$this->input->post('value'));
			}
			if($inputName == "email")
			{
				if($this->form_validation->valid_email_custom($this->input->post('value'))==false)
				{
					echo "please enter valid Email";
					return false;
				}
				$uch=$this->subscriptions_email_model->emailCheck($this->input->post('value'),$subscriptionId);
				if($uch)
				{
					echo "Email Already Existed";
					return false;
				}
				$updatedata = array('email'=>$groups);
			}
			if($inputName == "city")
			{
				if($this->form_validation->name_validate13($this->input->post('value'))==false)
				{
					echo "please enter valid City";
					return false;
				}
				$updatedata = array('city'=>$groups);
			}
			if($service == "sms")
				$success = $this->subscriptions_sms_model->update($updatedata,$subscriptionId);
			if($service == "email")
				$success = $this->subscriptions_email_model->updategroups($updatedata,$subscriptionId);
			if($success)
				echo 1;
		} 
		else 
		{
			echo "Not Updated, Please try again.";
		}
		
	}

	/**
	 * [Update groups for subscriptions [Tags Mode]]
	 * @return [bool] [JSON DATA]
	 * @author Baji SHaik <bajidotwork@gmail.com>
	 */
	public function updategroups($service)
	{
		$subscriptionId = $this->input->post('pk'); #PrimaryKey
		$inputName = $this->input->post('name');
		$groups = $this->input->post('value');
		if($subscriptionId && $inputName && $groups && $service)
		{
			$groupsdata = $this->subscription_groups_model->insertupdategroup($groups,$subscriptionId);
			if($service == "sms")
				$this->subscriptions_sms_model->update($groupsdata,$subscriptionId,1);
			if($service == "email")
				$this->subscriptions_email_model->updategroups($groupsdata,$subscriptionId,1);
			$this->session->set_flashdata("groups_success",1);
			echo 1;
		} 
		else 
		{
			echo "Group Not assigned, Please try again.";
		}
	}

	/**
	 * [Import SMS Subscriptions {csv/Xls}]
	 * @author Baji Shaik <bajidotwork@gmail.com>
	 * @package [PHP EXCEL]
	 */
	public function add_bulk_sms_subscriptions()
	{
		if(isset($_POST['save_csv']))
		{
			if(!isset($_FILES['sub_sms_file']['name']) || $_FILES['sub_sms_file']['name']=='')
			{
				$this->session->set_flashdata("upload_error1","Invalid file");
				redirect("emailsmssubscriptionsadmin/add_bulk_sms_subscriptions");
			}
			$this->load->model("user/users_reserved_model");
			
			$name=$_FILES['sub_sms_file']['name'];
			$tmp=$_FILES['sub_sms_file']['tmp_name'];
			move_uploaded_file($tmp,dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name);
			
			$this->load->library("Excel");
			$inputFileName = dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name;
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objReader->setReadDataOnly(true);//Get the area of data inserted
			$objPHPExcel = $objReader->load($inputFileName);

			$sheetData=$objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

			$cols=$sheetData[1];
			if(count($cols)!=5)
			{
				$this->session->set_flashdata("upload_error1","Invalid data format.");
				redirect("emailsmssubscriptionsadmin/add_bulk_sms_subscriptions");
			}
			if($cols['A']!='name' || $cols['B']!='phone' || $cols['C']!='country_code' || $cols['D']!='city' || $cols['E']!='group_ids' )
			{
				$this->session->set_flashdata("upload_error1","Invalid data format");
				redirect("emailsmssubscriptionsadmin/add_bulk_sms_subscriptions");
			}
			unset($sheetData[1]);

			if(count($sheetData)==0)
			{
				$this->session->set_flashdata("upload_error1","File contains no data.");
				redirect("emailsmssubscriptionsadmin/add_bulk_sms_subscriptions");
			}
			
			$rownum=1;
			$error='';
			$skipped=0;
			$done=0;
			$e=0;
			$tempnum=0;
			foreach($sheetData as $rr)
			{
				if(trim($rr['A'])=='' || trim($rr['B'])=='' || trim($rr['C'])=='' || trim($rr['D'])=='' || trim($rr['E'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Insufficient data";
					$rownum++;
					$skipped++;
					continue;
				}
				$e=0;
				$eName=trim($rr['A']);
				$ePhone=trim($rr['B']);
				$eCountry=trim($rr['C']);
				$eCity=trim($rr['D']);
				$eGroup_ids=trim($rr['E']);
				if(strlen(trim($rr['A']))<2)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must be at least 3 character";
				}
				else if(strlen(trim($rr['A']))>100)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must not be more than 100 characters";
				}
				else if (!preg_match('/^[a-zA-Z0-9 \.\-\,\"]+$/i', trim($rr['A'])))
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must contain letters and numbers only";
				}

				//Groups Validation
				if($eGroup_ids!='')
				{
					$groupcheck=$this->subscription_groups_model->groupvalidation($eGroup_ids);
					if($groupcheck)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Invalid Groups Assigned ";
						$e=1;
					}
				}
				
				//Mobile Number Validation
				if($ePhone!='')
				{
					if(strlen($ePhone)<10)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must be at least 10 characters";
						$e=1;
					}
					
					else if(strlen($ePhone)>15)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must not be more than 15 characters ";
						$e=1;
					}
					else if ($this->form_validation->numeric($ePhone)==false)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must be numeric ";
						$e=1;
					}
					else
					{
						$uch=$this->subscriptions_sms_model->phoneCheck($ePhone,0);
						if($uch)
						{
							if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
							if($e==0) $error.=" Row No: $rownum";
							else $error.=" | ";
							$error.=" Phone number already exists ";
							$e=1;
						}
					}
				}
				if($eCity != "")
				{
					if(strlen($eCity)<2)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) 
							$error.=' ,';
						$e=1;
						$error.="Row No:$rownum City must be at least 2 character";
					}
					else if ($this->form_validation->name_validate13($eCity)==false)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" City is invalid ";
						$e=1;
					}
				}
				

				if ($this->form_validation->countryCheck($eCountry)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" Country is invalid ";
					$e=1;
				}
				
				$tempnum=$rownum;
				
				$rownum++;
				if($e==0)
				{
					$rInfo['subscribe_name2']=$eName;
					$rInfo['country_code']=strtoupper($eCountry);
					$rInfo['subscribe_city2']=$eCity;
					$rInfo['group_ids']=$eGroup_ids;
					$rInfo['subscribe_phone']=$ePhone;

					$data=$this->subscriptions_sms_model->subscribe($rInfo);
					$done++;
				}
				else $skipped++;
				
			}
			$this->session->set_flashdata("upload_error",$error);
			$this->session->set_flashdata("upload_done",1);
			$this->session->set_flashdata("skipped",$skipped);
			$this->session->set_flashdata("done",$done);
			redirect("emailsmssubscriptionsadmin/add_bulk_sms_subscriptions");
		}
		$views = array( 'subscriptions/admin/bulk_sms_subscriptions_upload');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	/**
	 * [Import Email Subscriptions {csv/Xls}]
	 * @author Baji Shaik <bajidotwork@gmail.com>
	 * @package [PHP EXCEL]
	 */
	public function add_bulk_email_subscriptions()
	{
		if(isset($_POST['save_csv']))
		{
			if(!isset($_FILES['sub_sms_file']['name']) || $_FILES['sub_sms_file']['name']=='')
			{
				$this->session->set_flashdata("upload_error1","Invalid file");
				redirect("emailsmssubscriptionsadmin/add_bulk_email_subscriptions");
			}
			$this->load->model("user/users_reserved_model");
			
			$name=$_FILES['sub_sms_file']['name'];
			$tmp=$_FILES['sub_sms_file']['tmp_name'];
			move_uploaded_file($tmp,dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name);
			
			$this->load->library("Excel");
			$inputFileName = dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name;
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objReader->setReadDataOnly(true);//Get the area of data inserted
			$objPHPExcel = $objReader->load($inputFileName);

			$sheetData=$objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

			$cols=$sheetData[1];
			if(count($cols)!=5)
			{
				$this->session->set_flashdata("upload_error1","Invalid data format.");
				redirect("emailsmssubscriptionsadmin/add_bulk_email_subscriptions");
			}
			if($cols['A']!='name' || $cols['B']!='email' || $cols['C']!='country_code' || $cols['D']!='city' || $cols['E']!='group_ids')
			{
				$this->session->set_flashdata("upload_error1","Invalid data format");
				redirect("emailsmssubscriptionsadmin/add_bulk_email_subscriptions");
			}
			unset($sheetData[1]);

			if(count($sheetData)==0)
			{
				$this->session->set_flashdata("upload_error1","File contains no data.");
				redirect("emailsmssubscriptionsadmin/add_bulk_email_subscriptions");
			}
			
			$rownum=1;
			$error='';
			$skipped=0;
			$done=0;
			$e=0;
			$tempnum=0;
			foreach($sheetData as $rr)
			{
				if(trim($rr['A'])=='' || trim($rr['B'])=='' || trim($rr['C'])=='' || trim($rr['D'])=='' || trim($rr['E'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Insufficient data";
					$rownum++;
					$skipped++;
					continue;
				}
				$e=0;
				$eName=trim($rr['A']);
				$eEmail=trim($rr['B']);
				$eCountry=trim($rr['C']);
				$eCity=trim($rr['D']);
				$eGroup_ids=trim($rr['E']);
				if(strlen(trim($rr['A']))<2)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must be at least 3 character";
				}
				else if(strlen(trim($rr['A']))>100)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must not be more than 100 characters";
				}
				else if (!preg_match('/^[a-zA-Z0-9 \.\-\,\"]+$/i', trim($rr['A'])))
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must contain letters and numbers only";
				}

				//Groups Validation
				if($eGroup_ids!='')
				{
					$groupcheck=$this->subscription_groups_model->groupvalidation($eGroup_ids);
					if($groupcheck)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Invalid Groups Assigned ";
						$e=1;
					}
				}
				
				//Email Validations				
				if(strlen($eEmail)<6)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Email ID must be at least 6 character";
				}
				else if(strlen($eEmail)>200)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Email ID must not be more than 200 characters";
				}
				else if ($this->form_validation->valid_email_custom($eEmail)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$e=1;
					$error.="Row No:$rownum Email ID is invalid";
				}
				else
				{
					$uch=$this->subscriptions_email_model->emailCheck($eEmail,0);
					if($uch)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Email ID already exists ";
						$e=1;
					}
				}
				if($eCity != "")
				{
					if(strlen($eCity)<2)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						$e=1;
						$error.="Row No:$rownum City must be at least 2 character";
					}
					else if ($this->form_validation->name_validate13($eCity)==false)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" City is invalid ";
						$e=1;
					}
				}
				if ($this->form_validation->countryCheck($eCountry)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" Country is invalid ";
					$e=1;
				}
				
				$tempnum=$rownum;
				
				$rownum++;
				if($e==0)
				{
					$rInfo['subscribe_name1']=$eName;
					$rInfo['group_ids']=$eGroup_ids;
					$rInfo['country_code1']=strtoupper($eCountry);
					$rInfo['subscribe_city1']=$eCity;
					$rInfo['subscribe_email']=$eEmail;
					$rInfo['email_verify']=1;

					$data=$this->subscriptions_email_model->subscribe($rInfo);
					$done++;
				}
				else $skipped++;
				
			}
			$this->session->set_flashdata("upload_error",$error);
			$this->session->set_flashdata("upload_done",1);
			$this->session->set_flashdata("skipped",$skipped);
			$this->session->set_flashdata("done",$done);
			redirect("emailsmssubscriptionsadmin/add_bulk_email_subscriptions");
		}
		$views = array( 'subscriptions/admin/bulk_email_subscriptions_upload');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function bulk_delete()
	{
		$result['flag']=0;
		$result['msg']="Invalid request";
		if(isset($_POST['bulk_actions']) && $_POST['bulk_actions']=="remove" && $_POST['service_slug'])
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			foreach($_POST['ids'] as $id)
			{
				if($_POST['service_slug'] == "sms")
					$data=$this->subscriptions_sms_model->delete($id);
				if($_POST['service_slug'] == "email")
					$data=$this->subscriptions_email_model->delete($id);
				$count++;
			}
			$result['flag']=1;
			$result['msg']="'".$count."' Subscription(s) have been deleted successfully.";
			$result['num']=$count;
		}
		echo json_encode($result);
	}

	public function bulk_group_assign()
	{
		$result['flag']=0;
		$result['msg']="Invalid request";
		if(isset($_POST['bulk_actions']) && $_POST['service_slug'])
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			foreach($_POST['ids'] as $id)
			{
				if($_POST['service_slug'] == "sms")
				{
					$groupData = $this->subscriptions_sms_model->checkGroups($id,$_POST['group_data']);
					$data=$this->subscriptions_sms_model->update(array("group_id"=>$groupData),$id);
				}
				if($_POST['service_slug'] == "email")
				{
					$groupData = $this->subscriptions_email_model->checkGroups($id,$_POST['group_data']);
					$data=$this->subscriptions_email_model->updategroups(array("group_id"=>$groupData),$id);
				}
				$count++;
			}
			$result['flag']=1;
			$result['msg']="'".$count."' Subscription(s) have been Assigned successfully.";
			$result['num']=$count;
		}
		echo json_encode($result);
	}

	public function searchuser()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched subscribers with - ".$query);
		if($this->input->post('type')==1)
			$usersData=$this->subscriptions_email_model->searchAll($query);
		else if($this->input->post('type')==2)
			$usersData=$this->subscriptions_sms_model->searchAll($query);

		$resultUsers = [];
		foreach ($usersData as $oneUser)
		{
			if($this->input->post("type")==1)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['name']." (".$oneUser['email'].")");
			}
			else if($this->input->post("type")==2)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['name']." (+".$oneUser['isd_code'].$oneUser['phone'].")");
			}
			else
				$resultUsers[] = $oneUser;
		}
		// Means no result were found
		if (empty($resultUsers)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "user"      => $resultUsers
		    )
		));
	}
	public function searchcountries()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched countries with - ".$query);
		if($this->input->post('type')==1)
			$countriesData=$this->subscriptions_email_model->searchCountries($query);
		else if($this->input->post('type')==2)
			$countriesData=$this->subscriptions_sms_model->searchCountries($query);

		$resultCountries = [];
		foreach ($countriesData as $country)
		{
			if($this->input->post("type")==2)
			{
				$resultCountries[]=array("id"=>$country['country_code'],"text"=>$country['country_name']." (+".$country['isd_code'].")");
			}
			else
				$resultCountries[] = array("id"=>$country['country_code'],"text"=>$country['country_name']);
		}
		// Means no result were found
		if (empty($resultCountries)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "country"      => $resultCountries
		    )
		));
	}

	public function searchgroups()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched subscribers with - ".$query);
		if($this->input->post('type')==1)
			$usersData=$this->subscriptions_email_model->searchbyGroupAll($query);
		else if($this->input->post('type')==2)
			$usersData=$this->subscriptions_sms_model->searchbyGroupAll($query);

		$resultUsers = [];
		foreach ($usersData as $oneUser)
		{
			if($this->input->post("type")==1)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['group_name']);
			}
			else if($this->input->post("type")==2)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['group_name']);
			}
			else
				$resultUsers[] = $oneUser;
		}
		// Means no result were found
		if (empty($resultUsers)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "groups"      => $resultUsers
		    )
		));
	}

	public function email_subscribe_unsubscribe($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$subscriptionData=$this->subscriptions_email_model->subscriptionData($id);
			if(empty($subscriptionData))
			{
				goto end;
			}
			$this->subscriptions_email_model->updateUnsubscribeEmailStatus($id, $status);
			$data['flag']=1;
			$data['email']=$subscriptionData->email;
		}
		end:
		echo json_encode($data);
	}

	public function sms_subscribe_unsubscribe($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$subscriptionData=$this->subscriptions_sms_model->subscriptionData($id);
			if(empty($subscriptionData))
			{
				goto end;
			}
			$this->subscriptions_sms_model->updateUnsubscribeSmsStatus($id, $status);
			$data['flag']=1;
			$data['phone']='+'.$subscriptionData->isd_code."-".$subscriptionData->phone;
		}
		end:
		echo json_encode($data);
	}
	
	public function listemails(){}
	public function listsms(){}
	public function email_data(){}
	public function sms_data(){}
	public function email_resend(){}
	public function bulk_resend(){}
	public function sms_resend(){}
	public function sms_bulk_resend(){}
}
?>