<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Controls the Admin dashbaord operations for Emails Service
 * 
 * @version   1.1
 * @author    Manoj MS <manoj@agilonconsulting.com>
 */

class Emailadmin extends CI_Controller
{
	var $breadcrumb=array(
						"users"=>array("link"=>"usersadmin",
												"slugpart"=>"users",
												"titlepart"=>"Users",
												"main_model"=>"user/users_model",
												"module_links_path"=>"users/admin/users_nav_buttons",
												"name"=>"All Users"),
						"ashrams"=>array("link"=>"ashramadmin",
												"slugpart"=>"ashram",
												"titlepart"=>"Ashrams",
												"main_model"=>"ashrams/ashrams_model",
												"module_links_path"=>"ashrams/admin/nav_buttons",
												"name"=>"All Ashrams"),
						"satsangs"=>array("link"=>"satsangsadmin",
												"slugpart"=>"satsangs",
												"titlepart"=>"Satsangs",
												"main_model"=>"satsangs/satsangs_model",
												"module_links_path"=>"satsangs/admin/nav_buttons",
												"name"=>"All Satsangs"),
						"subscribe"=>array("link"=>"subscriptions",
												"slugfullpart"=>"emailsmssubscriptionsadmin",
												"slugpart"=>"subscriptions",
												"titlepart"=>"Subscriptions",
												"module_links_path"=>"subscriptions/admin/nav_buttons",
												"name"=>"Email Subscriptions"),
						"techsupport"=>array("link"=>"techsupportadmin",
												"slugpart"=>"techsupport",
												"titlepart"=>"Support Tickets",
												"name"=>"Support Tickets"),
						"vedoktashanti"=>array("link"=>"vedoktashantiadmin",
												"slugpart"=>"vedoktashanti",
												"titlepart"=>"VedoktaShanti Requests",
												"name"=>"VedoktaShanti Requests"),
						"greetings"=>array("link"=>"greetings",
												"slugpart"=>"greetings",
												"titlepart"=>"Greetings",
												"name"=>"All Greetings"),
						"email"=>array("link"=>"email",
												"slugpart"=>"email",
												"titlepart"=>"Email Queue",
												"name"=>"Email Queue"),
						"orders"=>array("link"=>"orders",
												"slugpart"=>"orders",
												"slugfullpart"=>"orders",
												"titlepart"=>"Sevas",
												"module_links_path"=>"orders/admin/nav_buttons",
												"name"=>"All Sevas"),


						);
	var $service='';
	var $status=array(0,1,2);
	var $status_values=array(0=>"Pending",1=>"Sent",2=>"Failed");
	var $bools=array(0=>"No",1=>"Yes");
	function __construct() 
    {
        parent::__construct();
		$this->load->model("emails_model");
		$this->load->model('ashrams/ashrams_model');
		$this->load->model('satsangs/satsangs_model');
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
	}
	public function listemails($serviceSlug='')
	{
		//if($this->checkService($serviceSlug))
		//{
			$views = array( 'emails/admin/list');
			$data = array('views'=>$views,"service"=>$serviceSlug);
			$this->load->view(ADMIN_TEMPLATE,$data);
		//}
	}
	public function email_data($serviceSlug='',$excel=0)
	{
		//if($this->checkService($serviceSlug))
		//{
		if($this->input->post("service_slug")!='')
			$serviceSlug=$this->input->post("service_slug");
		$data=$this->emails_model->listemails($serviceSlug,$excel);
		echo json_encode($data);
		//}
	}
	private function checkService($serviceSlug='')
	{
		$this->load->model("services_model");
		$result=$this->services_model->getBySlug($serviceSlug);
		if(!empty($result))
		{
			$this->service=$serviceSlug;
			return 1;
		}
		else
			return 0;
	}
	public function resend($serviceSlug='',$id=0)
	{
		$this->load->library("email_extension");
		if($this->input->post("service_slug")!='')
			$serviceSlug=$this->input->post("service_slug");
		$data=$this->email_extension->resendMail($serviceSlug,$id);
		echo json_encode($data);
	}
	public function bulk_resend($serviceSlug='')
	{
		$result['flag']=0;
		$result['msg']="Invalid request";
		if(isset($_POST['bulk_actions']) && $_POST['bulk_actions']=="resend")
		{
			$this->load->library("email_extension");
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			foreach($_POST['ids'] as $id)
			{
				if($this->input->post("service_slug")!='')
					$serviceSlug=$this->input->post("service_slug");
				$data=$this->email_extension->resendMail($serviceSlug,$id);
				if($data['flag']==1)
				{
					$count++;
				}
			}
			$result['flag']=1;
			$result['msg']="'".$count."' Email(s) have been resent successfully.";
			$result['num']=$count;
		}
		echo json_encode($result);
	}
}