<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Donationsadmin extends CI_Controller 
{
	var $service='donations';
    function __construct() 
	{
        parent::__construct();
        $this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/donations_model');
		$this->load->model('ashrams/donations_bundle_model');
		$this->load->model('ashrams/donations_categories_model');
		$this->load->model('ashrams/donations_groups_model');
		$this->load->model("mobile/mobileNotifications_model");
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_userdata("ashramId",0);
		}
		$ft="+12 months";
		$d=date("d M Y",strtotime($ft,strtotime("25 Aug 2018"))+(60*60*24));
    }

	function index()
	{
		$views = array( 'ashrams/admin/list_donations' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		if($this->session->userdata("ashramId")>0)
		{
			$donationsCategories=$this->donations_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			$donationGroups=$this->donations_groups_model->getGroupsListByAshramId($this->session->userdata("ashramId"));
		}
		else
		{
			$donationsCategories=$this->donations_categories_model->getList();
			$donationGroups=$this->donations_groups_model->getList();
		}
		$data['categories']=$donationsCategories;
		$data['donationGroups']=$donationGroups;
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Donations Listing");
	}

	public function listc($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->donations_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Donations Listing ajax request");
		}
	}

	public function categories()
	{
		$views = array( 'ashrams/admin/list_donations_categories');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listcats($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->donations_categories_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Donations categories listing ajax request");
		}
	}

	public function add_edit_category($id=0)
	{
		if($id)
		{
			$categoryData=$this->donations_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				$this->session->set_flashdata("cat_error",1);
				redirect("/donationsadmin/categories");
			}
			if($this->currentUser->roles!=1 && ($categoryData->category_ashram_id!=$this->session->userdata("ashramId")))
        	{
        		$this->session->set_flashdata("cat_error",1);
				redirect("/donationsadmin/categories");
        	}
		}
		else
			$categoryData=array();

		if(isset($_POST["add_category"]))
		{
			$this->form_validation->set_rules('name', 'Category name', 'trim|required|min_length[3]|max_length[200]|check_donations_category['.$id.']');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('donationsadmin/add_edit_category/'.$id);
				return;
			}
			
			$saved=$this->donations_categories_model->save($id,$categoryData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("cat_saved",1);
				else
				{
					$this->session->set_flashdata("cat_created",1);
				}
			}
			redirect('donationsadmin/add_edit_category/'.$saved);
		}
		else
		{	
		 	$views = array( 'ashrams/admin/add_edit_donation_category' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
        	$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if($id)
			{
				$data['categoryData']=$categoryData;
				$data['donationItems'] = $this->donations_model->getDonationsByCategory($id);
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function delete_category($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$categoryData=$this->donations_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				goto end;
			}
			if($categoryData->in_use>0)
			{
				$data['flag']=2;
				$data['name']=$categoryData->name;
				goto end;
			}

			$r=$this->donations_categories_model->delete($id,$categoryData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$categoryData->name;
				$this->logaction->log($this->service,"Admin - Category '".$categoryData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function category_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->donations_categories_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	
	function add_edit_donation($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_flashdata("donation_error",1);
			redirect('donationsadmin');
		}

		if(is_numeric($id) && $id)
		{
			$donationData=$this->donations_model->donationData($id);
			if(empty($donationData))
			{
				$this->session->set_flashdata("donation_error",1);
				redirect('donationsadmin');
			}
			if($donationData->ashram_id!=$this->session->userdata("ashramId"))
        	{
        		$this->session->set_flashdata("donation_error",1);
				redirect("donationsadmin");
        	}
		}
		else
		{
			$donationData=array();
		}

		$this->load->model('currencies_model');
		$ashramCurrencies = $this->currencies_model->getByAshram($this->session->userdata("ashramId"));

		if(isset($_POST["donation_name"]))
		{
			if(!isset($_POST['exclude_dates']) || !isset($_POST['include_dates']) || !isset($_POST['include_exclude_dates']) )
			{
				$this->session->set_flashdata("donation_error",1);
				redirect('donationsadmin/add_edit_donation/'.$id);
			}

			if(isset($_FILES['donation_image']['name']) && $_FILES['donation_image']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['donation_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['donation_image']['size']==0 || $ext=='' || !in_array($_FILES['donation_image']['type'],$allowed_file_types) ||
						$_FILES['donation_image']['size']>(1024*1024))
				{
					$this->session->set_flashdata("donation_error",1);
					redirect('donationsadmin/add_edit_donation/'.$id);
				}
			}

			$this->form_validation->set_rules('donation_name', 'Donation Name', 'trim|required|min_length[3]|max_length[100]|checkDonationName['.$id.']');
			$this->form_validation->set_rules('category', 'Category', 'trim|required|numeric|checkDonationCategory');
			$this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[3]|max_length[2000]');
			foreach ($ashramCurrencies as $currencyData)
			{
				$currencyparameters = strtolower($currencyData['currency']).' || '.$this->session->userdata("ashramId");
				$this->form_validation->set_rules('price_'.strtolower($currencyData['currency']), 'Price ('.$currencyData['currency'].')', 'trim|required|checkCurrencyValuesByAshram['.$currencyparameters.']');
			}
			$this->form_validation->set_rules('is_public_display', 'Is Public Diaply? ', 'trim|required|numeric|checkPublicDisplay');
			$this->form_validation->set_rules('max_family_members', 'Donation in the name of ', 'trim|required|checkMaxFamilyMembers|checkSingleUser');
			$this->form_validation->set_rules('have_personal_note', 'Have Personal Note? ', 'trim|required|numeric|checkPersonalNote');
			$this->form_validation->set_rules('days[]', 'Days', 'trim|checkDonationIncludedDays');
			$this->form_validation->set_rules('include_exclude_dates', 'Include / Excluded Dates', 'trim');
			$this->form_validation->set_rules('exclude_dates', 'Excluded Dates', 'trim|checkDonationExcludedDates');
			$this->form_validation->set_rules('include_dates', 'Included Dates', 'trim|checkDonationIncludedDates');
			$this->form_validation->set_rules('is_external_link', 'Is external link? ', 'trim|required|checkExternalLinkFlag');
			$this->form_validation->set_rules('is_price_fixed', 'Is price fixed? ', 'trim|required|checkPriceFixedFlag');
			$this->form_validation->set_rules('shipping', 'Shipping', 'trim|required|numeric|checkItemShipping');
			$this->form_validation->set_rules('limit_days_per_item', 'Limit Donation Days per Item? ', 'trim|required|checkLimitDonationDaysPerItem');
			if($this->input->post("is_external_link")==1)
				$this->form_validation->set_rules('external_link', 'External link', 'trim|required|valid_url');

			if($this->input->post("is_price_fixed")==0)
			{
				foreach ($ashramCurrencies as $currencyData)
				{
					$minPriceCurrencyparameters = strtolower($currencyData['currency']).' || '.$this->session->userdata("ashramId");
					$this->form_validation->set_rules('min_price_'.strtolower($currencyData['currency']), 'Min. Price ('.$currencyData['currency'].')', 'trim|required|checkCurrencyValuesByAshram['.$minPriceCurrencyparameters.']');
				}
				if($this->input->post("display_suggested_text")==1)
				{
					$this->form_validation->set_rules('suggested_text', 'Suggested text', 'trim|required|min_length[3]|max_length[100]');
				}


			}

			$this->form_validation->set_rules('partial_payments_allowed', 'Partial payments', 'trim|required|numeric|checkPartialPaymentOption');

			if($this->input->post("shipping")==1)
			{
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$this->form_validation->set_rules('shipping_domestic_'.strtolower($currencyData['currency']), 'Shipping domestic Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
					$this->form_validation->set_rules('shipping_international_'.strtolower($currencyData['currency']), 'Shipping international Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
				}
			}

			if($this->input->post("is_bundle")=='on')
			{
				$this->form_validation->set_rules('donation_ids', 'Donations', 'trim|required|checkDonations['.$id.']');
			}

			$this->form_validation->set_rules('only_for_admin', 'Only for Admin? ', 'trim|required|checkDonationIsOnlyForAdmin');
			$this->form_validation->set_rules('is_secret', 'Is Secret? ', 'trim|required|checkIsSecretDonation');
			if($this->input->post("is_secret")==1)
			{
				$this->form_validation->set_rules('s_key', 'Secret Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkDonationSecretKeyExists['.$id.']');
			}
			$this->form_validation->set_rules('item_key', 'Item Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkDonationItemKeyExists['.$id.']');

			$this->form_validation->set_rules('display_only_popup', 'Display Only Popup? ', 'trim|required|checkDonationDisplayOnlyPopup');
			if($this->input->post("display_only_popup")==1)
			{
				$this->form_validation->set_rules('popup_content', 'Popup Content', 'trim|required|min_length[3]|max_length[1000]');
			}

			$this->form_validation->set_rules('having_custom_email', 'Custom Email? ', 'trim|required|checkDonationHavingCustomEmail');
			if($this->input->post("having_custom_email")==1)
			{
				$this->form_validation->set_rules('custom_email_text', 'Custom Email Text', 'trim|required|min_length[3]|max_length[10000]');
			}

			$this->form_validation->set_rules('having_custom_sms', 'Custom SMS? ', 'trim|required|checkDonationHavingCustomSms');
			if($this->input->post("having_custom_sms")==1)
			{
				$this->form_validation->set_rules('custom_sms_text', 'Custom SMS Text', 'trim|required|min_length[6]|max_length[320]');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("donation_error",1);
				redirect('donationsadmin/add_edit_donation/'.$id);
				return;
			}
			$saved=$this->donations_model->save($id,$donationData);
			if($id==0)
			{
				$this->session->set_flashdata("donation_created",1);
			}
			else
			{
				$this->session->set_flashdata("donation_saved",1);
			}
			redirect('donationsadmin/add_edit_donation/'.$saved);
		}
		else
		{
			if($id>0 && (empty($donationData)) )
			{
				redirect('donationsadmin');
			}
			$views = array('ashrams/admin/add_edit_donation');
			$data = array('views'=>$views,'id'=>$id);
			if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
			$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if(is_numeric($id) && $id)
			{
				$data['donationData']=$donationData;
				$data['bundle']=$this->donations_bundle_model->getByDonation($id);
			}
			$data['categories']=$this->donations_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			$data['donationGroups']=$this->donations_groups_model->getGroupsListByAshramId($this->session->userdata("ashramId"));
			// $data['categories']=$this->donations_categories_model->getList();
			$data['ashramCurrencies'] = $ashramCurrencies;
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId"))
		{
			$donationData=$this->donations_model->donationData($id);
			if(empty($donationData))
			{
				goto end;
			}
			$r=$this->donations_model->delete($id,$donationData);
			if($r)
			{
				//deleting related notification data also
				$this->mobileNotifications_model->remove($id,'donations');
				$data['flag']=1;
				$data['donation_name']=$donationData->donation_name;
				$this->logaction->log($this->service,"Admin - Donation '".$donationData->donation_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function changestatus($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId") && isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			$donationData=$this->donations_model->donationData($id);
			if(empty($donationData))
			{
				goto end;
			}
			$data['donation_name']=$donationData->donation_name;
			if($donationData->status==$_POST['status'])
			{
				$data['flag']=2;
				goto end;
			}
			$this->donations_model->changeStatus($id,$_POST['status']);
			
			$data['flag']=1;
			
			if($_POST['status']==1)
				$this->logaction->log($this->service,"Admin - Donation '".$donationData->donation_name."' activated - ".$id);
			else
				$this->logaction->log($this->service,"Admin - Donation '".$donationData->donation_name."' deactivated - ".$id);
		}
		end:
		echo json_encode($data);
	}

	public function namecheck($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			echo 'false';
			return;
		}
		if(isset($_POST['donation_name']) && $_POST['donation_name']!='')
		{
			if(is_numeric($id))
			{
				$flag=$this->donations_model->checkDonationName($this->general_model->filtertext(trim($_POST['donation_name'])),$id);
				if($flag==1)
					echo 'false';
				else
					echo 'true';
			}
			else
				echo 'false';
		}
	}

	public function categorycheckname($id=0)
	{
		if($this->input->post('name')!='')
		{
			$slug=url_title($this->general_model->filtertext($this->input->post('name')));
			
			if(is_numeric($id))
			{
				$flag=$this->donations_categories_model->checkName($this->general_model->filtertext(trim($this->input->post('name'))),$id);
				if($flag==1)
					echo 2;
				else
					echo 1;
			}
			else
				echo 0;
		}
	}

	public function searchdonation($id=0)
	{
		$query = (!empty($_GET['q'])) ? strtolower($_GET['q']) : null;
		if (!isset($query)) {
		    die('Invalid query.');
		}
		$status = true;
		$donationsData=$this->donations_model->searchDonations($query,2);
		$resultDonations = [];
		$c=0;
		foreach ($donationsData as $donationItem)
		{
			if($donationItem->id==$id)
				continue;
			$resultDonations[$c]['id'] = $donationItem->id;
			$resultDonations[$c]['name'] = $donationItem->donation_name;
			$c++;
		}
		echo json_encode($resultDonations);
	}
	public function donation_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->donations_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}



	public function groups()
	{
		$views = array( 'ashrams/admin/list_donations_groups');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listgroups($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->donations_groups_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Donations groups listing ajax request");
		}
	}

	public function add_edit_group($id=0)
	{
		if($id)
		{
			$groupData=$this->donations_groups_model->groupData($id);
			if(empty($groupData))
			{
				$this->session->set_flashdata("cat_error",1);
				redirect("/donationsadmin/groups");
			}
			if($this->currentUser->roles!=1 && ($groupData->group_ashram_id!=$this->session->userdata("ashramId")))
        	{
        		$this->session->set_flashdata("cat_error",1);
				redirect("/donationsadmin/groups");
        	}
		}
		else
			$groupData=array();

		if(isset($_POST["add_group"]))
		{
			$this->form_validation->set_rules('name', 'Group name', 'trim|required|min_length[3]|max_length[200]|check_donations_group['.$id.']');
			$this->form_validation->set_rules('group_key', 'Group Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkDonationGroupKeyExists['.$id.']');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('donationsadmin/add_edit_group/'.$id);
				return;
			}
			
			$saved=$this->donations_groups_model->save($id,$groupData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("cat_saved",1);
				else
				{
					$this->session->set_flashdata("cat_created",1);
				}
			}
			redirect('donationsadmin/add_edit_group/'.$saved);
		}
		else
		{	
		 	$views = array( 'ashrams/admin/add_edit_donation_group' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
        	$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if($id)
			{
				$data['groupData']=$groupData;
				$data['donationItems'] = $this->donations_model->getDonationsByGroup($id);
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function delete_group($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$groupData=$this->donations_groups_model->groupData($id);
			if(empty($groupData))
			{
				goto end;
			}
			if($groupData->in_use>0)
			{
				$data['flag']=2;
				$data['name']=$groupData->name;
				goto end;
			}

			$r=$this->donations_groups_model->delete($id,$groupData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$groupData->name;
				$this->logaction->log($this->service,"Admin - Group '".$groupData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function groupcheckname($id=0)
	{
		if($this->input->post('name')!='')
		{
			$slug=url_title($this->general_model->filtertext($this->input->post('name')));
			
			if(is_numeric($id))
			{
				$flag=$this->donations_groups_model->checkName($this->general_model->filtertext(trim($this->input->post('name'))),$id);
				if($flag==1)
					echo 2;
				else
					echo 1;
			}
			else
				echo 0;
		}
	}

	public function group_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->donations_groups_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
}
?>