<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Donations extends CI_Controller 
{
	var $service="cart";
	var $currentUser='';
	var $pageName="Donations";
	var $currencies;
    function __construct() 
	{
        parent::__construct();
        $this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/donations_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->model('currencies_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/payflow_logs_model');
		$this->load->model("subscriptions/donors_model");
		$this->load->model("orders/subscription_payments_model");
		$this->load->model("offline_model");
        $this->load->model("credit_cards_model");
        $this->load->model('ashrams/seva_item_blocked_dates');
        
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       	{
       		if($this->session->userdata("force_change_password")==1)
			{
				$this->session->set_flashdata("reset_password_force",1);
				redirect("myaccount/change_password");
			}
       		$this->currentUser=$this->session->userdata("user_data");
       	}
       	if(empty($this->session->userdata("donationCartAshramIdSelection")))
       	{
       		$this->session->unset_userdata("defaultCurrency");
       	}
        if(in_array(global_site_flag, [2]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("donations?ashram_id=1&currency=inr");
        }
        if(in_array(global_site_flag, [4,7]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("donations?ashram_id=1&currency=usd");
        }
        if(is_single_currency_site==1 && $this->input->get("currency")!='' && default_currency!=strtolower($this->input->get("currency")))
        {
            if(in_array(global_site_flag, [2,4]))
            {
                redirect("donations?ashram_id=".default_ashram_id."&currency=".default_currency);
            }
            else
            {
                $this->session->unset_userdata("donationCartAshramIdSelection");
                $this->session->unset_userdata("defaultCurrency");
                redirect("donations");
            }
        }
       	if($this->input->get("ashram_id")!='')
       	{
       		$ashramData=$this->ashrams_model->ashramData($this->input->get("ashram_id"));
       		if(!empty($ashramData) && (is_numeric($this->input->get("ashram_id")) && $this->input->get("ashram_id") > 0) )
            {
       			$this->session->set_userdata("donationCartAshramIdSelection",$this->input->get("ashram_id"));
                $this->session->set_userdata("donationCartAshramId",$this->input->get("ashram_id"));
            }
       		else
            {
                $this->session->unset_userdata("donationCartAshramIdSelection");
                $this->session->unset_userdata("defaultCurrency");
       			redirect("donations");
            }
       	}
       	if($this->session->userdata("donationCartAshramIdSelection"))
       	{
	       	$this->currencies=$this->currencies_model->getByAshram($this->session->userdata("donationCartAshramIdSelection"));
	    }

       	if($this->input->get("currency")!='')
       	{
       		if(isset($this->currencies[$this->input->get("currency")]))
       			$this->session->set_userdata("defaultCurrency",$this->input->get("currency"));
       	}
       	if($this->input->get("view")!='')
       	{
       		if(in_array($this->input->get("view"),array("itemView","listView")))
       			$this->session->set_userdata('donationviewType', $this->input->get("view"));
       	}
       	$this->load->library('donationscart');
	    $this->load->model('cart_model');
       	if(!empty($this->session->userdata("donationCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
       	{
	       	$this->cart_model->validateCart($this->donationscart);
       	}
    }
    public function index()
    {
        if( appji_ashram_id>0 && ( ($this->session->userdata("donationCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id)) )
        {
            $this->session->unset_userdata("donationCartAshramIdSelection");
            $this->session->unset_userdata("defaultCurrency");
            redirect("donations");
        }
    	if(empty($this->input->get("ashram_id")) && !empty($this->session->userdata("donationCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
    	{
    		$this->session->unset_userdata("donationCartAshramIdSelection");
    		$this->session->unset_userdata("defaultCurrency");
    		redirect("donations");
    	}
    	if(!empty($this->session->userdata("donationCartAshramIdSelection")) && empty($this->input->get("ashram_id")))
    	{
    		redirect("donations?ashram_id=".$this->session->userdata("donationCartAshramIdSelection"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && empty($this->input->get("currency")))
    	{
    		redirect("donations?ashram_id=".$this->session->userdata("donationCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && !empty($this->session->userdata("donationCartAshramIdSelection")) && !empty($this->session->userdata("donationviewType")) && empty($this->input->get("view")))
    	{
    		redirect("donations?ashram_id=".$this->session->userdata("donationCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency")."&view=".$this->session->userdata('donationviewType'));
    	}
    	if($GLOBALS['site_settings']['donations']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
    	if(!empty($this->session->userdata("donationCartAshramIdSelection")))
       	{
	    	if($this->checkpublicdisplay()=="0")
	    	{
	    		$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
	    	}
    	}
    	$this->load->model('ashrams/ashrams_model');
    	$data['slug']="donations";
    	if(empty($this->session->userdata("donationCartAshramIdSelection")) || empty($this->session->userdata("defaultCurrency")))
		{
			$data['views'] = array('ashrams/public/cart_ashram_selection');
    		$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("donationCartAshramIdSelection"));
		}
		else
		{
			$data['cartObject']=$this->donationscart;
    		$data['views'] = array('ashrams/public/list_donations');
		}

        $cart=$this->donationscart->contents();
        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('donationCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }
    	
    	// $data['ashrams']=$this->ashrams_model->getList();
        $data['ashrams']=$this->ashrams_model->getOnlyActiveDonationItemsAshramList();
        $ashramids = array_column($data['ashrams'], 'id');
        if($this->session->userdata("donationCartAshramIdSelection")>0 && !in_array($this->session->userdata("donationCartAshramIdSelection"),$ashramids))
        {
            redirect("donations");
        }
		$this->load->view(FRONTEND_TEMPLATE,$data);
		if(!empty($this->session->userdata("donationCartAshramIdSelection")))
			$this->cart_log_model->log("Navigated to donations page :".current_url(),$this->session->userdata("donationCartAshramIdSelection"),2);
    }
    public function checkpublicdisplay()
    {
    	$ashramData=$this->ashrams_model->ashramData($this->session->userdata('donationCartAshramIdSelection'));
        if($ashramData->is_public_display==0)
        {
            if(empty($this->currentUser))
                return "0";
            if(!empty($this->currentUser) && $this->currentUser->roles !=1 && $this->currentUser->roles !=4 && $this->currentUser->roles !=3)
				return "0";
        }
        else
        {
            return $this->session->userdata('donationCartAshramIdSelection');
        }
    }
    public function changecurrency()
    {
    	if(isset($_POST['currency']) && $_POST['currency']!='')
    	{
    		if($_POST['currency'] == 'inr' && $this->getPaymentMode() == 'razorpay' && ( !empty($this->currentUser->admin) && $this->currentUser->admin != 1)){
    			$cart=$this->donationscart->contents();
    			if(empty($cart))
		    	{
		    		foreach ($this->currencies as $currencyData)
	    			{
		    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
		    			{
		    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
		    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("donationCartAshramIdSelection"),2);
		    				echo 1;
		    				return;
		    			}
	    			}
		    	} else if(count($cart) == 1){
		    		foreach ($this->currencies as $currencyData)
	    			{
		    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
		    			{
		    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
		    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("donationCartAshramIdSelection"),2);
		    				echo 1;
		    				return;
		    			}
	    			}
		    	}  else if(count($cart) > 1){
		    		$subcheck = "";
		    		foreach($cart as $key=>$val){
		            	$dd = $val['options']['subscription'];
		            	if($dd == 1)
		            		$subcheck = "true";
		        	}
		        	if($subcheck =="true"){
		        		echo 2;
		        		return;
		        	} else {
		        		foreach ($this->currencies as $currencyData)
		    			{
			    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
			    			{
			    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
			    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("donationCartAshramIdSelection"),2);
			    				echo 1;
			    				return;
			    			}
		    			}
		        	}
		    	}

    		} else {
                if(empty($this->currencies))
                {
                    echo 0;
                    return;
                }
	    		foreach ($this->currencies as $currencyData)
	    		{
	    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
	    			{
	    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
	    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("donationCartAshramIdSelection"),2);
	    				if(!empty($this->session->userdata("donationCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
	    					$this->cart_model->validateCart($this->donationscart);
	    				echo 1;
	    				return;
	    			}
	    		}
	    	}
	    	echo 0;
	    }
    }
    public function getPaymentMode()
    {
    	$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("donationCartAshramIdSelection"),2);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        $trustData=$trustsArray['inr'];
        $mode = $trustData->payment_mode;
        return $mode;
    }
    public function changeashram()
    {
    	if(!empty($this->donationscart->contents()))
    	foreach($this->donationscart->contents() as $key=>$val)
    	{
    		$donationData=$this->donations_model->donationData($val['id']);
    		break;
    	}
        $cart=$this->donationscart->contents();
        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('donationCartAshramId')!=$thiscartitem['options']['ashram_id'])
                {
                    $this->load->model('ashrams/ashrams_model');
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['ashram_name']=$ashramData->name;
                    $data['flag']=2;
                    echo json_encode($data);
                    return;
                }
            }
        }
    	if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='' && (empty($this->donationscart->contents()) || isset($donationData) && $donationData->ashram_id == $_POST['ashram_id']))
    	{
    		$this->load->model('ashrams/ashrams_model');
    		$ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
    		if(!empty($ashramData))
    		{
    			$this->session->set_userdata("donationCartAshramIdSelection",$_POST['ashram_id']);
                $this->session->set_userdata("donationCartAshramId",$_POST['ashram_id']);
    			$this->cart_log_model->log("Changed ashram to :".$ashramData->name,$this->session->userdata("donationCartAshramIdSelection"),2);
    			$data['flag']=1;
    			echo json_encode($data);
    			return;
    		}
    	}
    	else
    	{
    		$data['flag']=2;
    		if($donationData->ashram_id)
    		{	
    			$ashramData=$this->ashrams_model->ashramData($donationData->ashram_id);
    			$data['ashram_name']=$ashramData->name;
    		}
    		echo json_encode($data);
    		return;
    	}
    	$data['flag']=0;
    	echo json_encode($data);
    }

    public function removeAshramSession()
    {
    	$this->session->unset_userdata("donationCartAshramIdSelection");
    	echo 1;
    }
    public function checkout()
    {
    	if(empty($this->input->get("ashram_id")) || empty($this->input->get("currency")))
    	{
    		redirect("donations");
    	}
    	$cart=$this->donationscart->contents();
        if( ($this->session->userdata("donationCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id) )
        {
            foreach($cart as $thiscart)
            {
                if($this->input->get("currency") != $thiscart['options']['appji_currency'])
                {
                    redirect("donations/checkout?ashram_id=".$this->session->userdata("donationCartAshramIdSelection")."&currency=".$thiscart['options']['appji_currency']);
                }
            }
        }
        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('donationCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }
    	if(empty($cart))
    	{
            if( ($this->session->userdata("donationCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id) )
            {
                redirect("");
            }
            else if(!empty($this->session->userdata("donationCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
            {
                redirect("donations?ashram_id=".$this->session->userdata("donationCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
            }
            else
            {
                redirect("donations");
            }
    	}
    	$this->load->model("credit_cards_model");

    	$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("donationCartAshramId"),2);
        $data['ashramData'] = $this->ashrams_model->ashramData($this->session->userdata("donationCartAshramId"));
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		$data['trustData'] = isset($trustsArray['inr']) ? $trustsArray['inr'] : "";
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		$data['trustData'] = isset($trustsArray['usd']) ? $trustsArray['usd'] : "";
    	}

        // If trust data is not available then redirect to back
        if(empty($data['trustData']))
        {
            if( ($this->session->userdata("donationCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id) )
            {
                redirect("");
            }
            else if(!empty($this->session->userdata("donationCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
            {
                redirect("donations?ashram_id=".$this->session->userdata("donationCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
            }
            else
            {
                redirect("donations");
            }
        }

        $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
        $this->session->set_userdata("donations_temp_reference",$temp_reference);

    	$total=$this->cart_model->getTotalPrice($this->donationscart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	$data ['family_donors'] = [];
    	if($this->session->userdata("loggedIn"))
    	{
    		if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$cUserId=$this->session->userdata('temp_checkout_user')->id;
					$checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
					$data['credit_cards']=$this->credit_cards_model->getCards($cUserId);
				}
			}
			else
			{
				$checkoutUserId = $this->currentUser->sso_user_id;
				$data['credit_cards']=$this->credit_cards_model->getCards($this->currentUser->id);
			}
			$this->load->model("subscriptions/donors_model");
            $data ['family_donors'] = $this->donors_model->getUserUnhideDonors($checkoutUserId);
    	}
    	$data['views'] = array('ashrams/public/checkout_donations');
		$this->load->view(FRONTEND_TEMPLATE,$data);
		$this->cart_log_model->log("Navigated to donations checkout page :".current_url(),$this->session->userdata("donationCartAshramId"),2);
    }
    public function getcart()
    {
    	$userData=array();
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
			$userData=$this->session->userdata('temp_checkout_user');
		else
			$userData=$this->currentUser;

		$family_donors = [];
		if($this->session->userdata("loggedIn"))
    	{
    		if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
				}
			}
			else
			{
				$checkoutUserId = $this->currentUser->sso_user_id;
			}
			$this->load->model("subscriptions/donors_model");
            $family_donors = $this->donors_model->getUserUnhideDonors($checkoutUserId);
    	}

    	$data['cart_template']=$this->load->view("ashrams/public/_cart_template_donations",array('userData'=>$userData, 'family_donors'=> $family_donors),true);
    	$total=$this->cart_model->getTotalPrice($this->donationscart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	echo json_encode($data);
    }
    public function listitems()
	{
		$list=$this->donations_model->listPublic($this->session->userdata("donationCartAshramIdSelection"),$this->session->userdata("admin_data"),$this->session->userdata("user_data"));
		echo json_encode($list);
	}
	public function carttoptemplate()
	{
		$data['cartObject']=$this->donationscart;
		$data['slug']="donations";
		$response_data['cart_template']=$this->load->view("ashrams/public/_cart_top_template",$data,true);
		$response_data['count']=count($this->donationscart->contents());
		echo json_encode($response_data);
	}

	public function additem($id=0, $freeAmount=0, $row_key='')
	{
		$data['flag']=0;
		if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=55;
			goto end;
		}
		if($GLOBALS['site_settings']['donations']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['flag']=12;
    		$data['error_msg']="Donations are disabled";
			goto end;
    	}
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
		{
			if(!$this->session->userdata('temp_checkout_user'))
			{
				$data['flag']=12;
				$data['msg']='Please select user before adding Donation to cart.';
				goto end;
			}
		}
		if($GLOBALS['donationCartLocked']==1)
		{
			$data['flag']=11;
			goto end;
		}
		if(is_numeric($id) && $id)
		{
			$cart=$this->donationscart->contents();
            $cartCount = count($cart);
            if($cartCount>0)
            {
                foreach($cart as $thiscartitem)
                {
                    if($this->session->userdata('donationCartAshramId')!=$thiscartitem['options']['ashram_id'])
                    {
                        $this->load->model('ashrams/ashrams_model');
                        $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                        $data['ashram_name']=$ashramData->name;
                        $data['flag']=2;
                        goto end;
                    }
                }
            }
            if($cartCount >= 50)
            {
                $data['flag']=111;
                $data['error_msg']='MAX 50 items are allowed to cart.';
                goto end;
            }
			$amount=$this->cart_model->getTotalPrice($this->donationscart);
			$donationData=$this->donations_model->donationData($id);
			$col="price_".strtolower($this->session->userdata("defaultCurrency"));
            $minPriceCol="min_price_".strtolower($this->session->userdata("defaultCurrency"));
			if(empty($donationData))
			{
				$data['flag']=10;
				goto end;
			}
			
			$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
			if($donationData->$displayCol==0)
			{
				$data['flag']=10;
				goto end;
			}

            if($donationData->display_only_popup==1)
            {
                $data['flag']=112;
                goto end;
            }

			if($donationData->subscription==1)
			{
				$tempUserId=0;
				if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
					$tempUserId=$this->session->userdata('temp_checkout_user')->sso_user_id;
				else
					$tempUserId=$this->currentUser->sso_user_id;

				$donorsCount=$this->donors_model->getCountByUser($tempUserId);
				if($donorsCount==0)
				{
					$this->donors_model->createDefault($tempUserId);
				}
			}

            if($freeAmount > 0)
            {
                $_POST['amount']=$freeAmount;
            }
            $allow_one_user_per_day_per_seva = 0;
            if(isset($donationData->allow_one_user_per_day_per_seva) && $donationData->allow_one_user_per_day_per_seva == 1){
                $allow_one_user_per_day_per_seva = 1;
            }
			if($donationData->is_price_fixed==1)
				$_POST['amount']=$donationData->$col;

			if(isset($_POST['amount']))
			{
				if($_POST['amount']=='')
				{
					$data['flag']=12;
					$data['msg']='Enter Amount';
					goto end;
				}
				if(!preg_match("/^\d+$/",$_POST['amount']))
				{
					$data['flag']=12;
					$data['msg']='Enter only digits';
					goto end;
				}

				if(strlen($_POST['amount'])!=strlen(abs($_POST['amount'])))
				{
					$data['flag']=12;
					$data['msg']='Enter valid amount';
					goto end;
				}

                if($donationData->is_price_fixed==0)
                {
                    if(isset($donationData->$minPriceCol) && abs($_POST['amount'])<$donationData->$minPriceCol)
                    {
                        $data['flag']=12;
                        $data['msg']='Minimum Donation amount is '.$donationData->$minPriceCol;
                        goto end;
                    }
                }
			}
			else
			{
				goto end;
			}
			
			$netAmount=$amount+$_POST['amount'];

			if(strtolower($this->session->userdata("defaultCurrency"))=='inr' &&
				$netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
			{
				$data['flag']=13;
				$data['msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
				goto end;
			}
			if(strtolower($this->session->userdata("defaultCurrency"))=='usd' &&
				$netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
			{
				$data['flag']=13;
				$data['msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
				goto end;
			}

			if(strtolower($this->session->userdata("defaultCurrency"))=='inr')
			{
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}
			if(strtolower($this->session->userdata("defaultCurrency"))=='usd')
			{
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}

			if(trim(abs($_POST['amount']))<$minAmount)
			{
				$data['flag']=12;
				$data['msg']='Minimum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$minAmount;
				goto end;
			}
			if(trim(abs($_POST['amount']))>$maxAmount)
			{
				$data['flag']=12;
				$data['msg']='Maximum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$maxAmount;
				goto end;
			}


			$data['item']=$donationData;
			$data['type']='donation';
			$data['amount']=$_POST['amount'];
			$data['personal_note']='';
            $data['allow_one_user_per_day_per_seva'] = $allow_one_user_per_day_per_seva;
			$data['note']='';
            $data['other_name1']='';
            $data['other_name2']='';
            $data['other_name3']='';
            $data['other_name4']='';
            $data['other_name5']='';
            $data['other_name6']='';
            $data['is_appji_donation']=0;
			if($this->session->userdata("loggedIn"))
			{
				if($this->currentUser->admin==0)
				{
					$data['note']=$this->currentUser->family_details;
				}
				else
				{
					if($this->session->userdata('temp_checkout_user'))
					{
						$data['note']=$this->session->userdata('temp_checkout_user')->family_details;
					}
				}
			}

			if(!$this->session->userdata('donationCartAshramId') || $donationData->ashram_id==$this->session->userdata('donationCartAshramId') || count($cart)==0)
			{
				$response=$this->cart_model->addItem($data,1,$this->donationscart,$row_key);
				$flag=$response['flag'];
                if(isset($response['rowid']) && $response['rowid']!='')
                {
                    $data['rowKey'] = $response['rowid'];
                }
				if($flag==-2)
				{
					$this->logaction->log($this->service,"Donation added to cart _ Donation ID:".$id." _ ".$donationData->donation_name." _ Row ID: ".$response['rowid']);
					$data['flag']=1;
					$this->session->set_userdata('donationCartAshramId',$donationData->ashram_id);
					$this->cart_log_model->log("Item added - Name:".$donationData->donation_name.", Amount:".strtoupper($this->session->userdata("defaultCurrency"))." ".$data['amount'],$this->session->userdata("donationCartAshramId"),2);
				}
				else
				{
					$data['flag']=$flag;
				}
			}
			else
			{
				$this->load->model('ashrams/ashrams_model');
				$ashramData=$this->ashrams_model->ashramData($this->session->userdata('donationCartAshramId'));
				$data['ashram_name']=$ashramData->name;
				$data['flag']=2;
			}
		}
		end:
		ob_start();
		$cdata['cartObject']=$this->donationscart;
		$cdata['slug']="donations";
		$this->load->view("ashrams/public/_cart_top_template",$cdata);
		$data['cart_template']=ob_get_clean();
		echo json_encode($data);
	}

	public function removeitem()
	{
		$result['flag']=0;
		if($GLOBALS['donationCartLocked']==1)
		{
			$result['flag']=11;
			goto end;
		}
        $cart=$this->donationscart->contents();
        if(empty($cart))
        {
            $result['flag']=3;
            goto end;
        }
		if(isset($_POST['key']) && $_POST['key']!='')
		{
			$item=$this->donationscart->get_item($_POST['key']);
			if(!empty($item))
			{
				$upd= array(
			               'rowid' => $_POST['key'],
               				'qty'   => 0
				            );
				$this->donationscart->update($upd);
				$this->logaction->log($this->service,"Donation removed from cart _ Donation ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$_POST['key']);
				$this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
				$cc=$this->donationscart->contents();
				if(count($cc)==0)
				{
					$this->session->unset_userdata('donationCartAshramId');
				}
				$result['flag']=1;
				$result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('donationCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('donationCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
                //deleting item from blocked dates
                $this->seva_item_blocked_dates->deleteByRowId($_POST['key']);
			}
			else
			{
				$result['flag']=2;
			}
		}
		end:
		echo json_encode($result);
	}

	public function change_dates()
    {
        $result['flag']=0;
        if($GLOBALS['donationCartLocked']==1)
        {
            $result['flag']=11;
            goto end;
        }
        if(isset($_POST['donationid']) && is_numeric($_POST['donationid']) && $_POST['donationid'] && 
            isset($_POST['rowid']) && $_POST['rowid']!='')
        {
            $this->load->model('orders/orders_model');
            $donationData = $this->donations_model->donationData($_POST['donationid']);
            //checking is donation per day or other
            if($donationData->allow_one_user_per_day_per_seva == 1){
                $res_dates = explode(",",$this->donationscart->product_options($_POST['rowid'])['result_date']);
                $calendarDate = date('Y-m-d',strtotime($res_dates[0]));

                
                //get user initails to display in calendar
                $donationUserNames = $this->orders_model->orderItemsByItemIdAndDate($_POST['donationid'],date('m',strtotime($calendarDate)),date('Y',strtotime($calendarDate)));
                //Get User selected dates from table
                //$donationBlocked = $this->seva_item_blocked_dates->getBlockedDatesByUserAndItemAndDate($_POST['donationid'],$this->currentUser->id,date('m',strtotime($calendarDate)),date('Y',strtotime($calendarDate)),2);
                $events = [];
                $evetDates = [];
                $blockedDates = [];
                //preparing events to display in calendar
                foreach($donationUserNames as $name){
                    $split_dates =  (explode(",",$name->schedule_dates));
                    foreach($split_dates as $date){
                        $words = explode(" ", $name->family_member_details);
                        $disName = "";
                        foreach ($words as $w) {
                            $disName.=mb_substr($w, 0, 1)." ";
                        }
                        $key_date = date("Y-m-d",strtotime($date));
                        if(array_search($key_date, array_column($events, 'start')) !== False) {
                            $key = array_search($key_date, array_column($events, 'start'));
                            $events[$key]['title'] = 'More...';
                            $events[$key]['is_count_more'] = 1;
                        } else {
                            $events[] = array("title"=>trim($disName),"start"=>date("Y-m-d",strtotime($date)),"is_original_event"=>1,"is_count_more"=>0);
                            $evetDates[] = date("Y-m-d",strtotime($date));
                        }
                    }
                }

                foreach($res_dates as $date){
                    $blockedDates[] = date("Y-m-d",strtotime($date));
                    $events[] = array("title"=>'',"start"=>date("Y-m-d",strtotime($date)),"display"=>'background',"is_original_event"=>0,"is_count_more"=>0);
                }
                /*$ids = array();
                foreach($donationBlocked as $name){
                    if(strtotime(date('Y-m-d H:i:s')) > strtotime($name->expiry_date)){
                        $ids[] = $name->id;
                    }else {
                        $evetDates[] = date("Y-m-d",strtotime($name->selected_dates));
                        if($name->user_id == $this->currentUser->id && $name->row_id == $_POST['rowid']){
                            $blockedDates[] = date("Y-m-d",strtotime($name->selected_dates));
                            $events[] =  array("title"=>'',"start"=>date("Y-m-d",strtotime($name->selected_dates)),"display"=>'background',"is_original_event"=>0);
                        }
                    }
                }
                if(!empty($ids)){
                    $delete = $this->seva_item_blocked_dates->deleteAfterExpiry($ids);
                }*/
                $data['events'] = $events; 
                $data['eventDates'] = $evetDates;
                $data['blockedDates'] = $blockedDates;
                $data['calendarDate'] = $calendarDate;
                $data['rowid'] = $_POST['rowid'];
                //print_r($data); exit;
            }
            if(!empty($donationData) && $donationData->status==1)
            {
                $data['donationid'] = $_POST['donationid'];
                $data['item']=$donationData;
                $data['options']=$this->donationscart->product_options($_POST['rowid']);
                
                $result['template'] = $this->load->view('ashrams/public/_select_dates_donations',$data,true);
                if($donationData->allow_one_user_per_day_per_seva == 1){
                    $result['template'] = $this->load->view('ashrams/public/_select_single_dates_donations',$data,true);
                }
                $result['flag']=1;
            }
        }
        end:
        echo json_encode($result,JSON_HEX_APOS);
    }

    public function orderedDates($month,$year,$donationId,$rowid){
        
        $this->load->model('orders/orders_model');
        //get user initails to display in calendar
        $donationUserNames = $this->orders_model->orderItemsByItemIdAndDate($donationId,$month,$year);
        //Get User selected dates from table
        //$donationBlocked = $this->seva_item_blocked_dates->getBlockedDatesByUserAndItemAndDate($donationId,$this->currentUser->id,$month,$year,2);
        $events = [];
        $evetDates = [];
        $blockedDates = [];
        //preparing events to display in calendar
        foreach($donationUserNames as $name){
            $split_dates =  (explode(",",$name->schedule_dates ?? ""));
            $words = explode(" ", $name->family_member_details ?? "");
            $disName = "";
            foreach ($words as $w) {
                $disName.=mb_substr($w, 0, 1)." ";
            }
            foreach($split_dates as $date){
                $key_date = date("Y-m-d",strtotime($date));
                if(array_search($key_date, array_column($events, 'start')) !== False) {
                    $key = array_search($key_date, array_column($events, 'start'));
                    $events[$key]['title'] = 'More...';  
                    $events[$key]['is_count_more'] = 1;  
                } else {
                    $events[] =  array("title"=>trim($disName),"start"=>date("Y-m-d",strtotime($date)),"is_original_event"=>1,"is_count_more"=>0);
                    $evetDates[] = date("Y-m-d",strtotime($date));
                }
            }
        }
        $res_dates = explode(",",$this->donationscart->product_options($rowid)['result_date'] ?? "");
        foreach($res_dates as $date){
            $blockedDates[] = date("Y-m-d",strtotime($date));
            $events[] =  array("title"=>'',"start"=>date("Y-m-d",strtotime($date)),"display"=>'background',"is_original_event"=>0,"is_count_more"=>0);
        }
        /*$ids = array();
        foreach($donationBlocked as $name){
            if(strtotime(date('Y-m-d H:i:s')) > strtotime($name->expiry_date)){
                $ids[] = $name->id;
            }else {
                $evetDates[] = date("Y-m-d",strtotime($name->selected_dates));
                if($name->user_id == $this->currentUser->id){
                    $blockedDates[] = date("Y-m-d",strtotime($name->selected_dates));
                    $events[] =  array("title"=>'',"start"=>date("Y-m-d",strtotime($name->selected_dates)),"display"=>'background',"is_original_event"=>0);
                }
            }
        }
         if(!empty($ids)){
            $delete = $this->seva_item_blocked_dates->deleteAfterExpiry($ids);
        } */
        $data['events'] = $events; 
        $data['eventDates'] = $evetDates;
        $data['blockedDates'] = $blockedDates;
        echo json_encode($data,JSON_HEX_APOS);
    }

    public function orderedByDate($date,$donationId){
        $this->load->model('orders/orders_model');
        //get user initails to display in calendar
        $donationUserNames = $this->orders_model->orderItemsByItemIdAndSignleDate($donationId,$date);
        $events = '';
        foreach($donationUserNames as $name){
            $split_dates =  (explode(",",$name->schedule_dates ?? ""));
            $words = explode(" ", $name->family_member_details ?? "");
            $disName = "";
            foreach ($words as $w) {
                $disName.=mb_substr($w, 0, 1)." ";
            }
            foreach($split_dates as $sp_date){
                if($sp_date == date('d M Y',strtotime($date))) {
                    $events.=trim($disName).", ";
                }
            }
            $data = rtrim($events, ', ');
        }
        echo ($data);
    }

	public function dates_validate()
	{
		if($GLOBALS['donationCartLocked']==1)
        {
            echo 'cartLocked';
            exit;
        }
        if(empty($_POST['selected_dates'])){
            echo "0"; exit;
        }
        if(isset($_POST['donationid']) && is_numeric($_POST['donationid']) && $_POST['donationid'])
        {
            $donationData = $this->donations_model->donationData($_POST['donationid']);
            if(!empty($donationData) && $donationData->status==1)
            {
                $final=array();
                if($_POST['selected_dates']!='')
                    $selected=array_filter(explode(",",$_POST['selected_dates'] ?? ""));
                else
                    $selected=array();
                    
            /*  if($donationData->allow_one_user_per_day_per_seva == 1){ 
                    $this->load->model('ashrams/seva_item_blocked_dates');
                    $validate = $this->seva_item_blocked_dates->getItemByDates($_POST['donationid'],$selected,$_POST['rowid'],2);
                    $isValid = true;
                    foreach($validate as $date){
                        if(strtotime(date('Y-m-d H:i:s')) < strtotime($date->expiry_date) && $date->user_id != $this->currentUser->id){
                            echo "11"; exit;
                        }
                    }
                    $delete = $this->seva_item_blocked_dates->deleteDates($this->currentUser->id,$_POST['donationid'],$_POST['rowid'],2);
                    $insert = $this->seva_item_blocked_dates->saveDates($selected,$this->currentUser->id,$_POST['donationid'],$_POST['rowid'],2);
                    foreach($selected as $selectedDate) {
                        $final[] = $selectedDate;
                    }
                }
                else { */
                    if(isset($donationData->limit_days_per_item) && $donationData->limit_days_per_item!="All available days" && $donationData->limit_days_per_item>0)
                    {
                        if(count($selected)>$donationData->limit_days_per_item)
                        {
                            echo 'Maximum '.$donationData->limit_days_per_item.' day(s) allowed for this seva';
                            exit;
                        }
                    }
                    $startDate=date("d M Y 00:00:00");
                    $endDate=date("d M Y 23:59:00",strtotime("+5 Months"));
                    
                    if(isset($donationData->subscription) && $donationData->subscription==1)
                    {
                        if(count($selected)>1)
                        {
                            echo '10';
                            exit;
                        }
                        $tomorrow=date("d M Y 00:00:00",strtotime("+1 day"));
                        if(strtotime($selected[0])<strtotime($tomorrow))
                        {
                            echo "11";
                            exit;
                        }
                    }
                    
                    $dates_set=$this->cart_model->getDonationValidDates($donationData);
                    
                    if(!empty($selected))
                    {
                        foreach($selected as $selectedDate)
                        {
                            if($donationData->allow_one_user_per_day_per_seva == 1){
                                $selectedDate = date('d M Y',strtotime($selectedDate));
                            }
                            if(in_array($selectedDate,$dates_set))
                            {
                                $final[]=$selectedDate;
                            }
                        }
                    }
                //}
                
                foreach($final as $key=>$tms)
                {
                    $final[$key]=strtotime($tms ?? '');
                }
                
                asort($final);
                
                $store_array=array();
                
                $cnt=0;
                $first='';
                
                //print_r($store_array); exit;
                foreach($final as $key=>$tms)
                {
                    if($cnt==0)
                    $first=date("d M Y",$tms);
                    
                    $final[$key]=date("d M Y (D)",$tms);
                    $store_array[]=date("d M Y",$tms);
                    $cnt++;
                }
                //print_r($store_array); exit;
                if($_POST['save']==1)
                {
                    $opt=$this->donationscart->product_options($_POST['rowid']);
                    $opt['result_date']=implode(",",$store_array);
                    $opt['schedule_options']=$_POST;
                    $opt['user_date']=$first;

                    $upd= array(
                             'rowid' => $_POST['rowid'],
                             'options'   => $opt,
                             'qty'=>$cnt                    );

                    $this->donationscart->update($upd);
                    $this->cart_log_model->log("Dates changed - Name:".$donationData->donation_name,$this->session->userdata("donationCartAshramId"),2);
                    $this->cart_model->validateCart($this->donationscart);
                }
                echo implode("<br>",$final);
            }
        }
	}

	public function update_payment_count($key)
    {
    	$data['flag']=0;
		if($GLOBALS['donationCartLocked']==1)
		{
			$data['flag']=2;
            $data['msg']="Sorry! A transaction initiated by you, is already in progress.";
			goto end;
		}

    	$this->form_validation->set_rules('num_of_payments', 'Number of payments', 'trim|numeric');
    	if($this->form_validation->run() == FALSE)
		{
			$data['msg']="Invalid request";
			goto end;
		}
		$item=$this->donationscart->get_item($key);
		$options=$this->donationscart->product_options($key);
		if(empty($options) || $options['subscription']==0)
		{
			$data['msg']="Invalid item";
			goto end;
		}
		$total_payments=$this->donations_model->getSubscriptionsCount($options['result_date'],$item['id']);
		if($this->input->post("num_of_payments") > $total_payments)
		{
			$data['msg']="Invalid request";
			goto end;
		}

		$options['num_of_payments']=$this->input->post("num_of_payments");
		$options['expiration_method']=1;
		$updateArray= array(
	               'rowid' => $key,
       			       'options'   => $options
		            );
		

		$this->donationscart->update($updateArray);
		$this->cart_log_model->log("Number of payments updated - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
		$data['flag']=1;

		end:
		echo json_encode($data);
    }

	public function updatenote()
    {
		if($GLOBALS['donationCartLocked']==1)
		{
			echo 2;
			return;
		}

    	$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->donationscart->get_item($_POST['pk']);
		$options=$this->donationscart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['note']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );

	        foreach ($options as $key => $val)
			{
				$temp[$key] = $val;
			}

			$this->donationscart->update($updateArray);
			$this->cart_log_model->log("Family details updated - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updatePersonalnote()
    {
		if($GLOBALS['donationCartLocked']==1)
		{
			echo 2;
			return;
		}

    	$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->donationscart->get_item($_POST['pk']);
		$options=$this->donationscart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['personal_note']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );

	        foreach ($options as $key => $val)
			{
				$temp[$key] = $val;
			}

			$this->donationscart->update($updateArray);
			$this->cart_log_model->log("Personal Note updated - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updateamount()
    {
    	$data['flag']=0;
		if($GLOBALS['donationCartLocked']==1)
		{
			$data['flag']=2;
			goto end;
		}

    	//$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			goto end;
		}

		if(isset($_POST['value']))
		{
			if($_POST['value']=='')
			{
				$data['flag']=3;
				$data['msg']='Enter Amount';
				goto end;
			}
			if(!preg_match("/^\d+$/",$_POST['value']))
			{
				$data['flag']=3;
				$data['msg']='Enter only digits';
				goto end;
			}

			if(strlen($_POST['value'])!=strlen(abs($_POST['value'])))
			{
				$data['flag']=3;
				$data['msg']='Enter valid amount';
				goto end;
			}
		}
		else
		{
			goto end;
		}
		$item=$this->donationscart->get_item($_POST['pk']);
		$options=$this->donationscart->product_options($_POST['pk']);
		if(!empty($options) && $options['is_price_fixed']==0)
		{
			$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));

            $donationData=$this->donations_model->donationData($item['id']);
            $minPriceAmount=0;
			
			if(strtolower($this->session->userdata("defaultCurrency"))=='inr')
			{
                if(isset($donationData->min_price_inr) && $donationData->min_price_inr>0)
                {
                    $minPriceAmount = $donationData->min_price_inr;
                }
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}
			if(strtolower($this->session->userdata("defaultCurrency"))=='usd')
			{
                if(isset($donationData->min_price_usd) && $donationData->min_price_usd>0)
                {
                    $minPriceAmount = $donationData->min_price_usd;
                }
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}

            if(trim(abs($_POST['value']))<$minPriceAmount)
            {
                $data['flag']=3;
                $data['msg']='Minimum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$minPriceAmount;
                goto end;
            }

			if(trim(abs($_POST['value']))<$minAmount)
			{
				$data['flag']=3;
				$data['msg']='Minimum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$minAmount;
				goto end;
			}
			if(trim(abs($_POST['value']))>$maxAmount)
			{
				$data['flag']=3;
				$data['msg']='Maximum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$maxAmount;
				goto end;
			}
			$options[$priceCol]=$_POST['value'];
			$updateArray= array(
		               		'rowid' => $_POST['pk'],
           			       	'options'   => $options
			            );
			$this->donationscart->update($updateArray);
			$this->cart_log_model->log("Amount updated - Name:".$item['name'].", Amount:".strtoupper($this->session->userdata("defaultCurrency"))." ".$_POST['value'],$this->session->userdata("donationCartAshramId"),2);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
    }

    public function cancelprevious()
    {
    	$result['flag']=0;
    	if($GLOBALS['donationCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['donationCartStartedOn']);
			if(time()>=$startedOn)
			{
				$this->cart_model->regenerateSession(2);
				$result['flag']=1;
				goto end;
			}
		}
		end:
		echo json_encode($result);
    }
    public function checkout_notify($tab_index=null)
    {
    	if($tab_index!=null && in_array($tab_index,array(0,1,2)))
    	{
    		$data='';
    		if($tab_index==2)
    		{
    			$countryData=$this->locations_model->getCountryByCode($this->input->post("country"));
    			$data="<br>Data:<br>".$this->input->post("firstname")." ".$this->input->post("lastname")."<br>".
    				$this->input->post("city").", ".$this->input->post("state").", ".$this->input->post("country")."<br>".
    				"+".$countryData->isd_code." ".$this->input->post("phone")."<br>".
    				$this->input->post("email");
    		}
    		$this->cart_log_model->log("Checkout - navigated to tab ".($tab_index+1).$data,$this->session->userdata("donationCartAshramId"),2);
    	}
    }

    public function check_donation_modifications()
    {
        $result['flag']=1;
        //Validate Cart items
        $this->cart_model->validateCart($this->donationscart);

        //Check cart items count
        $cartContents=$this->donationscart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $result['flag']=0;
            goto end;
        }
        if(is_single_currency_site==1 && default_currency!=strtolower($this->session->userdata("defaultCurrency")))
        {
            $result['flag']=5;
            $result['alertMessage'] = '<strong>JGD. You cart not supporting the currency.</strong>';
            goto end;
        }
        $partialPayCount = 0;
        $noPartialPayCount = 0;
        $totalItems=count($cartContents);
        $validItems=0;
        foreach ($cartContents as $cartItem)
        {
            if($cartItem['options']['status']==1)
            {
                $validItems++;
            }
            if($cartItem['options']['partial_payments_allowed'] == 1)
            {
                $partialPayCount++;
            }
            else
            {
                $noPartialPayCount++;
            }

            if($this->session->userdata('donationCartAshramId')!=$cartItem['options']['ashram_id'])
            {
                $ashramData=$this->ashrams_model->ashramData($cartItem['options']['ashram_id']);
                $result['flag']=5;
                $result['alertMessage'] = '<strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>';
                goto end;
            }
        }

        // dont allow more than one partial payments, if all cart items are partial pay items
        if($partialPayCount>1 && $partialPayCount == $validItems)
        {
            $this->session->set_flashdata("partial_payment_error",1);
            $result['flag']=2;
            goto end;
        }
        

        //Check all items in cart are valid
        if($validItems!=$totalItems)
        {
            $result['flag']=4;
            goto end;
        }

        end:
        echo json_encode($result);

    }

    public function pay()
    {
    	//Check site settings
    	$result['flag']=0;
    	if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=3;
			goto end;
		}
    	if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}

		//Get trust accounts for Ashram and Currency defined
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("donationCartAshramId"),2);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$customData['trustData']=$trustsArray[strtolower($this->session->userdata("defaultCurrency"))];
    	$customData['trustData']=$this->ashrams_trust_accounts_model->removeCredentials($customData['trustData']);

		if($this->currentUser->admin==1 && $customData['trustData']->payment_mode=='razorpay' && $this->session->userdata("defaultCurrency")=='inr' && $this->input->post("payment_mode")=='default'){
    		$verify = $this->checkadminDonationPayments();
    		if($verify == 0 || $verify == 3){
    			$result['flag']=501;
				goto end;
    		}
    		if($verify == 4){
    			$result['flag']=502;
				goto end;
    		}
    	}

    	if($this->currentUser->admin!=1 && $customData['trustData']->payment_mode=='razorpay' && $this->session->userdata("defaultCurrency")=='inr'){
    		$verify = $this->checkuserDonationPayments();
    		if($verify == 1){
    			$result['flag']=502;
				goto end;
    		}
    	}

		//Get cart DB record
		if($GLOBALS['donationCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['donationCartStartedOn']);
			if(time()>=$startedOn)
			{
				$result['time_exceed']=1;
			}
			$result['flag']=5;
			goto end;
		}
		
	 	//Validate form data
	 	if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) ||
	 			!isset($_POST["preferred_name"]) ||
				!isset($_POST["email"]) || !isset($_POST["phone"]) ||
				!isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) ||
				!isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) ||
				!isset($_POST["donation_initials"]))
		{
	 		goto end;
		}

		$this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
		$this->form_validation->set_rules('email', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
		$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
		$this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('country', 'Country','trim|required|checkCountry');
		$this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
		$this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');
		if($this->currentUser->admin==1)
		{
			$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkAdminPaymentMode');
			$paymentMode=$this->input->post("payment_mode");
		}
		else
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

        if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode=='paypal')
        {
            if(isset($_POST["credit_card_id"]) && $_POST["credit_card_id"] !='')
            {
                $creditCardData=$this->credit_cards_model->getCard($_POST["credit_card_id"]);
                if(empty($creditCardData))
                {
                    goto end;
                }
            }
            else
            {
                if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode!='stripe' && $paymentMode!='cash')
                {
                    $this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
                    $this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
                    $this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
                    $this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
                }
            }
        }

		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
	 		goto end;
		}
		//Validate Cart items
		$this->cart_model->validateCart($this->donationscart);

		//Check cart items count
		$cartContents=$this->donationscart->contents();
		if(empty($cartContents)) //If cart is empty
		{
			$result['flag']=2;
	 		goto end;
		}

		$totalItems=count($cartContents);
		$validItems=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['status']==1)
			{
				$validItems++;
			}
		}

		//Check all items in cart are valid
		if($validItems!=$totalItems)
		{
			$result['flag']=4;
	 		goto end;
		}


		//Check for subscription items
		$subscription_error=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['subscription']==1 && $cartItem['options']['num_of_payments']==0)
			{
				$subscription_error=1;
				break;
			}
		}
		if($subscription_error==1)
		{
			$this->session->set_flashdata("donation_error","Please select number of payments for all subscription items");
			$result['flag']=9999;
			$result['reload']=true;
	 		goto end;
		}
		//Check for subscription items

		

		//Capture User ID
		$userId=0;
		if($this->session->userdata("loggedIn"))
		{
			if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$tData=$this->session->userdata('temp_checkout_user');
					$userId=$tData->id;
				}
			}
			else
			{
				$userId=$this->currentUser->id;
			}
		}

    	$amount=$this->cart_model->getTotalPrice($this->donationscart);

    	//Decide trust based on Currency
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}

    	$this->load->model('ashrams/ashrams_model');

    	//Define custom data before initializing transaction
    	$created_by_user_id=0;
    	$created_by=0;
		$userData=array();
		if($this->session->userdata('id'))
		{
			if($this->session->userdata('temp_checkout_user'))
			{
				$userData=$this->session->userdata('temp_checkout_user');
				$userId=$userData->id;
			}
			$created_by=1;
		}
		else if($this->session->userdata('user_id'))
		{
			$userId=$this->session->userdata('user_id');
			$userData=$this->currentUser;
			$created_by=2;
		}
        
		$this->cart_log_model->log("Payment initiated",$this->session->userdata("donationCartAshramId"),2);

		//If payment mode not set or payment mode is default
		if(!isset($paymentMode) || $paymentMode=='default')
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

		if($this->session->userdata('loggedIn'))
			$created_by_user_id=$this->currentUser->id;

		$customData['cartData']=$cartContents;
		$customData['formData']=$_POST;
		$customData['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("donationCartAshramId"));
		$customData['cart_type']=2;
		$customData['paymentMode']=$paymentMode;
		$customData['created_by']=$created_by;
		$customData['created_by_user_id']=$created_by_user_id;
		$customData['model']="orders/orders_model";
		$customData['model_name']="orders_model";
		$customData['ip_address']=$_SERVER['REMOTE_ADDR'];
		$customData['formData']['ashram_id']=$this->session->userdata("donationCartAshramId");

		$customData['formData']['is_manual_payment']=0;
		if($this->input->post("is_manual_payment"))
		{
			$customData['formData']['is_manual_payment']=1;
		}

        #--------------------------------------------------------------------------------------#
        //Which will validate Item Ashram ID and Order Ashram ID if any item mismatch with order Ashram ID It will returns flag 4 (Item modified warning and stop creating order).
        $this->load->helper("validate_order_ashram");
        $ashramCheck = validate_order_ashram(2,$cartContents,$this->session->userdata("donationCartAshramId"),$this->session->userdata("donationCartAshramIdSelection"));
        if($ashramCheck)
        {
            $result['flag']=4;
            goto end;
        }
        #--------------------------------------------------------------------------------------#

		$amount=$this->cart_model->getTotalPrice($this->donationscart);
		$customData['amount_in_words']=$this->general_model->amountToWords($amount);
		//Load payment model
		$this->load->model("payment_model");
		//Load Temp payments model
		$this->load->model("temp_payments_model");
		$reference=$this->payment_model->setTempInfo(
			$userId,
			$userData,
			$amount,
			base_url."donations/",
			base_url."donations/checkout?ashram_id=".$this->session->userdata("donationCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"),
			$customData,
			$this->session->userdata("defaultCurrency")
			);
		$result['flag']=1;
		$result['reference']=$reference;
		$this->cart_model->updateReferenceId($reference,2);

		$result['payment_mode']=$paymentMode;

        $tempOrderId = 0;
        $tempPaymentId = "";
        if($paymentMode=='razorpay')
        {
            $this->load->model("razorpay_webhook_model");
            $tempData = $this->razorpay_webhook_model->createTempOrders($reference,$this->session->userdata("donations_temp_reference"));

            $tempOrderId = $tempData["order_id"];
            $tempPaymentId = $tempData["payment_id"];
        }

        if($paymentMode=='stripe')
        {
            $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
            $result['temp_reference']=$temp_reference;

            $this->load->model("stripe_webhook_model");
            $str_amount = $amount*100;
            $tempData = $this->stripe_webhook_model->createTempOrders($reference,$temp_reference);
            $checkoutSession = $this->stripe_webhook_model->createStripeSession($this->session->userdata("defaultCurrency"),$this->input->post("email"),$customData['trustData'],2,$cartContents,$str_amount,$reference,$customData,$userId,$this->session->userdata("donationCartAshramIdSelection"));
            if($checkoutSession["status"] == "error")
            {
                $result['flag']=10023;
                $result['error_msg']=$checkoutSession['status_message'];
                goto end;
            }
        }

		if($this->session->userdata("defaultCurrency")=='usd')
		{
			$result['currency']="USD";
			if($paymentMode=='paypal')
			{
				$result['flag']=101;
				$this->load->model("paypal_model");
                $creditCardData = array();
				$paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
				if($paypalResponse['flag']==1)
				{
					$result['redirect_to']=$paypalResponse['redirect_url'];
					$result['payment_status']=1;
					$this->session->set_flashdata("order_placed",1);
					$this->session->set_userdata("order_placed",1);
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
				}
				else
				{
					$result['payment_status']=0;
					$result['error_msg']=$paypalResponse['error_msg'];
					$this->cart_model->updateReferenceId('',2);
					$this->cart_log_model->log("Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("donationCartAshramId"),2);
				}
			}
			if($paymentMode=='authorize.net')
			{
				$this->load->model("authorizenet_model");
				$authnetResponse=$this->authorizenet_model->processOneTimePayment($reference);
				if($authnetResponse['flag']==1)
				{
					$result['redirect_to']=$authnetResponse['redirect_url'];
					$result['payment_status']=1;
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
					$this->session->set_flashdata("order_placed",1);
				}
				else
				{
					$result['payment_status']=0;
					$result['error']="Error making payment";//$authnetResponse['error_msg'];
					$this->cart_model->updateReferenceId('',2);
					$this->cart_log_model->log("Payment failure:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
				}
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['payment_mode']="razorpay";
                $result['subscription_id']= "";
                $result['reference_no'] = $reference;
                $result['ashram_id'] = $this->session->userdata("donationCartAshramIdSelection");
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
			}

			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}
		else
		{
			$result['currency']="INR";
			if($paymentMode=='payu')
			{
				$result['redirect_to']='/payment/direct/'.$reference;
				$this->cart_log_model->log("Redirected to payment gateway:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
				$result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
				$result['prefill_email']=$this->input->post("email");
				$result['prefill_contact']=$this->input->post("phone");
                $result['payment_mode']="razorpay";
                $result['subscription_id']= "";
				$result['reference_no'] = $reference;
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
				$result['ashram_id'] = $this->session->userdata("donationCartAshramIdSelection");
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
			}
			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}

		end:
		echo json_encode($result);
    }

	public function donor_modal($key='')
    {
		if($GLOBALS['donationCartLocked']==1)
		{
			echo 2;
			return;
		}

		$options=$this->donationscart->product_options($key);
		if(!empty($options))
		{
			echo $this->load->view("donors/public/_donor_lookup",array("row_key"=>$key),true);
		}
    }

    public function donor_update($key='',$donorId=0)
    {
    	$result['flag']=0;
		if($GLOBALS['donationCartLocked']==1)
		{
			goto end;
		}

		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
			$userId=$this->session->userdata('temp_checkout_user')->sso_user_id;
		else
			$userId=$this->currentUser->sso_user_id;

		$options=$this->donationscart->product_options($key);
		if(!empty($options) && $options['subscription']==1)
		{
			$donorData=$this->donors_model->donorData($donorId);
			if(empty($donorData) || $userId!=$donorData->user_id)
			{
				goto end;
			}
			$options['donor_id']=$donorId;
			$updateArray= array(
		               'rowid' => $key,
           			       'options'   => $options
			            );

			$this->donationscart->update($updateArray);
			$this->cart_log_model->log("Donor updated - ID:".$donorId,$this->session->userdata("donationCartAshramId"),2);
			$result['flag']=1;

		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
    }

    public function list_donors()
	{
		$userData=array();
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
			$userData=$this->session->userdata('temp_checkout_user');
		else
			$userData=$this->currentUser;

		$list=$this->donors_model->getMyDonors($userData,0);
		echo json_encode($list);
		$this->logaction->log($this->service,"Public - Donors listing ajax request");
	}

	public function load_user_temp($uid=0)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$userData=$this->users_model->userData($uid);
			if(!empty($userData))
			{
				if($userData->status==1 && $userData->deleted==0 && $userData->email_verified==1)
				{
					unset($userData->pin);
					unset($userData->pass);
					unset($userData->conf_key);
					unset($userData->forgot_key);
					unset($userData->pin_copy);
					unset($userData->first_logged_in);
					unset($userData->security_complete);
					unset($userData->pin_set);
					unset($userData->role);
					unset($userData->roles);
					unset($userData->last_logged_in);
					$this->session->set_userdata('temp_checkout_user',$userData);
					$data['flag']=1;
					$data['userdata']=$userData;

					$this->load->library('poojascart');
					$this->load->library('storecart');
					$this->load->library('subscriptionscart');
					// $this->cart_model->emptyAllCarts();
				}
				else
				{
					$data['flag']=2;
				}
			}
			else
			{
				$data['flag']=2;
			}
		}
		header("Content-Type:application/json");
		echo json_encode($data);
	}

		public function checkadminPayments(){
		$cartContents=$this->donationscart->contents();
		if(count($cartContents) > 1){
			$subcheck = null;
			$d = "";
			foreach($cartContents as $key=>$val){
				if($subcheck != $val['options']['subscription']){
					$d .= "false-";
				}
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1){
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			$d = explode("-", $d);
			if($d[1] == "false"){
				echo 0;
			} else if($d[1] != "false" && $subcheck == 1) {
				echo 3;
			} else if($d[1] != "false" && $subcheck == 1 && $dayscheck == "true") {
				echo 4;
			} else {
				echo 1;
			}

		} else {
			foreach($cartContents as $key=>$val){
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1){
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			if($subcheck == 1 && $dayscheck == "true") {
				echo 4;
			} else {
				echo 1;
			}
		}
	}

	public function checkadminDonationPayments(){
		$cartContents=$this->donationscart->contents();
		if(count($cartContents) > 1){
			$subcheck = null;
			$d = "";
			foreach($cartContents as $key=>$val){
				if($subcheck != $val['options']['subscription']){
					$d .= "false-";
				}
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1){
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			$d = explode("-", $d);
			if($d[1] == "false"){
				return 0;
			} else if($d[1] != "false" && $subcheck == 1) {
				return 3;
			} else if($d[1] != "false" && $subcheck == 1 && $dayscheck == "true") {
				return 4;
			} else {
				return 1;
			}

		} else {
			foreach($cartContents as $key=>$val){
				$dayscheck = "";
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1){
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			if($subcheck == 1 && $dayscheck == "true") {
				return 4;
			} else {
				return 1;
			}
		}
	}

	public function checkuserPayments(){
		$cartContents=$this->donationscart->contents();
		foreach($cartContents as $key=>$val){
			if('days' == $val['options']['period']){
				echo 1;
			}
		}
	}

	public function checkuserDonationPayments(){
		$cartContents=$this->donationscart->contents();
		foreach($cartContents as $key=>$val){
			if('days' == $val['options']['period']){
				return 1;
			}
		}
	}

    public function donationOnFamilyTypeChange()
    {
        $result['flag']=1;
        if($GLOBALS['donationCartLocked']==1)
        {
            echo 11;
            goto end;
        }
        //Get Donation Item Key
        $donationItemRowKey = "";
        $donationItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
        if(!$donationItemRowKey || $donationItemRowKey=='' )
        {
            echo 12;
            goto end;
        }
        $this->form_validation->set_rules('donation_on_family_type', 'Donation on Family Type', 'trim|required|checkDonationOnFamilyType');
         if($this->form_validation->run() == FALSE)
        {
            echo 12;
            goto end;
        }
        //Get cart item options
        $itemOpt=$this->donationscart->product_options($donationItemRowKey);
        if(empty($itemOpt))
        {
            echo 13;
            goto end;
        }
        //Update donation on family type to cart
        $itemOpt['donation_on_family_type']=$this->input->post('donation_on_family_type');
        $upd= array(
                 'rowid' => $donationItemRowKey,
                 'options'   => $itemOpt);
        $this->donationscart->update($upd);
        end:
        return $result;
    }

    /*
    public function donationOnFamilyTypeChange_old()
    {
        $result['flag']=1;
        if($GLOBALS['donationCartLocked']==1)
        {
            echo 11;
            goto end;
        }
        $cartId = $this->input->post('cartId');
        $donationonFamilyType = $this->input->post('donationonFamilyType');
        $cartsessId = $this->input->post('cartsessId');
        if($cartId && $donationonFamilyType && $cartsessId)
        {
            $donationcart = $this->session->userdata('donationonFamilyType');
            $arrays = isset($donationcart)?$donationcart:array();
            $array_merge['donationonFamilyType'] = array_merge($arrays,array($cartsessId=>$donationonFamilyType));
            $this->session->set_userdata($array_merge);
        }

        end:
        return $result;
    }
    */

    public function donationOnFamilyMemberChange()
    {
        $result['flag']=1;
        if($GLOBALS['donationCartLocked']==1)
        {
            echo 11;
            goto end;
        }
        //Get Donation item row key
        $donationItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
        //Get Donation on family members
        $donationonFamilyMembers = ($this->input->post('donation_on_family_members')) ? $this->input->post('donation_on_family_members'): "";
        //Get cart item options
        $itemOpt=$this->donationscart->product_options($donationItemRowKey);
        if(empty($itemOpt))
        {
            echo 13;
            goto end;
        }
        if($donationItemRowKey && $donationonFamilyMembers && isset($itemOpt['donation_on_family_type']) && in_array($itemOpt['donation_on_family_type'], array('6','7')))
        {
            if(!$donationItemRowKey || $donationItemRowKey=='' || !$donationonFamilyMembers || $donationonFamilyMembers=='')
            {
                echo 12;
                goto end;
            }

            if($this->currentUser->admin==1)
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
                }
            }
            else
            {
                $checkoutUserId = $this->currentUser->sso_user_id;
            }
            $donors = $this->donors_model->getUserDonorIds($checkoutUserId);
            $donationonFamilyMembersarr = $donationonFamilyMembers;
            foreach($donationonFamilyMembersarr as $familyMember)
            {
                if($familyMember=='' || !is_numeric($familyMember) || $familyMember==0 || !in_array($familyMember, $donors))
                {
                    echo 14;
                    goto end;
                }
            }
            if($itemOpt['donation_on_family_type']==6)
            {
                $donationonFamilyMembersarr = $donors;
            }
            //Update donation on family member to cart
            $itemOpt['donation_on_family_members']=$donationonFamilyMembersarr;

            $upd= array(
                     'rowid' => $donationItemRowKey,
                     'options'   => $itemOpt);

            $this->donationscart->update($upd);
        }
        end:
        return $result;
    }

    /*
	public function donationOnFamilyMemberChange_old()
	{
        $result['flag']=1;
        if($GLOBALS['donationCartLocked']==1)
        {
           echo 11;
            goto end;
        }
		$cartId = $this->input->post('cartId');
		$donationonFamilyMembers = $this->input->post('donationonFamilyMembers');
		$cartsessId = $this->input->post('cartsessId');
		if($cartId && $donationonFamilyMembers && $cartsessId)
		{
			$donationcart = $this->session->userdata('donationonFamilyMembers');
			$arrays = isset($donationcart)?$donationcart:array();
			$array_merge['donationonFamilyMembers'] = array_merge($arrays,array($cartsessId=>$donationonFamilyMembers));
       		$this->session->set_userdata($array_merge);
		}

        end:
        return $result;
	}
    */


	public function changeListItemView()
	{
		$listType = $this->input->post('listType');
		if($listType)
		{
       		$this->session->set_userdata('donationviewType', $listType);
		}
	}



	public function clearCart()
	{
		$result['flag']=0;
		$cart=$this->donationscart->contents();
		if(empty($cart))
    	{
    		$result['flag']=2;
    	} else {
    		foreach ($cart as $key => $value)
    		{
    			if(isset($key) && $key!='')
				{
					$item=$this->donationscart->get_item($key);
					if(!empty($item))
					{
						$upd= array(
					               'rowid' => $key,
		               				'qty'   => 0
						            );
						$this->donationscart->update($upd);
						$this->logaction->log($this->service,"Donation removed from cart _ Donation ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
						$this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
					}
				}
    		}
            //delete from seva blocked dates
            //$this->seva_item_blocked_dates->ClearCart($this->currentUser->id);
    		$cc=$this->donationscart->contents();
			if(count($cc)==0)
			{
				$this->session->unset_userdata('donationCartAshramId');
				$result['flag']=1;
				$result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('donationCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('donationCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
			} else {
				$result['flag']=3;
				$result['cart_count']=count($cc);
			}
			
    		$this->cart_model->regenerateSession(1);
    	}
		
		end:
		echo json_encode($result);
	}

    public function addItemAgain()
    {
        $result['flag']=0;
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
           $result['flag']=55;
            goto end;
        }
        if($GLOBALS['site_settings']['donations']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
        {
           $result['flag']=12;
           $result['error_msg']="Donations are disabled";
            goto end;
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
               $result['flag']=51;
                goto end;
            }
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
        {
            if(!$this->session->userdata('temp_checkout_user'))
            {
               $result['flag']=12;
               $result['msg']='Please select user before adding Donation to cart.';
                goto end;
            }
        }
        if($GLOBALS['donationCartLocked']==1)
        {
           $result['flag']=11;
            goto end;
        }

        //Check cart items count
        $cartContents=$this->donationscart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $result['flag']=56;
            goto end;
        }

        if(isset($_POST['key']) && $_POST['key']!='')
        {
            $item=$this->donationscart->get_item($_POST['key']);
            if(!empty($item))
            {
                if(isset($_POST['freeAmount']) && $_POST['freeAmount']>0)
                {
                    $result = $this->addItem($item['id'],$_POST['freeAmount'],$_POST['key']);
                }
                else{
                    $result = $this->addItem($item['id'],0,$_POST['key']);
                }
                exit;
            }
            else
            {
                $result['flag']=2;
            }
        }
        end:
        echo json_encode($result);
    }

    public function updateOtherName($othernamefor=0)
    {
        if($GLOBALS['donationCartLocked']==1)
        {
            echo 2;
            return;
        }
        if(!in_array($othernamefor, [1,2,3,4,5,6,7,8,9,10]))
        {
            echo 0;
            return;
        }

        $this->form_validation->set_rules('value', 'Name','trim|required|min_length[2]|max_length[60]');
        $this->form_validation->set_rules('pk', 'ID', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            echo 0;
            return;
        }
        $item=$this->donationscart->get_item($_POST['pk']);
        $options=$this->donationscart->product_options($_POST['pk']);
        if(!empty($options))
        {
            $options['other_name'.$othernamefor]=$_POST['value'];
            $updateArray= array(
                       'rowid' => $_POST['pk'],
                           'options'   => $options
                        );
            $this->donationscart->update($updateArray);
            $this->cart_log_model->log("Other name updated, Item name:".$item['name'],$this->session->userdata("donationCartAshramId"),1);
            echo 1;
        }
        else
        {
            echo 0;
        }
    }

    public function removeOtherName()
    {
        $rowKey = '';
        $otherNameId = '';
        if(isset( $_POST['rowKey']) &&  $_POST['rowKey']>0)
        {
            $rowKey = $_POST['rowKey'];
        }
        if(isset( $_POST['otherNameId']) &&  $_POST['otherNameId']>0)
        {
            $otherNameId = $_POST['otherNameId'];
        }
        if($GLOBALS['donationCartLocked']==1)
        {
            echo 2;
            return;
        }
        if(!in_array($otherNameId, [1,2,3,4,5,6,7,8,9,10]))
        {
            echo 0;
            return;
        }

        $this->form_validation->set_rules('rowKey', 'Row Key', 'trim|required');
        $this->form_validation->set_rules('otherNameId', 'Other Name ID', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            echo 0;
            return;
        }
        $item=$this->donationscart->get_item($_POST['rowKey']);
        $options=$this->donationscart->product_options($_POST['rowKey']);
        if(!empty($options))
        {  
            if($otherNameId>0)
            {
                $deletedName = $options['other_name'.$otherNameId];
                $deletingId = $otherNameId;
                for($deletingId = $otherNameId; $deletingId<=10; $deletingId++)
                {
                    if($deletingId==10)
                    {
                        $options['other_name'.$deletingId] = "";
                    } else {
                        if(isset($options['other_name'.($deletingId+1)]) && $options['other_name'.($deletingId+1)]!='')
                        {
                            $options['other_name'.$deletingId] = $options['other_name'.($deletingId+1)];
                        }
                        else
                        {
                            $options['other_name'.$deletingId] = '';
                        }
                    }
                }
                $updateArray= array(
                       'rowid' => $_POST['rowKey'],
                           'options'   => $options
                        );
                $this->donationscart->update($updateArray);
                $this->cart_log_model->log($deletedName." name deleted, Item name:".$item['name'],$this->session->userdata("donationCartAshramId"),1);
                echo 1;
            }
        }
        else
        {
            echo 0;
        }
    }

    public function appji_donation($linkToken = '')
    {
        $data['slug']="donations";
        $data['is_this_appji_donation']=1;
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">Website is under maintenance, please try after some time.</h4>';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if($linkToken == '')
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        $this->load->model('appji/appji_model');
        $donationLinkDetails=$this->appji_model->donationLinkDetailsByLinkToken($linkToken);
        if(empty($donationLinkDetails))
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if( (isset($donationLinkDetails['isLinkExpired']) && $donationLinkDetails['isLinkExpired']==1) )
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">This Donation has already been paid or no longer valid.</h4>';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        $expiryDate = '';
        if(isset($donationLinkDetails['linkExpiryTime']) && $donationLinkDetails['linkExpiryTime']!='')
        {
            $expiryDate = date("Y-m-d H:i:s", $donationLinkDetails['linkExpiryTime']);
        }

        if( $expiryDate!='' && $expiryDate<date('Y-m-d H:i:s'))
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">Sorry, the link has expired. Please contact Appji support: <a href = "mailto: support@appji.org">support@appji.org</a> </h4>';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
                $data['showErrorMessage'] = '<h4 style="margin:0px;">Please verify your email and try again.</h4>';
                $data['views'] = array('ashrams/public/appji_donations');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
        {
            if(!$this->session->userdata('temp_checkout_user'))
            {
                $data['showErrorMessage'] = '<h4 style="margin:0px;">Please select user before adding Donation to cart.</h4>';
                $data['views'] = array('ashrams/public/appji_donations');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }

        if(!empty($this->donationscart->contents()))
        foreach($this->donationscart->contents() as $key=>$val)
        {
            $donationData=$this->donations_model->donationData($val['id']);
            break;
        }

        if(isset($donationData->ashram_id) && $donationData->ashram_id!=appji_ashram_id)
        {
            $ashramData=$this->ashrams_model->ashramData($donationData->ashram_id);
            $ashramName=$ashramData->name;
            $data['showErrorMessage'] = '<h5 style="margin:0px;"><strong>Jaya Guru Datta. You already have items from "'.$ashramName.'" ashram in your cart. If you wish to add items from another ashram/event, empty the cart and try again.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a></h5>';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($GLOBALS['donationCartLocked']==1)
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">Donation cart is locked. Please clear your cart to add this item. <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a></h4>';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        $cart=$this->donationscart->contents();
        foreach($cart as $thiscartitem)
        {
            if(isset($thiscartitem['options']['appji_link_token']) && $linkToken == $thiscartitem['options']['appji_link_token'])
            {
                if($thiscartitem['options']['result_date'] != date("d M Y"))
                {
                    $cart=$this->donationscart->contents();
                    if(empty($cart))
                    {
                        
                    }
                    else 
                    {
                        foreach ($cart as $key => $value)
                        {
                            if(isset($key) && $key!='')
                            {
                                $item=$this->donationscart->get_item($key);
                                if(!empty($item))
                                {
                                    $upd= array(
                                               'rowid' => $key,
                                                'qty'   => 0
                                                );
                                    $this->donationscart->update($upd);
                                    $this->logaction->log($this->service,"donation removed from cart _ donation ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                                    $this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
                                }
                            }
                        }
                        $this->cart_model->regenerateSession(2);
                    } 
                }
                else
                {
                    redirect("donations/checkout?ashram_id=".$donationData->ashram_id."&currency=".strtolower($donationLinkDetails['donationCurrency']));
                }
            }

            if(isset($thiscartitem['options']['appji_currency']) && $donationLinkDetails['donationCurrency'] != $thiscartitem['options']['appji_currency'])
            {
                $data['showErrorMessage'] = '<h5 style="margin:0px;"><strong>Jaya Guru Datta. You already have items in your cart with a different currency. If you wish to add this item, empty the cart and try again.<br><br><strong>Clear previous cart and proceed.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Previous Cart</a><br><br><strong>Proceed with previous cart.</strong><a href="'.base_url().'donations/checkout?ashram_id='.$donationData->ashram_id.'&currency='.strtolower($thiscartitem['options']['appji_currency']).'" class="btn btn-primary btn-xs" style="margin-left: 10px;"><i class="fa fa-times"></i> Proceed with Previous Cart</a></h5>';
                $data['views'] = array('ashrams/public/appji_donations');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
        $cartCount = count($cart);
        if($cartCount >= 50)
        {
            $data['showErrorMessage']='<h4 style="margin:0px;">MAX 50 items are allowed to cart.</h4>';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        $amount=$this->cart_model->getTotalPrice($this->donationscart, $linkToken, 'donation');
        $donationData=$this->donations_model->donationData(appji_donation_id);
        $col="price_".strtolower($donationLinkDetails['donationCurrency']);
        if(empty($donationData))
        {
            $data['showErrorMessage']='Donation item is unavailable';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        
        $displayCol=strtolower($donationLinkDetails['donationCurrency'])."_display";
        if($donationData->$displayCol==0)
        {
            $data['showErrorMessage']='Donation item is unavailable';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($donationData->display_only_popup==1)
        {
            $data['showErrorMessage']='You can not add this Item, Display only Popup Item';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($donationData->subscription==1)
        {
            $tempUserId=0;
            if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
                $tempUserId=$this->session->userdata('temp_checkout_user')->sso_user_id;
            else
                $tempUserId=$this->currentUser->sso_user_id;

            $donorsCount=$this->donors_model->getCountByUser($tempUserId);
            if($donorsCount==0)
            {
                $this->donors_model->createDefault($tempUserId);
            }
        }

        if(isset($donationLinkDetails['donationAmount']))
        {
            if($donationLinkDetails['donationAmount']=='')
            {
                $data['showErrorMessage']='Donation amount is required';
                $data['views'] = array('ashrams/public/appji_donations');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
            if(!preg_match("/^\d+$/",$donationLinkDetails['donationAmount']))
            {
                $data['showErrorMessage']='Donation amount should contains only digits';
                $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
            }

            if(strlen($donationLinkDetails['donationAmount'])!=strlen(abs($donationLinkDetails['donationAmount'])))
            {
                $data['showErrorMessage']='Donation amount should be valid amount';
                $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
            }
        }
        else
        {
            $data['showErrorMessage']='Donation amount is required';
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        
        $netAmount=$amount+$donationLinkDetails['donationAmount'];

        if(empty($this->currencies))
        {
            $this->currencies=$this->currencies_model->getByAshram(appji_ashram_id);
        }

        if(strtolower($donationLinkDetails['donationCurrency'])=='inr' &&
            $netAmount>$this->currencies[$donationLinkDetails['donationCurrency']]['max'])
        {
            $data['showErrorMessage']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$donationLinkDetails['donationCurrency']]['max'];
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if(strtolower($donationLinkDetails['donationCurrency'])=='usd' &&
            $netAmount>$this->currencies[$donationLinkDetails['donationCurrency']]['max'])
        {
            $data['showErrorMessage']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$donationLinkDetails['donationCurrency']]['max'];
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if(strtolower($donationLinkDetails['donationCurrency'])=='inr')
        {
            $minAmount=$this->currencies[$donationLinkDetails['donationCurrency']]['min'];
            $maxAmount=$this->currencies[$donationLinkDetails['donationCurrency']]['max'];
        }
        if(strtolower($donationLinkDetails['donationCurrency'])=='usd')
        {
            $minAmount=$this->currencies[$donationLinkDetails['donationCurrency']]['min'];
            $maxAmount=$this->currencies[$donationLinkDetails['donationCurrency']]['max'];
        }

        if(trim(abs($donationLinkDetails['donationAmount']))<$minAmount)
        {
            $data['showErrorMessage']='Minimum amount is '.strtoupper($donationLinkDetails['donationCurrency'])." ".$minAmount;
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if(trim(abs($donationLinkDetails['donationAmount']))>$maxAmount)
        {
            $data['showErrorMessage']='Maximum amount is '.strtoupper($donationLinkDetails['donationCurrency'])." ".$maxAmount;
            $data['views'] = array('ashrams/public/appji_donations');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        $data['item']=$donationData;
        $data['type']='donation';
        $data['amount']=$donationLinkDetails['donationAmount'];
        $data['personal_note']='';
        $data['note']='';
        $data['other_name1']='';
        $data['other_name2']='';
        $data['other_name3']='';
        $data['other_name4']='';
        $data['other_name5']='';
        $data['other_name6']='';
        $data['is_appji_donation']=1;
        $data['appji_donation_date']=$donationLinkDetails['donationDate'];
        $data['appji_currency']=$donationLinkDetails['donationCurrency'];
        $data['appji_donation_amount']=$donationLinkDetails['donationAmount'];
        $data['appji_link_token']=$donationLinkDetails['linkToken'];
        $data['appji_email']=$donationLinkDetails['appjiEmail'];
        $data['appji_user_full_name']=$donationLinkDetails['appjiUserFullName'];
        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==0)
            {
                $data['note']=$this->currentUser->family_details;
            }
            else
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $data['note']=$this->session->userdata('temp_checkout_user')->family_details;
                }
            }
        }

        if($donationData->ashram_id==appji_ashram_id || count($cart)==0)
        {
            $this->session->set_userdata("donationCartAshramIdSelection",$donationData->ashram_id);
            $this->session->set_userdata("donationCartAshramId",$donationData->ashram_id);
            $response=$this->cart_model->addItem($data,1,$this->donationscart);
            $flag=$response['flag'];
            if(isset($response['rowid']) && $response['rowid']!='')
            {
                $data['rowKey'] = $response['rowid'];
            }
            if($flag==-2)
            {
                $this->logaction->log($this->service,"Donation added to cart _ Donation ID:".$donationData->id." _ ".$donationData->donation_name." _ Row ID: ".$response['rowid']);
                $data['flag']=1;
                $this->session->set_userdata('donationCartAshramId',$donationData->ashram_id);
                $this->cart_log_model->log("Item added - Name:".$donationData->donation_name.", Amount:".strtoupper($data['appji_currency'])." ".$data['amount'],appji_ashram_id,2);
                redirect("donations/checkout?ashram_id=".$donationData->ashram_id."&currency=".strtolower($data['appji_currency']));
            }
            else
            {
                $data['showErrorMessage']='Something went wrong while adding item to cart please try again later';
                $data['views'] = array('ashrams/public/appji_donations');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
    }

    public function clear_cart_and_temp_user()
    {
        $cart=$this->donationscart->contents();
        if(!empty($cart))
        {
            foreach ($cart as $key => $value)
            {
                if(isset($key) && $key!='')
                {
                    $item=$this->donationscart->get_item($key);
                    if(!empty($item))
                    {
                        $upd= array(
                                   'rowid' => $key,
                                    'qty'   => 0
                                    );
                        $this->donationscart->update($upd);
                        $this->logaction->log($this->service,"Donation removed from cart _ Donation ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                        $this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
                    }
                }
            }
            
        }

        $this->session->unset_userdata('donationCartAshramId');
        $this->session->unset_userdata('donationCartAshramIdSelection');
        $this->session->unset_userdata('defaultCurrency');
        $this->session->unset_userdata('temp_checkout_user');
        $data['flag']=1;
        header("Content-Type:application/json");
        echo json_encode($data);
    }
}
?>