<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Checklistadmin extends CI_Controller 
{
	var $service='content';
	var $currentUser='';
    function __construct() 
	{
        parent::__construct();
        if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model('content/checklist_model');
		$this->load->model("user/users_model");
    }
	function index()
	{
		$views = array( 'checklists/admin/list' );
		$data = array('views'=>$views);
		$data['roles']=$this->users_model->getRoles();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listrecords($excel=0)
	{
		$list=$this->checklist_model->listAjaxAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Checklists listing ajax request");
	}
	function add_edit_checklist($id=0)
	{		
		if(isset($_POST["ck_create"]))
		{
			if($id)
			{
				$checklistData=$this->checklist_model->checklistData($id);
				if(empty($checklistData))
				{
					$this->session->set_flashdata("ck_error",1);
					redirect('checklistadmin');
				}
			}
			$this->form_validation->set_rules('role', 'Role', 'trim|required|checkUserRole');
			$this->form_validation->set_rules('topic', 'Topic', 'trim|required|min_length[6]|max_length[100]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("ck_error",1);
				redirect("checklistadmin/add_edit_checklist/".$id);
			}
			$saved=$this->checklist_model->save($id);
			if($saved)
			{
				if($id)
				{
					$this->session->set_flashdata("ck_saved",1);
					redirect("checklistadmin/add_edit_checklist/".$saved);
				}
				else
				{
					$this->session->set_flashdata("ck_created",1);
					redirect("checklistadmin/add_edit_checklist/".$saved);
				}
			}
			else
			{
				$this->session->set_flashdata("ck_error",1);
				redirect("checklistadmin/add_edit_checklist/".$id);
			}
			
		}
		else
		{
			$views = array( 'checklists/admin/add_edit_checklist' );
			$data = array('views'=>$views,'id'=>$id);
			$data['roles']=$this->users_model->getRoles();
			if($id)
			{
				$checklistData=$this->checklist_model->checklistData($id);
				if(empty($checklistData))
				{
					$this->session->set_flashdata("ck_error",1);
					redirect("checklistadmin");
				}
				$data['checklistData']=$checklistData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}
	
	public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$checklistData=$this->checklist_model->checklistData($id);
			if(!empty($checklistData))
			{
				$deleted=$this->checklist_model->delete($id,$checklistData);
				if($deleted)
				{
					$data['flag']=1;
					$data['topic']=$checklistData->topic;
				}
			}
		}
		echo json_encode($data);
	}
}
?>