<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Categoriesadmin extends CI_Controller 
{
	var $service='content';
	var $currentUser='';
    function __construct() 
    {
        parent::__construct();	
		$this->load->model('category/categories_model');
		$this->load->model('ashrams/ashrams_model');

		$this->categories_model->fetchCategories();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				$this->categories_model->fetchCategories(0,$this->currentUser->ashram_id);
			}
			else
			{
				if($this->session->userdata("ashramId"))
					$this->categories_model->fetchCategories(0,$this->session->userdata("ashramId"));
				else
					$this->categories_model->fetchCategories();
			}
		}
		else
		{
			$this->categories_model->fetchCategories();	
		}
			
    }
	/**
	 * List of Categories page
	 *
	 * @return void
	 * @author  Manoj MS <manoj@agilonconsulting.com>
	 */
	public function index()
	{
	 	$views = array( 'categories/admin/list');
	 	$data = array('views'=>$views);
	 	$data['ashrams']=$this->ashrams_model->getList();
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function add_edit_category($id=0)
	{
		if($id && !isset($this->categories_model->categoriesList['categories'][$id]))
		{
			$this->session->set_flashdata('category_error',1);
			redirect('categoriesadmin');
		}
		if(isset($_POST["add_category"]))
		{
			$this->form_validation->set_rules('category', 'Category', "trim|required|min_length[3]|max_length[100]|name_validate11|categoryCheck[$id]");
			$this->form_validation->set_rules('parent', 'Parent', 'trim|required|numeric|categoryParentCheck['.$id.']');
			$this->form_validation->set_rules('description', 'Description', 'trim|max_length[500]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('category_error',1);
				redirect('categoriesadmin/add_edit_category/'.$id);
			}
			$saved=$this->categories_model->saveCategory($id);
			if($saved)
			{
				if($id)
					$this->session->set_flashdata('category_saved',1);
				else
					$this->session->set_flashdata('category_created',1);
			}
			else
				$this->session->set_flashdata('category_error',1);
			redirect('categoriesadmin/add_edit_category/'.$saved);
		}
		else
		{
		 	$views = array( 'categories/admin/add_edit_category' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['ashrams']=$this->ashrams_model->getList();
			if($id && isset($this->categories_model->categoriesList['categories'][$id]))
			{
				$data['categoryData']=$this->categories_model->categoriesList['categories'][$id];
				if($data['categoryData']->ashram_id)
					$data['ashramData']=$this->ashrams_model->ashramData($data['categoryData']->ashram_id);
			}
			if($id && !isset($this->categories_model->categoriesList['categories'][$id]))
			{
				$this->session->set_flashdata('category_error',1);
				redirect('categoriesadmin');
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	/**
	 * Deletes Category
	 *
	 * @param int $id Category ID
	 * @return void
	 * @author  Manoj MS <manoj@agilonconsulting.com>
	 */
	public function delete_category($id=0)
	{
		if($id)
		{
			if(is_numeric($id))//Is ID numeric value
			{
				$result['data']=array();
				if(!isset($this->categories_model->categoriesList['categories'][$id]))
				{
					$this->session->set_flashdata('category_error',1);
					redirect('categoriesadmin');
				}
				$this->load->model('content/events_model');
				$this->load->model('content/events_category_model');
				$this->load->model('content/pages_model');
				$this->load->model('content/pages_category_model');
				$flag=$this->categories_model->delete($id);
				if($flag)
				{
					$this->session->set_flashdata('category_deleted',1);
					$this->session->set_flashdata('category_name',$this->categories_model->categoriesList['categories'][$id]->category);
					redirect('categoriesadmin');
				}
			}
			else
			{
				$this->session->set_flashdata('category_error',1);
				redirect('categoriesadmin');
			}
			
		}
		else
		{
			$this->session->set_flashdata('category_error',1);
			redirect('categoriesadmin');
		}
	}
	public function add_category_ajax()
	{
		if(isset($_POST['category']) && $_POST['category']!='' && isset($_POST['parent']) && is_numeric($_POST['parent']))
		{
			$this->form_validation->set_rules('category', 'Category', "trim|required|min_length[3]|max_length[100]|name_validate11|categoryCheck[0]");
			$this->form_validation->set_rules('parent', 'Parent', 'trim|required|numeric|categoryParentCheck[0]');
			if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$_POST['description']='';
			$saved=$this->categories_model->saveCategory(0);
			if($saved)
			{
				echo 1;
				return;
			}
			else
				echo 0;
		}
		else
			echo 0;
	}

	public function category_exists($categoryID=0)
	{
		if(is_numeric($categoryID))
			echo $this->categories_model->categoryCheck(trim($_POST['name']),$categoryID);
		else
			echo 0;
	}

	public function bulk()
	{
		if(isset($_POST['action']) && $_POST['action']=='bulk_delete')
		{
			$this->load->model('content/events_model');
			$this->load->model('content/events_category_model');
			$this->load->model('content/pages_model');
			$this->load->model('content/pages_category_model');
			
			$deleted=$this->categories_model->bulk_delete($_POST['delete_tags']);
			$this->session->set_flashdata("category_bulk_deleted",1);
			$this->session->set_flashdata("category_num",$deleted);
			redirect('categoriesadmin');
		}
		else
		{
			$this->session->set_flashdata("cat_error",1);
			redirect('categoriesadmin');
		}
	}
	public function export_categories()
	{
		$resp=$this->categories_model->export();
		echo json_encode($resp);
	}
}
?>